/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.projectRoots.ui;

import com.google.common.collect.Lists;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.SdkEditorAdditionalOptionsProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.AdditionalDataConfigurable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkAdditionalData;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.SdkType;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.projectRoots.impl.SdkConfigurationUtil;
import com.intellij.openapi.projectRoots.ui.PathEditor;
import com.intellij.openapi.projectRoots.ui.SdkPathEditor;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.ui.OrderRootTypeUIFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.ui.navigation.History;
import com.intellij.ui.navigation.Place;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SdkEditor
implements Configurable,
Place.Navigator {
    private static final Logger g = Logger.getInstance((String)"#com.intellij.openapi.projectRoots.ui.SdkEditor");
    private static final String d = "sdkTab";
    private Sdk f;
    private final Map<OrderRootType, SdkPathEditor> p = new HashMap<OrderRootType, SdkPathEditor>();
    private TextFieldWithBrowseButton e;
    private final Map<SdkType, List<AdditionalDataConfigurable>> s = new HashMap<SdkType, List<AdditionalDataConfigurable>>();
    private final Map<AdditionalDataConfigurable, JComponent> c = new HashMap<AdditionalDataConfigurable, JComponent>();
    private JPanel h;
    private final SdkModificator j = new EditedSdkModificator();
    private JPanel k;
    private TabbedPaneWrapper i;
    private final Project l;
    private final SdkModel n;
    private JLabel q;
    private String m;
    private String o;
    private String a;
    private final History b;
    private final Disposable r = Disposer.newDisposable();

    public SdkEditor(Project project2, SdkModel sdkModel, History history, ProjectJdkImpl projectJdkImpl) {
        this.l = project2;
        this.n = sdkModel;
        this.b = history;
        this.f = projectJdkImpl;
        this.e();
        this.b((Sdk)projectJdkImpl);
    }

    private void b(Sdk sdk) {
        this.f = sdk;
        if (this.f != null) {
            this.o = this.f.getName();
            this.a = this.f.getHomePath();
        } else {
            this.o = "";
            this.a = "";
        }
        for (AdditionalDataConfigurable additionalDataConfigurable : this.d()) {
            additionalDataConfigurable.setSdk(sdk);
        }
        if (this.k != null) {
            this.reset();
        }
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"sdk.configure.editor.title", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        return null;
    }

    public JComponent createComponent() {
        return this.k;
    }

    private void e() {
        this.k = new JPanel(new GridBagLayout());
        this.i = new TabbedPaneWrapper(this.r);
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            SdkPathEditor sdkPathEditor;
            if (this.f != null && !this.showTabForType(orderRootType) || (sdkPathEditor = ((OrderRootTypeUIFactory)OrderRootTypeUIFactory.FACTORY.getByKey((Object)orderRootType)).createPathEditor(this.f)) == null) continue;
            sdkPathEditor.setAddBaseDir(this.f.getHomeDirectory());
            this.i.addTab(sdkPathEditor.getDisplayName(), sdkPathEditor.createComponent());
            this.p.put(orderRootType, sdkPathEditor);
        }
        this.i.addChangeListener(changeEvent -> this.b.pushQueryPlace());
        this.e = this.createHomeComponent();
        this.e.getTextField().setEditable(false);
        this.q = new JLabel(this.c());
        this.k.add((Component)this.q, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insets((int)2, (int)10, (int)2, (int)2), 0, 0));
        this.k.add((Component)this.e, new GridBagConstraints(1, -1, 1, 1, 1.0, 0.0, 10, 2, (Insets)JBUI.insets((int)2, (int)2, (int)2, (int)10), 0, 0));
        this.h = new JPanel(new BorderLayout());
        this.k.add((Component)this.h, new GridBagConstraints(0, -1, 2, 1, 1.0, 0.0, 10, 1, (Insets)JBUI.insets((int)2, (int)10, (int)0, (int)10), 0, 0));
        this.k.add((Component)this.i.getComponent(), new GridBagConstraints(0, -1, 2, 1, 1.0, 1.0, 10, 1, (Insets)JBUI.insetsTop((int)2), 0, 0));
    }

    protected TextFieldWithBrowseButton createHomeComponent() {
        return new TextFieldWithBrowseButton(actionEvent -> this.a());
    }

    protected boolean showTabForType(@NotNull OrderRootType orderRootType) {
        if (orderRootType == null) {
            SdkEditor.a(0);
        }
        return ((SdkType)this.f.getSdkType()).isRootTypeApplicable(orderRootType);
    }

    private String c() {
        return this.f != null ? ((SdkType)this.f.getSdkType()).getHomeFieldLabel() : ProjectBundle.message((String)"sdk.configure.general.home.path", (Object[])new Object[0]);
    }

    public boolean isModified() {
        boolean bl2 = !Comparing.equal((String)(this.f == null ? null : this.f.getName()), (String)this.o);
        bl2 = bl2 || !Comparing.equal((String)FileUtil.toSystemIndependentName((String)this.g()), (String)FileUtil.toSystemIndependentName((String)this.a));
        for (PathEditor pathEditor : this.p.values()) {
            bl2 = bl2 || pathEditor.isModified();
        }
        for (AdditionalDataConfigurable additionalDataConfigurable : this.d()) {
            bl2 = bl2 || additionalDataConfigurable.isModified();
        }
        return bl2;
    }

    public void apply() throws ConfigurationException {
        if (!Comparing.equal((String)this.o, (String)(this.f == null ? "" : this.f.getName())) && (this.f == null || this.f.getName().isEmpty())) {
            throw new ConfigurationException(ProjectBundle.message((String)"sdk.list.name.required.error", (Object[])new Object[0]));
        }
        if (this.f != null) {
            this.o = this.f.getName();
            this.a = this.f.getHomePath();
            SdkModificator sdkModificator = this.f.getSdkModificator();
            sdkModificator.setHomePath(FileUtil.toSystemDependentName((String)this.g()));
            for (SdkPathEditor sdkPathEditor : this.p.values()) {
                sdkPathEditor.apply(sdkModificator);
            }
            ApplicationManager.getApplication().runWriteAction(() -> ((SdkModificator)sdkModificator).commitChanges());
            for (AdditionalDataConfigurable additionalDataConfigurable : this.d()) {
                if (additionalDataConfigurable == null) continue;
                additionalDataConfigurable.apply();
            }
        }
    }

    public void reset() {
        if (this.f == null) {
            this.b("");
            for (SdkPathEditor sdkPathEditor : this.p.values()) {
                sdkPathEditor.reset(null);
            }
        } else {
            SdkModificator sdkModificator = this.f.getSdkModificator();
            for (OrderRootType orderRootType : this.p.keySet()) {
                this.p.get(orderRootType).reset(sdkModificator);
            }
            sdkModificator.commitChanges();
            this.b(FileUtil.toSystemDependentName((String)((String)ObjectUtils.notNull((Object)this.f.getHomePath(), (Object)""))));
        }
        this.m = null;
        this.q.setText(this.c());
        this.b();
        for (AdditionalDataConfigurable additionalDataConfigurable : this.d()) {
            additionalDataConfigurable.reset();
        }
        this.e.setEnabled(this.f != null);
        for (int i2 = 0; i2 < this.i.getTabCount(); ++i2) {
            this.i.setEnabledAt(i2, this.f != null);
        }
    }

    public void disposeUIResources() {
        for (SdkType sdkType : this.s.keySet()) {
            for (AdditionalDataConfigurable additionalDataConfigurable : this.s.get(sdkType)) {
                additionalDataConfigurable.disposeUIResources();
            }
        }
        this.s.clear();
        this.c.clear();
        Disposer.dispose((Disposable)this.r);
    }

    private String g() {
        return this.e.getText().trim();
    }

    private void f() {
        for (PathEditor pathEditor : this.p.values()) {
            pathEditor.clearList();
        }
    }

    private void b(String string) {
        Color color;
        this.e.setText(string);
        if (string != null && !string.isEmpty() && this.f != null && this.f.getSdkType().isLocalSdk(this.f)) {
            File file = new File(string);
            boolean bl2 = ((SdkType)this.f.getSdkType()).getHomeChooserDescriptor().isChooseFolders();
            color = file.exists() && file.isDirectory() == bl2 ? UIUtil.getFieldForegroundColor() : PathEditor.INVALID_COLOR;
        } else {
            color = UIUtil.getFieldForegroundColor();
        }
        this.e.getTextField().setForeground(color);
    }

    private void a() {
        SdkType sdkType = (SdkType)this.f.getSdkType();
        SdkConfigurationUtil.selectSdkHome((SdkType)sdkType, string -> this.a((String)string, sdkType));
    }

    private void a(String string, SdkType sdkType) {
        if (string == null) {
            return;
        }
        this.b(string.replace('/', File.separatorChar));
        String string2 = this.a(string);
        ((ProjectJdkImpl)this.f).setName(string2);
        try {
            Sdk sdk = (Sdk)this.f.clone();
            SdkModificator sdkModificator = sdk.getSdkModificator();
            sdkModificator.setHomePath(string);
            sdkModificator.removeAllRoots();
            sdkModificator.commitChanges();
            sdkType.setupSdkPaths(sdk, this.n);
            this.f();
            this.m = sdk.getVersionString();
            if (this.m == null) {
                Messages.showMessageDialog((String)ProjectBundle.message((String)"sdk.java.corrupt.error", (Object[])new Object[]{string}), (String)ProjectBundle.message((String)"sdk.java.corrupt.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon());
            }
            sdkModificator = sdk.getSdkModificator();
            for (OrderRootType orderRootType : this.p.keySet()) {
                SdkPathEditor sdkPathEditor = this.p.get(orderRootType);
                sdkPathEditor.setAddBaseDir(sdk.getHomeDirectory());
                sdkPathEditor.addPaths(sdkModificator.getRoots(orderRootType));
            }
            this.n.getMulticaster().sdkHomeSelected(sdk, string);
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            g.error((Throwable)cloneNotSupportedException);
        }
    }

    private String a(String string) {
        Sdk[] sdkArray;
        String string2;
        String string3 = this.f.getName();
        if (Comparing.equal((String)string3, (String)(string2 = ((SdkType)this.f.getSdkType()).suggestSdkName(string3, string)))) {
            return string3;
        }
        String string4 = string2;
        HashSet<String> hashSet = new HashSet<String>();
        for (Sdk sdk : sdkArray = this.n.getSdks()) {
            hashSet.add(sdk.getName());
        }
        int n2 = 0;
        while (hashSet.contains(string4)) {
            string4 = string2 + " (" + ++n2 + ")";
        }
        return string4;
    }

    private void b() {
        this.h.removeAll();
        for (AdditionalDataConfigurable additionalDataConfigurable : this.d()) {
            JComponent jComponent = this.c.get(additionalDataConfigurable);
            if (jComponent == null) {
                jComponent = additionalDataConfigurable.createComponent();
                this.c.put(additionalDataConfigurable, jComponent);
            }
            if (jComponent == null) continue;
            if (additionalDataConfigurable.getTabName() != null) {
                for (int i2 = 0; i2 < this.i.getTabCount(); ++i2) {
                    if (!additionalDataConfigurable.getTabName().equals(this.i.getTitleAt(i2))) continue;
                    this.i.removeTabAt(i2);
                }
                this.i.addTab(additionalDataConfigurable.getTabName(), jComponent);
                continue;
            }
            this.h.add((Component)jComponent, "Center");
        }
    }

    @NotNull
    private List<AdditionalDataConfigurable> d() {
        if (this.f == null) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                SdkEditor.a(1);
            }
            return list2;
        }
        List<AdditionalDataConfigurable> list3 = this.a(this.f);
        if (list3 == null) {
            SdkEditor.a(2);
        }
        return list3;
    }

    @NotNull
    private List<AdditionalDataConfigurable> a(Sdk sdk) {
        SdkType sdkType = (SdkType)sdk.getSdkType();
        ArrayList arrayList = this.s.get(sdkType);
        if (arrayList == null) {
            arrayList = Lists.newArrayList();
            this.s.put(sdkType, arrayList);
            AdditionalDataConfigurable additionalDataConfigurable = sdkType.createAdditionalDataConfigurable(this.n, this.j);
            if (additionalDataConfigurable != null) {
                arrayList.add(additionalDataConfigurable);
            }
            for (SdkEditorAdditionalOptionsProvider sdkEditorAdditionalOptionsProvider : SdkEditorAdditionalOptionsProvider.getSdkOptionsFactory(this.f.getSdkType())) {
                AdditionalDataConfigurable additionalDataConfigurable2 = sdkEditorAdditionalOptionsProvider.createOptions(this.l, this.f);
                if (additionalDataConfigurable2 == null) continue;
                arrayList.add(additionalDataConfigurable2);
            }
        }
        ArrayList arrayList2 = arrayList;
        if (arrayList2 == null) {
            SdkEditor.a(3);
        }
        return arrayList2;
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean bl2) {
        if (place == null) {
            return ActionCallback.DONE;
        }
        this.i.setSelectedTitle((String)place.getPath(d));
        return ActionCallback.DONE;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            SdkEditor.a(4);
        }
        place.putPath(d, (Object)this.i.getSelectedTitle());
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/projectRoots/ui/SdkEditor";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/projectRoots/ui/SdkEditor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalDataConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "initAdditionalDataConfigurable";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "showTabForType";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class EditedSdkModificator
    implements SdkModificator {
        private EditedSdkModificator() {
        }

        public String getName() {
            return SdkEditor.this.f.getName();
        }

        public void setName(String string) {
            ((ProjectJdkImpl)SdkEditor.this.f).setName(string);
        }

        public String getHomePath() {
            return SdkEditor.this.g();
        }

        public void setHomePath(String string) {
            SdkEditor.this.a(string, (SdkType)SdkEditor.this.f.getSdkType());
        }

        public String getVersionString() {
            return SdkEditor.this.m != null ? SdkEditor.this.m : SdkEditor.this.f.getVersionString();
        }

        public void setVersionString(String string) {
            throw new UnsupportedOperationException();
        }

        public SdkAdditionalData getSdkAdditionalData() {
            return SdkEditor.this.f.getSdkAdditionalData();
        }

        public void setSdkAdditionalData(SdkAdditionalData sdkAdditionalData) {
            throw new UnsupportedOperationException();
        }

        @NotNull
        public VirtualFile[] getRoots(@NotNull OrderRootType orderRootType) {
            PathEditor pathEditor;
            if (orderRootType == null) {
                EditedSdkModificator.a(0);
            }
            if ((pathEditor = (PathEditor)SdkEditor.this.p.get(orderRootType)) == null) {
                throw new IllegalStateException("no editor for root type " + orderRootType);
            }
            VirtualFile[] virtualFileArray = pathEditor.getRoots();
            if (virtualFileArray == null) {
                EditedSdkModificator.a(1);
            }
            return virtualFileArray;
        }

        public void addRoot(@NotNull VirtualFile virtualFile, @NotNull OrderRootType orderRootType) {
            if (virtualFile == null) {
                EditedSdkModificator.a(2);
            }
            if (orderRootType == null) {
                EditedSdkModificator.a(3);
            }
            ((SdkPathEditor)SdkEditor.this.p.get(orderRootType)).addPaths(new VirtualFile[]{virtualFile});
        }

        public void removeRoot(@NotNull VirtualFile virtualFile, @NotNull OrderRootType orderRootType) {
            if (virtualFile == null) {
                EditedSdkModificator.a(4);
            }
            if (orderRootType == null) {
                EditedSdkModificator.a(5);
            }
            ((SdkPathEditor)SdkEditor.this.p.get(orderRootType)).removePaths(new VirtualFile[]{virtualFile});
        }

        public void removeRoots(@NotNull OrderRootType orderRootType) {
            if (orderRootType == null) {
                EditedSdkModificator.a(6);
            }
            ((SdkPathEditor)SdkEditor.this.p.get(orderRootType)).clearList();
        }

        public void removeAllRoots() {
            for (PathEditor pathEditor : SdkEditor.this.p.values()) {
                pathEditor.clearList();
            }
        }

        public void commitChanges() {
        }

        public boolean isWritable() {
            return true;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "rootType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/projectRoots/ui/SdkEditor$EditedSdkModificator";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "root";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/projectRoots/ui/SdkEditor$EditedSdkModificator";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getRoots";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getRoots";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "addRoot";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRoot";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "removeRoots";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

