/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.ConfigurationError;
import com.intellij.openapi.roots.ui.configuration.ConfigurationErrors;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectConfigurationProblem;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.Gray;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Alarm;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.event.MouseEvent;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ErrorPaneConfigurable
extends JPanel
implements Configurable,
Disposable,
ConfigurationErrors {
    private final Alarm a;
    private final List<ConfigurationError> e = new ArrayList<ConfigurationError>();
    private int h;
    private int d;
    private final Object b = new Object();
    private final MergingUpdateQueue f;
    private final JTextPane c = new JTextPane();
    private final Runnable g;

    public ErrorPaneConfigurable(Project project2, StructureConfigurableContext structureConfigurableContext, Runnable runnable) {
        super(new BorderLayout());
        this.g = runnable;
        this.c.setEditorKit(UIUtil.getHTMLEditorKit());
        this.c.setEditable(false);
        this.c.setBackground(UIUtil.getListBackground());
        JScrollPane jScrollPane = ScrollPaneFactory.createScrollPane((Component)this.c, (boolean)true);
        jScrollPane.setHorizontalScrollBarPolicy(31);
        this.add(jScrollPane);
        this.f = new MergingUpdateQueue("ErrorPaneConfigurable Content Updates", 300, false, (JComponent)jScrollPane, (Disposable)this, (JComponent)jScrollPane);
        this.a = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)this);
        project2.getMessageBus().connect((Disposable)this).subscribe(ConfigurationErrors.TOPIC, (Object)this);
        this.c.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            public void hyperlinkActivated(HyperlinkEvent hyperlinkEvent) {
                URL uRL = hyperlinkEvent.getURL();
                AWTEvent aWTEvent = EventQueue.getCurrentEvent();
                if (!(aWTEvent instanceof MouseEvent)) {
                    return;
                }
                MouseEvent mouseEvent = (MouseEvent)aWTEvent;
                if (uRL != null) {
                    Object object;
                    ConfigurationError configurationError = null;
                    for (Element element = hyperlinkEvent.getSourceElement(); element != null; element = element.getParentElement()) {
                        if (!"li".equals(element.getName())) continue;
                        object = element.getParentElement();
                        for (int i2 = 0; i2 < object.getElementCount(); ++i2) {
                            if (object.getElement(i2) != element) continue;
                            configurationError = ErrorPaneConfigurable.this.a(i2, ErrorPaneConfigurable.this.d);
                        }
                        break;
                    }
                    if (configurationError == null) {
                        return;
                    }
                    object = uRL.getHost();
                    String string = uRL.getPath();
                    if (string != null && string.startsWith("/")) {
                        string = StringUtil.unescapeXml((String)string.substring(1));
                    }
                    if (string != null) {
                        if ("fix".equals(object)) {
                            MouseEvent mouseEvent2 = new MouseEvent(mouseEvent.getComponent(), mouseEvent.getID(), mouseEvent.getWhen(), mouseEvent.getModifiers(), mouseEvent.getX() - 15, mouseEvent.getY() + 10, mouseEvent.getClickCount(), mouseEvent.isPopupTrigger());
                            configurationError.fix(ErrorPaneConfigurable.this.c, new RelativePoint(mouseEvent2));
                        } else {
                            configurationError.navigate();
                        }
                    }
                }
            }
        });
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationError a(int n2, int n3) {
        Object object = this.b;
        synchronized (object) {
            return n3 == this.h ? this.e.get(n2) : null;
        }
    }

    public void refresh() {
        this.a.cancelAllRequests();
        this.a.addRequest(() -> {
            String string = "<html><header><style type='text/css'>body {  color: #" + ColorUtil.toHex((Color)new JBColor((Color)Gray.x33, UIUtil.getLabelForeground())) + ";  font-family: '" + UIUtil.getLabelFont().getName() + ",serif';  font-size: " + UIUtil.getLabelFont().getSize() + ";}li {  margin-bottom: 5;}ol {}a { text-decoration: none;}</style></header><body>";
            StringBuilder stringBuilder = new StringBuilder(string);
            int n2 = 0;
            stringBuilder.append("<ol>");
            ConfigurationError[] configurationErrorArray = this.b;
            synchronized (this.b) {
                ConfigurationError[] configurationErrorArray2 = this.e.toArray(new ConfigurationError[0]);
                int n3 = this.h;
                // ** MonitorExit[var6_4] (shouldn't be in output)
                for (ConfigurationError configurationError : configurationErrorArray2) {
                    String string2;
                    if (++n2 > 100) break;
                    stringBuilder.append("<li>");
                    if (configurationError instanceof ProjectConfigurationProblem) {
                        ProjectStructureProblemDescription projectStructureProblemDescription = ((ProjectConfigurationProblem)configurationError).getProblemDescription();
                        string2 = projectStructureProblemDescription.getDescription();
                        if (string2 == null) {
                            ProjectStructureElement projectStructureElement = projectStructureProblemDescription.getPlace().getContainingElement();
                            string2 = XmlStringUtil.convertToHtmlContent((String)projectStructureProblemDescription.getMessage(false));
                            if (projectStructureProblemDescription.canShowPlace()) {
                                string2 = projectStructureElement.getTypeName() + " <a href='http://navigate/" + n2 + "'>" + XmlStringUtil.convertToHtmlContent((String)projectStructureElement.getPresentableName()) + "</a>: " + StringUtil.decapitalize((String)string2);
                            }
                        } else {
                            string2 = XmlStringUtil.convertToHtmlContent((String)string2);
                        }
                    } else {
                        string2 = XmlStringUtil.convertToHtmlContent((String)configurationError.getDescription());
                    }
                    if (configurationError.canBeFixed()) {
                        string2 = string2 + " <a href='http://fix/" + n2 + "'>[Fix]</a>";
                    }
                    stringBuilder.append(string2).append("</li>");
                }
                stringBuilder.append("</ol></body></html>");
                this.f.queue((Update)new ShowErrorsUpdate(n3, stringBuilder.toString()));
                if (this.g != null) {
                    this.g.run();
                }
                return;
            }
        }, 100);
    }

    @Nls
    public String getDisplayName() {
        return "Problems";
    }

    @Nullable
    public JComponent createComponent() {
        return this;
    }

    public boolean isModified() {
        return false;
    }

    public void apply() throws ConfigurationException {
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    public void dispose() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addError(@NotNull ConfigurationError configurationError) {
        if (configurationError == null) {
            ErrorPaneConfigurable.a(0);
        }
        Object object = this.b;
        synchronized (object) {
            this.e.add(configurationError);
            ++this.h;
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeError(@NotNull ConfigurationError configurationError) {
        if (configurationError == null) {
            ErrorPaneConfigurable.a(1);
        }
        Object object = this.b;
        synchronized (object) {
            this.e.remove(configurationError);
            ++this.h;
        }
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getErrorsCount() {
        Object object = this.b;
        synchronized (object) {
            return this.e.size();
        }
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "error";
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/ErrorPaneConfigurable";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addError";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "removeError";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ShowErrorsUpdate
    extends Update {
        private final int a;
        private final String b;

        public ShowErrorsUpdate(int n2, String string) {
            super((Object)n2);
            this.a = n2;
            this.b = string;
        }

        public void run() {
            if (!Disposer.isDisposed((Disposable)ErrorPaneConfigurable.this)) {
                ErrorPaneConfigurable.this.c.setText(this.b);
                ErrorPaneConfigurable.this.d = this.a;
            }
        }

        public boolean canEat(Update update) {
            return update instanceof ShowErrorsUpdate && this.a > ((ShowErrorsUpdate)update).a;
        }
    }
}

