/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration;

import com.intellij.core.JavaCoreBundle;
import com.intellij.icons.AllIcons;
import com.intellij.ide.util.BrowseFilesListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.project.ex.ProjectEx;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.impl.LanguageLevelProjectExtensionImpl;
import com.intellij.openapi.roots.ui.configuration.GeneralProjectSettingsElement;
import com.intellij.openapi.roots.ui.configuration.LanguageLevelCombo;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectJdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.DetailsComponent;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.project.ProjectKt;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.FieldPanel;
import com.intellij.ui.InsertPathAction;
import com.intellij.ui.components.fields.ExtendableTextField;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectConfigurable
extends ProjectStructureElementConfigurable<Project>
implements DetailsComponent.Facade {
    private final Project g;
    private LanguageLevelCombo b;
    private ProjectJdkConfigurable e;
    private FieldPanel j;
    private JTextField h;
    private JPanel i;
    private final StructureConfigurableContext k;
    private final ModulesConfigurator f;
    private JPanel d;
    private boolean c = false;
    private DetailsComponent a;
    private final GeneralProjectSettingsElement l;

    public ProjectConfigurable(Project project2, StructureConfigurableContext structureConfigurableContext, ModulesConfigurator modulesConfigurator, ProjectSdksModel projectSdksModel) {
        this.g = project2;
        this.k = structureConfigurableContext;
        this.f = modulesConfigurator;
        this.c();
        this.l = new GeneralProjectSettingsElement(structureConfigurableContext);
        final ProjectStructureDaemonAnalyzer projectStructureDaemonAnalyzer = structureConfigurableContext.getDaemonAnalyzer();
        this.f.addAllModuleChangeListener(new ModuleEditor.ChangeListener(){

            @Override
            public void moduleStateChanged(ModifiableRootModel modifiableRootModel) {
                projectStructureDaemonAnalyzer.queueUpdate(ProjectConfigurable.this.l);
            }
        });
        this.a(projectSdksModel);
    }

    @Override
    public ProjectStructureElement getProjectStructureElement() {
        return this.l;
    }

    public DetailsComponent getDetailsComponent() {
        return this.a;
    }

    public JComponent createOptionsPanel() {
        this.a = new DetailsComponent(false, false);
        this.a.setContent((JComponent)this.i);
        this.a.setText(new String[]{this.getBannerSlogan()});
        this.e.createComponent();
        return this.a.getComponent();
    }

    private void a(ProjectSdksModel projectSdksModel) {
        this.i = new JPanel(new GridBagLayout());
        this.i.setPreferredSize((Dimension)JBUI.size((int)700, (int)500));
        if (ProjectKt.isDirectoryBased((Project)this.g)) {
            JPanel jPanel = new JPanel(new BorderLayout());
            JLabel jLabel = new JLabel("<html><body><b>Project name:</b></body></html>", 2);
            jPanel.add((Component)jLabel, "North");
            this.h = new JTextField();
            this.h.setColumns(40);
            JPanel jPanel2 = new JPanel();
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            jPanel2.add(Box.createHorizontalStrut(4));
            jPanel2.add(this.h);
            jPanel.add((Component)jPanel2, "Center");
            JPanel jPanel3 = new JPanel(new FlowLayout(0, 0, 0));
            jPanel3.add(jPanel);
            jPanel3.setAlignmentX(0.0f);
            this.i.add((Component)jPanel3, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)4, (int)0, (int)10, (int)0), 0, 0));
        }
        this.e = new ProjectJdkConfigurable(this.g, projectSdksModel);
        this.i.add((Component)this.e.createComponent(), new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insetsTop((int)4), 0, 0));
        this.i.add((Component)this.d, new GridBagConstraints(0, -1, 1, 1, 1.0, 1.0, 18, 0, (Insets)JBUI.insetsTop((int)4), 0, 0));
        this.i.setBorder(new EmptyBorder(0, 10, 0, 10));
        this.j.getTextField().getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                if (ProjectConfigurable.this.c) {
                    return;
                }
                ProjectConfigurable.this.f.processModuleCompilerOutputChanged(ProjectConfigurable.this.getCompilerOutputUrl());
            }
        });
        this.e.addChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ProjectConfigurable.this.b.sdkUpdated(ProjectConfigurable.this.e.getSelectedProjectJdk(), ProjectConfigurable.this.g.isDefault());
                LanguageLevelProjectExtensionImpl.getInstanceImpl((Project)ProjectConfigurable.this.g).setCurrentLevel(ProjectConfigurable.this.b.getSelectedLevel());
            }
        });
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LanguageLevelProjectExtensionImpl.getInstanceImpl((Project)ProjectConfigurable.this.g).setCurrentLevel(ProjectConfigurable.this.b.getSelectedLevel());
            }
        });
    }

    public void disposeUIResources() {
        if (this.e != null) {
            this.e.disposeUIResources();
        }
    }

    public void reset() {
        this.c = true;
        try {
            this.e.reset();
            String string = this.b();
            if (string != null) {
                this.j.setText(FileUtil.toSystemDependentName((String)VfsUtilCore.urlToPath((String)string)));
            }
            this.b.reset(this.g);
            if (this.h != null) {
                this.h.setText(this.g.getName());
            }
        }
        finally {
            this.c = false;
        }
        this.k.getDaemonAnalyzer().queueUpdate(this.l);
    }

    public void apply() throws ConfigurationException {
        CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)this.g);
        assert (compilerProjectExtension != null) : this.g;
        if (this.h != null && StringUtil.isEmptyOrSpaces((String)this.h.getText())) {
            throw new ConfigurationException("Please, specify project name!");
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            String string = this.j.getText();
            if (string != null && string.length() > 0) {
                try {
                    string = FileUtil.resolveShortWindowsName((String)string);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                string = FileUtil.toSystemIndependentName((String)string);
                compilerProjectExtension.setCompilerOutputUrl(VfsUtilCore.pathToUrl((String)string));
            } else {
                compilerProjectExtension.setCompilerOutputPointer(null);
            }
            LanguageLevelProjectExtension languageLevelProjectExtension = LanguageLevelProjectExtension.getInstance((Project)this.g);
            LanguageLevel languageLevel = this.b.getSelectedLevel();
            if (languageLevel != null) {
                languageLevelProjectExtension.setLanguageLevel(languageLevel);
            }
            languageLevelProjectExtension.setDefault(Boolean.valueOf(this.b.isDefault()));
            this.e.apply();
            if (this.h != null) {
                ((ProjectEx)this.g).setProjectName(this.getProjectName());
                if (this.a != null) {
                    this.a.setText(new String[]{this.getBannerSlogan()});
                }
            }
        });
    }

    public void setDisplayName(String string) {
    }

    public Project getEditableObject() {
        return this.g;
    }

    public String getBannerSlogan() {
        return ProjectBundle.message((String)"project.roots.project.banner.text", (Object[])new Object[]{this.g.getName()});
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"project.roots.project.display.name", (Object[])new Object[0]);
    }

    public Icon getIcon(boolean bl2) {
        return AllIcons.Nodes.Project;
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "reference.settingsdialog.project.structure.general";
    }

    public boolean isModified() {
        LanguageLevelProjectExtension languageLevelProjectExtension = LanguageLevelProjectExtension.getInstance((Project)this.g);
        if (languageLevelProjectExtension.isDefault() != this.b.isDefault() || !languageLevelProjectExtension.isDefault() && !languageLevelProjectExtension.getLanguageLevel().equals((Object)this.b.getSelectedLevel())) {
            return true;
        }
        String string = this.b();
        if (!Comparing.strEqual((String)FileUtil.toSystemIndependentName((String)VfsUtilCore.urlToPath((String)string)), (String)FileUtil.toSystemIndependentName((String)this.j.getText()))) {
            return true;
        }
        if (this.e.isModified()) {
            return true;
        }
        return !this.getProjectName().equals(this.g.getName());
    }

    @NotNull
    public String getProjectName() {
        String string = this.h != null ? this.h.getText().trim() : this.g.getName();
        if (string == null) {
            ProjectConfigurable.a(0);
        }
        return string;
    }

    @Nullable
    private String b() {
        CompilerProjectExtension compilerProjectExtension = CompilerProjectExtension.getInstance((Project)this.g);
        return compilerProjectExtension != null ? compilerProjectExtension.getCompilerOutputUrl() : null;
    }

    private void a() {
        this.b = new LanguageLevelCombo(JavaCoreBundle.message((String)"default.language.level.description", (Object[])new Object[0])){

            @Override
            protected LanguageLevel getDefaultLevel() {
                Sdk sdk = ProjectConfigurable.this.e.getSelectedProjectJdk();
                if (sdk == null) {
                    return null;
                }
                JavaSdkVersion javaSdkVersion = JavaSdk.getInstance().getVersion(sdk);
                return javaSdkVersion == null ? null : javaSdkVersion.getMaxLanguageLevel();
            }
        };
        ExtendableTextField extendableTextField = new ExtendableTextField();
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        InsertPathAction.addTo((JTextComponent)extendableTextField, (FileChooserDescriptor)fileChooserDescriptor);
        fileChooserDescriptor.setHideIgnored(false);
        BrowseFilesListener browseFilesListener = new BrowseFilesListener((JTextField)extendableTextField, "", ProjectBundle.message((String)"project.compiler.output", (Object[])new Object[0]), fileChooserDescriptor);
        this.j = new FieldPanel((JTextField)extendableTextField, null, null, (ActionListener)browseFilesListener, EmptyRunnable.getInstance());
        FileChooserFactory.getInstance().installFileCompletion(this.j.getTextField(), fileChooserDescriptor, true, null);
    }

    public String getCompilerOutputUrl() {
        return VfsUtilCore.pathToUrl((String)this.j.getText().trim());
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/ProjectConfigurable", "getProjectName"));
    }

    private /* synthetic */ void c() {
        JPanel jPanel;
        this.a();
        this.d = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(5, 1, new Insets(0, 0, 0, 0), -1, 5, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(4, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        JLabel jLabel = new JLabel();
        this.a(jLabel, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.language.level"));
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        LanguageLevelCombo languageLevelCombo = this.b;
        jPanel2.add((Component)((Object)languageLevelCombo), new GridConstraints(0, 0, 1, 1, 8, 0, 7, 3, null, null, null));
        JLabel jLabel2 = new JLabel();
        this.a(jLabel2, ResourceBundle.getBundle("messages/ProjectBundle").getString("project.compiler.output"));
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 1, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 4, 10, 0), -1, -1, false, false));
        jPanel.add((Component)jPanel3, new GridConstraints(3, 0, 1, 1, 0, 3, 6, 0, null, null, null));
        FieldPanel fieldPanel = this.j;
        jPanel3.add((Component)fieldPanel, new GridConstraints(0, 0, 1, 1, 0, 1, 6, 0, null, null, null));
        ButtonGroup buttonGroup = new ButtonGroup();
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.d;
    }

    private /* synthetic */ void a(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '&') {
                if (++i2 == string.length()) break;
                if (!bl2 && string.charAt(i2) != '&') {
                    bl2 = true;
                    c2 = string.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i2));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl2) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }
}

