/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.ProjectSettingsService;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.InputValidatorEx;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.PathUtilRt;
import java.util.Collection;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/actions/ChangeModuleNamesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.java.ui"})
public final class ChangeModuleNamesAction
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent anActionEvent) {
        Intrinsics.checkParameterIsNotNull((Object)anActionEvent, (String)"e");
        Project project2 = anActionEvent.getProject();
        Presentation presentation = anActionEvent.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setVisible(project2 != null && ModuleGrouperKt.isQualifiedModuleNamesEnabled((Project)project2) && anActionEvent.getData(LangDataKeys.MODIFIABLE_MODULE_MODEL) != null);
        Module[] moduleArray = (Module[])anActionEvent.getData(LangDataKeys.MODULE_CONTEXT_ARRAY);
        Presentation presentation2 = anActionEvent.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation2, (String)"e.presentation");
        presentation2.setEnabled(moduleArray != null && ((Object[])moduleArray).length > 1);
    }

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        boolean bl2;
        String string;
        Module module2;
        ModifiableModuleModel modifiableModuleModel;
        Module[] moduleArray;
        block8: {
            String object;
            Intrinsics.checkParameterIsNotNull((Object)anActionEvent, (String)"e");
            Module[] moduleArray2 = (Module[])anActionEvent.getData(LangDataKeys.MODULE_CONTEXT_ARRAY);
            if (moduleArray2 == null) {
                return;
            }
            moduleArray = moduleArray2;
            ModifiableModuleModel modifiableModuleModel2 = (ModifiableModuleModel)anActionEvent.getData(LangDataKeys.MODIFIABLE_MODULE_MODEL);
            if (modifiableModuleModel2 == null) {
                return;
            }
            modifiableModuleModel = modifiableModuleModel2;
            Function1<Module, String> function1 = new Function1<Module, String>(modifiableModuleModel){
                final /* synthetic */ ModifiableModuleModel $model;

                @NotNull
                public final String invoke(@NotNull Module module2) {
                    Intrinsics.checkParameterIsNotNull((Object)module2, (String)"module");
                    StringBuilder stringBuilder = new StringBuilder();
                    String string = this.$model.getActualName(module2);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"model.getActualName(module)");
                    return stringBuilder.append(StringsKt.substringBeforeLast$default((String)string, (char)'.', null, (int)2, null)).append(".").toString();
                }
                {
                    this.$model = modifiableModuleModel;
                    super(1);
                }
            };
            Intrinsics.checkExpressionValueIsNotNull((Object)moduleArray, (String)"modules");
            Object[] objectArray = moduleArray;
            Module module3 = moduleArray[0];
            Intrinsics.checkExpressionValueIsNotNull((Object)module3, (String)"modules[0]");
            String string2 = object = function1.invoke(module3);
            int n2 = objectArray.length;
            for (int charSequence = 0; charSequence < n2; ++charSequence) {
                module2 = objectArray[charSequence];
                Module module4 = module2;
                String string3 = string2;
                CharSequence charSequence2 = string3;
                Module module5 = module4;
                Intrinsics.checkExpressionValueIsNotNull((Object)module5, (String)"m");
                string2 = StringsKt.commonPrefixWith$default((CharSequence)charSequence2, (CharSequence)function1.invoke(module5), (boolean)false, (int)2, null);
            }
            string = StringsKt.substringBeforeLast((String)string2, (char)'.', (String)"");
            for (Object object2 : (Object[])moduleArray) {
                module2 = (Module)object2;
                if (!Intrinsics.areEqual((Object)modifiableModuleModel.getActualName(module2), (Object)string)) continue;
                bl2 = true;
                break block8;
            }
            bl2 = false;
        }
        boolean bl3 = bl2;
        InputValidatorEx inputValidatorEx = new InputValidatorEx(bl3){
            final /* synthetic */ boolean $isPrefixEqualToModuleName;

            @Nullable
            public String getErrorText(@NotNull String string) {
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"inputString");
                Object object = string;
                if (object.length() > 0) {
                    boolean bl2;
                    block7: {
                        object = StringsKt.split$default((CharSequence)string, (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
                        if (object instanceof Collection && ((Collection)object).isEmpty()) {
                            bl2 = false;
                        } else {
                            Iterator<T> iterator = object.iterator();
                            while (iterator.hasNext()) {
                                T t2 = iterator.next();
                                String string2 = (String)t2;
                                CharSequence charSequence = string2;
                                if (!(charSequence.length() == 0)) continue;
                                bl2 = true;
                                break block7;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) {
                        return ProjectBundle.message((String)"error.message.module.name.prefix.contains.empty.string", (Object[])new Object[0]);
                    }
                }
                if (this.$isPrefixEqualToModuleName && (object = (CharSequence)string).length() == 0) {
                    return ProjectBundle.message((String)"error.message.module.name.cannot.be.empty", (Object[])new Object[0]);
                }
                if (!PathUtilRt.isValidFileName((String)(string + ".iml"), (boolean)true)) {
                    return ProjectBundle.message((String)"error.message.module.name.prefix.contains.invalid.chars", (Object[])new Object[0]);
                }
                return null;
            }

            public boolean checkInput(@NotNull String string) {
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"inputString");
                return this.getErrorText(string) == null;
            }

            public boolean canClose(@NotNull String string) {
                Intrinsics.checkParameterIsNotNull((Object)string, (String)"inputString");
                return this.getErrorText(string) == null;
            }
            {
                this.$isPrefixEqualToModuleName = bl2;
            }
        };
        String string4 = Messages.showInputDialog((Project)anActionEvent.getProject(), (String)ProjectBundle.message((String)"dialog.text.enter.common.prefix", (Object[])new Object[]{((Object[])moduleArray).length}), (String)ProjectBundle.message((String)"dialog.title.change.module.names", (Object[])new Object[0]), null, (String)string, (InputValidator)((InputValidator)inputValidatorEx), (TextRange)TextRange.allOf((String)string), (String)ProjectBundle.message((String)"dialog.text.enter.common.prefix.comment", (Object[])new Object[0]));
        if (string4 == null) {
            return;
        }
        CharSequence charSequence = string;
        String string5 = charSequence.length() == 0 ? "" : "" + string + '.';
        module2 = string4;
        charSequence = module2.length() == 0 || StringsKt.endsWith$default((CharSequence)string4, (char)'.', (boolean)false, (int)2, null) ? string4 : "" + string4 + '.';
        for (Object object : (Module)moduleArray) {
            String string6;
            Module module6 = (Module)object;
            String string7 = modifiableModuleModel.getActualName(module6);
            if (Intrinsics.areEqual((Object)string7, (Object)string)) {
                string6 = string4;
            } else {
                StringBuilder stringBuilder = new StringBuilder().append((String)charSequence);
                String string8 = string7;
                Intrinsics.checkExpressionValueIsNotNull((Object)string8, (String)"oldName");
                string6 = stringBuilder.append(StringsKt.removePrefix((String)string8, (CharSequence)string5)).toString();
            }
            String string9 = string6;
            modifiableModuleModel.renameModule(module6, string9);
        }
        ProjectSettingsService.getInstance((Project)anActionEvent.getProject()).processModulesMoved(moduleArray, null);
    }

    public ChangeModuleNamesAction() {
        super(ProjectBundle.message((String)"action.text.change.module.names", (Object[])new Object[0]), ProjectBundle.message((String)"action.description.change.module.names", (Object[])new Object[0]), null);
    }
}

