/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactProperties;
import com.intellij.packaging.artifacts.ArtifactPropertiesProvider;
import com.intellij.packaging.artifacts.ModifiableArtifact;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.ArtifactPropertiesEditor;
import com.intellij.ui.TabbedPaneWrapper;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nullable;

public class ArtifactPropertiesEditors {
    private static final List<String> d = Arrays.asList("Validation", "Pre-processing", "Post-processing");
    private final Map<String, JPanel> b;
    private final ArtifactEditorContext e;
    private final Artifact a;
    private final List<PropertiesEditorInfo> c;

    public ArtifactPropertiesEditors(ArtifactEditorContext artifactEditorContext, Artifact artifact, Artifact artifact2) {
        this.e = artifactEditorContext;
        this.a = artifact;
        this.b = new HashMap<String, JPanel>();
        this.c = new ArrayList<PropertiesEditorInfo>();
        for (ArtifactPropertiesProvider artifactPropertiesProvider : artifact2.getPropertiesProviders()) {
            PropertiesEditorInfo propertiesEditorInfo = new PropertiesEditorInfo(artifactPropertiesProvider);
            this.c.add(propertiesEditorInfo);
            String string = propertiesEditorInfo.a.getTabName();
            JPanel jPanel = this.b.get(string);
            if (jPanel == null) {
                jPanel = new JPanel((LayoutManager)new VerticalFlowLayout());
                this.b.put(string, jPanel);
            }
            jPanel.add(propertiesEditorInfo.a.createComponent());
        }
    }

    public void applyProperties() {
        for (PropertiesEditorInfo propertiesEditorInfo : this.c) {
            if (!propertiesEditorInfo.isModified()) continue;
            propertiesEditorInfo.applyProperties();
        }
    }

    public void addTabs(TabbedPaneWrapper tabbedPaneWrapper) {
        ArrayList<String> arrayList = new ArrayList<String>(this.b.keySet());
        Collections.sort(arrayList, (string, string2) -> {
            int n2;
            int n3 = d.indexOf(string);
            if (n3 == -1) {
                n3 = d.size();
            }
            if ((n2 = d.indexOf(string2)) == -1) {
                n2 = d.size();
            }
            if (n3 != n2) {
                return n3 - n2;
            }
            return string.compareTo((String)string2);
        });
        for (String string3 : arrayList) {
            tabbedPaneWrapper.addTab(string3, (JComponent)this.b.get(string3));
        }
    }

    public boolean isModified() {
        for (PropertiesEditorInfo propertiesEditorInfo : this.c) {
            if (!propertiesEditorInfo.isModified()) continue;
            return true;
        }
        return false;
    }

    public void removeTabs(TabbedPaneWrapper tabbedPaneWrapper) {
        block0: for (String string : this.b.keySet()) {
            for (int i2 = 0; i2 < tabbedPaneWrapper.getTabCount(); ++i2) {
                if (!string.equals(tabbedPaneWrapper.getTitleAt(i2))) continue;
                tabbedPaneWrapper.removeTabAt(i2);
                continue block0;
            }
        }
    }

    @Nullable
    public String getHelpId(String string) {
        if ("Validation".equals(string)) {
            return "reference.project.structure.artifacts.validation";
        }
        if ("Pre-processing".equals(string)) {
            return "reference.project.structure.artifacts.preprocessing";
        }
        if ("Post-processing".equals(string)) {
            return "reference.project.structure.artifacts.postprocessing";
        }
        for (PropertiesEditorInfo propertiesEditorInfo : this.c) {
            ArtifactPropertiesEditor artifactPropertiesEditor = propertiesEditorInfo.a;
            if (!artifactPropertiesEditor.getTabName().equals(string)) continue;
            return artifactPropertiesEditor.getHelpId();
        }
        return null;
    }

    private class PropertiesEditorInfo {
        private final ArtifactPropertiesEditor a;
        private final ArtifactProperties<?> b;
        private final ArtifactPropertiesProvider c;

        private PropertiesEditorInfo(ArtifactPropertiesProvider artifactPropertiesProvider) {
            this.c = artifactPropertiesProvider;
            this.b = artifactPropertiesProvider.createProperties(ArtifactPropertiesEditors.this.a.getArtifactType());
            ArtifactProperties artifactProperties = ArtifactPropertiesEditors.this.a.getProperties(artifactPropertiesProvider);
            if (artifactProperties != null) {
                ArtifactUtil.copyProperties(artifactProperties, this.b);
            }
            this.a = this.b.createEditor(ArtifactPropertiesEditors.this.e);
            this.a.reset();
        }

        public void applyProperties() {
            this.a.apply();
            ModifiableArtifact modifiableArtifact = ArtifactPropertiesEditors.this.e.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(ArtifactPropertiesEditors.this.a);
            modifiableArtifact.setProperties(this.c, this.b);
        }

        public boolean isModified() {
            return this.a.isModified();
        }
    }
}

