/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.ide.dnd.DnDEvent;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.DnDTarget;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.ComplexElementSubstitutionParameters;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeSelection;
import com.intellij.openapi.roots.ui.configuration.artifacts.PackagingElementDraggingObject;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.ArtifactRootNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingNodeSource;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingTreeNodeFactory;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.elements.PackagingElementType;
import com.intellij.packaging.impl.elements.DirectoryPackagingElement;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingElementPropertiesPanel;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.awt.RelativeRectangle;
import com.intellij.ui.border.CustomLineBorder;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LayoutTreeComponent
implements DnDTarget,
Disposable {
    @NonNls
    private static final String e = "<empty>";
    @NonNls
    private static final String h = "properties";
    private final ArtifactEditorImpl m;
    private final LayoutTree g;
    private final JPanel n;
    private final ComplexElementSubstitutionParameters c;
    private final ArtifactEditorContext l;
    private final Artifact a;
    private SelectedElementInfo<?> d = new SelectedElementInfo(this, null);
    private JPanel k;
    private JPanel i;
    private final LayoutTreeBuilder f;
    private boolean j;
    private final LayoutTreeStructure b;

    public LayoutTreeComponent(ArtifactEditorImpl artifactEditorImpl, ComplexElementSubstitutionParameters complexElementSubstitutionParameters, ArtifactEditorContext artifactEditorContext, Artifact artifact, boolean bl2) {
        this.m = artifactEditorImpl;
        this.c = complexElementSubstitutionParameters;
        this.l = artifactEditorContext;
        this.a = artifact;
        this.j = bl2;
        this.g = new LayoutTree(this.m);
        this.b = new LayoutTreeStructure();
        this.f = new LayoutTreeBuilder();
        Disposer.register((Disposable)this, (Disposable)this.g);
        Disposer.register((Disposable)this, (Disposable)this.f);
        this.g.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                LayoutTreeComponent.this.updatePropertiesPanel(false);
            }
        });
        this.b();
        this.n = new JPanel(new BorderLayout());
        this.n.add((Component)ScrollPaneFactory.createScrollPane((Component)((Object)this.g)), "Center");
        this.n.add((Component)this.k, "South");
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DnDManager.getInstance().registerTarget((DnDTarget)this, (JComponent)((Object)this.g));
        }
    }

    @Nullable
    private WeightBasedComparator a() {
        return this.j ? new WeightBasedComparator(true) : null;
    }

    public void setSortElements(boolean bl2) {
        this.j = bl2;
        this.f.setNodeDescriptorComparator((Comparator)this.a());
        this.m.getContext().getParent().getDefaultSettings().setSortElements(bl2);
    }

    @Nullable
    private static PackagingElementNode a(Object object) {
        if (!(object instanceof DefaultMutableTreeNode)) {
            return null;
        }
        Object object2 = ((DefaultMutableTreeNode)object).getUserObject();
        return object2 instanceof PackagingElementNode ? (PackagingElementNode)((Object)object2) : null;
    }

    private void b() {
        this.i = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setMinimumSize((Dimension)JBUI.emptySize());
        jPanel.setPreferredSize((Dimension)JBUI.emptySize());
        this.k = new JPanel(new CardLayout());
        this.i.setBorder((Border)new CustomLineBorder(1, 0, 0, 0));
        this.k.add(e, jPanel);
        this.k.add(h, this.i);
    }

    public Artifact getArtifact() {
        return this.m.getArtifact();
    }

    public LayoutTree getLayoutTree() {
        return this.g;
    }

    public void updatePropertiesPanel(boolean bl2) {
        PackagingElement<?> packagingElement = this.getSelection().getElementIfSingle();
        if (!bl2 && Comparing.equal(packagingElement, (Object)((SelectedElementInfo)this.d).b)) {
            return;
        }
        this.d.save();
        this.d = new SelectedElementInfo(this, packagingElement);
        this.d.showPropertiesPanel();
    }

    public void saveElementProperties() {
        this.d.save();
    }

    public void rebuildTree() {
        this.f.updateFromRoot(true);
        this.updatePropertiesPanel(true);
        this.m.queueValidation();
    }

    public LayoutTreeSelection getSelection() {
        return this.g.getSelection();
    }

    public void addNewPackagingElement(@NotNull PackagingElementType<?> packagingElementType) {
        CompositePackagingElement compositePackagingElement;
        PackagingElementNode<?> packagingElementNode;
        Object obj;
        if (packagingElementType == null) {
            LayoutTreeComponent.a(0);
        }
        if ((obj = (packagingElementNode = this.a(this.g.getSelection())).getFirstElement()) instanceof CompositePackagingElement) {
            compositePackagingElement = (CompositePackagingElement)obj;
        } else {
            compositePackagingElement = this.getArtifact().getRootElement();
            packagingElementNode = this.g.getRootPackagingNode();
        }
        if (!this.checkCanAdd(compositePackagingElement, packagingElementNode)) {
            return;
        }
        List list2 = packagingElementType.chooseAndCreate(this.l, this.getArtifact(), compositePackagingElement);
        PackagingElementNode<?> packagingElementNode2 = packagingElementNode;
        this.editLayout(() -> {
            CompositePackagingElement<?> compositePackagingElement2 = LayoutTreeComponent.a(compositePackagingElement, packagingElementNode2);
            for (PackagingElement packagingElement : list2) {
                compositePackagingElement2.addOrFindChild(packagingElement);
            }
        });
        this.updateAndSelect(packagingElementNode, list2);
    }

    private static CompositePackagingElement<?> a(CompositePackagingElement<?> compositePackagingElement, PackagingElementNode<?> compositePackagingElementNode) {
        Object obj;
        CompositePackagingElementNode compositePackagingElementNode2;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (compositePackagingElementNode2 = compositePackagingElementNode; compositePackagingElementNode2 != null && !(compositePackagingElementNode2 instanceof ArtifactRootNode); compositePackagingElementNode2 = compositePackagingElementNode2.getParentNode()) {
            obj = compositePackagingElementNode2.getFirstElement();
            if (!(obj instanceof DirectoryPackagingElement)) {
                return compositePackagingElement;
            }
            arrayList.add(((DirectoryPackagingElement)((Object)obj)).getDirectoryName());
        }
        if (compositePackagingElementNode2 == null) {
            return compositePackagingElement;
        }
        obj = compositePackagingElementNode2.getElementIfSingle();
        if (!(obj instanceof CompositePackagingElement)) {
            return compositePackagingElement;
        }
        Collections.reverse(arrayList);
        String string = StringUtil.join(arrayList, (String)"/");
        return PackagingElementFactory.getInstance().getOrCreateDirectory((CompositePackagingElement)obj, string);
    }

    public boolean checkCanModify(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementNode<?> packagingElementNode) {
        if (packagingElement == null) {
            LayoutTreeComponent.a(1);
        }
        if (packagingElementNode == null) {
            LayoutTreeComponent.a(2);
        }
        return this.checkCanModify(packagingElementNode.getNodeSource(packagingElement));
    }

    public boolean checkCanModifyChildren(@NotNull PackagingElement<?> packagingElement, @NotNull PackagingElementNode<?> packagingElementNode, @NotNull Collection<? extends PackagingElementNode<?>> collection) {
        if (packagingElement == null) {
            LayoutTreeComponent.a(3);
        }
        if (packagingElementNode == null) {
            LayoutTreeComponent.a(4);
        }
        if (collection == null) {
            LayoutTreeComponent.a(5);
        }
        ArrayList<PackagingNodeSource> arrayList = new ArrayList<PackagingNodeSource>(packagingElementNode.getNodeSource(packagingElement));
        for (PackagingElementNode<?> packagingElementNode2 : collection) {
            arrayList.addAll(packagingElementNode2.getNodeSources());
        }
        return this.checkCanModify(arrayList);
    }

    public boolean checkCanModify(Collection<PackagingNodeSource> collection) {
        if (collection.isEmpty()) {
            return true;
        }
        if (collection.size() > 1) {
            Messages.showErrorDialog((Component)this.m.getMainComponent(), (String)"The selected node consist of several elements so it cannot be edited.\nSwitch off 'Show content of elements' checkbox to edit the output layout.");
        } else {
            PackagingNodeSource packagingNodeSource = (PackagingNodeSource)ContainerUtil.getFirstItem(collection, null);
            if (packagingNodeSource != null) {
                Messages.showErrorDialog((Component)this.m.getMainComponent(), (String)("The selected node belongs to '" + packagingNodeSource.getPresentableName() + "' element so it cannot be edited.\nSwitch off 'Show content of elements' checkbox to edit the output layout."));
            }
        }
        return false;
    }

    public boolean checkCanAdd(CompositePackagingElement<?> compositePackagingElement, PackagingElementNode<?> compositePackagingElementNode) {
        boolean bl2 = true;
        for (CompositePackagingElementNode compositePackagingElementNode2 = compositePackagingElementNode; compositePackagingElementNode2 != null && !(compositePackagingElementNode2 instanceof ArtifactRootNode); compositePackagingElementNode2 = compositePackagingElementNode2.getParentNode()) {
            Object obj = compositePackagingElementNode2.getFirstElement();
            if (obj instanceof DirectoryPackagingElement) continue;
            bl2 = false;
            break;
        }
        return bl2 || this.checkCanModify((PackagingElement<?>)compositePackagingElement, compositePackagingElementNode);
    }

    public boolean checkCanRemove(List<? extends PackagingElementNode<?>> list2) {
        HashSet<PackagingNodeSource> hashSet = new HashSet<PackagingNodeSource>();
        for (Object object2 : list2) {
            hashSet.addAll(LayoutTreeComponent.a(object2.getNodeSources()));
        }
        if (!hashSet.isEmpty()) {
            Object object;
            if (hashSet.size() == 1) {
                Object object2;
                object2 = ((PackagingNodeSource)hashSet.iterator().next()).getPresentableName();
                object = "The selected node belongs to '" + object2 + "' element. Do you want to remove the whole '" + object2 + "' element from the artifact?";
            } else {
                object = "The selected node belongs to " + list2.size() + " elements. Do you want to remove all these elements from the artifact?";
            }
            int n2 = Messages.showYesNoDialog((Component)this.m.getMainComponent(), (String)object, (String)"Remove Elements", null);
            if (n2 != 0) {
                return false;
            }
        }
        return true;
    }

    public void updateAndSelect(PackagingElementNode<?> packagingElementNode, List<? extends PackagingElement<?>> list2) {
        this.m.queueValidation();
        this.b.clearCaches();
        this.f.queueUpdateFrom(packagingElementNode, true).doWhenDone(() -> {
            List<PackagingElementNode<?>> list3 = this.g.findNodes(list2);
            this.f.select(ArrayUtil.toObjectArray(list3), null);
        });
    }

    public void selectNode(@NotNull String string, @NotNull PackagingElement<?> packagingElement) {
        PackagingElementNode<?> packagingElementNode;
        if (string == null) {
            LayoutTreeComponent.a(6);
        }
        if (packagingElement == null) {
            LayoutTreeComponent.a(7);
        }
        if ((packagingElementNode = this.g.findCompositeNodeByPath(string)) == null) {
            return;
        }
        for (SimpleNode simpleNode : packagingElementNode.getChildren()) {
            if (!(simpleNode instanceof PackagingElementNode)) continue;
            List list2 = ((PackagingElementNode)simpleNode).getPackagingElements();
            for (PackagingElement packagingElement2 : list2) {
                if (!packagingElement2.isEqualTo(packagingElement)) continue;
                this.f.select(simpleNode);
                return;
            }
        }
    }

    public void selectNode(@NotNull String string, @NotNull String string2) {
        PackagingElementNode<?> packagingElementNode;
        if (string == null) {
            LayoutTreeComponent.a(8);
        }
        if (string2 == null) {
            LayoutTreeComponent.a(9);
        }
        if ((packagingElementNode = this.g.findCompositeNodeByPath(string)) == null) {
            return;
        }
        for (SimpleNode simpleNode : packagingElementNode.getChildren()) {
            if (!(simpleNode instanceof PackagingElementNode) || !string2.equals(((PackagingElementNode)simpleNode).getElementPresentation().getSearchName())) continue;
            this.f.select(simpleNode);
            return;
        }
    }

    public void editLayout(Runnable runnable) {
        this.l.editLayout(this.a, runnable);
    }

    public void removeSelectedElements() {
        LayoutTreeSelection layoutTreeSelection = this.g.getSelection();
        if (!this.checkCanRemove(layoutTreeSelection.getNodes())) {
            return;
        }
        this.editLayout(() -> this.removeNodes(layoutTreeSelection.getNodes()));
        this.m.rebuildTries();
    }

    public void removeNodes(List<PackagingElementNode<?>> list2) {
        Object object;
        HashSet<Collection<PackagingNodeSource>> hashSet = new HashSet<Collection<PackagingNodeSource>>();
        for (PackagingElementNode<?> object22 : list2) {
            object = object22.getPackagingElements();
            for (PackagingElement packagingElement : object) {
                Collection<PackagingNodeSource> collection;
                Collection<PackagingNodeSource> collection2 = object22.getNodeSource(packagingElement);
                if (collection2.isEmpty()) {
                    collection = object22.getParentElement(packagingElement);
                    if (collection == null) continue;
                    hashSet.add(collection);
                    collection.removeChild(packagingElement);
                    continue;
                }
                collection = LayoutTreeComponent.a(collection2);
                for (PackagingNodeSource packagingNodeSource : collection) {
                    hashSet.add((Collection<PackagingNodeSource>)packagingNodeSource.getSourceParentElement());
                    packagingNodeSource.getSourceParentElement().removeChild(packagingNodeSource.getSourceElement());
                }
            }
        }
        List<PackagingElementNode<?>> list3 = this.g.findNodes(hashSet);
        Iterator iterator = list3.iterator();
        while (iterator.hasNext()) {
            object = (PackagingElementNode)((Object)iterator.next());
            this.g.addSubtreeToUpdate((PackagingElementNode)((Object)object));
        }
    }

    private static Collection<PackagingNodeSource> a(Collection<PackagingNodeSource> collection) {
        HashSet<PackagingNodeSource> hashSet = new HashSet<PackagingNodeSource>();
        LayoutTreeComponent.a(collection, hashSet);
        return hashSet;
    }

    private static void a(Collection<PackagingNodeSource> collection, Set<PackagingNodeSource> set) {
        for (PackagingNodeSource packagingNodeSource : collection) {
            Collection<PackagingNodeSource> collection2 = packagingNodeSource.getParentSources();
            if (collection2.isEmpty()) {
                set.add(packagingNodeSource);
                continue;
            }
            LayoutTreeComponent.a(collection2, set);
        }
    }

    private PackagingElementNode<?> a(LayoutTreeSelection layoutTreeSelection) {
        PackagingElementNode<?> packagingElementNode = layoutTreeSelection.getNodeIfSingle();
        if (packagingElementNode != null) {
            if (packagingElementNode.getFirstElement() instanceof CompositePackagingElement) {
                return packagingElementNode;
            }
            CompositePackagingElementNode compositePackagingElementNode = packagingElementNode.getParentNode();
            if (compositePackagingElementNode != null) {
                return compositePackagingElementNode;
            }
        }
        return this.g.getRootPackagingNode();
    }

    public JPanel getTreePanel() {
        return this.n;
    }

    public void dispose() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DnDManager.getInstance().unregisterTarget((DnDTarget)this, (JComponent)((Object)this.g));
        }
    }

    public boolean update(DnDEvent dnDEvent) {
        DefaultMutableTreeNode defaultMutableTreeNode;
        dnDEvent.setDropPossible(false);
        dnDEvent.hideHighlighter();
        Object object = dnDEvent.getAttachedObject();
        if (object instanceof PackagingElementDraggingObject && (defaultMutableTreeNode = this.a(dnDEvent.getRelativePoint().getPoint((Component)((Object)this.g)))) != null) {
            Object e2;
            PackagingElementDraggingObject packagingElementDraggingObject = (PackagingElementDraggingObject)object;
            PackagingElementNode packagingElementNode = LayoutTreeComponent.a(defaultMutableTreeNode);
            if (packagingElementNode != null && packagingElementDraggingObject.canDropInto(packagingElementNode) && (e2 = packagingElementNode.getFirstElement()) instanceof CompositePackagingElement) {
                packagingElementDraggingObject.setTargetNode(packagingElementNode);
                packagingElementDraggingObject.setTargetElement((CompositePackagingElement)e2);
                Rectangle rectangle = this.g.getPathBounds(TreeUtil.getPathFromRoot((TreeNode)defaultMutableTreeNode));
                dnDEvent.setHighlighting(new RelativeRectangle((Component)((Object)this.g), rectangle), 1);
                dnDEvent.setDropPossible(true);
            }
        }
        return false;
    }

    public void drop(DnDEvent dnDEvent) {
        Object object = dnDEvent.getAttachedObject();
        if (object instanceof PackagingElementDraggingObject) {
            PackagingElementDraggingObject packagingElementDraggingObject = (PackagingElementDraggingObject)object;
            PackagingElementNode<?> packagingElementNode = packagingElementDraggingObject.getTargetNode();
            CompositePackagingElement<?> compositePackagingElement = packagingElementDraggingObject.getTargetElement();
            if (compositePackagingElement == null || packagingElementNode == null || !packagingElementDraggingObject.checkCanDrop()) {
                return;
            }
            if (!this.checkCanAdd(compositePackagingElement, packagingElementNode)) {
                return;
            }
            ArrayList arrayList = new ArrayList();
            this.editLayout(() -> {
                packagingElementDraggingObject.beforeDrop();
                CompositePackagingElement<?> compositePackagingElement2 = LayoutTreeComponent.a(compositePackagingElement, packagingElementNode);
                for (PackagingElement<?> packagingElement : packagingElementDraggingObject.createPackagingElements(this.l)) {
                    arrayList.add(packagingElement);
                    compositePackagingElement2.addOrFindChild(packagingElement);
                }
            });
            this.updateAndSelect(packagingElementNode, arrayList);
            this.m.getSourceItemsTree().rebuildTree();
        }
    }

    @Nullable
    private DefaultMutableTreeNode a(Point point) {
        for (TreePath treePath = this.g.getPathForLocation(point.x, point.y); treePath != null; treePath = treePath.getParentPath()) {
            PackagingElement<?> packagingElement = this.g.getElementByPath(treePath);
            if (!(packagingElement instanceof CompositePackagingElement)) continue;
            return (DefaultMutableTreeNode)treePath.getLastPathComponent();
        }
        return null;
    }

    public void cleanUpOnLeave() {
    }

    public void updateDraggedImage(Image image, Point point, Point point2) {
    }

    public void startRenaming(TreePath treePath) {
        this.g.startEditingAtPath(treePath);
    }

    public boolean isEditing() {
        return this.g.isEditing();
    }

    public void setRootElement(CompositePackagingElement<?> compositePackagingElement) {
        this.l.getOrCreateModifiableArtifactModel().getOrCreateModifiableArtifact(this.a).setRootElement(compositePackagingElement);
        this.b.updateRootElement();
        DefaultMutableTreeNode defaultMutableTreeNode = this.g.getRootNode();
        defaultMutableTreeNode.setUserObject(this.b.getRootElement());
        this.f.updateNode(defaultMutableTreeNode);
        this.rebuildTree();
        this.m.getSourceItemsTree().rebuildTree();
    }

    public CompositePackagingElement<?> getRootElement() {
        return this.l.getRootElement(this.a);
    }

    public void updateTreeNodesPresentation() {
        this.f.updateFromRoot(false);
    }

    public void updateRootNode() {
        this.f.updateNode(this.g.getRootNode());
    }

    public void initTree() {
        this.f.initRootNode();
        this.d.showPropertiesPanel();
    }

    public void putIntoDefaultLocations(@NotNull List<? extends PackagingSourceItem> list2) {
        if (list2 == null) {
            LayoutTreeComponent.a(10);
        }
        ArrayList arrayList = new ArrayList();
        this.editLayout(() -> {
            if (list2 == null) {
                LayoutTreeComponent.a(17);
            }
            CompositePackagingElement compositePackagingElement = this.getArtifact().getRootElement();
            ArtifactType artifactType = this.getArtifact().getArtifactType();
            for (PackagingSourceItem packagingSourceItem : list2) {
                String string = artifactType.getDefaultPathFor(packagingSourceItem);
                if (string == null) continue;
                CompositePackagingElement compositePackagingElement2 = string.endsWith("!/") ? PackagingElementFactory.getInstance().getOrCreateArchive(compositePackagingElement, StringUtil.trimEnd((String)string, (String)"!/")) : PackagingElementFactory.getInstance().getOrCreateDirectory(compositePackagingElement, string);
                List list4 = packagingSourceItem.createElements(this.l);
                arrayList.addAll(compositePackagingElement2.addOrFindChildren((Collection)list4));
            }
        });
        this.m.getSourceItemsTree().rebuildTree();
        this.updateAndSelect(this.g.getRootPackagingNode(), arrayList);
    }

    public void putElements(@NotNull String string, @NotNull List<? extends PackagingElement<?>> list2) {
        if (string == null) {
            LayoutTreeComponent.a(11);
        }
        if (list2 == null) {
            LayoutTreeComponent.a(12);
        }
        ArrayList arrayList = new ArrayList();
        this.editLayout(() -> {
            if (string == null) {
                LayoutTreeComponent.a(15);
            }
            if (list2 == null) {
                LayoutTreeComponent.a(16);
            }
            CompositePackagingElement compositePackagingElement = PackagingElementFactory.getInstance().getOrCreateDirectory(this.getArtifact().getRootElement(), string);
            arrayList.addAll(compositePackagingElement.addOrFindChildren((Collection)list2));
        });
        this.m.getSourceItemsTree().rebuildTree();
        this.updateAndSelect(this.g.getRootPackagingNode(), arrayList);
    }

    public void packInto(@NotNull List<? extends PackagingSourceItem> list2, String string) {
        if (list2 == null) {
            LayoutTreeComponent.a(13);
        }
        ArrayList arrayList = new ArrayList();
        CompositePackagingElement compositePackagingElement = this.getArtifact().getRootElement();
        this.editLayout(() -> {
            if (list2 == null) {
                LayoutTreeComponent.a(14);
            }
            CompositePackagingElement compositePackagingElement2 = PackagingElementFactory.getInstance().getOrCreateArchive(compositePackagingElement, string);
            for (PackagingSourceItem packagingSourceItem : list2) {
                List list4 = packagingSourceItem.createElements(this.l);
                compositePackagingElement2.addOrFindChildren((Collection)list4);
            }
            arrayList.add(compositePackagingElement2);
        });
        this.m.getSourceItemsTree().rebuildTree();
        this.updateAndSelect(this.g.getRootPackagingNode(), arrayList);
    }

    public boolean isPropertiesModified() {
        PackagingElementPropertiesPanel packagingElementPropertiesPanel = ((SelectedElementInfo)this.d).a;
        return packagingElementPropertiesPanel != null && packagingElementPropertiesPanel.isModified();
    }

    public void resetElementProperties() {
        PackagingElementPropertiesPanel packagingElementPropertiesPanel = ((SelectedElementInfo)this.d).a;
        if (packagingElementPropertiesPanel != null) {
            packagingElementPropertiesPanel.reset();
        }
    }

    public boolean isSortElements() {
        return this.j;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 1: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentPath";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodeName";
                break;
            }
            case 10: 
            case 13: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 11: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 12: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/artifacts/LayoutTreeComponent";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addNewPackagingElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCanModify";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCanModifyChildren";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "selectNode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "putIntoDefaultLocations";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "putElements";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "packInto";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$packInto$6";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$putElements$5";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$putIntoDefaultLocations$4";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class LayoutTreeBuilder
    extends SimpleTreeBuilder {
        public LayoutTreeBuilder() {
            super((JTree)((Object)LayoutTreeComponent.this.g), LayoutTreeComponent.this.g.getBuilderModel(), (AbstractTreeStructure)LayoutTreeComponent.this.b, (Comparator)LayoutTreeComponent.this.a());
        }

        public void updateNode(DefaultMutableTreeNode defaultMutableTreeNode) {
            super.updateNode(defaultMutableTreeNode);
        }
    }

    private class LayoutTreeStructure
    extends SimpleTreeStructure {
        private ArtifactRootNode a;

        private LayoutTreeStructure() {
        }

        public Object getRootElement() {
            if (this.a == null) {
                this.a = PackagingTreeNodeFactory.createRootNode(LayoutTreeComponent.this.m, LayoutTreeComponent.this.l, LayoutTreeComponent.this.c, LayoutTreeComponent.this.getArtifact().getArtifactType());
            }
            return this.a;
        }

        public void updateRootElement() {
            this.a = null;
        }
    }

    private static class SelectedElementInfo<E extends PackagingElement<?>> {
        private final E b;
        private PackagingElementPropertiesPanel a;
        final /* synthetic */ LayoutTreeComponent this$0;

        private SelectedElementInfo(E e2) {
            this.this$0 = var1_1;
            this.b = e2;
            if (this.b != null) {
                this.a = e2.getType().createElementPropertiesPanel(this.b, ((LayoutTreeComponent)var1_1).l);
                ((LayoutTreeComponent)var1_1).i.removeAll();
                if (this.a != null) {
                    ((LayoutTreeComponent)var1_1).i.add("Center", ScrollPaneFactory.createScrollPane((Component)this.a.createComponent(), (boolean)true));
                    this.a.reset();
                    ((LayoutTreeComponent)var1_1).i.revalidate();
                }
            }
        }

        public void save() {
            if (this.a != null && this.a.isModified()) {
                this.this$0.editLayout(() -> this.a.apply());
            }
        }

        public void showPropertiesPanel() {
            CardLayout cardLayout = (CardLayout)this.this$0.k.getLayout();
            if (this.a != null) {
                cardLayout.show(this.this$0.k, LayoutTreeComponent.h);
            } else {
                cardLayout.show(this.this$0.k, LayoutTreeComponent.e);
            }
            this.this$0.k.repaint();
        }
    }
}

