/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.packaging.artifacts.ArtifactType;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.PackagingElementResolvingContext;
import com.intellij.packaging.impl.elements.ManifestFileUtil;
import com.intellij.packaging.ui.ManifestFileConfiguration;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class ManifestFilesInfo {
    private static final Logger c = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.artifacts.ManifestFilesInfo");
    private final Map<VirtualFile, ManifestFileConfiguration> b = new HashMap<VirtualFile, ManifestFileConfiguration>();
    private final Map<VirtualFile, ManifestFileConfiguration> a = new HashMap<VirtualFile, ManifestFileConfiguration>();

    @Nullable
    public ManifestFileConfiguration getManifestFile(CompositePackagingElement<?> compositePackagingElement, ArtifactType artifactType, PackagingElementResolvingContext packagingElementResolvingContext) {
        VirtualFile virtualFile = ManifestFileUtil.findManifestFile(compositePackagingElement, packagingElementResolvingContext, artifactType);
        if (virtualFile == null) {
            return null;
        }
        ManifestFileConfiguration manifestFileConfiguration = this.b.get(virtualFile);
        if (manifestFileConfiguration == null) {
            manifestFileConfiguration = ManifestFileUtil.createManifestFileConfiguration(virtualFile);
            this.a.put(virtualFile, new ManifestFileConfiguration(manifestFileConfiguration));
            this.b.put(virtualFile, manifestFileConfiguration);
        }
        return manifestFileConfiguration;
    }

    public void saveManifestFiles() {
        for (Map.Entry<VirtualFile, ManifestFileConfiguration> entry : this.b.entrySet()) {
            ManifestFileConfiguration manifestFileConfiguration;
            ManifestFileConfiguration manifestFileConfiguration2 = entry.getValue();
            String string = manifestFileConfiguration2.getManifestFilePath();
            if (string == null || (manifestFileConfiguration = this.a.get(entry.getKey())) != null && manifestFileConfiguration.equals((Object)manifestFileConfiguration2)) continue;
            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(string);
            if (virtualFile == null) {
                File file = new File(FileUtil.toSystemDependentName((String)string));
                FileUtil.createIfDoesntExist((File)file);
                virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
                if (virtualFile == null) {
                    c.error("cannot create file: " + file);
                }
            }
            ManifestFileUtil.updateManifest(virtualFile, manifestFileConfiguration2.getMainClass(), manifestFileConfiguration2.getClasspath(), true);
        }
    }

    public boolean isManifestFilesModified() {
        return !this.a.equals(this.b);
    }

    public void clear() {
        this.b.clear();
        this.a.clear();
    }
}

