/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorEx;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeComponent;
import com.intellij.openapi.roots.ui.configuration.artifacts.LayoutTreeSelection;
import com.intellij.openapi.roots.ui.configuration.artifacts.actions.LayoutTreeActionBase;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.CompositePackagingElementNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.nodes.PackagingElementNode;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.packaging.elements.CompositePackagingElement;
import com.intellij.packaging.elements.CompositePackagingElementType;
import com.intellij.packaging.elements.PackagingElement;
import com.intellij.packaging.elements.PackagingElementFactory;
import com.intellij.packaging.impl.artifacts.ArtifactUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class SurroundElementWithAction
extends LayoutTreeActionBase {
    public SurroundElementWithAction(ArtifactEditorEx artifactEditorEx) {
        super("Surround With...", artifactEditorEx);
        this.registerCustomShortcutSet(KeymapUtil.getActiveKeymapShortcuts((String)"SurroundWith"), (JComponent)((Object)artifactEditorEx.getLayoutTreeComponent().getLayoutTree()));
    }

    @Override
    protected boolean isEnabled() {
        return this.myArtifactEditor.getLayoutTreeComponent().getSelection().getCommonParentElement() != null;
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        final LayoutTreeComponent layoutTreeComponent = this.myArtifactEditor.getLayoutTreeComponent();
        LayoutTreeSelection layoutTreeSelection = layoutTreeComponent.getSelection();
        final CompositePackagingElement<?> compositePackagingElement = layoutTreeSelection.getCommonParentElement();
        if (compositePackagingElement == null) {
            return;
        }
        CompositePackagingElementNode compositePackagingElementNode = layoutTreeSelection.getNodes().get(0).getParentNode();
        if (compositePackagingElementNode == null) {
            return;
        }
        if (!layoutTreeComponent.checkCanModifyChildren((PackagingElement<?>)compositePackagingElement, compositePackagingElementNode, (Collection<? extends PackagingElementNode<?>>)layoutTreeSelection.getNodes())) {
            return;
        }
        CompositePackagingElementType[] compositePackagingElementTypeArray = PackagingElementFactory.getInstance().getCompositeElementTypes();
        final List<PackagingElement<?>> list2 = layoutTreeSelection.getElements();
        if (compositePackagingElementTypeArray.length == 1) {
            this.a(compositePackagingElementTypeArray[0], compositePackagingElement, list2, layoutTreeComponent);
        } else {
            JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<CompositePackagingElementType>("Surround With...", compositePackagingElementTypeArray){

                public Icon getIconFor(CompositePackagingElementType compositePackagingElementType) {
                    return compositePackagingElementType.getCreateElementIcon();
                }

                @NotNull
                public String getTextFor(CompositePackagingElementType compositePackagingElementType) {
                    String string = compositePackagingElementType.getPresentableName();
                    if (string == null) {
                        1.a(0);
                    }
                    return string;
                }

                public PopupStep onChosen(CompositePackagingElementType compositePackagingElementType, boolean bl2) {
                    return this.doFinalStep(() -> SurroundElementWithAction.this.a(compositePackagingElementType, compositePackagingElement, list2, layoutTreeComponent));
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/artifacts/actions/SurroundElementWithAction$1", "getTextFor"));
                }
            }).showInBestPositionFor(anActionEvent.getDataContext());
        }
    }

    private void a(CompositePackagingElementType<?> compositePackagingElementType, CompositePackagingElement<?> compositePackagingElement, List<PackagingElement<?>> list2, LayoutTreeComponent layoutTreeComponent) {
        if (this.myArtifactEditor.isDisposed() || list2.isEmpty()) {
            return;
        }
        Project project2 = this.myArtifactEditor.getContext().getProject();
        String string = ((PackagingElement)ContainerUtil.getFirstItem(list2, null)).createPresentation(this.myArtifactEditor.getContext()).getPresentableName();
        String string2 = PathUtil.suggestFileName((String)string);
        CompositePackagingElement compositePackagingElement2 = compositePackagingElementType.createComposite(compositePackagingElement, string2, this.myArtifactEditor.getContext());
        if (compositePackagingElement2 != null) {
            layoutTreeComponent.editLayout(() -> {
                for (PackagingElement packagingElement : list2) {
                    compositePackagingElement2.addOrFindChild(ArtifactUtil.copyWithChildren(packagingElement, project2));
                }
                for (PackagingElement packagingElement : list2) {
                    compositePackagingElement.removeChild(packagingElement);
                }
                compositePackagingElement.addOrFindChild((PackagingElement)compositePackagingElement2);
            });
            layoutTreeComponent.rebuildTree();
        }
    }
}

