/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.dnd.AdvancedDnDSource;
import com.intellij.ide.dnd.DnDAction;
import com.intellij.ide.dnd.DnDDragStartBean;
import com.intellij.ide.dnd.DnDManager;
import com.intellij.ide.dnd.aware.DnDAwareTree;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.ui.configuration.artifacts.ArtifactEditorImpl;
import com.intellij.openapi.roots.ui.configuration.artifacts.SimpleDnDAwareTree;
import com.intellij.openapi.roots.ui.configuration.artifacts.SourceItemsDraggingObject;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemNode;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.SourceItemsTreeRoot;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.ExtractIntoDefaultLocationAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.PackAndPutIntoDefaultLocationAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.PutSourceItemIntoDefaultLocationAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.PutSourceItemIntoParentAndLinkViaManifestAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.SourceItemFindUsagesAction;
import com.intellij.openapi.roots.ui.configuration.artifacts.sourceItems.actions.SourceItemNavigateAction;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.packaging.ui.ArtifactEditorContext;
import com.intellij.packaging.ui.PackagingSourceItem;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.treeStructure.SimpleTreeBuilder;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Image;
import java.awt.Point;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SourceItemsTree
extends SimpleDnDAwareTree
implements AdvancedDnDSource,
Disposable {
    private final ArtifactEditorImpl a;
    private final SimpleTreeBuilder b;

    public SourceItemsTree(ArtifactEditorContext artifactEditorContext, ArtifactEditorImpl artifactEditorImpl) {
        this.a = artifactEditorImpl;
        this.b = new SimpleTreeBuilder((JTree)((Object)this), this.getBuilderModel(), (AbstractTreeStructure)new SourceItemsTreeStructure(artifactEditorContext, artifactEditorImpl), (Comparator)new WeightBasedComparator(true));
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        Disposer.register((Disposable)this, (Disposable)this.b);
        PopupHandler.installPopupHandler((JComponent)((Object)this), (ActionGroup)this.c(), (String)"unknown", (ActionManager)ActionManager.getInstance());
        this.a();
    }

    private void a() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DnDManager.getInstance().registerSource((AdvancedDnDSource)this);
        }
    }

    private ActionGroup c() {
        DefaultActionGroup defaultActionGroup = new DefaultActionGroup();
        defaultActionGroup.add((AnAction)new PutSourceItemIntoDefaultLocationAction(this, this.a));
        defaultActionGroup.add((AnAction)new PackAndPutIntoDefaultLocationAction(this, this.a));
        defaultActionGroup.add((AnAction)new PutSourceItemIntoParentAndLinkViaManifestAction(this, this.a));
        defaultActionGroup.add((AnAction)new ExtractIntoDefaultLocationAction(this, this.a));
        defaultActionGroup.add((AnAction)Separator.getInstance());
        defaultActionGroup.add((AnAction)new SourceItemNavigateAction(this));
        defaultActionGroup.add((AnAction)new SourceItemFindUsagesAction(this, this.a.getContext().getProject(), this.a.getContext().getParent()));
        DefaultTreeExpander defaultTreeExpander = new DefaultTreeExpander((JTree)((Object)this));
        CommonActionsManager commonActionsManager = CommonActionsManager.getInstance();
        defaultActionGroup.add((AnAction)Separator.getInstance());
        defaultActionGroup.addAction(commonActionsManager.createExpandAllAction((TreeExpander)defaultTreeExpander, (JComponent)((Object)this)));
        defaultActionGroup.addAction(commonActionsManager.createCollapseAllAction((TreeExpander)defaultTreeExpander, (JComponent)((Object)this)));
        return defaultActionGroup;
    }

    public void rebuildTree() {
        this.b.updateFromRoot(true);
    }

    public void initTree() {
        this.b.initRootNode();
    }

    public void dispose() {
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            DnDManager.getInstance().unregisterSource((AdvancedDnDSource)this);
        }
    }

    private DefaultMutableTreeNode[] b() {
        return (DefaultMutableTreeNode[])this.getSelectedNodes(DefaultMutableTreeNode.class, null);
    }

    public boolean canStartDragging(DnDAction dnDAction, Point point) {
        return !this.getSelectedItems().isEmpty();
    }

    public DnDDragStartBean startDragging(DnDAction dnDAction, Point point) {
        List<PackagingSourceItem> list2 = this.getSelectedItems();
        return new DnDDragStartBean((Object)new SourceItemsDraggingObject(list2.toArray(new PackagingSourceItem[0])));
    }

    public List<SourceItemNode> getSelectedSourceItemNodes() {
        ArrayList<SourceItemNode> arrayList = new ArrayList<SourceItemNode>();
        for (DefaultMutableTreeNode defaultMutableTreeNode : this.b()) {
            Object object = defaultMutableTreeNode.getUserObject();
            if (!(object instanceof SourceItemNode)) continue;
            arrayList.add((SourceItemNode)((Object)object));
        }
        return arrayList;
    }

    public List<PackagingSourceItem> getSelectedItems() {
        ArrayList<PackagingSourceItem> arrayList = new ArrayList<PackagingSourceItem>();
        for (SourceItemNode sourceItemNode : this.getSelectedSourceItemNodes()) {
            PackagingSourceItem packagingSourceItem = sourceItemNode.getSourceItem();
            if (packagingSourceItem == null || !packagingSourceItem.isProvideElements()) continue;
            arrayList.add(packagingSourceItem);
        }
        return arrayList;
    }

    public Pair<Image, Point> createDraggedImage(DnDAction dnDAction, Point point) {
        DefaultMutableTreeNode[] defaultMutableTreeNodeArray = this.b();
        if (defaultMutableTreeNodeArray.length == 1) {
            return DnDAwareTree.getDragImage((Tree)this, (TreePath)TreeUtil.getPathFromRoot((TreeNode)defaultMutableTreeNodeArray[0]), (Point)point);
        }
        return DnDAwareTree.getDragImage((Tree)this, (String)ProjectBundle.message((String)"drag.n.drop.text.0.packaging.elements", (Object[])new Object[]{defaultMutableTreeNodeArray.length}), (Point)point);
    }

    public void dragDropEnd() {
    }

    public void dropActionChanged(int n2) {
    }

    private static class SourceItemsTreeStructure
    extends SimpleTreeStructure {
        private final ArtifactEditorContext b;
        private final ArtifactEditorImpl c;
        private SourceItemsTreeRoot a;

        public SourceItemsTreeStructure(ArtifactEditorContext artifactEditorContext, ArtifactEditorImpl artifactEditorImpl) {
            this.b = artifactEditorContext;
            this.c = artifactEditorImpl;
        }

        public Object getRootElement() {
            if (this.a == null) {
                this.a = new SourceItemsTreeRoot(this.b, this.c);
            }
            return this.a;
        }
    }
}

