/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.classpath.AddItemPopupAction;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathElementChooser;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathTableItem;
import com.intellij.openapi.roots.ui.configuration.classpath.CreateModuleLibraryChooser;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.util.PlatformIcons;

class AddNewModuleLibraryAction
extends AddItemPopupAction<Library> {
    private static final Logger e = Logger.getInstance(AddNewModuleLibraryAction.class);
    private final StructureConfigurableContext d;

    public AddNewModuleLibraryAction(ClasspathPanel classpathPanel, int n2, StructureConfigurableContext structureConfigurableContext) {
        super(classpathPanel, n2, ProjectBundle.message((String)"classpath.add.simple.module.library.action", (Object[])new Object[0]), PlatformIcons.JAR_ICON);
        this.d = structureConfigurableContext;
    }

    @Override
    protected ClasspathTableItem<?> createTableItem(Library library) {
        OrderEntry[] orderEntryArray;
        for (OrderEntry orderEntry : orderEntryArray = this.myClasspathPanel.getRootModel().getOrderEntries()) {
            LibraryOrderEntry libraryOrderEntry;
            if (!(orderEntry instanceof LibraryOrderEntry) || !library.equals((libraryOrderEntry = (LibraryOrderEntry)orderEntry).getLibrary())) continue;
            return ClasspathTableItem.createLibItem(libraryOrderEntry, this.d);
        }
        e.error("Unknown library " + library);
        return null;
    }

    @Override
    protected ClasspathElementChooser<Library> createChooser() {
        LibraryTable.ModifiableModel modifiableModel = this.myClasspathPanel.getRootModel().getModuleLibraryTable().getModifiableModel();
        return new CreateModuleLibraryChooser(this.myClasspathPanel, modifiableModel);
    }
}

