/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.classpath;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryTypeServiceImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.LibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.ChangeLibraryLevelDialog;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ArchiveFileSystem;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ChangeLibraryLevelActionBase
extends AnAction {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.classpath.ChangeLibraryLevelActionBase");
    protected final Project myProject;
    protected final String myTargetTableLevel;
    protected final boolean myCopy;

    public ChangeLibraryLevelActionBase(@NotNull Project project2, @NotNull String string, @NotNull String string2, boolean bl2) {
        if (project2 == null) {
            ChangeLibraryLevelActionBase.a(0);
        }
        if (string == null) {
            ChangeLibraryLevelActionBase.a(1);
        }
        if (string2 == null) {
            ChangeLibraryLevelActionBase.a(2);
        }
        this.myProject = project2;
        this.myTargetTableLevel = string2;
        this.myCopy = bl2;
        this.getTemplatePresentation().setText(this.a() + " to " + string + "...");
    }

    protected abstract LibraryTableModifiableModelProvider getModifiableTableModelProvider();

    protected abstract JComponent getParentComponent();

    @Nullable
    protected Library doCopy(LibraryEx libraryEx) {
        VirtualFile virtualFile = this.getBaseDir();
        String string = virtualFile != null ? virtualFile.getPath() + "/lib" : "";
        VirtualFile[] virtualFileArray = libraryEx.getFiles(OrderRootType.CLASSES);
        boolean bl2 = this.isConvertingToModuleLibrary() && virtualFileArray.length == 1;
        String string2 = bl2 ? "" : StringUtil.notNullize((String)libraryEx.getName(), (String)LibraryTypeServiceImpl.suggestLibraryName((VirtualFile[])virtualFileArray));
        LibraryTableModifiableModelProvider libraryTableModifiableModelProvider = this.getModifiableTableModelProvider();
        ChangeLibraryLevelDialog changeLibraryLevelDialog = new ChangeLibraryLevelDialog(this.getParentComponent(), this.myProject, this.myCopy, string2, string, bl2, libraryTableModifiableModelProvider);
        if (!changeLibraryLevelDialog.showAndGet()) {
            return null;
        }
        LinkedHashSet<File> linkedHashSet = new LinkedHashSet<File>();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string3 = changeLibraryLevelDialog.getDirectoryForFilesPath();
        if (string3 != null) {
            for (Library library : OrderRootType.getAllTypes()) {
                for (VirtualFile virtualFile2 : libraryEx.getFiles((OrderRootType)library)) {
                    if (!virtualFile2.isInLocalFileSystem() && !(virtualFile2.getFileSystem() instanceof ArchiveFileSystem)) continue;
                    linkedHashSet.add(VfsUtilCore.virtualToIoFile((VirtualFile)VfsUtil.getLocalFile((VirtualFile)virtualFile2)));
                }
            }
            if (!this.a(linkedHashSet, string3, hashMap)) {
                return null;
            }
        }
        Library library = libraryTableModifiableModelProvider.getModifiableModel().createLibrary(StringUtil.nullize((String)changeLibraryLevelDialog.getLibraryName()), libraryEx.getKind());
        LibraryEx.ModifiableModelEx modifiableModelEx = (LibraryEx.ModifiableModelEx)library.getModifiableModel();
        LibraryEditingUtil.copyLibrary(libraryEx, hashMap, modifiableModelEx);
        WriteAction.run(() -> modifiableModelEx.commit());
        return library;
    }

    private boolean a(final Set<File> set, final @NotNull String string, final Map<String, String> map) {
        if (string == null) {
            ChangeLibraryLevelActionBase.a(3);
        }
        final Ref ref = Ref.create((Object)false);
        new Task.Modal(this.myProject, (this.myCopy ? "Copying" : "Moving") + " Library Files", true){

            public void run(@NotNull ProgressIndicator progressIndicator) {
                if (progressIndicator == null) {
                    1.a(0);
                }
                File file = new File(FileUtil.toSystemDependentName((String)string));
                for (File file2 : set) {
                    progressIndicator.checkCanceled();
                    File file3 = FileUtil.findSequentNonexistentFile((File)file, (String)FileUtil.getNameWithoutExtension((File)file2), (String)FileUtilRt.getExtension((String)file2.getName()));
                    try {
                        if (file2.isDirectory()) {
                            if (ChangeLibraryLevelActionBase.this.myCopy) {
                                FileUtil.copyDir((File)file2, (File)file3);
                            } else {
                                FileUtil.moveDirWithContent((File)file2, (File)file3);
                            }
                        } else if (ChangeLibraryLevelActionBase.this.myCopy) {
                            FileUtil.copy((File)file2, (File)file3);
                        } else {
                            FileUtil.rename((File)file2, (File)file3);
                        }
                    }
                    catch (IOException iOException) {
                        String string3 = ChangeLibraryLevelActionBase.this.a();
                        String string2 = "Cannot " + string3.toLowerCase() + " file " + file2.getAbsolutePath() + ": " + iOException.getMessage();
                        Messages.showErrorDialog((Project)ChangeLibraryLevelActionBase.this.myProject, (String)string2, (String)("Cannot " + string3));
                        a.info((Throwable)iOException);
                        return;
                    }
                    map.put(FileUtil.toSystemIndependentName((String)file2.getAbsolutePath()), FileUtil.toSystemIndependentName((String)file3.getAbsolutePath()));
                }
                ref.set((Object)true);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/roots/ui/configuration/classpath/ChangeLibraryLevelActionBase$1", "run"));
            }
        }.queue();
        if (!((Boolean)ref.get()).booleanValue()) {
            return false;
        }
        new WriteAction(){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    2.a(0);
                }
                for (Map.Entry entry : map.entrySet()) {
                    VirtualFile virtualFile;
                    String string = (String)entry.getKey();
                    String string2 = (String)entry.getValue();
                    LocalFileSystem.getInstance().refreshAndFindFileByPath(string2);
                    if (ChangeLibraryLevelActionBase.this.myCopy || (virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(string).getParentFile())) == null) continue;
                    virtualFile.refresh(false, false);
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/roots/ui/configuration/classpath/ChangeLibraryLevelActionBase$2", "run"));
            }
        }.execute();
        return true;
    }

    public void update(AnActionEvent anActionEvent) {
        Presentation presentation = anActionEvent.getPresentation();
        boolean bl2 = this.isEnabled();
        presentation.setVisible(bl2);
        presentation.setEnabled(bl2);
    }

    private String a() {
        return this.myCopy ? "Copy" : "Move";
    }

    @Nullable
    protected VirtualFile getBaseDir() {
        return this.myProject.getBaseDir();
    }

    protected boolean isConvertingToModuleLibrary() {
        return this.myTargetTableLevel.equals("module");
    }

    protected abstract boolean isEnabled();

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetTableName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetTableLevel";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDirPath";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/classpath/ChangeLibraryLevelActionBase";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "copyOrMoveFiles";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

