/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.libraries;

import com.intellij.ide.IdeBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.ModuleLibraryTable;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.impl.libraries.LibraryImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.libraries.LibraryType;
import com.intellij.openapi.roots.ui.configuration.FacetsProvider;
import com.intellij.openapi.roots.ui.configuration.classpath.ClasspathPanel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureValidator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ParameterizedRunnable;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.Predicate;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryEditingUtil {
    private static final Logger a = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil");

    private LibraryEditingUtil() {
    }

    public static boolean libraryAlreadyExists(LibraryTable.ModifiableModel modifiableModel, String string) {
        Iterator iterator = modifiableModel.getLibraryIterator();
        while (iterator.hasNext()) {
            Library library = (Library)iterator.next();
            String string2 = modifiableModel instanceof LibrariesModifiableModel ? ((LibrariesModifiableModel)modifiableModel).getLibraryEditor(library).getName() : library.getName();
            if (!string.equals(string2)) continue;
            return true;
        }
        return false;
    }

    public static String suggestNewLibraryName(LibraryTable.ModifiableModel modifiableModel, String string) {
        String string2 = string;
        int n2 = 1;
        while (LibraryEditingUtil.libraryAlreadyExists(modifiableModel, string2)) {
            string2 = string + n2++;
        }
        return string2;
    }

    public static Predicate<Library> getNotAddedSuitableLibrariesCondition(ModuleRootModel moduleRootModel, FacetsProvider facetsProvider) {
        OrderEntry[] orderEntryArray = moduleRootModel.getOrderEntries();
        HashSet<Library> hashSet = new HashSet<Library>(orderEntryArray.length);
        for (OrderEntry orderEntry : orderEntryArray) {
            LibraryImpl libraryImpl;
            if (!(orderEntry instanceof LibraryOrderEntry) || !orderEntry.isValid() || (libraryImpl = (LibraryImpl)((LibraryOrderEntry)orderEntry).getLibrary()) == null) continue;
            Library library2 = libraryImpl.getSource();
            hashSet.add((Library)(library2 != null ? library2 : libraryImpl));
        }
        return library -> {
            LibraryType libraryType;
            Library library2;
            if (hashSet.contains(library)) {
                return false;
            }
            if (library instanceof LibraryImpl && (library2 = ((LibraryImpl)library).getSource()) != null && hashSet.contains(library2)) {
                return false;
            }
            library2 = ((LibraryEx)library).getKind();
            return library2 == null || (libraryType = LibraryType.findByKind((LibraryKind)library2)) == null || libraryType.isSuitableModule(moduleRootModel.getModule(), facetsProvider);
        };
    }

    public static void copyLibrary(LibraryEx libraryEx, Map<String, String> map, LibraryEx.ModifiableModelEx modifiableModelEx) {
        modifiableModelEx.setProperties(libraryEx.getProperties());
        for (OrderRootType orderRootType : OrderRootType.getAllTypes()) {
            String[] stringArray;
            for (String string : stringArray = libraryEx.getUrls(orderRootType)) {
                String string2;
                String string3;
                String string4;
                String string5 = VirtualFileManager.extractProtocol((String)string);
                if (string5 == null) continue;
                String string6 = VirtualFileManager.extractPath((String)string);
                int n2 = string6.indexOf("!/");
                if (n2 != -1) {
                    string4 = string6.substring(0, n2);
                    string3 = string6.substring(n2);
                } else {
                    string4 = string6;
                    string3 = "";
                }
                String string7 = map.get(string4);
                String string8 = string2 = string7 != null ? VirtualFileManager.constructUrl((String)string5, (String)(string7 + string3)) : string;
                if (libraryEx.isJarDirectory(string, orderRootType)) {
                    modifiableModelEx.addJarDirectory(string2, false, orderRootType);
                    continue;
                }
                modifiableModelEx.addRoot(string2, orderRootType);
            }
        }
    }

    public static LibraryTablePresentation getLibraryTablePresentation(@NotNull Project project2, @NotNull String string) {
        if (project2 == null) {
            LibraryEditingUtil.a(0);
        }
        if (string == null) {
            LibraryEditingUtil.a(1);
        }
        if (string.equals("module")) {
            return ModuleLibraryTable.MODULE_LIBRARY_TABLE_PRESENTATION;
        }
        LibraryTable libraryTable = LibraryTablesRegistrar.getInstance().getLibraryTableByLevel(string, project2);
        a.assertTrue(libraryTable != null, (Object)string);
        return libraryTable.getPresentation();
    }

    public static List<LibraryType> getSuitableTypes(ClasspathPanel classpathPanel) {
        ArrayList<LibraryType> arrayList = new ArrayList<LibraryType>();
        arrayList.add(null);
        Module module2 = classpathPanel.getRootModel().getModule();
        for (LibraryType libraryType : (LibraryType[])LibraryType.EP_NAME.getExtensions()) {
            if (libraryType.getCreateActionName() == null || !libraryType.isSuitableModule(module2, classpathPanel.getModuleConfigurationState().getFacetsProvider())) continue;
            arrayList.add(libraryType);
        }
        return arrayList;
    }

    public static boolean hasSuitableTypes(ClasspathPanel classpathPanel) {
        return LibraryEditingUtil.getSuitableTypes(classpathPanel).size() > 1;
    }

    public static BaseListPopupStep<LibraryType> createChooseTypeStep(ClasspathPanel classpathPanel, final ParameterizedRunnable<LibraryType> parameterizedRunnable) {
        return new BaseListPopupStep<LibraryType>(IdeBundle.message((String)"popup.title.select.library.type", (Object[])new Object[0]), LibraryEditingUtil.getSuitableTypes(classpathPanel)){

            @NotNull
            public String getTextFor(LibraryType libraryType) {
                String string = libraryType != null ? libraryType.getCreateActionName() : IdeBundle.message((String)"create.default.library.type.action.name", (Object[])new Object[0]);
                if (string == null) {
                    1.a(0);
                }
                return string;
            }

            public Icon getIconFor(LibraryType libraryType) {
                return libraryType != null ? libraryType.getIcon(null) : PlatformIcons.LIBRARY_ICON;
            }

            public PopupStep onChosen(LibraryType libraryType, boolean bl2) {
                return this.doFinalStep(() -> parameterizedRunnable.run((Object)libraryType));
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/libraries/LibraryEditingUtil$1", "getTextFor"));
            }
        };
    }

    public static List<Module> getSuitableModules(@NotNull ModuleStructureConfigurable moduleStructureConfigurable, @Nullable LibraryKind libraryKind, @Nullable Library library) {
        if (moduleStructureConfigurable == null) {
            LibraryEditingUtil.a(2);
        }
        ArrayList<Module> arrayList = new ArrayList<Module>();
        LibraryType libraryType = libraryKind == null ? null : LibraryType.findByKind((LibraryKind)libraryKind);
        for (Module module2 : moduleStructureConfigurable.getModules()) {
            ModuleRootModel moduleRootModel;
            if (libraryType != null && !libraryType.isSuitableModule(module2, (FacetsProvider)moduleStructureConfigurable.getFacetConfigurator()) || library != null && !LibraryEditingUtil.getNotAddedSuitableLibrariesCondition(moduleRootModel = moduleStructureConfigurable.getContext().getModulesConfigurator().getRootModel(module2), moduleStructureConfigurable.getFacetConfigurator()).apply((Object)library)) continue;
            arrayList.add(module2);
        }
        return arrayList;
    }

    public static void showDialogAndAddLibraryToDependencies(@NotNull Library library, @NotNull Project project2, boolean bl2) {
        if (library == null) {
            LibraryEditingUtil.a(3);
        }
        if (project2 == null) {
            LibraryEditingUtil.a(4);
        }
        ProjectStructureValidator.showDialogAndAddLibraryToDependencies(library, project2, bl2);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootConfigurable";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/libraries/LibraryEditingUtil";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getLibraryTablePresentation";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getSuitableModules";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "showDialogAndAddLibraryToDependencies";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

