/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryKind;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryEditingUtil;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseLibrariesConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import org.jetbrains.annotations.NotNull;

public class AddLibraryToModuleDependenciesAction
extends DumbAwareAction {
    @NotNull
    private final Project b;
    @NotNull
    private final BaseLibrariesConfigurable a;

    public AddLibraryToModuleDependenciesAction(@NotNull Project project2, @NotNull BaseLibrariesConfigurable baseLibrariesConfigurable) {
        if (project2 == null) {
            AddLibraryToModuleDependenciesAction.a(0);
        }
        if (baseLibrariesConfigurable == null) {
            AddLibraryToModuleDependenciesAction.a(1);
        }
        super("Add to Modules...", "Add the library to the dependencies list of chosen modules", null);
        this.b = project2;
        this.a = baseLibrariesConfigurable;
    }

    public void update(AnActionEvent anActionEvent) {
        ProjectStructureElement projectStructureElement = this.a.getSelectedElement();
        boolean bl2 = false;
        if (projectStructureElement instanceof LibraryProjectStructureElement) {
            LibraryEx libraryEx = (LibraryEx)((LibraryProjectStructureElement)projectStructureElement).getLibrary();
            bl2 = !LibraryEditingUtil.getSuitableModules(ModuleStructureConfigurable.getInstance(this.b), (LibraryKind)libraryEx.getKind(), (Library)libraryEx).isEmpty();
        }
        anActionEvent.getPresentation().setVisible(bl2);
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        LibraryProjectStructureElement libraryProjectStructureElement = (LibraryProjectStructureElement)this.a.getSelectedElement();
        if (libraryProjectStructureElement == null) {
            return;
        }
        Library library = libraryProjectStructureElement.getLibrary();
        LibraryEditingUtil.showDialogAndAddLibraryToDependencies(library, this.b, false);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "configurable";
                break;
            }
        }
        objectArray[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/AddLibraryToModuleDependenciesAction";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

