/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.facet.Facet;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FindUsagesInProjectStructureActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementRenderer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzerListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.MasterDetailsState;
import com.intellij.openapi.ui.MasterDetailsStateService;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.navigation.Place;
import com.intellij.util.IconUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseStructureConfigurable
extends MasterDetailsComponent
implements SearchableConfigurable,
Disposable,
Place.Navigator {
    protected StructureConfigurableContext myContext;
    protected final Project myProject;
    protected boolean myUiDisposed;
    private boolean a;
    protected boolean myAutoScrollEnabled;

    protected BaseStructureConfigurable(Project project2, MasterDetailsState masterDetailsState) {
        super(masterDetailsState);
        this.myUiDisposed = true;
        this.myAutoScrollEnabled = true;
        this.myProject = project2;
    }

    protected BaseStructureConfigurable(@NotNull Project project2) {
        if (project2 == null) {
            BaseStructureConfigurable.a(0);
        }
        this.myUiDisposed = true;
        this.myAutoScrollEnabled = true;
        this.myProject = project2;
    }

    public void init(StructureConfigurableContext structureConfigurableContext) {
        this.myContext = structureConfigurableContext;
        this.myContext.getDaemonAnalyzer().addListener(new ProjectStructureDaemonAnalyzerListener(){

            @Override
            public void problemsChanged(@NotNull ProjectStructureElement projectStructureElement) {
                if (projectStructureElement == null) {
                    1.a(0);
                }
                if (!BaseStructureConfigurable.this.myTree.isShowing()) {
                    return;
                }
                BaseStructureConfigurable.this.myTree.revalidate();
                BaseStructureConfigurable.this.myTree.repaint();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseStructureConfigurable$1", "problemsChanged"));
            }
        });
    }

    protected MasterDetailsStateService getStateService() {
        return MasterDetailsStateService.getInstance((Project)this.myProject);
    }

    public ActionCallback navigateTo(@Nullable Place place, boolean bl2) {
        MasterDetailsComponent.MyNode myNode;
        if (place == null) {
            return ActionCallback.DONE;
        }
        Object object = place.getPath("treeObject");
        String string = (String)place.getPath("treeName");
        if (object == null && string == null) {
            return ActionCallback.DONE;
        }
        MasterDetailsComponent.MyNode myNode2 = object == null ? null : BaseStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)object);
        MasterDetailsComponent.MyNode myNode3 = myNode = string == null ? null : BaseStructureConfigurable.findNodeByName((TreeNode)this.myRoot, (String)string);
        if (myNode2 == null && myNode == null) {
            return ActionCallback.DONE;
        }
        NamedConfigurable namedConfigurable = myNode2 != null ? myNode2.getConfigurable() : myNode.getConfigurable();
        ActionCallback actionCallback = new ActionCallback().doWhenDone(() -> {
            this.myAutoScrollEnabled = true;
        });
        this.myAutoScrollEnabled = false;
        this.myAutoScrollHandler.cancelAllRequests();
        MasterDetailsComponent.MyNode myNode4 = myNode2 != null ? myNode2 : myNode;
        this.selectNodeInTree((DefaultMutableTreeNode)myNode4, bl2).doWhenDone(() -> {
            this.setSelectedNode(myNode4);
            Place.goFurther((Object)namedConfigurable, (Place)place, (boolean)bl2).notifyWhenDone(actionCallback);
        });
        return actionCallback;
    }

    public void queryPlace(@NotNull Place place) {
        if (place == null) {
            BaseStructureConfigurable.a(1);
        }
        if (this.myCurrentConfigurable != null) {
            place.putPath("treeObject", this.myCurrentConfigurable.getEditableObject());
            Place.queryFurther((Object)this.myCurrentConfigurable, (Place)place);
        }
    }

    protected void initTree() {
        if (this.a) {
            return;
        }
        this.a = true;
        super.initTree();
        new TreeSpeedSearch(this.myTree, treePath -> this.getTextForSpeedSearch((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()), true);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        this.myTree.setCellRenderer((TreeCellRenderer)((Object)new ProjectStructureElementRenderer(this.myContext)));
    }

    @NotNull
    protected String getTextForSpeedSearch(MasterDetailsComponent.MyNode myNode) {
        String string = myNode.getDisplayName();
        if (string == null) {
            BaseStructureConfigurable.a(2);
        }
        return string;
    }

    public void disposeUIResources() {
        if (this.myUiDisposed) {
            return;
        }
        super.disposeUIResources();
        this.myUiDisposed = true;
        this.myAutoScrollHandler.cancelAllRequests();
        this.myContext.getDaemonAnalyzer().clear();
        Disposer.dispose((Disposable)this);
    }

    public void checkCanApply() throws ConfigurationException {
    }

    protected void addCollapseExpandActions(List<AnAction> list2) {
        TreeExpander treeExpander = new TreeExpander(){

            public void expandAll() {
                TreeUtil.expandAll((JTree)BaseStructureConfigurable.this.myTree);
            }

            public boolean canExpand() {
                return true;
            }

            public void collapseAll() {
                TreeUtil.collapseAll((JTree)BaseStructureConfigurable.this.myTree, (int)0);
            }

            public boolean canCollapse() {
                return true;
            }
        };
        CommonActionsManager commonActionsManager = CommonActionsManager.getInstance();
        list2.add(commonActionsManager.createExpandAllAction(treeExpander, (JComponent)this.myTree));
        list2.add(commonActionsManager.createCollapseAllAction(treeExpander, (JComponent)this.myTree));
    }

    @Nullable
    public ProjectStructureElement getSelectedElement() {
        MasterDetailsComponent.MyNode myNode;
        NamedConfigurable namedConfigurable;
        TreePath treePath = this.myTree.getSelectionPath();
        if (treePath != null && treePath.getLastPathComponent() instanceof MasterDetailsComponent.MyNode && (namedConfigurable = (myNode = (MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getConfigurable()) instanceof ProjectStructureElementConfigurable) {
            return ((ProjectStructureElementConfigurable)namedConfigurable).getProjectStructureElement();
        }
        return null;
    }

    public void reset() {
        this.myUiDisposed = false;
        if (!this.a) {
            this.initTree();
            this.myTree.setShowsRootHandles(false);
            this.a();
        } else {
            this.reloadTreeNodes();
        }
        super.reset();
    }

    private void a() {
        this.loadTree();
        for (ProjectStructureElement projectStructureElement : this.getProjectStructureElements()) {
            this.myContext.getDaemonAnalyzer().queueUpdate(projectStructureElement);
        }
    }

    protected final void reloadTreeNodes() {
        super.disposeUIResources();
        this.myTree.setShowsRootHandles(false);
        this.a();
    }

    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        List list2 = Collections.emptyList();
        if (list2 == null) {
            BaseStructureConfigurable.a(3);
        }
        return list2;
    }

    protected abstract void loadTree();

    @NotNull
    protected ArrayList<AnAction> createActions(boolean bl2) {
        ArrayList<AnAction> arrayList = new ArrayList<AnAction>();
        AbstractAddGroup abstractAddGroup = this.createAddAction();
        if (abstractAddGroup != null) {
            arrayList.add((AnAction)abstractAddGroup);
        }
        arrayList.add((AnAction)new MyRemoveAction());
        List<? extends AnAction> list2 = this.createCopyActions(bl2);
        arrayList.addAll(list2);
        arrayList.add((AnAction)Separator.getInstance());
        if (bl2) {
            arrayList.add(new MyFindUsagesAction((JComponent)this.myTree));
        }
        ArrayList<AnAction> arrayList2 = arrayList;
        if (arrayList2 == null) {
            BaseStructureConfigurable.a(4);
        }
        return arrayList2;
    }

    @NotNull
    protected List<? extends AnAction> createCopyActions(boolean bl2) {
        List list2 = Collections.emptyList();
        if (list2 == null) {
            BaseStructureConfigurable.a(5);
        }
        return list2;
    }

    public void onStructureUnselected() {
    }

    public void onStructureSelected() {
    }

    @Nullable
    protected abstract AbstractAddGroup createAddAction();

    protected List<? extends RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return Collections.emptyList();
    }

    @NotNull
    private MultiMap<RemoveConfigurableHandler, MasterDetailsComponent.MyNode> a(List<MasterDetailsComponent.MyNode> list2) {
        List<? extends RemoveConfigurableHandler<?>> list3 = this.getRemoveHandlers();
        LinkedMultiMap linkedMultiMap = new LinkedMultiMap();
        for (MasterDetailsComponent.MyNode myNode : list2) {
            RemoveConfigurableHandler<?> removeConfigurableHandler;
            NamedConfigurable namedConfigurable = myNode.getConfigurable();
            if (namedConfigurable == null || (removeConfigurableHandler = BaseStructureConfigurable.a(list3, namedConfigurable.getClass())) == null) continue;
            linkedMultiMap.putValue(removeConfigurableHandler, (Object)myNode);
        }
        LinkedMultiMap linkedMultiMap2 = linkedMultiMap;
        if (linkedMultiMap2 == null) {
            BaseStructureConfigurable.a(6);
        }
        return linkedMultiMap2;
    }

    private static RemoveConfigurableHandler<?> a(List<? extends RemoveConfigurableHandler<?>> list2, Class<? extends NamedConfigurable> clazz) {
        for (RemoveConfigurableHandler<?> removeConfigurableHandler : list2) {
            if (!removeConfigurableHandler.getConfigurableClass().isAssignableFrom(clazz)) continue;
            return removeConfigurableHandler;
        }
        return null;
    }

    private static List<?> a(Collection<MasterDetailsComponent.MyNode> collection) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (MasterDetailsComponent.MyNode myNode : collection) {
            arrayList.add(myNode.getConfigurable().getEditableObject());
        }
        return arrayList;
    }

    protected void removeFacetNodes(@NotNull List<Facet> list2) {
        if (list2 == null) {
            BaseStructureConfigurable.a(7);
        }
        for (Facet facet : list2) {
            MasterDetailsComponent.MyNode myNode = BaseStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)facet);
            if (myNode == null) continue;
            this.removePaths(new TreePath[]{TreeUtil.getPathFromRoot((TreeNode)myNode)});
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseStructureConfigurable";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facets";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/BaseStructureConfigurable";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextForSpeedSearch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectStructureElements";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopyActions";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "groupNodes";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "queryPlace";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeFacetNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static abstract class AbstractAddGroup
    extends ActionGroup
    implements MasterDetailsComponent.ActionGroupWithPreselection {
        protected AbstractAddGroup(String string, Icon icon) {
            super(string, true);
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(icon);
            Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
            if (keymap != null) {
                Shortcut[] shortcutArray = keymap.getShortcuts("NewElement");
                this.setShortcutSet((ShortcutSet)new CustomShortcutSet(shortcutArray));
            }
        }

        public AbstractAddGroup(String string) {
            this(string, IconUtil.getAddIcon());
        }

        public ActionGroup getActionGroup() {
            return this;
        }
    }

    protected class MyRemoveAction
    extends MasterDetailsComponent.MyDeleteAction {
        public MyRemoveAction() {
            super((MasterDetailsComponent)BaseStructureConfigurable.this, (Condition)new Condition<Object[]>(){

                public boolean value(Object[] multiMap) {
                    ArrayList<MasterDetailsComponent.MyNode> arrayList = new ArrayList<MasterDetailsComponent.MyNode>();
                    for (Object object : multiMap) {
                        if (!(object instanceof MasterDetailsComponent.MyNode)) {
                            return false;
                        }
                        arrayList.add((MasterDetailsComponent.MyNode)object);
                    }
                    MultiMap multiMap2 = BaseStructureConfigurable.this.a(arrayList);
                    for (Map.Entry entry : multiMap2.entrySet()) {
                        if (((RemoveConfigurableHandler)entry.getKey()).canBeRemoved(BaseStructureConfigurable.a((Collection)entry.getValue()))) continue;
                        return false;
                    }
                    return true;
                }
            });
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            TreePath[] treePathArray = BaseStructureConfigurable.this.myTree.getSelectionPaths();
            if (treePathArray == null) {
                return;
            }
            List<MasterDetailsComponent.MyNode> list2 = this.a(treePathArray);
            BaseStructureConfigurable.this.removeNodes(list2);
        }

        private List<MasterDetailsComponent.MyNode> a(TreePath[] treePathArray) {
            List list2 = ContainerUtil.mapNotNull((Object[])treePathArray, treePath -> {
                Object object = treePath.getLastPathComponent();
                return object instanceof MasterDetailsComponent.MyNode ? (MasterDetailsComponent.MyNode)object : null;
            });
            MultiMap multiMap = BaseStructureConfigurable.this.a(list2);
            ArrayList<MasterDetailsComponent.MyNode> arrayList = new ArrayList<MasterDetailsComponent.MyNode>();
            for (Map.Entry entry : multiMap.entrySet()) {
                boolean bl2 = ((RemoveConfigurableHandler)entry.getKey()).remove(BaseStructureConfigurable.a((Collection)entry.getValue()));
                if (!bl2) continue;
                arrayList.addAll((Collection)entry.getValue());
            }
            return arrayList;
        }
    }

    private class MyFindUsagesAction
    extends FindUsagesInProjectStructureActionBase {
        public MyFindUsagesAction(JComponent jComponent) {
            super(jComponent, BaseStructureConfigurable.this.myProject);
        }

        @Override
        protected boolean isEnabled() {
            TreePath treePath = BaseStructureConfigurable.this.myTree.getSelectionPath();
            if (treePath != null) {
                MasterDetailsComponent.MyNode myNode = (MasterDetailsComponent.MyNode)treePath.getLastPathComponent();
                return !myNode.isDisplayInBold();
            }
            return false;
        }

        @Override
        protected StructureConfigurableContext getContext() {
            return BaseStructureConfigurable.this.myContext;
        }

        @Override
        protected ProjectStructureElement getSelectedElement() {
            return BaseStructureConfigurable.this.getSelectedElement();
        }

        @Override
        protected RelativePoint getPointToShowResults() {
            int n2 = BaseStructureConfigurable.this.myTree.getSelectionRows()[0];
            Rectangle rectangle = BaseStructureConfigurable.this.myTree.getRowBounds(n2);
            Point point = rectangle.getLocation();
            point.x += rectangle.width;
            return new RelativePoint((Component)BaseStructureConfigurable.this.myTree, point);
        }
    }
}

