/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.jarRepository.JarRepositoryManager;
import com.intellij.jarRepository.RepositoryAttachDialog;
import com.intellij.jarRepository.RepositoryLibraryType;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.impl.libraries.LibraryEx;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.roots.libraries.NewLibraryConfiguration;
import com.intellij.openapi.roots.libraries.ui.OrderRoot;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ComparingJarFilesTask;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ConvertToRepositoryLibraryActionBase;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ConvertToRepositoryLibraryActionBaseKt;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibraryJarsDiffDialog;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.idea.maven.utils.library.RepositoryUtils;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0003\b&\u0018\u0000 $2\u00020\u0001:\u0001$B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u0013\u001a\u00020\u0016H\u0002J\u0018\u0010\u0017\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0014H$J\u0018\u0010\u0019\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J$\u0010\u001c\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u00162\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u001f\u0012\u0004\u0012\u00020\r0\u001eH$J\u0018\u0010 \u001a\u0004\u0018\u00010\u00122\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00120\"H\u0002J\u0010\u0010#\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u001c\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006%"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertToRepositoryLibraryActionBase;", "Lcom/intellij/openapi/project/DumbAwareAction;", "context", "Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;", "(Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;)V", "getContext", "()Lcom/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext;", "project", "Lcom/intellij/openapi/project/Project;", "kotlin.jvm.PlatformType", "getProject", "()Lcom/intellij/openapi/project/Project;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "changeCoordinatesAndRetry", "mavenCoordinates", "Lorg/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor;", "library", "Lcom/intellij/openapi/roots/impl/libraries/LibraryEx;", "detectOrSpecifyMavenCoordinates", "Lcom/intellij/openapi/roots/libraries/Library;", "downloadLibraryAndReplace", "getSelectedLibrary", "replaceByLibrary", "configuration", "Lcom/intellij/openapi/roots/libraries/NewLibraryConfiguration;", "replaceLibrary", "configureNewLibrary", "Lkotlin/Function1;", "Lcom/intellij/openapi/roots/ui/configuration/libraryEditor/LibraryEditorBase;", "specifyMavenCoordinates", "detectedCoordinates", "", "update", "Companion", "intellij.java.ui"})
public abstract class ConvertToRepositoryLibraryActionBase
extends DumbAwareAction {
    private final Project b;
    @NotNull
    private final StructureConfigurableContext a;
    public static final Companion Companion = new Companion(null);

    protected final Project getProject() {
        return this.b;
    }

    @Nullable
    protected abstract LibraryEx getSelectedLibrary();

    public void update(@NotNull AnActionEvent anActionEvent) {
        Intrinsics.checkParameterIsNotNull((Object)anActionEvent, (String)"e");
        LibraryEx libraryEx = this.getSelectedLibrary();
        Presentation presentation = anActionEvent.getPresentation();
        Intrinsics.checkExpressionValueIsNotNull((Object)presentation, (String)"e.presentation");
        presentation.setEnabledAndVisible(libraryEx != null && libraryEx.getKind() == null);
    }

    public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
        Intrinsics.checkParameterIsNotNull((Object)anActionEvent, (String)"e");
        LibraryEx libraryEx = this.getSelectedLibrary();
        if (libraryEx == null) {
            return;
        }
        LibraryEx libraryEx2 = libraryEx;
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = this.a((Library)libraryEx2);
        if (jpsMavenRepositoryLibraryDescriptor == null) {
            return;
        }
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor2 = jpsMavenRepositoryLibraryDescriptor;
        this.a(libraryEx2, jpsMavenRepositoryLibraryDescriptor2);
    }

    private final void a(LibraryEx libraryEx, JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor) {
        File file;
        Object object;
        OrderRoot orderRoot;
        Object t2;
        RepositoryLibraryProperties repositoryLibraryProperties = new RepositoryLibraryProperties(jpsMavenRepositoryLibraryDescriptor.getGroupId(), jpsMavenRepositoryLibraryDescriptor.getArtifactId(), jpsMavenRepositoryLibraryDescriptor.getVersion(), jpsMavenRepositoryLibraryDescriptor.isIncludeTransitiveDependencies());
        boolean bl2 = RepositoryUtils.libraryHasSources((Library)libraryEx);
        boolean bl3 = RepositoryUtils.libraryHasJavaDocs((Library)libraryEx);
        ConvertToRepositoryLibraryActionBaseKt.access$getLOG$p().debug("Resolving " + jpsMavenRepositoryLibraryDescriptor);
        Collection<OrderRoot> collection = JarRepositoryManager.loadDependenciesModal(this.b, repositoryLibraryProperties, bl2, bl3, null, null);
        Intrinsics.checkExpressionValueIsNotNull(collection, (String)"JarRepositoryManager.loa\u2026, hasJavadoc, null, null)");
        Collection<OrderRoot> collection2 = collection;
        Object object2 = (Object[])collection2;
        Object object3 = object2;
        Collection object4 = new ArrayList();
        Object object5 = object3.iterator();
        while (object5.hasNext()) {
            t2 = object5.next();
            orderRoot = (OrderRoot)t2;
            if (!Intrinsics.areEqual((Object)orderRoot.getType(), (Object)OrderRootType.CLASSES)) continue;
            object4.add(t2);
        }
        object2 = (List)object4;
        object3 = object2;
        Collection collection3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)object2, (int)10));
        object5 = object3.iterator();
        while (object5.hasNext()) {
            t2 = object5.next();
            orderRoot = (OrderRoot)t2;
            object = collection3;
            file = VfsUtilCore.virtualToIoFile((VirtualFile)orderRoot.getFile());
            object.add(file);
        }
        List list2 = (List)collection3;
        if (list2.isEmpty()) {
            if (Messages.showYesNoDialog((String)"No files were downloaded. Do you want to try different coordinates?", (String)"Failed to Download Library", null) != 0) {
                return;
            }
            this.a(jpsMavenRepositoryLibraryDescriptor, libraryEx);
            return;
        }
        VirtualFile[] virtualFileArray = libraryEx.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        object3 = virtualFileArray;
        Object[] objectArray = object3;
        object5 = new ArrayList(((Object[])object3).length);
        for (Object object6 : objectArray) {
            VirtualFile virtualFile = (VirtualFile)object6;
            object = object5;
            file = VfsUtilCore.virtualToIoFile((VirtualFile)virtualFile);
            object.add(file);
        }
        object2 = (List)object5;
        Project project2 = this.b;
        Intrinsics.checkExpressionValueIsNotNull((Object)project2, (String)"project");
        object3 = new ComparingJarFilesTask(project2, list2, (List<? extends File>)object2);
        object3.queue();
        if (((ComparingJarFilesTask)((Object)object3)).getCancelled()) {
            return;
        }
        if (!((ComparingJarFilesTask)((Object)object3)).getFilesAreTheSame()) {
            VirtualFile virtualFile = ((ComparingJarFilesTask)((Object)object3)).getLibraryFileToCompare();
            VirtualFile virtualFile2 = ((ComparingJarFilesTask)((Object)object3)).getDownloadedFileToCompare();
            String string = LibraryUtil.getPresentableName((Library)((Library)libraryEx));
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"LibraryUtil.getPresentableName(library)");
            Project project3 = this.b;
            Intrinsics.checkExpressionValueIsNotNull((Object)project3, (String)"project");
            LibraryJarsDiffDialog libraryJarsDiffDialog = new LibraryJarsDiffDialog(virtualFile, virtualFile2, jpsMavenRepositoryLibraryDescriptor, string, project3);
            libraryJarsDiffDialog.show();
            ((ComparingJarFilesTask)((Object)object3)).deleteTemporaryFiles();
            int n2 = libraryJarsDiffDialog.getExitCode();
            if (n2 == 1) {
                return;
            }
            if (n2 == LibraryJarsDiffDialog.Companion.getCHANGE_COORDINATES_CODE()) {
                this.a(jpsMavenRepositoryLibraryDescriptor, libraryEx);
                return;
            }
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(this, libraryEx, collection2, repositoryLibraryProperties){
            final /* synthetic */ ConvertToRepositoryLibraryActionBase this$0;
            final /* synthetic */ LibraryEx $library;
            final /* synthetic */ Collection $roots;
            final /* synthetic */ RepositoryLibraryProperties $libraryProperties;

            public final void run() {
                Library library = (Library)this.$library;
                String string = this.$library.getName();
                if (string == null) {
                    string = "";
                }
                ConvertToRepositoryLibraryActionBase.access$replaceByLibrary(this.this$0, library, new NewLibraryConfiguration(this, string, RepositoryLibraryType.getInstance(), (LibraryProperties)this.$libraryProperties){
                    final /* synthetic */ downloadLibraryAndReplace.1 this$0;

                    public void addRoots(@NotNull LibraryEditor libraryEditor) {
                        Intrinsics.checkParameterIsNotNull((Object)libraryEditor, (String)"editor");
                        libraryEditor.addRoots(this.this$0.$roots);
                    }
                    {
                        this.this$0 = var1_1;
                        super(string, libraryType, libraryProperties);
                    }
                });
            }
            {
                this.this$0 = convertToRepositoryLibraryActionBase;
                this.$library = libraryEx;
                this.$roots = collection;
                this.$libraryProperties = repositoryLibraryProperties;
            }
        });
    }

    private final void a(JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor, LibraryEx libraryEx) {
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor2 = this.a(CollectionsKt.listOf((Object)jpsMavenRepositoryLibraryDescriptor));
        if (jpsMavenRepositoryLibraryDescriptor2 == null) {
            return;
        }
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor3 = jpsMavenRepositoryLibraryDescriptor2;
        ApplicationManager.getApplication().invokeLater(new Runnable(this, libraryEx, jpsMavenRepositoryLibraryDescriptor3){
            final /* synthetic */ ConvertToRepositoryLibraryActionBase this$0;
            final /* synthetic */ LibraryEx $library;
            final /* synthetic */ JpsMavenRepositoryLibraryDescriptor $coordinates;

            public final void run() {
                ConvertToRepositoryLibraryActionBase.access$downloadLibraryAndReplace(this.this$0, this.$library, this.$coordinates);
            }
            {
                this.this$0 = convertToRepositoryLibraryActionBase;
                this.$library = libraryEx;
                this.$coordinates = jpsMavenRepositoryLibraryDescriptor;
            }
        });
    }

    private final JpsMavenRepositoryLibraryDescriptor a(Library library) {
        String string;
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        List<JpsMavenRepositoryLibraryDescriptor> list2 = Companion.detectMavenCoordinates(virtualFileArray);
        ConvertToRepositoryLibraryActionBaseKt.access$getLOG$p().debug("Maven coordinates for " + LibraryUtil.getPresentableName((Library)library) + " JARs: " + list2);
        if (list2.size() == 1) {
            return list2.get(0);
        }
        String string2 = string = list2.isEmpty() ? "Cannot detect Maven coordinates from the library JARs" : "Multiple Maven coordinates are found in the library JARs";
        if (Messages.showYesNoDialog((Project)this.b, (String)("" + string + ". Do you want to search Maven repositories manually?"), (String)"Cannot Detect Maven Coordinates", null) != 0) {
            return null;
        }
        return this.a(list2);
    }

    private final JpsMavenRepositoryLibraryDescriptor a(List<? extends JpsMavenRepositoryLibraryDescriptor> list2) {
        JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor = (JpsMavenRepositoryLibraryDescriptor)CollectionsKt.firstOrNull(list2);
        RepositoryAttachDialog repositoryAttachDialog = new RepositoryAttachDialog(this.b, jpsMavenRepositoryLibraryDescriptor != null ? jpsMavenRepositoryLibraryDescriptor.getMavenId() : null, RepositoryAttachDialog.Mode.SEARCH);
        if (!repositoryAttachDialog.showAndGet()) {
            return null;
        }
        return new JpsMavenRepositoryLibraryDescriptor(repositoryAttachDialog.getCoordinateText(), repositoryAttachDialog.getIncludeTransitiveDependencies());
    }

    private final void a(Library library, NewLibraryConfiguration newLibraryConfiguration) {
        String[] stringArray = library.getUrls(AnnotationOrderRootType.getInstance());
        ProjectStructureConfigurable projectStructureConfigurable = ProjectStructureConfigurable.getInstance(this.b);
        VirtualFile[] virtualFileArray = library.getFiles(OrderRootType.CLASSES);
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray, (String)"library.getFiles(OrderRootType.CLASSES)");
        Object[] objectArray = virtualFileArray;
        VirtualFile[] virtualFileArray2 = library.getFiles(OrderRootType.SOURCES);
        Intrinsics.checkExpressionValueIsNotNull((Object)virtualFileArray2, (String)"library.getFiles(OrderRootType.SOURCES)");
        projectStructureConfigurable.registerObsoleteLibraryRoots(ArraysKt.asList((Object[])ArraysKt.plus((Object[])objectArray, (Object[])virtualFileArray2)));
        this.replaceLibrary(library, (Function1<? super LibraryEditorBase, Unit>)((Function1)new Function1<LibraryEditorBase, Unit>(newLibraryConfiguration, stringArray){
            final /* synthetic */ NewLibraryConfiguration $configuration;
            final /* synthetic */ String[] $annotationUrls;

            public final void invoke(@NotNull LibraryEditorBase libraryEditorBase) {
                Intrinsics.checkParameterIsNotNull((Object)libraryEditorBase, (String)"editor");
                libraryEditorBase.setProperties(this.$configuration.getProperties());
                libraryEditorBase.removeAllRoots();
                this.$configuration.addRoots((LibraryEditor)libraryEditorBase);
                Intrinsics.checkExpressionValueIsNotNull((Object)this.$annotationUrls, (String)"annotationUrls");
                for (Object object : (Object[])this.$annotationUrls) {
                    String string = (String)object;
                    libraryEditorBase.addRoot(string, AnnotationOrderRootType.getInstance());
                }
            }
            {
                this.$configuration = newLibraryConfiguration;
                this.$annotationUrls = stringArray;
                super(1);
            }
        }));
    }

    protected abstract void replaceLibrary(@NotNull Library var1, @NotNull Function1<? super LibraryEditorBase, Unit> var2);

    @NotNull
    protected final StructureConfigurableContext getContext() {
        return this.a;
    }

    public ConvertToRepositoryLibraryActionBase(@NotNull StructureConfigurableContext structureConfigurableContext) {
        Intrinsics.checkParameterIsNotNull((Object)structureConfigurableContext, (String)"context");
        super("Convert to Repository Library...", "Convert a regular library to a repository library which additionally stores its Maven coordinates, so the IDE can automatically download the library JARs if they are missing", null);
        this.a = structureConfigurableContext;
        this.b = this.a.getProject();
    }

    public static final /* synthetic */ void access$replaceByLibrary(ConvertToRepositoryLibraryActionBase convertToRepositoryLibraryActionBase, @NotNull Library library, @NotNull NewLibraryConfiguration newLibraryConfiguration) {
        convertToRepositoryLibraryActionBase.a(library, newLibraryConfiguration);
    }

    public static final /* synthetic */ void access$downloadLibraryAndReplace(ConvertToRepositoryLibraryActionBase convertToRepositoryLibraryActionBase, @NotNull LibraryEx libraryEx, @NotNull JpsMavenRepositoryLibraryDescriptor jpsMavenRepositoryLibraryDescriptor) {
        convertToRepositoryLibraryActionBase.a(libraryEx, jpsMavenRepositoryLibraryDescriptor);
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ\u0012\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000b\u001a\u00020\bH\u0002\u00a8\u0006\f"}, d2={"Lcom/intellij/openapi/roots/ui/configuration/projectRoot/ConvertToRepositoryLibraryActionBase$Companion;", "", "()V", "detectMavenCoordinates", "", "Lorg/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor;", "libraryRoots", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "([Lcom/intellij/openapi/vfs/VirtualFile;)Ljava/util/List;", "parsePomProperties", "virtualFile", "intellij.java.ui"})
    public static final class Companion {
        @NotNull
        public final List<JpsMavenRepositoryLibraryDescriptor> detectMavenCoordinates(@NotNull VirtualFile[] virtualFileArray) {
            Object[] objectArray;
            Intrinsics.checkParameterIsNotNull((Object)virtualFileArray, (String)"libraryRoots");
            Object[] objectArray2 = objectArray = (Object[])virtualFileArray;
            Collection collection = new ArrayList();
            for (Object object : objectArray2) {
                List list2;
                Collection collection2;
                Object[] objectArray3;
                Object object2;
                Collection collection3;
                Object[] objectArray4;
                Object object3;
                VirtualFile virtualFile = (VirtualFile)object;
                VirtualFile[] virtualFileArray2 = virtualFile.findFileByRelativePath("META-INF/maven");
                if (virtualFileArray2 != null && (virtualFileArray2 = virtualFileArray2.getChildren()) != null) {
                    objectArray4 = object3 = (Object[])virtualFileArray2;
                    collection3 = new ArrayList();
                    for (Object object4 : objectArray4) {
                        List list3;
                        Object object5 = object2 = (VirtualFile)object4;
                        Intrinsics.checkExpressionValueIsNotNull((Object)object5, (String)"groupDir");
                        VirtualFile[] virtualFileArray3 = object5.getChildren();
                        if (virtualFileArray3 != null) {
                            Object[] objectArray5 = objectArray3 = (Object[])virtualFileArray3;
                            collection2 = new ArrayList();
                            for (Object object6 : objectArray5) {
                                VirtualFile virtualFile2;
                                Object object7 = object6;
                                VirtualFile virtualFile3 = (VirtualFile)object7;
                                if (virtualFile3.findChild("pom.properties") == null) continue;
                                VirtualFile virtualFile4 = virtualFile2;
                                collection2.add(virtualFile4);
                            }
                            list3 = (List)collection2;
                        } else {
                            list3 = CollectionsKt.emptyList();
                        }
                        Iterable iterable = list3;
                        CollectionsKt.addAll((Collection)collection3, (Iterable)iterable);
                    }
                    list2 = (List)collection3;
                } else {
                    list2 = CollectionsKt.emptyList();
                }
                List list4 = list2;
                objectArray4 = object3 = (Iterable)list4;
                collection3 = new ArrayList();
                Object[] objectArray6 = objectArray4;
                Iterator iterator = objectArray6.iterator();
                while (iterator.hasNext()) {
                    Object object4;
                    object2 = object4 = iterator.next();
                    objectArray3 = (Object[])object2;
                    Intrinsics.checkExpressionValueIsNotNull((Object)objectArray3, (String)"it");
                    if (Companion.a((VirtualFile)objectArray3) == null) continue;
                    Object[] objectArray7 = collection2;
                    collection3.add(objectArray7);
                }
                Iterable iterable = (List)collection3;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            }
            return (List)collection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final JpsMavenRepositoryLibraryDescriptor a(VirtualFile virtualFile) {
            Object object;
            Object object2;
            Object object3;
            Properties properties = new Properties();
            try {
                object3 = virtualFile.getInputStream();
                object2 = null;
                try {
                    object = (InputStream)object3;
                    properties.load((InputStream)object);
                    object = Unit.INSTANCE;
                }
                catch (Throwable throwable) {
                    object2 = throwable;
                    throw throwable;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object3, (Throwable)object2);
                }
            }
            catch (IOException iOException) {
                return null;
            }
            object3 = properties.getProperty("groupId");
            object2 = properties.getProperty("artifactId");
            object = properties.getProperty("version");
            return object3 != null && object2 != null && object != null ? new JpsMavenRepositoryLibraryDescriptor((String)object3, (String)object2, (String)object) : null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }
    }
}

