/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModel;
import com.intellij.openapi.projectRoots.impl.ProjectJdkImpl;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.JdkConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectSdksModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.SdkProjectStructureElement;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.NamedConfigurable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JdkListConfigurable
extends BaseStructureConfigurable {
    @NotNull
    private final ProjectSdksModel c;
    private final SdkModel.Listener b = new SdkModel.Listener(){

        public void sdkAdded(Sdk sdk) {
        }

        public void beforeSdkRemove(Sdk sdk) {
        }

        public void sdkChanged(Sdk sdk, String string) {
            this.a();
        }

        public void sdkHomeSelected(Sdk sdk, String string) {
            this.a();
        }

        private void a() {
            NamedConfigurable namedConfigurable;
            TreePath treePath = JdkListConfigurable.this.myTree.getSelectionPath();
            if (treePath != null && (namedConfigurable = ((MasterDetailsComponent.MyNode)treePath.getLastPathComponent()).getConfigurable()) instanceof JdkConfigurable) {
                namedConfigurable.updateName();
            }
        }
    };

    public JdkListConfigurable(Project project2, ProjectStructureConfigurable projectStructureConfigurable) {
        super(project2);
        this.c = projectStructureConfigurable.getProjectJdksModel();
        this.c.addListener(this.b);
    }

    protected String getComponentStateKey() {
        return "JdkListConfigurable.UI";
    }

    @Nls
    public String getDisplayName() {
        return "SDKs";
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return this.myCurrentConfigurable != null ? this.myCurrentConfigurable.getHelpTopic() : "reference.settingsdialog.project.structure.jdk";
    }

    @NotNull
    @NonNls
    public String getId() {
        if ("jdk.list" == null) {
            JdkListConfigurable.b(0);
        }
        return "jdk.list";
    }

    @Override
    protected void loadTree() {
        HashMap hashMap = this.c.getProjectSdks();
        for (Sdk sdk : hashMap.keySet()) {
            JdkConfigurable jdkConfigurable = new JdkConfigurable((ProjectJdkImpl)hashMap.get(sdk), this.c, this.TREE_UPDATER, this.myHistory, this.myProject);
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)jdkConfigurable), this.myRoot);
        }
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<SdkProjectStructureElement> arrayList = new ArrayList<SdkProjectStructureElement>();
        for (Sdk sdk : this.c.getProjectSdks().values()) {
            arrayList.add(new SdkProjectStructureElement(this.myContext, sdk));
        }
        ArrayList<SdkProjectStructureElement> arrayList2 = arrayList;
        if (arrayList2 == null) {
            JdkListConfigurable.b(1);
        }
        return arrayList2;
    }

    public boolean addJdkNode(Sdk sdk, boolean bl2) {
        if (!this.myUiDisposed) {
            this.myContext.getDaemonAnalyzer().queueUpdate(new SdkProjectStructureElement(this.myContext, sdk));
            this.addNode(new MasterDetailsComponent.MyNode((NamedConfigurable)new JdkConfigurable((ProjectJdkImpl)sdk, this.c, this.TREE_UPDATER, this.myHistory, this.myProject)), this.myRoot);
            if (bl2) {
                this.selectNodeInTree((DefaultMutableTreeNode)MasterDetailsComponent.findNodeByObject((TreeNode)this.myRoot, (Object)sdk));
            }
            return true;
        }
        return false;
    }

    public void dispose() {
        this.c.removeListener(this.b);
        this.c.disposeUIResources();
    }

    @NotNull
    public ProjectSdksModel getJdksTreeModel() {
        ProjectSdksModel projectSdksModel = this.c;
        if (projectSdksModel == null) {
            JdkListConfigurable.b(2);
        }
        return projectSdksModel;
    }

    @Override
    public void reset() {
        super.reset();
        this.myTree.setRootVisible(false);
    }

    public void apply() throws ConfigurationException {
        boolean bl2 = false;
        for (int i2 = 0; i2 < this.myRoot.getChildCount(); ++i2) {
            NamedConfigurable namedConfigurable = ((MasterDetailsComponent.MyNode)this.myRoot.getChildAt(i2)).getConfigurable();
            if (!namedConfigurable.isModified()) continue;
            namedConfigurable.apply();
            bl2 = true;
        }
        if (this.c.isModified() || bl2) {
            this.c.apply((MasterDetailsComponent)this);
        }
        this.c.setProjectSdk(ProjectRootManager.getInstance((Project)this.myProject).getProjectSdk());
    }

    public boolean isModified() {
        return super.isModified() || this.c.isModified();
    }

    public static JdkListConfigurable getInstance(Project project2) {
        return (JdkListConfigurable)((Object)ServiceManager.getService((Project)project2, JdkListConfigurable.class));
    }

    @Override
    public BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return new BaseStructureConfigurable.AbstractAddGroup(ProjectBundle.message((String)"add.new.jdk.text", (Object[])new Object[0])){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent anActionEvent) {
                DefaultActionGroup defaultActionGroup = new DefaultActionGroup(ProjectBundle.message((String)"add.new.jdk.text", (Object[])new Object[0]), true);
                JdkListConfigurable.this.c.createAddActions(defaultActionGroup, (JComponent)JdkListConfigurable.this.myTree, sdk -> JdkListConfigurable.this.addJdkNode((Sdk)sdk, true));
                AnAction[] anActionArray = defaultActionGroup.getChildren(null);
                if (anActionArray == null) {
                    2.a(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkListConfigurable$2", "getChildren"));
            }
        };
    }

    @Override
    protected List<? extends RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return Collections.singletonList(new SdkRemoveHandler());
    }

    @Nullable
    protected String getEmptySelectionString() {
        return "Select an SDK to view or edit its details here";
    }

    private static /* synthetic */ void b(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkListConfigurable";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectStructureElements";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getJdksTreeModel";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private class SdkRemoveHandler
    extends RemoveConfigurableHandler<Sdk> {
        public SdkRemoveHandler() {
            super(JdkConfigurable.class);
        }

        @Override
        public boolean remove(@NotNull Collection<Sdk> collection) {
            if (collection == null) {
                SdkRemoveHandler.b(0);
            }
            for (Sdk sdk : collection) {
                JdkListConfigurable.this.c.removeSdk(sdk);
                JdkListConfigurable.this.myContext.getDaemonAnalyzer().removeElement(new SdkProjectStructureElement(JdkListConfigurable.this.myContext, sdk));
            }
            return true;
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sdks", "com/intellij/openapi/roots/ui/configuration/projectRoot/JdkListConfigurable$SdkRemoveHandler", "remove"));
        }
    }
}

