/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.ui.configuration.libraries.LibraryPresentationManager;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditor;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryRootsComponent;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ProjectStructureElementConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LibraryConfigurable
extends ProjectStructureElementConfigurable<Library> {
    private LibraryRootsComponent d;
    private final Library e;
    private final StructureLibraryTableModifiableModelProvider b;
    private final StructureConfigurableContext g;
    private final Project c;
    private final LibraryProjectStructureElement h;
    private boolean a;
    private boolean f;

    protected LibraryConfigurable(StructureLibraryTableModifiableModelProvider structureLibraryTableModifiableModelProvider, Library library, StructureConfigurableContext structureConfigurableContext, Runnable runnable) {
        super(true, runnable);
        this.b = structureLibraryTableModifiableModelProvider;
        this.g = structureConfigurableContext;
        this.c = structureConfigurableContext.getProject();
        this.e = library;
        this.h = new LibraryProjectStructureElement(structureConfigurableContext, this.e);
    }

    public JComponent createOptionsPanel() {
        this.d = new LibraryRootsComponent(this.c, (Computable<LibraryEditor>)((Computable)() -> this.getLibraryEditor()));
        this.d.addListener(() -> {
            this.g.getDaemonAnalyzer().queueUpdate(this.h);
            this.updateName();
        });
        return this.d.getComponent();
    }

    public boolean isModified() {
        return this.d != null && this.d.hasChanges();
    }

    @Override
    @NotNull
    public ProjectStructureElement getProjectStructureElement() {
        LibraryProjectStructureElement libraryProjectStructureElement = this.h;
        if (libraryProjectStructureElement == null) {
            LibraryConfigurable.a(0);
        }
        return libraryProjectStructureElement;
    }

    public void apply() {
        this.a();
    }

    public void reset() {
        this.d();
    }

    public void disposeUIResources() {
        if (this.d != null) {
            Disposer.dispose((Disposable)this.d);
            this.d = null;
        }
    }

    public void setDisplayName(String string) {
        if (!this.a) {
            this.getLibraryEditor().setName(string);
            if (this.d != null) {
                this.d.onLibraryRenamed();
            }
            this.g.getDaemonAnalyzer().queueUpdateForAllElementsWithErrors();
        }
    }

    protected LibraryEditor getLibraryEditor() {
        return this.b.getModifiableModel().getLibraryEditor(this.e);
    }

    public void updateName() {
        this.a = true;
        try {
            super.updateName();
        }
        finally {
            this.a = false;
        }
    }

    public Library getEditableObject() {
        return this.e;
    }

    public String getBannerSlogan() {
        LibraryTable libraryTable = this.e.getTable();
        String string = libraryTable == null ? ProjectBundle.message((String)"module.library.display.name", (Object[])new Object[]{1}) : libraryTable.getPresentation().getDisplayName(false);
        return ProjectBundle.message((String)"project.roots.library.banner.text", (Object[])new Object[]{this.getDisplayName(), string});
    }

    public String getDisplayName() {
        if (this.b.getModifiableModel().hasLibraryEditor(this.e)) {
            return this.getLibraryEditor().getName();
        }
        return this.e.getName();
    }

    public void onSelected() {
        this.d();
    }

    public void onUnselected() {
        this.a();
    }

    private void d() {
        if (this.d != null) {
            this.d.updatePropertiesLabel();
            this.d.resetProperties();
            this.f = true;
        }
    }

    private void a() {
        if (this.d != null && this.f) {
            this.d.applyProperties();
            this.f = false;
        }
    }

    public Icon getIcon(boolean bl2) {
        return LibraryPresentationManager.getInstance().getNamedLibraryIcon(this.e, this.g);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        return "preferences.jdkGlobalLibs";
    }

    public void updateComponent() {
        if (this.d != null) {
            this.d.updateRootsTree();
        }
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/LibraryConfigurable", "getProjectStructureElement"));
    }
}

