/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.CommonBundle;
import com.intellij.facet.Facet;
import com.intellij.facet.impl.ProjectFacetsConfigurator;
import com.intellij.facet.impl.ui.actions.AddFacetToModuleAction;
import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.impl.FlattenModulesToggleAction;
import com.intellij.ide.projectView.impl.ModuleGroup;
import com.intellij.ide.projectView.impl.ModuleGroupingImplementation;
import com.intellij.ide.projectView.impl.ModuleGroupingTreeHelper;
import com.intellij.ide.util.projectWizard.ModuleBuilder;
import com.intellij.ide.util.projectWizard.NamePathComponent;
import com.intellij.ide.util.projectWizard.ProjectWizardUtil;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleConfigurationEditor;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.module.ModuleGrouperKt;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectBundle;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.LanguageLevelModuleExtension;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LibraryOrderEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleSourceOrderEntry;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.impl.ClonableOrderEntry;
import com.intellij.openapi.roots.impl.ProjectRootManagerImpl;
import com.intellij.openapi.roots.impl.RootModelImpl;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.ui.configuration.ClasspathEditor;
import com.intellij.openapi.roots.ui.configuration.ModuleEditor;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.ProjectStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.actions.ChangeModuleNamesAction;
import com.intellij.openapi.roots.ui.configuration.projectRoot.BaseStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetEditorFacadeImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.FacetStructureConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.ModuleStructureExtension;
import com.intellij.openapi.roots.ui.configuration.projectRoot.RemoveConfigurableHandler;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.TextConfigurable;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.LibraryProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ModuleProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.NamedConfigurable;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointerManager;
import com.intellij.ui.navigation.Place;
import com.intellij.util.PathUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModuleStructureConfigurable
extends BaseStructureConfigurable
implements Place.Navigator {
    private static final Comparator<MasterDetailsComponent.MyNode> b = (myNode, myNode2) -> {
        NamedConfigurable namedConfigurable = myNode.getConfigurable();
        NamedConfigurable namedConfigurable2 = myNode2.getConfigurable();
        if (namedConfigurable.getClass() == namedConfigurable2.getClass()) {
            return StringUtil.naturalCompare((String)myNode.getDisplayName(), (String)myNode2.getDisplayName());
        }
        Object object = namedConfigurable.getEditableObject();
        Object object2 = namedConfigurable2.getEditableObject();
        if (object2 instanceof Module && object instanceof ModuleGroup) {
            return -1;
        }
        if (object instanceof Module && object2 instanceof ModuleGroup) {
            return 1;
        }
        if (object2 instanceof Module && object instanceof String) {
            return 1;
        }
        if (object instanceof Module && object2 instanceof String) {
            return -1;
        }
        if (object2 instanceof Module && object instanceof Facet) {
            return 1;
        }
        if (object instanceof Module && object2 instanceof Facet) {
            return -1;
        }
        if (object2 instanceof ModuleGroup && object instanceof String) {
            return 1;
        }
        if (object instanceof ModuleGroup && object2 instanceof String) {
            return -1;
        }
        return 0;
    };
    private boolean e;
    private boolean c;
    private final ModuleManager d;
    private final FacetEditorFacadeImpl f;
    private final List<RemoveConfigurableHandler<?>> g;

    public ModuleStructureConfigurable(Project project2, ModuleManager moduleManager) {
        super(project2);
        this.f = new FacetEditorFacadeImpl(this, this.TREE_UPDATER);
        this.d = moduleManager;
        this.g = new ArrayList();
        this.g.add(new ModuleRemoveHandler());
        this.g.add(new FacetInModuleRemoveHandler());
        for (ModuleStructureExtension moduleStructureExtension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            this.g.addAll(moduleStructureExtension.getRemoveHandlers());
        }
    }

    protected String getComponentStateKey() {
        return "ModuleStructureConfigurable.UI";
    }

    @Override
    protected void initTree() {
        super.initTree();
        this.myTree.setRootVisible(false);
    }

    @Override
    @NotNull
    protected String getTextForSpeedSearch(MasterDetailsComponent.MyNode myNode) {
        if (myNode instanceof ModuleNode) {
            String string = ((ModuleNode)myNode).c();
            if (string == null) {
                ModuleStructureConfigurable.b(0);
            }
            return string;
        }
        if (myNode instanceof ModuleGroupNodeImpl) {
            String string = ((ModuleGroupNodeImpl)myNode).getModuleGroup().getQualifiedName();
            if (string == null) {
                ModuleStructureConfigurable.b(1);
            }
            return string;
        }
        String string = super.getTextForSpeedSearch(myNode);
        if (string == null) {
            ModuleStructureConfigurable.b(2);
        }
        return string;
    }

    protected ArrayList<AnAction> getAdditionalActions() {
        ArrayList<AnAction> arrayList = new ArrayList<AnAction>();
        arrayList.add(ActionManager.getInstance().getAction("MoveModuleToGroup"));
        arrayList.add((AnAction)new ChangeModuleNamesAction());
        return arrayList;
    }

    public void addNode(MasterDetailsComponent.MyNode myNode, MasterDetailsComponent.MyNode myNode2) {
        super.addNode(myNode, myNode2);
    }

    @Override
    @NotNull
    protected ArrayList<AnAction> createActions(boolean bl3) {
        List list2 = super.createActions(bl3);
        if (bl3) {
            ((ArrayList)list2).add(Separator.getInstance());
            ((ArrayList)list2).add(new FlattenModulesToggleAction(this.myProject, () -> true, () -> this.c, bl2 -> {
                this.c = bl2;
                this.g();
            }));
            ((ArrayList)list2).add(new HideGroupsAction());
            this.addCollapseExpandActions(list2);
        }
        List list3 = list2;
        if (list3 == null) {
            ModuleStructureConfigurable.b(3);
        }
        return list3;
    }

    @Override
    @NotNull
    protected List<? extends AnAction> createCopyActions(boolean bl2) {
        List<MyCopyAction> list2 = Collections.singletonList(new MyCopyAction());
        if (list2 == null) {
            ModuleStructureConfigurable.b(4);
        }
        return list2;
    }

    @Override
    protected void loadTree() {
        this.f();
        this.c().reload();
        this.myUiDisposed = false;
    }

    @Override
    @NotNull
    protected Collection<? extends ProjectStructureElement> getProjectStructureElements() {
        ArrayList<ModuleProjectStructureElement> arrayList = new ArrayList<ModuleProjectStructureElement>();
        for (Module module2 : this.d.getModules()) {
            arrayList.add(new ModuleProjectStructureElement(this.myContext, module2));
        }
        ArrayList<ModuleProjectStructureElement> arrayList2 = arrayList;
        if (arrayList2 == null) {
            ModuleStructureConfigurable.b(5);
        }
        return arrayList2;
    }

    protected void updateSelection(@Nullable NamedConfigurable namedConfigurable) {
        FacetStructureConfigurable.getInstance(this.myProject).disposeMultipleSettingsEditor();
        ApplicationManager.getApplication().assertIsDispatchThread();
        super.updateSelection(namedConfigurable);
        if (namedConfigurable != null) {
            this.c(namedConfigurable);
        }
    }

    protected boolean isAutoScrollEnabled() {
        return this.myAutoScrollEnabled;
    }

    protected boolean updateMultiSelection(List<NamedConfigurable> list2) {
        return FacetStructureConfigurable.getInstance(this.myProject).updateMultiSelection(list2, this.getDetailsComponent());
    }

    private void c(NamedConfigurable namedConfigurable) {
        ModuleConfigurable moduleConfigurable;
        ModuleEditor moduleEditor;
        if (namedConfigurable instanceof ModuleConfigurable && (moduleEditor = (moduleConfigurable = (ModuleConfigurable)namedConfigurable).getModuleEditor()) != null) {
            moduleEditor.init(this.myHistory);
        }
        if (namedConfigurable instanceof FacetConfigurable) {
            ((FacetConfigurable)namedConfigurable).getEditor().onFacetSelected();
        }
    }

    private void f() {
        ModuleGrouper moduleGrouper = this.d();
        ModuleGroupingTreeHelper moduleGroupingTreeHelper = ModuleGroupingTreeHelper.forEmptyTree((!this.e && !this.c ? 1 : 0) != 0, (ModuleGroupingImplementation)ModuleGroupingTreeHelper.createDefaultGrouping((ModuleGrouper)moduleGrouper), ModuleStructureConfigurable::a, module2 -> this.a((Module)module2, moduleGrouper), this.getNodeComparator());
        moduleGroupingTreeHelper.createModuleNodes(Arrays.asList(this.d.getModules()), (MutableTreeNode)this.myRoot, this.c());
        if (ModuleStructureConfigurable.a((TreeNode)this.myRoot)) {
            this.myTree.setShowsRootHandles(true);
        }
        this.sortDescendants(this.myRoot);
        if (this.myProject.isDefault()) {
            this.myRoot.removeAllChildren();
        }
        this.a(this.myRoot, this.myProject);
    }

    private static boolean a(TreeNode treeNode) {
        int n2 = treeNode.getChildCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            TreeNode treeNode2 = treeNode.getChildAt(i2);
            if (treeNode2.getChildCount() <= 0) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private ModuleNode a(Module module2, ModuleGrouper moduleGrouper) {
        ModuleConfigurable moduleConfigurable = new ModuleConfigurable(this.myContext.myModulesConfigurator, module2, this.TREE_UPDATER, moduleGrouper);
        List list2 = moduleGrouper.getModuleAsGroupPath(module2);
        ModuleNode moduleNode = new ModuleNode(moduleConfigurable, list2 != null ? new ModuleGroup(list2) : null);
        this.f.addFacetsNodes(module2, moduleNode);
        this.a(module2, moduleNode);
        ModuleNode moduleNode2 = moduleNode;
        if (moduleNode2 == null) {
            ModuleStructureConfigurable.b(6);
        }
        return moduleNode2;
    }

    @NotNull
    private static MasterDetailsComponent.MyNode a(ModuleGroup moduleGroup) {
        TextConfigurable<ModuleGroup> textConfigurable = new TextConfigurable<ModuleGroup>(moduleGroup, moduleGroup.toString(), ProjectBundle.message((String)"module.group.banner.text", (Object[])new Object[]{moduleGroup.toString()}), ProjectBundle.message((String)"project.roots.module.groups.text", (Object[])new Object[0]), PlatformIcons.CLOSED_MODULE_GROUP_ICON);
        ModuleGroupNodeImpl moduleGroupNodeImpl = new ModuleGroupNodeImpl(textConfigurable, moduleGroup);
        if (moduleGroupNodeImpl == null) {
            ModuleStructureConfigurable.b(7);
        }
        return moduleGroupNodeImpl;
    }

    private void a(MasterDetailsComponent.MyNode myNode, Project project2) {
        for (ModuleStructureExtension moduleStructureExtension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            moduleStructureExtension.addRootNodes(myNode, project2, this.TREE_UPDATER);
        }
    }

    private void a(Module module2, MasterDetailsComponent.MyNode myNode) {
        for (ModuleStructureExtension moduleStructureExtension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            moduleStructureExtension.addModuleNodeChildren(module2, myNode, this.TREE_UPDATER);
        }
    }

    public boolean updateProjectTree(Module[] moduleGroupingTreeHelper) {
        if (this.myRoot.getChildCount() == 0) {
            return false;
        }
        ArrayList<Pair> arrayList = new ArrayList<Pair>(((ModuleGroupingTreeHelper<Module, MasterDetailsComponent.MyNode>)moduleGroupingTreeHelper).length);
        for (ModuleGroupingTreeHelper<Module, MasterDetailsComponent.MyNode> moduleGroupingTreeHelper2 : moduleGroupingTreeHelper) {
            MasterDetailsComponent.MyNode myNode = this.findModuleNode((Module)moduleGroupingTreeHelper2);
            LOG.assertTrue(myNode != null, (Object)("Module " + moduleGroupingTreeHelper2.getName() + " is not in project."));
            arrayList.add(Pair.create((Object)myNode, moduleGroupingTreeHelper2));
        }
        ModuleGroupingTreeHelper<Module, MasterDetailsComponent.MyNode> moduleGroupingTreeHelper3 = this.a();
        moduleGroupingTreeHelper3.moveModuleNodesToProperGroup(arrayList, (MutableTreeNode)this.myRoot, this.c(), (JTree)this.myTree);
        return true;
    }

    private DefaultTreeModel c() {
        return (DefaultTreeModel)this.myTree.getModel();
    }

    @NotNull
    private ModuleGroupingTreeHelper<Module, MasterDetailsComponent.MyNode> a() {
        ModuleGrouper moduleGrouper = this.d();
        ModuleGroupingImplementation moduleGroupingImplementation = ModuleGroupingTreeHelper.createDefaultGrouping((ModuleGrouper)moduleGrouper);
        ModuleGroupingTreeHelper moduleGroupingTreeHelper = ModuleGroupingTreeHelper.forTree((MutableTreeNode)this.myRoot, myNode -> myNode instanceof ModuleGroupNode ? ((ModuleGroupNode)myNode).getModuleGroup() : null, myNode -> myNode instanceof ModuleNode ? ((ModuleNode)myNode).a() : null, (!this.e && !this.c ? 1 : 0) != 0, (ModuleGroupingImplementation)moduleGroupingImplementation, ModuleStructureConfigurable::a, module2 -> this.a((Module)module2, moduleGrouper), this.getNodeComparator());
        if (moduleGroupingTreeHelper == null) {
            ModuleStructureConfigurable.b(8);
        }
        return moduleGroupingTreeHelper;
    }

    protected Comparator<MasterDetailsComponent.MyNode> getNodeComparator() {
        List list2 = ContainerUtil.mapNotNull((Object[])ModuleStructureExtension.EP_NAME.getExtensions(), ModuleStructureExtension::getNodeComparator);
        return new MergingComparator<MasterDetailsComponent.MyNode>(ContainerUtil.concat((List)list2, Collections.singletonList(b)));
    }

    @Override
    public void init(StructureConfigurableContext structureConfigurableContext) {
        super.init(structureConfigurableContext);
        this.addItemsChangeListener(new MasterDetailsComponent.ItemsChangeListener(){

            public void itemChanged(@Nullable Object object) {
                if (object instanceof Library) {
                    Library library = (Library)object;
                    MasterDetailsComponent.MyNode myNode = MasterDetailsComponent.findNodeByObject((TreeNode)ModuleStructureConfigurable.this.myRoot, (Object)library);
                    if (myNode != null) {
                        TreeNode treeNode = myNode.getParent();
                        myNode.removeFromParent();
                        ModuleStructureConfigurable.this.c().reload(treeNode);
                    }
                    ModuleStructureConfigurable.this.myContext.getDaemonAnalyzer().removeElement(new LibraryProjectStructureElement(ModuleStructureConfigurable.this.myContext, library));
                }
            }
        });
    }

    @Override
    public void reset() {
        super.reset();
        for (ModuleStructureExtension moduleStructureExtension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            moduleStructureExtension.reset(this.myProject);
        }
    }

    public void apply() throws ConfigurationException {
        this.checkForEmptyAndDuplicatedNames(ProjectBundle.message((String)"rename.message.prefix.module", (Object[])new Object[0]), ProjectBundle.message((String)"rename.module.title", (Object[])new Object[0]), ModuleConfigurable.class);
        for (ModuleStructureExtension moduleStructureExtension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            if (!moduleStructureExtension.isModified()) continue;
            moduleStructureExtension.apply();
        }
        if (this.myContext.myModulesConfigurator.isModified()) {
            this.myContext.myModulesConfigurator.apply();
        }
        for (ModuleStructureExtension moduleStructureExtension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            moduleStructureExtension.afterModelCommit();
        }
    }

    public boolean isModified() {
        if (this.myContext.myModulesConfigurator.isModified()) {
            return true;
        }
        for (ModuleStructureExtension moduleStructureExtension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            if (!moduleStructureExtension.isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void disposeUIResources() {
        super.disposeUIResources();
        this.f.clearMaps(true);
        this.myContext.myModulesConfigurator.disposeUIResources();
        super.disposeUIResources();
        for (ModuleStructureExtension moduleStructureExtension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            moduleStructureExtension.disposeUIResources();
        }
    }

    public void dispose() {
    }

    @NotNull
    public JComponent createComponent() {
        MyDataProviderWrapper myDataProviderWrapper = new MyDataProviderWrapper(super.createComponent());
        if (myDataProviderWrapper == null) {
            ModuleStructureConfigurable.b(9);
        }
        return myDataProviderWrapper;
    }

    public String getDisplayName() {
        return ProjectBundle.message((String)"project.roots.display.name", (Object[])new Object[0]);
    }

    @Nullable
    @NonNls
    public String getHelpTopic() {
        String string = super.getHelpTopic();
        if (string != null) {
            return string;
        }
        return "reference.settingsdialog.project.structure.module";
    }

    public ActionCallback selectOrderEntry(@NotNull Module module2, @Nullable OrderEntry orderEntry) {
        ModuleStructureExtension moduleStructureExtension2;
        if (module2 == null) {
            ModuleStructureConfigurable.b(10);
        }
        for (ModuleStructureExtension moduleStructureExtension2 : (Place)ModuleStructureExtension.EP_NAME.getExtensions()) {
            ActionCallback actionCallback = moduleStructureExtension2.selectOrderEntry(module2, orderEntry);
            if (actionCallback == null) continue;
            return actionCallback;
        }
        Place place = new Place();
        place.putPath("category", (Object)this);
        Runnable runnable = null;
        MasterDetailsComponent.MyNode myNode = this.findModuleNode(module2);
        if (myNode != null) {
            place.putPath("treeObject", (Object)module2);
            place.putPath("selectedEditor", (Object)ClasspathEditor.NAME);
            runnable = () -> {
                ModuleEditor moduleEditor;
                ModuleConfigurationEditor moduleConfigurationEditor;
                if (orderEntry != null && (moduleConfigurationEditor = (moduleEditor = ((ModuleConfigurable)myNode.getConfigurable()).getModuleEditor()).getEditor(ClasspathEditor.NAME)) instanceof ClasspathEditor) {
                    ((ClasspathEditor)moduleConfigurationEditor).selectOrderEntry(orderEntry);
                }
            };
        }
        moduleStructureExtension2 = ProjectStructureConfigurable.getInstance(this.myProject).navigateTo(place, true);
        return runnable != null ? moduleStructureExtension2.doWhenDone(runnable) : moduleStructureExtension2;
    }

    private ModuleGrouper d() {
        return ModuleGrouper.instanceFor((Project)this.myProject, (ModifiableModuleModel)this.myContext.myModulesConfigurator.getModuleModel());
    }

    public static ModuleStructureConfigurable getInstance(Project project2) {
        return (ModuleStructureConfigurable)((Object)ServiceManager.getService((Project)project2, ModuleStructureConfigurable.class));
    }

    public Project getProject() {
        return this.myProject;
    }

    public Module[] getModules() {
        if (this.myContext.myModulesConfigurator != null) {
            ModifiableModuleModel modifiableModuleModel = this.myContext.myModulesConfigurator.getModuleModel();
            return modifiableModuleModel.getModules();
        }
        return this.d.getModules();
    }

    public void removeLibraryOrderEntry(Module module2, Library library) {
        OrderEntry[] orderEntryArray;
        ModuleEditor moduleEditor = this.myContext.myModulesConfigurator.getModuleEditor(module2);
        LOG.assertTrue(moduleEditor != null, (Object)"Current module editor was not initialized");
        ModifiableRootModel modifiableRootModel = moduleEditor.getModifiableRootModelProxy();
        for (OrderEntry orderEntry : orderEntryArray = modifiableRootModel.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry) || !Comparing.strEqual((String)orderEntry.getPresentableName(), (String)library.getName())) continue;
            modifiableRootModel.removeOrderEntry(orderEntry);
            break;
        }
        this.myContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.myContext, module2));
        this.myTree.repaint();
    }

    public void addLibraryOrderEntry(Module module2, Library library) {
        OrderEntry[] orderEntryArray;
        ModuleEditor moduleEditor = this.myContext.myModulesConfigurator.getModuleEditor(module2);
        LOG.assertTrue(moduleEditor != null, (Object)"Current module editor was not initialized");
        ModifiableRootModel modifiableRootModel = moduleEditor.getModifiableRootModelProxy();
        for (OrderEntry orderEntry : orderEntryArray = modifiableRootModel.getOrderEntries()) {
            if (!(orderEntry instanceof LibraryOrderEntry) || !Comparing.strEqual((String)orderEntry.getPresentableName(), (String)library.getName()) || Messages.showYesNoDialog((Project)module2.getProject(), (String)ProjectBundle.message((String)"project.roots.replace.library.entry.message", (Object[])new Object[]{orderEntry.getPresentableName()}), (String)ProjectBundle.message((String)"project.roots.replace.library.entry.title", (Object[])new Object[0]), (Icon)Messages.getInformationIcon()) != 0) continue;
            modifiableRootModel.removeOrderEntry(orderEntry);
            break;
        }
        modifiableRootModel.addLibraryEntry(library);
        this.myContext.getDaemonAnalyzer().queueUpdate(new ModuleProjectStructureElement(this.myContext, module2));
        this.myTree.repaint();
    }

    @Nullable
    public MasterDetailsComponent.MyNode findModuleNode(Module module2) {
        return ModuleStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)module2);
    }

    public FacetEditorFacadeImpl getFacetEditorFacade() {
        return this.f;
    }

    public ProjectFacetsConfigurator getFacetConfigurator() {
        return this.myContext.myModulesConfigurator.getFacetsConfigurator();
    }

    private void a(boolean bl2, String string) {
        List<Module> list2 = this.myContext.myModulesConfigurator.addModule((Component)this.myTree, bl2, string);
        if (list2 != null) {
            for (Module module2 : list2) {
                this.a(module2);
            }
        }
    }

    private void a(Module module2) {
        Object object;
        MasterDetailsComponent.MyNode myNode;
        TreePath treePath = this.myTree.getSelectionPath();
        MasterDetailsComponent.MyNode myNode2 = null;
        if (treePath != null) {
            ModifiableModuleModel modifiableModuleModel;
            String[] stringArray;
            myNode = (MasterDetailsComponent.MyNode)treePath.getLastPathComponent();
            object = myNode.getConfigurable().getEditableObject();
            if (object instanceof ModuleGroup) {
                this.myContext.myModulesConfigurator.getModuleModel().setModuleGroupPath(module2, ((ModuleGroup)object).getGroupPath());
                myNode2 = myNode;
            } else if (object instanceof Module && (stringArray = (modifiableModuleModel = this.myContext.myModulesConfigurator.getModuleModel()).getModuleGroupPath((Module)object)) != null) {
                modifiableModuleModel.setModuleGroupPath(module2, stringArray);
                myNode2 = ModuleStructureConfigurable.findNodeByObject((TreeNode)this.myRoot, (Object)new ModuleGroup(Arrays.asList(stringArray)));
            }
        }
        if (myNode2 == null) {
            myNode2 = this.myRoot;
        }
        myNode = this.a(module2, this.d());
        TreeUtil.insertNode((MutableTreeNode)myNode, (MutableTreeNode)myNode2, (DefaultTreeModel)this.c(), this.getNodeComparator());
        this.selectNodeInTree((DefaultMutableTreeNode)myNode);
        object = this.myContext.getDaemonAnalyzer();
        ((ProjectStructureDaemonAnalyzer)object).queueUpdate(new ModuleProjectStructureElement(this.myContext, module2));
        ((ProjectStructureDaemonAnalyzer)object).queueUpdateForAllElementsWithErrors();
    }

    @Nullable
    public Module getSelectedModule() {
        Object object = this.getSelectedObject();
        if (object instanceof Module) {
            return (Module)object;
        }
        if (object instanceof Library && ((Library)object).getTable() == null) {
            MasterDetailsComponent.MyNode myNode = (MasterDetailsComponent.MyNode)this.myTree.getSelectionPath().getLastPathComponent();
            return (Module)((MasterDetailsComponent.MyNode)myNode.getParent()).getConfigurable().getEditableObject();
        }
        return null;
    }

    @NotNull
    @NonNls
    public String getId() {
        if ("project.structure" == null) {
            ModuleStructureConfigurable.b(11);
        }
        return "project.structure";
    }

    @Nullable
    public Module getModule(String string) {
        if (string == null) {
            return null;
        }
        return this.myContext != null && this.myContext.myModulesConfigurator != null ? this.myContext.myModulesConfigurator.getModule(string) : this.d.findModuleByName(string);
    }

    public StructureConfigurableContext getContext() {
        return this.myContext;
    }

    private static boolean a(NamedConfigurable namedConfigurable) {
        for (ModuleStructureExtension moduleStructureExtension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            if (!moduleStructureExtension.canBeCopied(namedConfigurable)) continue;
            return true;
        }
        return false;
    }

    private void b(NamedConfigurable namedConfigurable) {
        for (ModuleStructureExtension moduleStructureExtension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
            moduleStructureExtension.copy(namedConfigurable, this.TREE_UPDATER);
        }
    }

    private void g() {
        DefaultMutableTreeNode defaultMutableTreeNode = null;
        TreePath treePath = this.myTree.getSelectionPath();
        if (treePath != null) {
            defaultMutableTreeNode = (DefaultMutableTreeNode)treePath.getLastPathComponent();
        }
        this.a().moveAllModuleNodesToProperGroups((MutableTreeNode)this.myRoot, this.c());
        if (defaultMutableTreeNode != null) {
            TreeUtil.selectInTree((DefaultMutableTreeNode)defaultMutableTreeNode, (boolean)true, (JTree)this.myTree);
        }
    }

    @Override
    protected BaseStructureConfigurable.AbstractAddGroup createAddAction() {
        return new BaseStructureConfigurable.AbstractAddGroup(ProjectBundle.message((String)"add.new.header.text", (Object[])new Object[0])){

            @NotNull
            public AnAction[] getChildren(@Nullable AnActionEvent anActionEvent) {
                AddModuleAction addModuleAction = new AddModuleAction(false);
                addModuleAction.getTemplatePresentation().setText("New Module");
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add((Object)addModuleAction);
                AddModuleAction addModuleAction2 = new AddModuleAction(true);
                addModuleAction2.getTemplatePresentation().setText("Import Module");
                addModuleAction2.getTemplatePresentation().setIcon(AllIcons.ToolbarDecorator.Import);
                arrayList.add((Object)addModuleAction2);
                Collection<AnAction> collection = AddFacetToModuleAction.createAddFrameworkActions(ModuleStructureConfigurable.this.f, ModuleStructureConfigurable.this.myProject);
                if (!collection.isEmpty()) {
                    arrayList.add(new Separator(ProjectBundle.message((String)"add.group.framework.separator", (Object[])new Object[0])));
                    arrayList.addAll(collection);
                }
                NullableComputable nullableComputable = () -> {
                    Object object;
                    TreePath treePath = ModuleStructureConfigurable.this.myTree.getSelectionPath();
                    Object object2 = object = treePath == null ? null : treePath.getLastPathComponent();
                    if (object instanceof MasterDetailsComponent.MyNode) {
                        return (MasterDetailsComponent.MyNode)object;
                    }
                    return null;
                };
                ArrayList<AnAction> arrayList2 = new ArrayList<AnAction>();
                for (ModuleStructureExtension moduleStructureExtension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
                    arrayList2.addAll(moduleStructureExtension.createAddActions((NullableComputable<MasterDetailsComponent.MyNode>)nullableComputable, ModuleStructureConfigurable.this.TREE_UPDATER, ModuleStructureConfigurable.this.myProject, ModuleStructureConfigurable.this.myRoot));
                }
                if (!arrayList2.isEmpty() && !arrayList.isEmpty()) {
                    arrayList.add(new Separator());
                }
                arrayList.addAll(arrayList2);
                AnAction[] anActionArray = arrayList.toArray(AnAction.EMPTY_ARRAY);
                if (anActionArray == null) {
                    2.a(0);
                }
                return anActionArray;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$2", "getChildren"));
            }
        };
    }

    protected List<RemoveConfigurableHandler<?>> getRemoveHandlers() {
        return this.g;
    }

    @Nullable
    protected String getEmptySelectionString() {
        return ProjectBundle.message((String)"empty.module.selection.string", (Object[])new Object[0]);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 10: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 10: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getTextForSpeedSearch";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createActions";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createCopyActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectStructureElements";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleNode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createModuleGroupNode";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupingHelper";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getId";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "selectOrderEntry";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 10: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MergingComparator<T>
    implements Comparator<T> {
        private final List<Comparator<T>> a;

        MergingComparator(List<Comparator<T>> list2) {
            this.a = list2;
        }

        @Override
        public int compare(T t2, T t3) {
            for (Comparator<T> comparator : this.a) {
                int n2 = comparator.compare(t2, t3);
                if (n2 == 0) continue;
                return n2;
            }
            return 0;
        }
    }

    private class AddModuleAction
    extends AnAction
    implements DumbAware {
        private final boolean a;

        AddModuleAction(boolean bl2) {
            super(ProjectBundle.message((String)"add.new.module.text.full", (Object[])new Object[0]), null, AllIcons.Actions.Module);
            this.a = bl2;
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            ModuleGroup moduleGroup;
            String string = "untitled";
            MasterDetailsComponent.MyNode myNode = ModuleStructureConfigurable.this.getSelectedNode();
            if (ModuleGrouperKt.isQualifiedModuleNamesEnabled((Project)ModuleStructureConfigurable.this.myProject) && myNode instanceof ModuleGroupNodeImpl && (moduleGroup = ((ModuleGroupNode)myNode).getModuleGroup()) != null && !moduleGroup.getGroupPathList().isEmpty()) {
                string = StringUtil.join((Collection)moduleGroup.getGroupPathList(), (String)".") + ".untitled";
            }
            ModuleStructureConfigurable.this.a(this.a, string);
        }
    }

    private class MyCopyAction
    extends AnAction
    implements DumbAware {
        private MyCopyAction() {
            super(CommonBundle.message((String)"button.copy", (Object[])new Object[0]), CommonBundle.message((String)"button.copy", (Object[])new Object[0]), COPY_ICON);
        }

        public void actionPerformed(AnActionEvent anActionEvent) {
            NamedConfigurable namedConfigurable = ModuleStructureConfigurable.this.getSelectedConfigurable();
            if (namedConfigurable instanceof ModuleConfigurable) {
                try {
                    ModuleEditor moduleEditor = ((ModuleConfigurable)namedConfigurable).getModuleEditor();
                    String string = IdeBundle.message((String)"project.new.wizard.module.identification", (Object[])new Object[0]);
                    final NamePathComponent namePathComponent = new NamePathComponent(IdeBundle.message((String)"label.module.name", (Object[])new Object[0]), IdeBundle.message((String)"label.component.file.location", (Object[])new Object[]{StringUtil.capitalize((String)string)}), IdeBundle.message((String)"title.select.project.file.directory", (Object[])new Object[]{string}), IdeBundle.message((String)"description.select.project.file.directory", (Object[])new Object[]{StringUtil.capitalize((String)string)}), true, false);
                    Module module2 = moduleEditor.getModule();
                    if (module2 != null) {
                        namePathComponent.setPath(FileUtil.toSystemDependentName((String)PathUtil.getParentPath((String)module2.getModuleFilePath())));
                    }
                    DialogBuilder dialogBuilder = new DialogBuilder((Component)ModuleStructureConfigurable.this.myTree);
                    dialogBuilder.setTitle(ProjectBundle.message((String)"copy.module.dialog.title", (Object[])new Object[0]));
                    dialogBuilder.setCenterPanel((JComponent)namePathComponent);
                    dialogBuilder.setPreferredFocusComponent((JComponent)namePathComponent.getNameComponent());
                    dialogBuilder.setOkOperation(() -> {
                        String string2 = namePathComponent.getNameValue();
                        if (string2.isEmpty()) {
                            Messages.showErrorDialog((String)ProjectBundle.message((String)"enter.module.copy.name.error.message", (Object[])new Object[0]), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
                            return;
                        }
                        if (ModuleStructureConfigurable.this.getModule(string2) != null) {
                            Messages.showErrorDialog((String)ProjectBundle.message((String)"module.0.already.exists.error.message", (Object[])new Object[]{string2}), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
                            return;
                        }
                        if (namePathComponent.getPath().isEmpty()) {
                            Messages.showErrorDialog((String)IdeBundle.message((String)"prompt.enter.project.file.location", (Object[])new Object[]{string}), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
                            return;
                        }
                        if (!ProjectWizardUtil.createDirectoryIfNotExists(IdeBundle.message((String)"directory.project.file.directory", (Object[])new Object[]{string}), namePathComponent.getPath(), true)) {
                            Messages.showErrorDialog((String)ProjectBundle.message((String)"path.0.is.invalid.error.message", (Object[])new Object[]{namePathComponent.getPath()}), (String)CommonBundle.message((String)"title.error", (Object[])new Object[0]));
                            return;
                        }
                        dialogBuilder.getDialogWrapper().close(0);
                    });
                    if (dialogBuilder.show() != 0) {
                        return;
                    }
                    final ModifiableRootModel modifiableRootModel = moduleEditor.getModifiableRootModel();
                    String string2 = namePathComponent.getPath();
                    ModuleBuilder moduleBuilder = new ModuleBuilder(){

                        public void setupRootModel(ModifiableRootModel modifiableRootModel2) {
                            if (modifiableRootModel.isSdkInherited()) {
                                modifiableRootModel2.inheritSdk();
                            } else {
                                modifiableRootModel2.setSdk(modifiableRootModel.getSdk());
                            }
                            ((CompilerModuleExtension)modifiableRootModel2.getModuleExtension(CompilerModuleExtension.class)).inheritCompilerOutputPath(true);
                            ((LanguageLevelModuleExtension)modifiableRootModel2.getModuleExtension(LanguageLevelModuleExtension.class)).setLanguageLevel(LanguageLevelModuleExtensionImpl.getInstance((Module)modifiableRootModel.getModule()).getLanguageLevel());
                            for (OrderEntry orderEntry : modifiableRootModel.getOrderEntries()) {
                                if (orderEntry instanceof JdkOrderEntry || orderEntry instanceof ModuleSourceOrderEntry || !(orderEntry instanceof ClonableOrderEntry)) continue;
                                modifiableRootModel2.addOrderEntry(((ClonableOrderEntry)orderEntry).cloneEntry((RootModelImpl)modifiableRootModel2, (ProjectRootManagerImpl)ProjectRootManager.getInstance((Project)ModuleStructureConfigurable.this.myProject), VirtualFilePointerManager.getInstance()));
                            }
                            VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(namePathComponent.getPath());
                            if (virtualFile == null) {
                                virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(namePathComponent.getPath());
                            }
                            modifiableRootModel2.addContentEntry(virtualFile);
                        }

                        public ModuleType getModuleType() {
                            return ModuleType.get((Module)modifiableRootModel.getModule());
                        }
                    };
                    moduleBuilder.setName(namePathComponent.getNameValue());
                    moduleBuilder.setModuleFilePath(string2 + "/" + moduleBuilder.getName() + ".iml");
                    Module module3 = ModuleStructureConfigurable.this.myContext.myModulesConfigurator.addModule(moduleBuilder);
                    if (module3 != null) {
                        ModuleStructureConfigurable.this.a(module3);
                    }
                }
                catch (Exception exception) {
                    LOG.error((Throwable)exception);
                }
            } else {
                ModuleStructureConfigurable.this.b(namedConfigurable);
            }
        }

        public void update(AnActionEvent anActionEvent) {
            TreePath[] treePathArray = ModuleStructureConfigurable.this.myTree.getSelectionPaths();
            if (treePathArray == null || treePathArray.length != 1) {
                anActionEvent.getPresentation().setEnabled(false);
            } else {
                NamedConfigurable namedConfigurable = ModuleStructureConfigurable.this.getSelectedConfigurable();
                anActionEvent.getPresentation().setEnabled(namedConfigurable instanceof ModuleConfigurable || ModuleStructureConfigurable.a(namedConfigurable));
            }
        }
    }

    private class HideGroupsAction
    extends ToggleAction
    implements DumbAware {
        HideGroupsAction() {
            super("", "", AllIcons.ObjectBrowser.CompactEmptyPackages);
        }

        public void update(@NotNull AnActionEvent anActionEvent) {
            if (anActionEvent == null) {
                HideGroupsAction.a(0);
            }
            super.update(anActionEvent);
            Presentation presentation = anActionEvent.getPresentation();
            String string = ProjectBundle.message((String)(ModuleStructureConfigurable.this.e ? "project.roots.plain.mode.action.text.enabled" : "project.roots.plain.mode.action.text.disabled"), (Object[])new Object[0]);
            presentation.setText(string);
            presentation.setDescription(string);
            if (ModuleStructureConfigurable.this.myContext.myModulesConfigurator != null) {
                presentation.setVisible(ModuleStructureConfigurable.this.myContext.myModulesConfigurator.getModuleModel().hasModuleGroups());
            }
        }

        public boolean isSelected(AnActionEvent anActionEvent) {
            return ModuleStructureConfigurable.this.e;
        }

        public void setSelected(AnActionEvent anActionEvent, boolean bl2) {
            ModuleStructureConfigurable.this.e = bl2;
            ModuleStructureConfigurable.this.g();
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$HideGroupsAction", "update"));
        }
    }

    private class MyDataProviderWrapper
    extends JPanel
    implements DataProvider {
        MyDataProviderWrapper(JComponent jComponent) {
            super(new BorderLayout());
            this.add((Component)jComponent, "Center");
        }

        @Nullable
        public Object getData(@NonNls String string) {
            TreePath[] treePathArray;
            if (LangDataKeys.MODULE_CONTEXT_ARRAY.is(string) && (treePathArray = ModuleStructureConfigurable.this.myTree.getSelectionPaths()) != null) {
                LinkedHashSet<Module> linkedHashSet = new LinkedHashSet<Module>();
                for (TreePath treePath : treePathArray) {
                    MasterDetailsComponent.MyNode myNode = (MasterDetailsComponent.MyNode)treePath.getLastPathComponent();
                    NamedConfigurable namedConfigurable = myNode.getConfigurable();
                    LOG.assertTrue(namedConfigurable != null, (Object)"already disposed");
                    Object object = namedConfigurable.getEditableObject();
                    if (object instanceof Module) {
                        linkedHashSet.add((Module)object);
                        continue;
                    }
                    if (!(myNode instanceof ModuleGroupNode) || ((ModuleGroupNode)myNode).getModuleGroup() == null) continue;
                    TreeUtil.treeNodeTraverser((TreeNode)myNode).forEach(treeNode -> {
                        Object object;
                        if (treeNode instanceof MasterDetailsComponent.MyNode && (object = ((MasterDetailsComponent.MyNode)treeNode).getConfigurable().getEditableObject()) instanceof Module) {
                            linkedHashSet.add((Module)object);
                        }
                    });
                }
                return !linkedHashSet.isEmpty() ? linkedHashSet.toArray(Module.EMPTY_ARRAY) : null;
            }
            if (LangDataKeys.MODULE_CONTEXT.is(string)) {
                return ModuleStructureConfigurable.this.getSelectedModule();
            }
            if (LangDataKeys.MODIFIABLE_MODULE_MODEL.is(string)) {
                return ModuleStructureConfigurable.this.myContext.myModulesConfigurator.getModuleModel();
            }
            return null;
        }
    }

    private class ModuleRemoveHandler
    extends RemoveConfigurableHandler<Module> {
        ModuleRemoveHandler() {
            super(ModuleConfigurable.class);
        }

        @Override
        public boolean remove(@NotNull Collection<Module> collection) {
            ModulesConfigurator modulesConfigurator;
            List<Module> list2;
            if (collection == null) {
                ModuleRemoveHandler.b(0);
            }
            if ((list2 = (modulesConfigurator = ModuleStructureConfigurable.this.myContext.myModulesConfigurator).deleteModules(collection)).isEmpty()) {
                return false;
            }
            for (Module module2 : list2) {
                List<Facet> list3 = modulesConfigurator.getFacetsConfigurator().removeAllFacets(module2);
                FacetStructureConfigurable.getInstance(ModuleStructureConfigurable.this.myProject).removeFacetNodes(list3);
                ModuleStructureConfigurable.this.myContext.getDaemonAnalyzer().removeElement(new ModuleProjectStructureElement(ModuleStructureConfigurable.this.myContext, module2));
                for (ModuleStructureExtension moduleStructureExtension : (ModuleStructureExtension[])ModuleStructureExtension.EP_NAME.getExtensions()) {
                    moduleStructureExtension.moduleRemoved(module2);
                }
            }
            return true;
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modules", "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$ModuleRemoveHandler", "remove"));
        }
    }

    private class FacetInModuleRemoveHandler
    extends RemoveConfigurableHandler<Facet> {
        FacetInModuleRemoveHandler() {
            super(FacetConfigurable.class);
        }

        @Override
        public boolean remove(@NotNull Collection<Facet> collection) {
            if (collection == null) {
                FacetInModuleRemoveHandler.b(0);
            }
            for (Facet facet : collection) {
                List<Facet> list2 = ModuleStructureConfigurable.this.myContext.myModulesConfigurator.getFacetsConfigurator().removeFacet(facet);
                FacetStructureConfigurable.getInstance(ModuleStructureConfigurable.this.myProject).removeFacetNodes(list2);
            }
            return true;
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facets", "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$FacetInModuleRemoveHandler", "remove"));
        }
    }

    private static class ModuleGroupNodeImpl
    extends MasterDetailsComponent.MyNode
    implements ModuleGroupNode {
        private final ModuleGroup a;

        ModuleGroupNodeImpl(@NotNull NamedConfigurable namedConfigurable, @NotNull ModuleGroup moduleGroup) {
            if (namedConfigurable == null) {
                ModuleGroupNodeImpl.a(0);
            }
            if (moduleGroup == null) {
                ModuleGroupNodeImpl.a(1);
            }
            super(namedConfigurable, true);
            this.a = moduleGroup;
        }

        @Override
        @NotNull
        public ModuleGroup getModuleGroup() {
            ModuleGroup moduleGroup = this.a;
            if (moduleGroup == null) {
                ModuleGroupNodeImpl.a(2);
            }
            return moduleGroup;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurable";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleGroup";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$ModuleGroupNodeImpl";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$ModuleGroupNodeImpl";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleGroup";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private static interface ModuleGroupNode
    extends MutableTreeNode {
        @Nullable
        public ModuleGroup getModuleGroup();
    }

    private class ModuleNode
    extends MasterDetailsComponent.MyNode
    implements ModuleGroupNode {
        private final ModuleGroup a;

        public ModuleNode(@Nullable ModuleConfigurable moduleConfigurable, ModuleGroup moduleGroup) {
            if (moduleConfigurable == null) {
                ModuleNode.a(0);
            }
            super((NamedConfigurable)moduleConfigurable);
            this.a = moduleGroup;
        }

        @Override
        public ModuleGroup getModuleGroup() {
            return this.a;
        }

        @NotNull
        public String getDisplayName() {
            String string = ModuleStructureConfigurable.this.c ? this.c() : this.b().getShortenedName(this.a());
            if (string == null) {
                ModuleNode.a(1);
            }
            return string;
        }

        @NotNull
        private String c() {
            String string = ModuleStructureConfigurable.this.myContext.myModulesConfigurator.getModuleModel().getActualName(this.a());
            if (string == null) {
                ModuleNode.a(2);
            }
            return string;
        }

        private ModuleGrouper b() {
            return this.getConfigurable().getModuleGrouper();
        }

        public ModuleConfigurable getConfigurable() {
            return (ModuleConfigurable)super.getConfigurable();
        }

        private Module a() {
            return this.getConfigurable().getModule();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void reloadNode(DefaultTreeModel defaultTreeModel) {
            boolean bl2 = ModuleStructureConfigurable.this.myAutoScrollEnabled;
            try {
                ModuleStructureConfigurable.this.myAutoScrollEnabled = false;
                ModuleGroupingTreeHelper moduleGroupingTreeHelper = ModuleStructureConfigurable.this.a();
                MasterDetailsComponent.MyNode myNode = (MasterDetailsComponent.MyNode)moduleGroupingTreeHelper.moveModuleNodeToProperGroup((MutableTreeNode)this, (Object)this.a(), (MutableTreeNode)ModuleStructureConfigurable.this.myRoot, defaultTreeModel, (JTree)ModuleStructureConfigurable.this.myTree);
                defaultTreeModel.reload((TreeNode)myNode);
            }
            finally {
                ModuleStructureConfigurable.this.myAutoScrollEnabled = bl2;
            }
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: 
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: 
                case 2: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "configurable";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$ModuleNode";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/ModuleStructureConfigurable$ModuleNode";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDisplayName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFullModuleName";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: 
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

