/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.roots.libraries.LibraryTablesRegistrar;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.roots.ui.configuration.libraryEditor.LibraryEditorListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.LibrariesModifiableModel;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureLibraryTableModifiableModelProvider;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzer;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EventDispatcher;
import gnu.trove.THashMap;
import java.util.EventListener;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructureConfigurableContext
implements Disposable,
LibraryEditorListener {
    private final ProjectStructureDaemonAnalyzer a;
    public final ModulesConfigurator myModulesConfigurator;
    public final Map<String, LibrariesModifiableModel> myLevel2Providers = new THashMap();
    private final EventDispatcher<LibraryEditorListener> b = EventDispatcher.create(LibraryEditorListener.class);
    private final Project c;

    public StructureConfigurableContext(Project project2, ModulesConfigurator modulesConfigurator) {
        this.c = project2;
        this.myModulesConfigurator = modulesConfigurator;
        Disposer.register((Disposable)project2, (Disposable)this);
        this.a = new ProjectStructureDaemonAnalyzer(this);
    }

    public VirtualFile[] getLibraryFiles(Library library, OrderRootType orderRootType) {
        LibrariesModifiableModel librariesModifiableModel;
        LibraryTable.ModifiableModel modifiableModel;
        LibraryTable libraryTable = library.getTable();
        if (libraryTable != null && (modifiableModel = this.getModifiableLibraryTable(libraryTable)) instanceof LibrariesModifiableModel && (librariesModifiableModel = (LibrariesModifiableModel)modifiableModel).hasLibraryEditor(library)) {
            return librariesModifiableModel.getLibraryEditor(library).getFiles(orderRootType);
        }
        return library.getFiles(orderRootType);
    }

    public Project getProject() {
        return this.c;
    }

    public ProjectStructureDaemonAnalyzer getDaemonAnalyzer() {
        return this.a;
    }

    public void dispose() {
    }

    public ModulesConfigurator getModulesConfigurator() {
        return this.myModulesConfigurator;
    }

    public Module[] getModules() {
        return this.myModulesConfigurator.getModules();
    }

    public String getRealName(Module module2) {
        return this.myModulesConfigurator.getModuleModel().getActualName(module2);
    }

    public void resetLibraries() {
        LibraryTablesRegistrar libraryTablesRegistrar = LibraryTablesRegistrar.getInstance();
        this.myLevel2Providers.clear();
        this.myLevel2Providers.put("application", new LibrariesModifiableModel(libraryTablesRegistrar.getLibraryTable(), this.c, this));
        this.myLevel2Providers.put("project", new LibrariesModifiableModel(libraryTablesRegistrar.getLibraryTable(this.c), this.c, this));
        for (LibraryTable libraryTable : libraryTablesRegistrar.getCustomLibraryTables()) {
            this.myLevel2Providers.put(libraryTable.getTableLevel(), new LibrariesModifiableModel(libraryTable, this.c, this));
        }
    }

    public void addLibraryEditorListener(LibraryEditorListener libraryEditorListener) {
        this.b.addListener((EventListener)libraryEditorListener);
    }

    public void addLibraryEditorListener(@NotNull LibraryEditorListener libraryEditorListener, @NotNull Disposable disposable) {
        if (libraryEditorListener == null) {
            StructureConfigurableContext.a(0);
        }
        if (disposable == null) {
            StructureConfigurableContext.a(1);
        }
        this.b.addListener((EventListener)libraryEditorListener, disposable);
    }

    @Override
    public void libraryRenamed(@NotNull Library library, String string, String string2) {
        if (library == null) {
            StructureConfigurableContext.a(2);
        }
        ((LibraryEditorListener)this.b.getMulticaster()).libraryRenamed(library, string, string2);
    }

    public StructureLibraryTableModifiableModelProvider getGlobalLibrariesProvider() {
        return this.createModifiableModelProvider("application");
    }

    public StructureLibraryTableModifiableModelProvider createModifiableModelProvider(String string) {
        return new StructureLibraryTableModifiableModelProvider(string, this);
    }

    public StructureLibraryTableModifiableModelProvider getProjectLibrariesProvider() {
        return this.createModifiableModelProvider("project");
    }

    public LibraryTable.ModifiableModel getModifiableLibraryTable(@NotNull LibraryTable libraryTable) {
        String string;
        if (libraryTable == null) {
            StructureConfigurableContext.a(3);
        }
        if ((string = libraryTable.getTableLevel()).equals("module")) {
            return libraryTable.getModifiableModel();
        }
        return this.myLevel2Providers.get(string);
    }

    @Nullable
    public Library getLibrary(String string, String string2) {
        LibrariesModifiableModel librariesModifiableModel = this.myLevel2Providers.get(string2);
        return librariesModifiableModel == null ? null : StructureConfigurableContext.a(string, librariesModifiableModel);
    }

    @Nullable
    private static Library a(@NotNull String string, @NotNull LibrariesModifiableModel librariesModifiableModel) {
        if (string == null) {
            StructureConfigurableContext.a(4);
        }
        if (librariesModifiableModel == null) {
            StructureConfigurableContext.a(5);
        }
        for (Library library : librariesModifiableModel.getLibraries()) {
            Library library2 = StructureConfigurableContext.a(library, librariesModifiableModel);
            if (library2 == null || !string.equals(library2.getName())) continue;
            return library2;
        }
        return null;
    }

    @Nullable
    public Library getLibraryModel(@NotNull Library library) {
        LibraryTable libraryTable;
        if (library == null) {
            StructureConfigurableContext.a(6);
        }
        if ((libraryTable = library.getTable()) != null) {
            return StructureConfigurableContext.a(library, this.myLevel2Providers.get(libraryTable.getTableLevel()));
        }
        return library;
    }

    @Nullable
    private static Library a(Library library, LibrariesModifiableModel librariesModifiableModel) {
        if (librariesModifiableModel == null) {
            return library;
        }
        if (librariesModifiableModel.wasLibraryRemoved(library)) {
            return null;
        }
        return librariesModifiableModel.hasLibraryEditor(library) ? (Library)librariesModifiableModel.getLibraryEditor(library).getModel() : library;
    }

    public void reset() {
        this.resetLibraries();
        this.myModulesConfigurator.resetModuleEditors();
        this.a.reset();
    }

    public void clear() {
        this.myLevel2Providers.clear();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "library";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "libraryName";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/StructureConfigurableContext";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addLibraryEditorListener";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "libraryRenamed";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getModifiableLibraryTable";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "findLibraryModel";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getLibraryModel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

