/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui.configuration.projectRoot.daemon;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.roots.ui.configuration.projectRoot.StructureConfigurableContext;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectConfigurationProblems;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureDaemonAnalyzerListener;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElement;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureElementUsage;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemDescription;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureProblemsHolderImpl;
import com.intellij.openapi.roots.ui.configuration.projectRoot.daemon.ProjectStructureValidator;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.MultiValuesMap;
import com.intellij.util.Alarm;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProjectStructureDaemonAnalyzer
implements Disposable {
    private static final Logger h = Logger.getInstance((String)"#com.intellij.openapi.roots.ui.configuration.projectRoot.validation.ProjectStructureDaemonAnalyzer");
    private final Map<ProjectStructureElement, ProjectStructureProblemsHolderImpl> e = new HashMap<ProjectStructureElement, ProjectStructureProblemsHolderImpl>();
    private final MultiValuesMap<ProjectStructureElement, ProjectStructureElementUsage> f = new MultiValuesMap();
    private final MultiValuesMap<ProjectStructureElement, ProjectStructureElementUsage> b = new MultiValuesMap();
    private final Set<ProjectStructureElement> d = new HashSet<ProjectStructureElement>();
    private final Set<ProjectStructureElement> g = new HashSet<ProjectStructureElement>();
    private final Map<ProjectStructureElement, ProjectStructureProblemDescription> j = new HashMap<ProjectStructureElement, ProjectStructureProblemDescription>();
    private final MergingUpdateQueue c;
    private final MergingUpdateQueue i;
    private final EventDispatcher<ProjectStructureDaemonAnalyzerListener> l = EventDispatcher.create(ProjectStructureDaemonAnalyzerListener.class);
    private final AtomicBoolean a = new AtomicBoolean(false);
    private final ProjectConfigurationProblems k;

    public ProjectStructureDaemonAnalyzer(StructureConfigurableContext structureConfigurableContext) {
        Disposer.register((Disposable)structureConfigurableContext, (Disposable)this);
        this.k = new ProjectConfigurationProblems(this, structureConfigurableContext);
        this.c = new MergingUpdateQueue("Project Structure Daemon Analyzer", 300, false, null, (Disposable)this, null, Alarm.ThreadToUse.POOLED_THREAD);
        this.i = new MergingUpdateQueue("Project Structure Analysis Results Updater", 300, false, MergingUpdateQueue.ANY_COMPONENT, (Disposable)this, null, Alarm.ThreadToUse.SWING_THREAD);
    }

    private void a(ProjectStructureElement projectStructureElement, boolean bl2, boolean bl3) {
        if (this.a.get()) {
            return;
        }
        if (bl2) {
            this.e(projectStructureElement);
        }
        if (bl3) {
            this.c(projectStructureElement);
        }
    }

    private void e(ProjectStructureElement projectStructureElement) {
        ProjectStructureProblemsHolderImpl projectStructureProblemsHolderImpl = new ProjectStructureProblemsHolderImpl();
        ReadAction.run(() -> {
            if (this.a.get()) {
                return;
            }
            if (h.isDebugEnabled()) {
                h.debug("checking " + projectStructureElement);
            }
            ProjectStructureValidator.check(projectStructureElement, projectStructureProblemsHolderImpl);
        });
        this.i.queue((Update)new ProblemsComputedUpdate(projectStructureElement, projectStructureProblemsHolderImpl));
    }

    private void c(ProjectStructureElement projectStructureElement) {
        List list2 = (List)ReadAction.compute(() -> {
            if (this.a.get()) {
                return null;
            }
            if (h.isDebugEnabled()) {
                h.debug("collecting usages in " + projectStructureElement);
            }
            return ProjectStructureDaemonAnalyzer.a(projectStructureElement);
        });
        if (list2 != null) {
            this.i.queue((Update)new UsagesCollectedUpdate(projectStructureElement, list2));
        }
    }

    private static List<ProjectStructureElementUsage> a(ProjectStructureElement projectStructureElement) {
        return ProjectStructureValidator.getUsagesInElement(projectStructureElement);
    }

    private void a(ProjectStructureElement projectStructureElement, List<ProjectStructureElementUsage> list2) {
        this.b(projectStructureElement);
        for (ProjectStructureElementUsage projectStructureElementUsage : list2) {
            this.a(projectStructureElementUsage);
        }
        this.d.remove(projectStructureElement);
        this.i.queue((Update)new ReportUnusedElementsUpdate());
    }

    public void queueUpdate(@NotNull ProjectStructureElement projectStructureElement) {
        if (projectStructureElement == null) {
            ProjectStructureDaemonAnalyzer.a(0);
        }
        this.b(projectStructureElement, true, true);
    }

    private void b(@NotNull ProjectStructureElement projectStructureElement, boolean bl2, boolean bl3) {
        if (projectStructureElement == null) {
            ProjectStructureDaemonAnalyzer.a(1);
        }
        if (h.isDebugEnabled()) {
            h.debug("start " + (bl2 ? "checking " : "") + (bl3 ? "collecting usages " : "") + "for " + projectStructureElement);
        }
        if (bl3) {
            this.d.add(projectStructureElement);
        }
        if (projectStructureElement.shouldShowWarningIfUnused()) {
            this.g.add(projectStructureElement);
        }
        this.c.queue((Update)new AnalyzeElementUpdate(projectStructureElement, bl2, bl3));
    }

    public void removeElement(ProjectStructureElement projectStructureElement) {
        this.removeElements(Collections.singletonList(projectStructureElement));
    }

    public void removeElements(@NotNull List<? extends ProjectStructureElement> list2) {
        if (list2 == null) {
            ProjectStructureDaemonAnalyzer.a(2);
        }
        this.d.removeAll(list2);
        this.g.removeAll(list2);
        for (ProjectStructureElement projectStructureElement : list2) {
            this.j.remove(projectStructureElement);
            this.e.remove(projectStructureElement);
            Collection collection = this.f.removeAll((Object)projectStructureElement);
            if (collection != null) {
                for (ProjectStructureElementUsage projectStructureElementUsage : collection) {
                    this.e.remove(projectStructureElementUsage.getContainingElement());
                }
            }
            this.b(projectStructureElement);
            ((ProjectStructureDaemonAnalyzerListener)this.l.getMulticaster()).problemsChanged(projectStructureElement);
        }
        this.i.queue((Update)new ReportUnusedElementsUpdate());
    }

    private void a() {
        if (!this.d.isEmpty()) {
            return;
        }
        for (ProjectStructureElement projectStructureElement : this.g) {
            Collection collection = this.f.get((Object)projectStructureElement);
            ProjectStructureProblemDescription projectStructureProblemDescription = collection == null || collection.isEmpty() ? projectStructureElement.createUnusedElementWarning() : null;
            ProjectStructureProblemDescription projectStructureProblemDescription2 = this.j.put(projectStructureElement, projectStructureProblemDescription);
            ProjectStructureProblemsHolderImpl projectStructureProblemsHolderImpl = this.e.get(projectStructureElement);
            if (projectStructureProblemsHolderImpl == null) {
                projectStructureProblemsHolderImpl = new ProjectStructureProblemsHolderImpl();
                this.e.put(projectStructureElement, projectStructureProblemsHolderImpl);
            }
            if (projectStructureProblemDescription2 != null) {
                projectStructureProblemsHolderImpl.removeProblem(projectStructureProblemDescription2);
            }
            if (projectStructureProblemDescription != null) {
                projectStructureProblemsHolderImpl.registerProblem(projectStructureProblemDescription);
            }
            if (projectStructureProblemDescription2 == null && projectStructureProblemDescription == null) continue;
            ((ProjectStructureDaemonAnalyzerListener)this.l.getMulticaster()).problemsChanged(projectStructureElement);
        }
    }

    private void b(ProjectStructureElement projectStructureElement) {
        Collection collection = this.b.removeAll((Object)projectStructureElement);
        if (collection != null) {
            for (ProjectStructureElementUsage projectStructureElementUsage : collection) {
                this.f.remove((Object)projectStructureElementUsage.getSourceElement(), (Object)projectStructureElementUsage);
            }
        }
    }

    private void a(@NotNull ProjectStructureElementUsage projectStructureElementUsage) {
        if (projectStructureElementUsage == null) {
            ProjectStructureDaemonAnalyzer.a(3);
        }
        this.f.put((Object)projectStructureElementUsage.getSourceElement(), (Object)projectStructureElementUsage);
        this.b.put((Object)projectStructureElementUsage.getContainingElement(), (Object)projectStructureElementUsage);
    }

    public void stop() {
        h.debug("analyzer stopped");
        this.a.set(true);
        this.c.cancelAllUpdates();
        this.i.cancelAllUpdates();
        this.clearCaches();
        this.c.deactivate();
        this.i.deactivate();
    }

    public void clearCaches() {
        h.debug("clear caches");
        this.e.clear();
    }

    public void queueUpdateForAllElementsWithErrors() {
        ArrayList<ProjectStructureElement> arrayList = new ArrayList<ProjectStructureElement>();
        for (Map.Entry<ProjectStructureElement, ProjectStructureProblemsHolderImpl> entry : this.e.entrySet()) {
            if (!entry.getValue().containsProblems()) continue;
            arrayList.add(entry.getKey());
        }
        this.e.clear();
        h.debug("Adding to queue updates for " + arrayList.size() + " problematic elements");
        for (ProjectStructureElement projectStructureElement : arrayList) {
            this.queueUpdate(projectStructureElement);
        }
    }

    public void dispose() {
        this.a.set(true);
        this.c.cancelAllUpdates();
        this.i.cancelAllUpdates();
    }

    @Nullable
    public ProjectStructureProblemsHolderImpl getProblemsHolder(ProjectStructureElement projectStructureElement) {
        return this.e.get(projectStructureElement);
    }

    public Collection<ProjectStructureElementUsage> getUsages(ProjectStructureElement projectStructureElement) {
        ProjectStructureElement[] projectStructureElementArray;
        for (ProjectStructureElement projectStructureElement2 : projectStructureElementArray = this.d.toArray(new ProjectStructureElement[0])) {
            this.a(projectStructureElement2, ProjectStructureDaemonAnalyzer.a(projectStructureElement2));
        }
        List<ProjectStructureElementUsage> list2 = this.f.get((Object)projectStructureElement);
        return list2 != null ? list2 : Collections.emptyList();
    }

    public void addListener(ProjectStructureDaemonAnalyzerListener projectStructureDaemonAnalyzerListener) {
        h.debug("listener added " + projectStructureDaemonAnalyzerListener);
        this.l.addListener((EventListener)projectStructureDaemonAnalyzerListener);
    }

    public void reset() {
        h.debug("analyzer started");
        this.c.activate();
        this.i.activate();
        this.c.queue(new Update("reset"){

            public void run() {
                ProjectStructureDaemonAnalyzer.this.a.set(false);
            }
        });
    }

    public void clear() {
        this.j.clear();
        this.g.clear();
        this.f.clear();
        this.b.clear();
        this.d.clear();
        this.k.clearProblems();
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usage";
                break;
            }
        }
        objectArray2[1] = "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "queueUpdate";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "removeElements";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "addUsage";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class ReportUnusedElementsUpdate
    extends Update {
        private ReportUnusedElementsUpdate() {
            super((Object)"unused elements");
        }

        public void run() {
            ProjectStructureDaemonAnalyzer.this.a();
        }
    }

    private class ProblemsComputedUpdate
    extends Update {
        private final ProjectStructureElement a;
        private final ProjectStructureProblemsHolderImpl c;
        private final Object[] b;

        public ProblemsComputedUpdate(ProjectStructureElement projectStructureElement, ProjectStructureProblemsHolderImpl projectStructureProblemsHolderImpl) {
            super((Object)projectStructureElement);
            this.a = projectStructureElement;
            this.c = projectStructureProblemsHolderImpl;
            this.b = new Object[]{projectStructureElement, "problems computed"};
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (this.b == null) {
                ProblemsComputedUpdate.a(0);
            }
            return this.b;
        }

        public void run() {
            ProjectStructureProblemDescription projectStructureProblemDescription;
            if (ProjectStructureDaemonAnalyzer.this.a.get()) {
                return;
            }
            if (h.isDebugEnabled()) {
                h.debug("updating problems for " + this.a);
            }
            if ((projectStructureProblemDescription = (ProjectStructureProblemDescription)ProjectStructureDaemonAnalyzer.this.j.get(this.a)) != null) {
                this.c.registerProblem(projectStructureProblemDescription);
            }
            ProjectStructureDaemonAnalyzer.this.e.put(this.a, this.c);
            ((ProjectStructureDaemonAnalyzerListener)ProjectStructureDaemonAnalyzer.this.l.getMulticaster()).problemsChanged(this.a);
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$ProblemsComputedUpdate", "getEqualityObjects"));
        }
    }

    private class UsagesCollectedUpdate
    extends Update {
        private final ProjectStructureElement a;
        private final List<ProjectStructureElementUsage> c;
        private final Object[] b;

        public UsagesCollectedUpdate(ProjectStructureElement projectStructureElement, List<ProjectStructureElementUsage> list2) {
            super((Object)projectStructureElement);
            this.a = projectStructureElement;
            this.c = list2;
            this.b = new Object[]{projectStructureElement, "usages collected"};
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (this.b == null) {
                UsagesCollectedUpdate.a(0);
            }
            return this.b;
        }

        public void run() {
            if (ProjectStructureDaemonAnalyzer.this.a.get()) {
                return;
            }
            if (h.isDebugEnabled()) {
                h.debug("updating usages for " + this.a);
            }
            ProjectStructureDaemonAnalyzer.this.a(this.a, this.c);
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$UsagesCollectedUpdate", "getEqualityObjects"));
        }
    }

    private class AnalyzeElementUpdate
    extends Update {
        private final ProjectStructureElement b;
        private final boolean c;
        private final boolean d;
        private final Object[] a;

        public AnalyzeElementUpdate(ProjectStructureElement projectStructureElement, boolean bl2, boolean bl3) {
            super((Object)projectStructureElement);
            this.b = projectStructureElement;
            this.c = bl2;
            this.d = bl3;
            this.a = new Object[]{this.b, this.c, this.d};
        }

        public boolean canEat(Update update) {
            if (!(update instanceof AnalyzeElementUpdate)) {
                return false;
            }
            AnalyzeElementUpdate analyzeElementUpdate = (AnalyzeElementUpdate)update;
            return !(!this.b.equals(analyzeElementUpdate.b) || analyzeElementUpdate.c && !this.c || analyzeElementUpdate.d && !this.d);
        }

        @NotNull
        public Object[] getEqualityObjects() {
            if (this.a == null) {
                AnalyzeElementUpdate.a(0);
            }
            return this.a;
        }

        public void run() {
            try {
                ProjectStructureDaemonAnalyzer.this.a(this.b, this.c, this.d);
            }
            catch (Throwable throwable) {
                h.error(throwable);
            }
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/roots/ui/configuration/projectRoot/daemon/ProjectStructureDaemonAnalyzer$AnalyzeElementUpdate", "getEqualityObjects"));
        }
    }
}

