/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.module;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.impl.module.CloudApplicationConfigurable;
import com.intellij.remoteServer.impl.module.CloudApplicationConfiguration;
import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.remoteServer.util.CloudConnectionTask;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudMultiSourceServerRuntimeInstance;
import com.intellij.remoteServer.util.DelayedRunner;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloudSourceApplicationConfigurable<SC extends CloudConfigurationBase, DC extends CloudDeploymentNameConfiguration, SR extends CloudMultiSourceServerRuntimeInstance<DC, ?, ?, ?>, AC extends CloudApplicationConfiguration>
extends CloudApplicationConfigurable {
    private final Project a;
    private final Disposable b;
    private DelayedRunner c;
    private RemoteServer<?> d;

    public CloudSourceApplicationConfigurable(@Nullable Project project2, Disposable disposable) {
        this.a = project2;
        this.b = disposable;
    }

    @Override
    public void setAccount(RemoteServer<?> remoteServer) {
        this.d = remoteServer;
        this.clearCloudData();
    }

    protected RemoteServer<SC> getAccount() {
        return this.d;
    }

    @Override
    public JComponent getComponent() {
        JComponent jComponent = this.getMainPanel();
        if (this.c == null) {
            this.c = new DelayedRunner(jComponent){
                private RemoteServer<?> a;

                protected boolean wasChanged() {
                    boolean bl2;
                    boolean bl3 = bl2 = this.a != CloudSourceApplicationConfigurable.this.d;
                    if (bl2) {
                        this.a = CloudSourceApplicationConfigurable.this.d;
                    }
                    return bl2;
                }

                protected void run() {
                    CloudSourceApplicationConfigurable.this.loadCloudData();
                }
            };
            Disposer.register((Disposable)this.b, (Disposable)this.c);
        }
        return jComponent;
    }

    protected void clearCloudData() {
        this.getExistingComboBox().removeAllItems();
    }

    protected void loadCloudData() {
        new ConnectionTask<Collection<Deployment>>("Loading existing applications list"){

            protected void run(final ServerConnection<DC> serverConnection, final Semaphore semaphore, final AtomicReference<Collection<Deployment>> atomicReference) {
                serverConnection.connectIfNeeded(new ServerConnector.ConnectionCallback<DC>(){

                    public void connected(@NotNull ServerRuntimeInstance<DC> serverRuntimeInstance) {
                        if (serverRuntimeInstance == null) {
                            1.a(0);
                        }
                        serverConnection.computeDeployments(() -> {
                            atomicReference.set(serverConnection.getDeployments());
                            semaphore.up();
                            UIUtil.invokeLaterIfNeeded(() -> {
                                if (!Disposer.isDisposed((Disposable)CloudSourceApplicationConfigurable.this.b)) {
                                    CloudSourceApplicationConfigurable.this.a((Collection)atomicReference.get());
                                }
                            });
                        });
                    }

                    public void errorOccurred(@NotNull String string) {
                        if (string == null) {
                            1.a(1);
                        }
                        this.runtimeErrorOccurred(string);
                        semaphore.up();
                    }

                    private static /* synthetic */ void a(int n2) {
                        Object[] objectArray;
                        Object[] objectArray2;
                        Object[] objectArray3 = new Object[3];
                        switch (n2) {
                            default: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "serverRuntimeInstance";
                                break;
                            }
                            case 1: {
                                objectArray2 = objectArray3;
                                objectArray3[0] = "errorMessage";
                                break;
                            }
                        }
                        objectArray2[1] = "com/intellij/remoteServer/impl/module/CloudSourceApplicationConfigurable$2$1";
                        switch (n2) {
                            default: {
                                objectArray = objectArray2;
                                objectArray2[2] = "connected";
                                break;
                            }
                            case 1: {
                                objectArray = objectArray2;
                                objectArray2[2] = "errorOccurred";
                                break;
                            }
                        }
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                    }
                });
            }

            protected Collection<Deployment> run(SR SR) throws ServerRuntimeException {
                return null;
            }
        }.performAsync();
    }

    private void a(Collection<Deployment> collection) {
        JComboBox jComboBox = this.getExistingComboBox();
        jComboBox.removeAllItems();
        for (Deployment deployment : collection) {
            jComboBox.addItem(deployment.getName());
        }
    }

    protected Project getProject() {
        return this.a;
    }

    protected abstract JComboBox getExistingComboBox();

    protected abstract JComponent getMainPanel();

    public abstract AC createConfiguration();

    protected abstract class ConnectionTask<T>
    extends CloudConnectionTask<T, SC, DC, SR> {
        public ConnectionTask(String string) {
            super(CloudSourceApplicationConfigurable.this.a, string, CloudSourceApplicationConfigurable.this.getAccount());
        }
    }
}

