/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ssh;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.ssh.SSHUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.PlatformUtils;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;

public class RSyncUtil {
    private static final Logger a = Logger.getInstance(RSyncUtil.class);
    public static final String RSYNC = "rsync";
    public static final String RSYNC_OPTIONS = "-zarv";
    public static final String RSYNC_SSH_PORT_OPTION = "-e";
    public static final String RSYNC_PORT_OPTION = "-p %s";
    public static final String RSYNC_PUBLIC_KEY_OPTION = "-i %s";
    public static final String RSYNC_SSH_OPTIONS = "ssh %s %s";
    public static final int CHECK_CANCELLED_TIMEOUT = 200;
    public static final int DEFAULT_SSH_PORT = 22;

    private static boolean a() {
        return RSyncUtil.a(RSYNC, "--version");
    }

    @NotNull
    public static List<String> externalToolSuggestion() {
        if (!Registry.is((String)"ide.remote.interpreters.use.rsync")) {
            List<String> list2 = Collections.emptyList();
            if (list2 == null) {
                RSyncUtil.a(0);
            }
            return list2;
        }
        if (!PlatformUtils.isRubyMine()) {
            List<String> list3 = Collections.emptyList();
            if (list3 == null) {
                RSyncUtil.a(1);
            }
            return list3;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        if (!RSyncUtil.a()) {
            arrayList.add(RSYNC);
        }
        ArrayList<String> arrayList2 = arrayList;
        if (arrayList2 == null) {
            RSyncUtil.a(2);
        }
        return arrayList2;
    }

    public static boolean canUseRSync() {
        if (!Registry.is((String)"ide.remote.interpreters.use.rsync") || SystemInfo.isWindows && !Registry.is((String)"ide.remote.interpreters.rsync.enabled.on.windows")) {
            return false;
        }
        return RSyncUtil.a();
    }

    private static boolean a(String string, String string2) {
        try {
            File file = PathEnvironmentVariableUtil.findInPath((String)string);
            if (file == null) {
                return false;
            }
            GeneralCommandLine generalCommandLine = new GeneralCommandLine(new String[]{file.getAbsolutePath(), string2});
            String string3 = ScriptRunnerUtil.getProcessOutput((GeneralCommandLine)generalCommandLine);
            String string4 = string3.split("\n")[0];
            if (string4.matches(".*command not found.*")) {
                a.info(string + " not found");
                return false;
            }
            a.info(string + " version: " + string4);
        }
        catch (ExecutionException executionException) {
            a.error("Error during execution of command" + string);
            return false;
        }
        return true;
    }

    public static void uploadWithRSync(String string, String string2, RemoteSdkCredentials remoteSdkCredentials, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        String string3;
        if (progressIndicator == null) {
            RSyncUtil.a(3);
        }
        if ((string3 = PathUtilRt.getFileName((String)string2)).equals(PathUtilRt.getFileName((String)string))) {
            string2 = string2.substring(0, string2.length() - string3.length());
        }
        Pair<String, String[]> pair2 = RSyncUtil.a(string, string2, remoteSdkCredentials, true);
        RSyncUtil.a((String)pair2.first, (String[])pair2.second, progressIndicator, remoteSdkCredentials);
    }

    public static void downloadWithRSync(String string, String string2, RemoteSdkCredentials remoteSdkCredentials, @NotNull ProgressIndicator progressIndicator) throws ExecutionException {
        if (progressIndicator == null) {
            RSyncUtil.a(4);
        }
        if (!string2.endsWith(File.separator)) {
            string2 = string2 + File.separator;
        }
        FileUtil.createDirectory((File)new File(string));
        Pair<String, String[]> pair2 = RSyncUtil.a(string, string2, remoteSdkCredentials, false);
        RSyncUtil.a((String)pair2.first, (String[])pair2.second, progressIndicator, remoteSdkCredentials);
    }

    private static void a(@NotNull String string, String[] stringArray, final @NotNull ProgressIndicator progressIndicator, final @NotNull RemoteSdkCredentials remoteSdkCredentials) throws ExecutionException {
        File file;
        if (string == null) {
            RSyncUtil.a(5);
        }
        if (progressIndicator == null) {
            RSyncUtil.a(6);
        }
        if (remoteSdkCredentials == null) {
            RSyncUtil.a(7);
        }
        if ((file = PathEnvironmentVariableUtil.findInPath((String)string)) == null) {
            return;
        }
        PtyCommandLine ptyCommandLine = new PtyCommandLine();
        ptyCommandLine.setConsoleMode(false);
        ptyCommandLine.setExePath(file.getPath());
        ptyCommandLine.addParameters(stringArray);
        final OSProcessHandler oSProcessHandler = new OSProcessHandler((GeneralCommandLine)ptyCommandLine);
        assert (oSProcessHandler.getProcessInput() != null);
        final PrintWriter printWriter = new PrintWriter(oSProcessHandler.getProcessInput());
        oSProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent processEvent, @NotNull Key key) {
                if (processEvent == null) {
                    1.a(0);
                }
                if (key == null) {
                    1.a(1);
                }
                try {
                    progressIndicator.checkCanceled();
                }
                catch (ProcessCanceledException processCanceledException) {
                    oSProcessHandler.destroyProcess();
                }
                if (key == ProcessOutputTypes.STDOUT) {
                    if (processEvent.getText().contains(File.separator)) {
                        progressIndicator.setText(processEvent.getText());
                    }
                } else if (key == ProcessOutputTypes.STDERR && !processEvent.getText().contains("No such file or directory")) {
                    a.info(processEvent.getText());
                }
                if (SSHUtil.PASSPHRASE_PROMPT.matcher(processEvent.getText()).matches()) {
                    this.a(remoteSdkCredentials.getPassphrase());
                } else if (processEvent.getText().trim().toLowerCase(Locale.ENGLISH).endsWith("password:")) {
                    String string = remoteSdkCredentials.getPassword() != null ? remoteSdkCredentials.getPassword() : remoteSdkCredentials.getUserName();
                    this.a(string);
                } else if (processEvent.getText().contains("Are you sure you want to continue connecting")) {
                    this.a("yes");
                }
            }

            private void a(String string) {
                printWriter.println(string != null ? string : "");
                printWriter.flush();
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "outputType";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/ssh/RSyncUtil$1";
                objectArray[2] = "onTextAvailable";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        oSProcessHandler.startNotify();
        while (!oSProcessHandler.waitFor(200L)) {
            if (progressIndicator.isCanceled()) {
                oSProcessHandler.destroyProcess();
            }
            progressIndicator.checkCanceled();
        }
        oSProcessHandler.waitFor();
        if (!progressIndicator.isCanceled() && oSProcessHandler.getExitCode() != null && oSProcessHandler.getExitCode() != 0) {
            a.info("RSync exited with code: " + oSProcessHandler.getExitCode());
        }
    }

    private static Pair<String, String[]> a(String string, String string2, RemoteSdkCredentials remoteSdkCredentials, boolean bl2) {
        String string3;
        String string4;
        String string5;
        String string6 = String.format("%s@%s:%s", remoteSdkCredentials.getUserName(), remoteSdkCredentials.getHost(), string2);
        if (bl2) {
            string5 = string;
            string4 = string6;
        } else {
            string5 = string6;
            string4 = string;
        }
        String string7 = remoteSdkCredentials.getPrivateKeyFile() != null ? String.format(RSYNC_PUBLIC_KEY_OPTION, remoteSdkCredentials.getPrivateKeyFile()) : "";
        String string8 = string3 = remoteSdkCredentials.getPort() != 22 ? String.format(RSYNC_PORT_OPTION, remoteSdkCredentials.getPort()) : "";
        if (string7.length() + string3.length() > 0) {
            String string9 = String.format(RSYNC_SSH_OPTIONS, string3, string7);
            return Pair.create((Object)RSYNC, (Object)new String[]{RSYNC_OPTIONS, RSYNC_SSH_PORT_OPTION, string9, string5, string4});
        }
        return Pair.create((Object)RSYNC, (Object)new String[]{RSYNC_OPTIONS, string5, string4});
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ssh/RSyncUtil";
                break;
            }
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "progressIndicator";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "credentials";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "externalToolSuggestion";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ssh/RSyncUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "uploadWithRSync";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "downloadWithRSync";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "runAndListenBashCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

