/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.CommonBundle;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoType;
import com.intellij.codeInsight.daemon.impl.SeveritiesProvider;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.HighlighterColors;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.EffectType;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.rt.execution.junit.FileComparisonFailure;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import java.awt.Color;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class ExpectedHighlightingData {
    private static final String l = "error";
    private static final String k = "warning";
    private static final String c = "weak_warning";
    private static final String a = "info";
    private static final String h = "EOLError";
    private static final String m = "EOLWarning";
    private static final String j = "inject";
    private static final String n = "symbolName";
    private static final String g = "lineMarker";
    private static final String q = "*";
    private static final HighlightInfoType i = new HighlightInfoType.HighlightInfoTypeImpl(HighlightSeverity.INFORMATION, HighlighterColors.TEXT);
    private final Map<String, ExpectedHighlightingSet> d;
    private final Map<RangeMarker, LineMarkerInfo> b;
    private final Document o;
    private final PsiFile f;
    private final String e;
    private boolean p;

    public ExpectedHighlightingData(@NotNull Document document, boolean bl2, boolean bl3) {
        if (document == null) {
            ExpectedHighlightingData.a(0);
        }
        this(document, bl2, false, bl3);
    }

    public ExpectedHighlightingData(@NotNull Document document, boolean bl2, boolean bl3, boolean bl4) {
        if (document == null) {
            ExpectedHighlightingData.a(1);
        }
        this(document, bl2, bl3, bl4, null);
    }

    public ExpectedHighlightingData(@NotNull Document document, boolean bl2, boolean bl3, boolean bl4, @Nullable PsiFile psiFile) {
        if (document == null) {
            ExpectedHighlightingData.a(2);
        }
        this(document, bl2, bl3, bl4, false, psiFile);
    }

    public ExpectedHighlightingData(@NotNull Document document, boolean bl2, boolean bl3, boolean bl4, boolean bl5, @Nullable PsiFile psiFile) {
        if (document == null) {
            ExpectedHighlightingData.a(3);
        }
        this(document, psiFile);
        this.p = bl5;
        if (bl2) {
            this.checkWarnings();
        }
        if (bl3) {
            this.checkWeakWarnings();
        }
        if (bl4) {
            this.checkInfos();
        }
    }

    public ExpectedHighlightingData(@NotNull Document document, @Nullable PsiFile psiFile) {
        if (document == null) {
            ExpectedHighlightingData.a(4);
        }
        this.d = new LinkedHashMap<String, ExpectedHighlightingSet>();
        this.b = new THashMap();
        this.o = document;
        this.f = psiFile;
        this.e = document.getText();
        this.registerHighlightingType(l, new ExpectedHighlightingSet(HighlightSeverity.ERROR, false, true));
        this.registerHighlightingType(k, new ExpectedHighlightingSet(HighlightSeverity.WARNING, false, false));
        this.registerHighlightingType(c, new ExpectedHighlightingSet(HighlightSeverity.WEAK_WARNING, false, false));
        this.registerHighlightingType(j, new ExpectedHighlightingSet(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, false, false));
        this.registerHighlightingType(a, new ExpectedHighlightingSet(HighlightSeverity.INFORMATION, false, false));
        this.registerHighlightingType(n, new ExpectedHighlightingSet(HighlightInfoType.SYMBOL_TYPE_SEVERITY, false, false));
        for (SeveritiesProvider severitiesProvider : (SeveritiesProvider[])Extensions.getExtensions((ExtensionPointName)SeveritiesProvider.EP_NAME)) {
            for (HighlightInfoType highlightInfoType : severitiesProvider.getSeveritiesHighlightInfoTypes()) {
                HighlightSeverity highlightSeverity = highlightInfoType.getSeverity(null);
                this.registerHighlightingType(highlightSeverity.getName(), new ExpectedHighlightingSet(highlightSeverity, false, true));
            }
        }
        this.registerHighlightingType(h, new ExpectedHighlightingSet(HighlightSeverity.ERROR, true, true));
        this.registerHighlightingType(m, new ExpectedHighlightingSet(HighlightSeverity.WARNING, true, false));
    }

    public boolean hasLineMarkers() {
        return !this.b.isEmpty();
    }

    public void init() {
        WriteCommandAction.writeCommandAction(null).run(() -> {
            this.b(this.o);
            this.a(this.o);
            this.a();
        });
    }

    public void checkWarnings() {
        this.registerHighlightingType(k, new ExpectedHighlightingSet(HighlightSeverity.WARNING, false, true));
        this.registerHighlightingType(m, new ExpectedHighlightingSet(HighlightSeverity.WARNING, true, true));
    }

    public void checkWeakWarnings() {
        this.registerHighlightingType(c, new ExpectedHighlightingSet(HighlightSeverity.WEAK_WARNING, false, true));
    }

    public void checkInfos() {
        this.registerHighlightingType(a, new ExpectedHighlightingSet(HighlightSeverity.INFORMATION, false, true));
        this.registerHighlightingType(j, new ExpectedHighlightingSet(HighlightInfoType.INJECTED_FRAGMENT_SEVERITY, false, true));
    }

    public void checkSymbolNames() {
        this.registerHighlightingType(n, new ExpectedHighlightingSet(HighlightInfoType.SYMBOL_TYPE_SEVERITY, false, true));
    }

    public void registerHighlightingType(@NotNull String string, @NotNull ExpectedHighlightingSet expectedHighlightingSet) {
        if (string == null) {
            ExpectedHighlightingData.a(5);
        }
        if (expectedHighlightingSet == null) {
            ExpectedHighlightingData.a(6);
        }
        this.d.put(string, expectedHighlightingSet);
    }

    private void a() {
        for (Map.Entry<RangeMarker, LineMarkerInfo> entry : this.b.entrySet()) {
            RangeMarker rangeMarker = entry.getKey();
            int n2 = rangeMarker.getStartOffset();
            int n3 = rangeMarker.getEndOffset();
            LineMarkerInfo lineMarkerInfo = entry.getValue();
            PsiElement psiElement = lineMarkerInfo.getElement();
            assert (psiElement != null) : lineMarkerInfo;
            TextRange textRange = new TextRange(n2, n3);
            String string = lineMarkerInfo.getLineMarkerTooltip();
            MyLineMarkerInfo myLineMarkerInfo = new MyLineMarkerInfo(psiElement, textRange, lineMarkerInfo.updatePass, GutterIconRenderer.Alignment.RIGHT, string);
            entry.setValue(myLineMarkerInfo);
        }
    }

    private void b(Document document) {
        Matcher matcher;
        String string = document.getText();
        String string2 = ".*?((<lineMarker)(?: descr=\"((?:[^\"\\\\]|\\\\\")*)\")?>)(.*)";
        Pattern pattern = Pattern.compile(string2, 32);
        Pattern pattern2 = Pattern.compile("(.*?)(</lineMarker>)(.*)", 32);
        while ((matcher = pattern.matcher(string)).matches()) {
            int n2 = matcher.start(1);
            String string3 = matcher.group(3) != null ? matcher.group(3) : q;
            String string4 = matcher.group(4);
            Matcher matcher2 = pattern2.matcher(string4);
            if (!matcher2.matches()) {
                Assert.fail((String)"Cannot find closing </lineMarker>");
            }
            document.replaceString(n2, matcher.end(1), (CharSequence)"");
            String string5 = matcher2.group(1);
            int n3 = n2 + matcher2.start(3);
            String string6 = matcher2.group(2);
            document.replaceString(n2, n3, (CharSequence)string5);
            PsiElement psiElement = Objects.requireNonNull(this.f.findElementAt(n2));
            TextRange textRange = new TextRange(n2, n3 -= string6.length());
            String string7 = StringUtil.unescapeStringCharacters((String)string3);
            MyLineMarkerInfo myLineMarkerInfo = new MyLineMarkerInfo(psiElement, textRange, 11, GutterIconRenderer.Alignment.RIGHT, string7);
            this.b.put(document.createRangeMarker(n2, n3), myLineMarkerInfo);
            string = document.getText();
        }
    }

    private void a(Document document) {
        String string = document.getText();
        Set<String> set = this.d.keySet();
        String string2 = "(?:" + StringUtil.join(set, (String)")|(?:") + ")";
        String string3 = "<(" + string2 + ")(?:\\s+descr=\"((?:[^\"]|\\\\\"|\\\\\\\\\"|\\\\\\[|\\\\])*)\")?(?:\\s+type=\"([0-9A-Z_]+)\")?(?:\\s+foreground=\"([0-9xa-f]+)\")?(?:\\s+background=\"([0-9xa-f]+)\")?(?:\\s+effectcolor=\"([0-9xa-f]+)\")?(?:\\s+effecttype=\"([A-Z]+)\")?(?:\\s+fonttype=\"([0-9]+)\")?(?:\\s+textAttributesKey=\"((?:[^\"]|\\\\\"|\\\\\\\\\"|\\\\\\[|\\\\])*)\")?(?:\\s+bundleMsg=\"((?:[^\"]|\\\\\"|\\\\\\\\\")*)\")?(/)?>";
        Matcher matcher = Pattern.compile(string3).matcher(string);
        int n2 = 0;
        Ref ref = Ref.create((Object)0);
        while (matcher.find(n2)) {
            ref.set((Object)((Integer)ref.get() + matcher.start() - n2));
            n2 = this.a(matcher, string, document, (Ref<Integer>)ref);
        }
    }

    private int a(Matcher matcher, String string, Document document, Ref<Integer> ref) {
        Matcher matcher2;
        int n2;
        int n3;
        boolean bl2;
        document.deleteString(((Integer)ref.get()).intValue(), (Integer)ref.get() + matcher.end() - matcher.start());
        int n4 = 1;
        String string2 = matcher.group(n4++);
        String string3 = matcher.group(n4++);
        String string4 = matcher.group(n4++);
        String string5 = matcher.group(n4++);
        String string6 = matcher.group(n4++);
        String string7 = matcher.group(n4++);
        String string8 = matcher.group(n4++);
        String string9 = matcher.group(n4++);
        String string10 = matcher.group(n4++);
        String string11 = matcher.group(n4++);
        boolean bl3 = bl2 = matcher.group(n4) != null;
        if (string3 == null) {
            string3 = q;
        } else if (string3.equals("null")) {
            string3 = null;
        }
        if (string3 != null) {
            string3 = string3.replaceAll("\\\\\\\\\"", "\"");
            string3 = string3.replaceAll("\\\\\"", "\"");
        }
        HighlightInfoType highlightInfoType = i;
        if (string4 != null) {
            try {
                highlightInfoType = this.getTypeByName(string4);
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            if (highlightInfoType == null) {
                Assert.fail((String)("Wrong highlight type: " + string4));
            }
        }
        TextAttributes textAttributes = null;
        if (string5 != null) {
            n3 = Integer.parseInt(string9);
            textAttributes = new TextAttributes(Color.decode(string5), Color.decode(string6), Color.decode(string7), EffectType.valueOf((String)string8), n3);
        }
        n3 = (Integer)ref.get();
        if (bl2) {
            n2 = matcher.end();
        } else {
            int n5 = matcher.end();
            matcher2 = Pattern.compile("</" + string2 + ">").matcher(string);
            while (true) {
                int n6;
                if (!matcher2.find(n5)) {
                    n2 = n5;
                    break;
                }
                int n7 = n6 = matcher.find(n5) ? matcher.start() : string.length();
                if (matcher2.start() < n6) {
                    ref.set((Object)((Integer)ref.get() + matcher2.start() - n5));
                    document.deleteString(((Integer)ref.get()).intValue(), (Integer)ref.get() + matcher2.end() - matcher2.start());
                    n2 = matcher2.end();
                    break;
                }
                ref.set((Object)((Integer)ref.get() + n6 - n5));
                n5 = this.a(matcher, string, document, ref);
            }
        }
        ExpectedHighlightingSet expectedHighlightingSet = this.d.get(string2);
        if (expectedHighlightingSet.b) {
            List list2;
            matcher2 = string10 == null ? null : TextAttributesKey.createTextAttributesKey((String)string10);
            HighlightInfo.Builder builder = HighlightInfo.newHighlightInfo((HighlightInfoType)highlightInfoType).range(n3, ((Integer)ref.get()).intValue()).severity(expectedHighlightingSet.d);
            if (textAttributes != null) {
                builder.textAttributes(textAttributes);
            }
            if (matcher2 != null) {
                builder.textAttributes((TextAttributesKey)matcher2);
            }
            if (string11 != null) {
                list2 = StringUtil.split((String)string11, (String)"|");
                ResourceBundle resourceBundle = ResourceBundle.getBundle((String)list2.get(0));
                string3 = CommonBundle.message((ResourceBundle)resourceBundle, (String)((String)list2.get(1)), (Object[])list2.stream().skip(2L).toArray());
            }
            if (string3 != null) {
                builder.description(string3);
                builder.unescapedToolTip(string3);
            }
            if (expectedHighlightingSet.c) {
                builder.endOfLine();
            }
            list2 = builder.createUnconditionally();
            expectedHighlightingSet.a.add(list2);
        }
        return n2;
    }

    protected HighlightInfoType getTypeByName(String string) throws Exception {
        Field field = HighlightInfoType.class.getField(string);
        return (HighlightInfoType)field.get(null);
    }

    public void checkLineMarkers(@NotNull Collection<LineMarkerInfo> collection, @NotNull String string) {
        if (collection == null) {
            ExpectedHighlightingData.a(7);
        }
        if (string == null) {
            ExpectedHighlightingData.a(8);
        }
        String string2 = this.f == null ? "" : this.f.getName() + ": ";
        StringBuilder stringBuilder = new StringBuilder();
        for (LineMarkerInfo lineMarkerInfo : collection) {
            if (ExpectedHighlightingData.a(lineMarkerInfo, this.b.values())) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(string2).append("extra ").append(ExpectedHighlightingData.a(string, lineMarkerInfo.startOffset, lineMarkerInfo.endOffset)).append(": '").append(lineMarkerInfo.getLineMarkerTooltip()).append('\'');
        }
        for (LineMarkerInfo lineMarkerInfo : this.b.values()) {
            if (!collection.isEmpty() && ExpectedHighlightingData.a(lineMarkerInfo, collection)) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(string2).append("missing ").append(ExpectedHighlightingData.a(string, lineMarkerInfo.startOffset, lineMarkerInfo.endOffset)).append(": '").append(lineMarkerInfo.getLineMarkerTooltip()).append('\'');
        }
        if (stringBuilder.length() > 0) {
            Assert.fail((String)stringBuilder.toString());
        }
    }

    private static boolean a(LineMarkerInfo lineMarkerInfo, Collection<LineMarkerInfo> collection) {
        String string = lineMarkerInfo.getLineMarkerTooltip();
        for (LineMarkerInfo lineMarkerInfo2 : collection) {
            String string2;
            if (lineMarkerInfo2.startOffset != lineMarkerInfo.startOffset || lineMarkerInfo2.endOffset != lineMarkerInfo.endOffset || !Comparing.equal((String)string, (String)(string2 = lineMarkerInfo2.getLineMarkerTooltip())) && !q.equals(string2) && !q.equals(string)) continue;
            return true;
        }
        return false;
    }

    public void checkResult(Collection<HighlightInfo> collection, String string) {
        this.checkResult(collection, string, null);
    }

    public void checkResult(Collection<HighlightInfo> collection, String string, @Nullable String string2) {
        String string3 = this.f == null ? "" : this.f.getName() + ": ";
        StringBuilder stringBuilder = new StringBuilder();
        for (HighlightInfo object2 : ExpectedHighlightingData.a(collection)) {
            if (this.b(object2) || this.p) continue;
            int n2 = object2.startOffset;
            int n3 = object2.endOffset;
            String string4 = string.substring(n2, n3);
            String string5 = object2.getDescription();
            if (stringBuilder.length() > 0) {
                stringBuilder.append('\n');
            }
            stringBuilder.append(string3).append("extra ").append(ExpectedHighlightingData.a(string, n2, n3)).append(": '").append(string4).append('\'');
            if (string5 != null) {
                stringBuilder.append(" (").append(string5).append(')');
            }
            stringBuilder.append(" [").append(object2.type).append(']');
        }
        Collection<ExpectedHighlightingSet> collection2 = this.d.values();
        for (ExpectedHighlightingSet expectedHighlightingSet : ExpectedHighlightingData.a(collection2)) {
            Set set = expectedHighlightingSet.a;
            for (String string5 : set) {
                if (ExpectedHighlightingData.a(collection, (HighlightInfo)string5) || !expectedHighlightingSet.b) continue;
                int n4 = ((HighlightInfo)string5).startOffset;
                int n5 = ((HighlightInfo)string5).endOffset;
                String string6 = string.substring(n4, n5);
                String string7 = string5.getDescription();
                if (stringBuilder.length() > 0) {
                    stringBuilder.append('\n');
                }
                stringBuilder.append(string3).append("missing ").append(ExpectedHighlightingData.a(string, n4, n5)).append(": '").append(string6).append('\'');
                if (string7 == null) continue;
                stringBuilder.append(" (").append(string7).append(")");
            }
        }
        if (stringBuilder.length() > 0) {
            VirtualFile virtualFile;
            if (string2 == null && this.f != null && (virtualFile = this.f.getVirtualFile()) != null) {
                string2 = (String)virtualFile.getUserData(VfsTestUtil.TEST_DATA_FILE_PATH);
            }
            stringBuilder.append('\n');
            this.a(collection, string, stringBuilder.toString(), string2);
        }
    }

    private static <T> List<T> a(Collection<T> collection) {
        return ContainerUtil.reverse((List)(collection instanceof List ? (List<Object>)collection : new ArrayList<T>(collection)));
    }

    private void a(Collection<HighlightInfo> collection, String string, String string2, @Nullable String string3) {
        String string4 = ExpectedHighlightingData.composeText(this.d, collection, string);
        if (string3 != null && !this.e.equals(string4)) {
            throw new FileComparisonFailure(string2, this.e, string4, string3);
        }
        Assert.assertEquals((String)(string2 + "\n"), (Object)this.e, (Object)string4);
        Assert.fail((String)string2);
    }

    private static String a(Map<String, ExpectedHighlightingSet> map, HighlightInfo highlightInfo) {
        Map.Entry entry2 = (Map.Entry)ContainerUtil.find(map.entrySet(), entry -> ((ExpectedHighlightingSet)entry.getValue()).b && ((ExpectedHighlightingSet)entry.getValue()).d == highlightInfo.getSeverity() && ((ExpectedHighlightingSet)entry.getValue()).c == highlightInfo.isAfterEndOfLine());
        return entry2 != null ? (String)entry2.getKey() : null;
    }

    public static String composeText(Map<String, ExpectedHighlightingSet> map, Collection<HighlightInfo> collection, String string) {
        List<Pair<String, HighlightInfo>> list2 = collection.stream().map(highlightInfo -> Pair.pair((Object)ExpectedHighlightingData.a(map, highlightInfo), (Object)highlightInfo)).filter(pair2 -> pair2.first != null).collect(Collectors.toList());
        boolean bl2 = map.values().stream().flatMap(expectedHighlightingSet -> ((ExpectedHighlightingSet)expectedHighlightingSet).a.stream()).anyMatch(highlightInfo -> highlightInfo.forcedTextAttributesKey != null);
        Collections.sort(list2, (pair2, pair3) -> {
            int n2;
            HighlightInfo highlightInfo = (HighlightInfo)pair2.second;
            HighlightInfo highlightInfo2 = (HighlightInfo)pair3.second;
            int n3 = highlightInfo2.endOffset - highlightInfo.endOffset;
            if (n3 != 0) {
                return n3;
            }
            if (!highlightInfo.isAfterEndOfLine() && !highlightInfo2.isAfterEndOfLine() ? (n2 = highlightInfo.startOffset - highlightInfo2.startOffset) != 0 : (n2 = Comparing.compare((boolean)highlightInfo2.isAfterEndOfLine(), (boolean)highlightInfo.isAfterEndOfLine())) != 0) {
                return n2;
            }
            n2 = highlightInfo2.getSeverity().compareTo(highlightInfo.getSeverity());
            if (n2 != 0) {
                return n2;
            }
            return Comparing.compare((Comparable)((Object)highlightInfo.getDescription()), (Comparable)((Object)highlightInfo2.getDescription()));
        });
        StringBuilder stringBuilder = new StringBuilder();
        int[] nArray = ExpectedHighlightingData.a(stringBuilder, list2, 0, string, string.length(), -1, bl2);
        stringBuilder.insert(0, string.substring(0, nArray[1]));
        return stringBuilder.toString();
    }

    private static int[] a(StringBuilder stringBuilder, List<Pair<String, HighlightInfo>> list2, int n2, String string, int n3, int n4, boolean bl2) {
        int n5;
        for (n5 = n2; n5 < list2.size(); ++n5) {
            Object object;
            Pair<String, HighlightInfo> pair2 = list2.get(n5);
            HighlightInfo highlightInfo = (HighlightInfo)pair2.second;
            if (highlightInfo.endOffset <= n4) break;
            String string2 = (String)pair2.first;
            HighlightInfo highlightInfo2 = n5 < list2.size() - 1 ? (HighlightInfo)list2.get((int)(n5 + 1)).second : null;
            stringBuilder.insert(0, string.substring(highlightInfo.endOffset, n3));
            stringBuilder.insert(0, "</" + string2 + '>');
            n3 = highlightInfo.endOffset;
            if (highlightInfo2 != null && highlightInfo2.endOffset > highlightInfo.startOffset) {
                object = ExpectedHighlightingData.a(stringBuilder, list2, n5 + 1, string, n3, highlightInfo.startOffset, bl2);
                n5 = object[0] - 1;
                n3 = object[1];
            }
            stringBuilder.insert(0, string.substring(highlightInfo.startOffset, n3));
            object = '<' + string2 + " descr=\"" + StringUtil.escapeQuotes((String)String.valueOf(highlightInfo.getDescription())) + '\"';
            if (bl2) {
                object = (String)object + " textAttributesKey=\"" + highlightInfo.forcedTextAttributesKey + '\"';
            }
            object = (String)object + '>';
            stringBuilder.insert(0, (String)object);
            n3 = highlightInfo.startOffset;
        }
        return new int[]{n5, n3};
    }

    private static boolean a(Collection<HighlightInfo> collection, HighlightInfo highlightInfo) {
        for (HighlightInfo highlightInfo2 : collection) {
            if (!ExpectedHighlightingData.a(highlightInfo, highlightInfo2)) continue;
            return true;
        }
        return false;
    }

    private boolean b(HighlightInfo highlightInfo) {
        if (highlightInfo.getTextAttributes(null, null) == TextAttributes.ERASE_MARKER) {
            return true;
        }
        Collection<ExpectedHighlightingSet> collection = this.d.values();
        for (ExpectedHighlightingSet expectedHighlightingSet : collection) {
            if (expectedHighlightingSet.d != highlightInfo.getSeverity()) continue;
            if (!expectedHighlightingSet.b) {
                return true;
            }
            Set set = expectedHighlightingSet.a;
            for (HighlightInfo highlightInfo2 : set) {
                if (!ExpectedHighlightingData.a(highlightInfo2, highlightInfo)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean a(HighlightInfo highlightInfo, HighlightInfo highlightInfo2) {
        if (highlightInfo == highlightInfo2) {
            return true;
        }
        return !(highlightInfo2.getSeverity() != highlightInfo.getSeverity() || highlightInfo2.startOffset != highlightInfo.startOffset || highlightInfo2.endOffset != highlightInfo.endOffset || highlightInfo2.isAfterEndOfLine() != highlightInfo.isAfterEndOfLine() || highlightInfo.type != i && !highlightInfo.type.equals(highlightInfo2.type) || !Comparing.strEqual((String)q, (String)highlightInfo.getDescription()) && !Comparing.strEqual((String)highlightInfo2.getDescription(), (String)highlightInfo.getDescription()) || highlightInfo.forcedTextAttributes != null && !Comparing.equal((Object)highlightInfo.getTextAttributes(null, null), (Object)highlightInfo2.getTextAttributes(null, null)) || highlightInfo.forcedTextAttributesKey != null && !highlightInfo.forcedTextAttributesKey.equals((Object)highlightInfo2.forcedTextAttributesKey));
    }

    private static String a(String string, int n2, int n3) {
        int n4 = StringUtil.offsetToLineNumber((CharSequence)string, (int)n2);
        int n5 = StringUtil.offsetToLineNumber((CharSequence)string, (int)n3);
        int n6 = n2 - StringUtil.lineColToOffset((CharSequence)string, (int)n4, (int)0);
        int n7 = n3 - StringUtil.lineColToOffset((CharSequence)string, (int)n5, (int)0);
        if (n4 == n5) {
            return String.format("(%d:%d/%d)", n4 + 1, n6 + 1, n7 - n6);
        }
        return String.format("(%d:%d..%d:%d)", n4 + 1, n5 + 1, n6 + 1, n7 + 1);
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlightingSet";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "markerInfos";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/ExpectedHighlightingData";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "registerHighlightingType";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkLineMarkers";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class MyLineMarkerInfo
    extends LineMarkerInfo<PsiElement> {
        private final String a;

        public MyLineMarkerInfo(PsiElement psiElement, TextRange textRange, int n2, GutterIconRenderer.Alignment alignment, String string) {
            super(psiElement, textRange, null, n2, null, null, alignment);
            this.a = string;
        }

        public String getLineMarkerTooltip() {
            return this.a;
        }
    }

    public static class ExpectedHighlightingSet {
        private final HighlightSeverity d;
        private final boolean c;
        private final boolean b;
        private final Set<HighlightInfo> a;

        public ExpectedHighlightingSet(@NotNull HighlightSeverity highlightSeverity, boolean bl2, boolean bl3) {
            if (highlightSeverity == null) {
                ExpectedHighlightingSet.a(0);
            }
            this.d = highlightSeverity;
            this.c = bl2;
            this.b = bl3;
            this.a = new THashSet();
        }

        private static /* synthetic */ void a(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "severity", "com/intellij/testFramework/ExpectedHighlightingData$ExpectedHighlightingSet", "<init>"));
        }
    }
}

