/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.ProjectTopics;
import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.completion.CompletionProgressIndicator;
import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.ide.startup.StartupManagerEx;
import com.intellij.ide.startup.impl.StartupManagerImpl;
import com.intellij.idea.IdeaLogger;
import com.intellij.idea.IdeaTestApplication;
import com.intellij.mock.MockApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.DocumentReferenceManagerImpl;
import com.intellij.openapi.command.impl.UndoManagerImpl;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.UndoManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.impl.EditorFactoryImpl;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.impl.FileDocumentManagerImpl;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.impl.FileTypeManagerImpl;
import com.intellij.openapi.module.EmptyModuleType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.DumbModeTask;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ex.ProjectManagerEx;
import com.intellij.openapi.project.impl.ProjectManagerImpl;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.EmptyRunnable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.encoding.EncodingManager;
import com.intellij.openapi.vfs.encoding.EncodingManagerImpl;
import com.intellij.openapi.vfs.impl.VirtualFilePointerTracker;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFSImpl;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.impl.PsiDocumentManagerImpl;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageManagerImpl;
import com.intellij.psi.templateLanguages.TemplateDataLanguageMappings;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.RunAll;
import com.intellij.testFramework.SdkLeakTracker;
import com.intellij.testFramework.TestDataProvider;
import com.intellij.testFramework.TestRunnerUtil;
import com.intellij.testFramework.ThreadTracker;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.UsefulTestCase;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.UnindexedFilesUpdater;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ref.GCUtil;
import com.intellij.util.ui.UIUtil;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LightPlatformTestCase
extends UsefulTestCase
implements DataProvider {
    @NonNls
    private static final String q = "Light project: ";
    private static IdeaTestApplication t;
    protected static Project ourProject;
    private static Module l;
    private static PsiManager u;
    private static boolean p;
    private static VirtualFile o;
    private static TestCase v;
    public static Thread ourTestThread;
    private static LightProjectDescriptor n;
    private static SdkLeakTracker s;
    private ThreadTracker r;
    private VirtualFilePointerTracker m;
    private static int k;

    public static Project getProject() {
        return ourProject;
    }

    public static Module getModule() {
        return l;
    }

    @NotNull
    public static PsiManager getPsiManager() {
        if (u == null) {
            u = PsiManager.getInstance((Project)ourProject);
        }
        PsiManager psiManager = u;
        if (psiManager == null) {
            LightPlatformTestCase.b(0);
        }
        return psiManager;
    }

    @NotNull
    public static IdeaTestApplication initApplication() {
        IdeaTestApplication ideaTestApplication = t = IdeaTestApplication.getInstance();
        if (ideaTestApplication == null) {
            LightPlatformTestCase.b(1);
        }
        return ideaTestApplication;
    }

    public static void disposeApplication() {
        if (t != null) {
            ApplicationManager.getApplication().runWriteAction(() -> Disposer.dispose((Disposable)t));
            t = null;
        }
    }

    public static IdeaTestApplication getApplication() {
        return t;
    }

    public static void reportTestExecutionStatistics() {
        System.out.println("----- TEST STATISTICS -----");
        UsefulTestCase.logSetupTeardownCosts();
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.appInstancesCreated' value='%d']", MockApplication.INSTANCES_CREATED));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.projectInstancesCreated' value='%d']", ProjectManagerImpl.TEST_PROJECTS_CREATED));
        long l2 = 0L;
        for (GarbageCollectorMXBean garbageCollectorMXBean : ManagementFactory.getGarbageCollectorMXBeans()) {
            l2 += garbageCollectorMXBean.getCollectionTime();
        }
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.gcTimeMs' value='%d']", l2));
        System.out.println(String.format("##teamcity[buildStatisticValue key='ideaTests.classesLoaded' value='%d']", ManagementFactory.getClassLoadingMXBean().getTotalLoadedClassCount()));
    }

    protected void resetAllFields() {
        this.a(((Object)((Object)this)).getClass());
    }

    private void a(@NotNull Class<?> clazz) {
        if (clazz == null) {
            LightPlatformTestCase.b(2);
        }
        try {
            UsefulTestCase.clearDeclaredFields((Object)this, clazz);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
        if (clazz == LightPlatformTestCase.class) {
            return;
        }
        this.a(clazz.getSuperclass());
    }

    private static void x() {
        ((PersistentFSImpl)PersistentFS.getInstance()).cleanPersistedContents();
    }

    private static void a(@NotNull LightProjectDescriptor lightProjectDescriptor) throws Exception {
        if (lightProjectDescriptor == null) {
            LightPlatformTestCase.b(3);
        }
        n = lightProjectDescriptor;
        if (ourProject != null) {
            LightPlatformTestCase.closeAndDeleteProject();
        }
        ApplicationManager.getApplication().runWriteAction(LightPlatformTestCase::x);
        File file = FileUtil.createTempFile((String)"light_temp", (String)".ipr");
        LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        new Throwable(file.getPath()).printStackTrace(new PrintStream(byteArrayOutputStream));
        ourProject = PlatformTestCase.createProject(file, q + byteArrayOutputStream);
        ourPathToKeep = file.getPath();
        u = null;
        n.setUpProject(ourProject, new LightProjectDescriptor.SetupHandler(){

            @Override
            public void moduleCreated(@NotNull Module module2) {
                if (module2 == null) {
                    1.b(0);
                }
                l = module2;
            }

            @Override
            public void sourceRootCreated(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    1.b(1);
                }
                o = virtualFile;
            }

            private static /* synthetic */ void b(int n2) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "module";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "sourceRoot";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/testFramework/LightPlatformTestCase$1";
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "moduleCreated";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "sourceRootCreated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public static VirtualFile getSourceRoot() {
        return o;
    }

    @Override
    protected void setUp() throws Exception {
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            super.setUp();
            ApplicationInfoImpl.setInStressTest((boolean)this.isStressTest());
            if (this.isPerformanceTest()) {
                Timings.getStatistics();
            }
            LightPlatformTestCase.initApplication();
            t.setDataProvider(this);
            LightProjectDescriptor lightProjectDescriptor = this.getProjectDescriptor();
            LightPlatformTestCase.doSetup(lightProjectDescriptor, this.configureLocalInspectionTools(), this.getTestRootDisposable());
            InjectedLanguageManagerImpl.pushInjectors((Project)LightPlatformTestCase.getProject());
            this.storeSettings();
            this.r = new ThreadTracker();
            ModuleRootManager.getInstance((Module)l).orderEntries().getAllLibrariesAndSdkClassesRoots();
            this.m = new VirtualFilePointerTracker();
        }));
    }

    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        SimpleLightProjectDescriptor simpleLightProjectDescriptor = new SimpleLightProjectDescriptor(this.getModuleType(), this.getProjectJDK());
        if (simpleLightProjectDescriptor == null) {
            LightPlatformTestCase.b(4);
        }
        return simpleLightProjectDescriptor;
    }

    public static void doSetup(@NotNull LightProjectDescriptor lightProjectDescriptor, @NotNull LocalInspectionTool[] localInspectionToolArray, @NotNull Disposable disposable) throws Exception {
        if (lightProjectDescriptor == null) {
            LightPlatformTestCase.b(5);
        }
        if (localInspectionToolArray == null) {
            LightPlatformTestCase.b(6);
        }
        if (disposable == null) {
            LightPlatformTestCase.b(7);
        }
        LightPlatformTestCase.assertNull((String)("Previous test " + v + " hasn't called tearDown(). Probably overridden without super call."), (Object)v);
        IdeaLogger.ourErrorsOccurred = null;
        ApplicationManager.getApplication().assertIsDispatchThread();
        s = new SdkLeakTracker();
        boolean bl2 = true;
        if (ourProject == null || n == null || !n.equals(lightProjectDescriptor)) {
            LightPlatformTestCase.a(lightProjectDescriptor);
            bl2 = false;
        }
        ProjectManagerEx projectManagerEx = ProjectManagerEx.getInstanceEx();
        try {
            projectManagerEx.openTestProject(ourProject);
        }
        catch (Throwable throwable) {
            ourProject = null;
            throw throwable;
        }
        if (bl2) {
            DumbService.getInstance((Project)ourProject).queueTask((DumbModeTask)new UnindexedFilesUpdater(ourProject));
        }
        MessageBusConnection messageBusConnection = ourProject.getMessageBus().connect(disposable);
        messageBusConnection.subscribe(ProjectTopics.MODULES, (Object)new ModuleListener(){

            public void moduleAdded(@NotNull Project project2, @NotNull Module module2) {
                if (project2 == null) {
                    2.a(0);
                }
                if (module2 == null) {
                    2.a(1);
                }
                TestCase.fail((String)"Adding modules is not permitted in LightIdeaTestCase.");
            }

            private static /* synthetic */ void a(int n2) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n2) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "project";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "module";
                        break;
                    }
                }
                objectArray[1] = "com/intellij/testFramework/LightPlatformTestCase$2";
                objectArray[2] = "moduleAdded";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        LightPlatformTestCase.clearUncommittedDocuments(LightPlatformTestCase.getProject());
        InspectionsKt.configureInspections((InspectionProfileEntry[])localInspectionToolArray, LightPlatformTestCase.getProject(), disposable);
        LightPlatformTestCase.assertFalse((boolean)LightPlatformTestCase.getPsiManager().isDisposed());
        Boolean bl3 = null;
        try {
            bl3 = StartupManagerEx.getInstanceEx((Project)LightPlatformTestCase.getProject()).startupActivityPassed();
        }
        catch (Exception exception) {
            // empty catch block
        }
        LightPlatformTestCase.assertTrue((String)("open: " + LightPlatformTestCase.getProject().isOpen() + "; disposed:" + LightPlatformTestCase.getProject().isDisposed() + "; startup passed:" + bl3 + "; all open projects: " + Arrays.asList(ProjectManager.getInstance().getOpenProjects())), (boolean)LightPlatformTestCase.getProject().isInitialized());
        CodeStyle.setTemporarySettings((Project)LightPlatformTestCase.getProject(), (CodeStyleSettings)new CodeStyleSettings());
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        if (fileDocumentManager instanceof FileDocumentManagerImpl) {
            Document[] documentArray = fileDocumentManager.getUnsavedDocuments();
            fileDocumentManager.saveAllDocuments();
            ApplicationManager.getApplication().runWriteAction(() -> ((FileDocumentManagerImpl)((FileDocumentManagerImpl)fileDocumentManager)).dropAllUnsavedDocuments());
            LightPlatformTestCase.assertEmpty("There are unsaved documents", Arrays.asList(documentArray));
        }
        UIUtil.dispatchAllInvocationEvents();
        ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue();
    }

    protected void enableInspectionTools(InspectionProfileEntry ... inspectionProfileEntryArray) {
        if (inspectionProfileEntryArray == null) {
            LightPlatformTestCase.b(8);
        }
        InspectionsKt.enableInspectionTools(LightPlatformTestCase.getProject(), this.getTestRootDisposable(), inspectionProfileEntryArray);
    }

    protected void enableInspectionTool(@NotNull InspectionToolWrapper inspectionToolWrapper) {
        if (inspectionToolWrapper == null) {
            LightPlatformTestCase.b(9);
        }
        InspectionsKt.enableInspectionTool(LightPlatformTestCase.getProject(), inspectionToolWrapper, this.getTestRootDisposable());
    }

    protected void enableInspectionTool(@NotNull InspectionProfileEntry inspectionProfileEntry) {
        if (inspectionProfileEntry == null) {
            LightPlatformTestCase.b(10);
        }
        InspectionsKt.enableInspectionTool(LightPlatformTestCase.getProject(), inspectionProfileEntry, this.getTestRootDisposable());
    }

    @NotNull
    protected LocalInspectionTool[] configureLocalInspectionTools() {
        if (LocalInspectionTool.EMPTY_ARRAY == null) {
            LightPlatformTestCase.b(11);
        }
        return LocalInspectionTool.EMPTY_ARRAY;
    }

    @Override
    protected void tearDown() throws Exception {
        Project project2 = LightPlatformTestCase.getProject();
        new RunAll(() -> CodeStyle.dropTemporarySettings((Project)project2), this::checkForSettingsDamage, () -> LightPlatformTestCase.doTearDown(project2, t), () -> LightPlatformTestCase.checkEditorsReleased(), () -> s.checkForJdkTableLeaks(), () -> super.tearDown(), () -> this.r.checkLeak(), () -> InjectedLanguageManagerImpl.checkInjectorsAreDisposed((Project)project2), () -> this.m.assertPointersAreDisposed()).run();
    }

    public static void doTearDown(@NotNull Project project2, @NotNull IdeaTestApplication ideaTestApplication) {
        if (project2 == null) {
            LightPlatformTestCase.b(12);
        }
        if (ideaTestApplication == null) {
            LightPlatformTestCase.b(13);
        }
        new RunAll(new ThrowableRunnable[0]).append(() -> ((FileTypeManagerImpl)FileTypeManager.getInstance()).drainReDetectQueue()).append(() -> {
            if (project2 == null) {
                LightPlatformTestCase.b(37);
            }
            CodeStyle.dropTemporarySettings((Project)project2);
        }).append(LightPlatformTestCase::C).append(() -> {
            if (project2 == null) {
                LightPlatformTestCase.b(36);
            }
            UsefulTestCase.doPostponedFormatting(project2);
        }).append(() -> {
            if (project2 == null) {
                LightPlatformTestCase.b(35);
            }
            LookupManager.getInstance((Project)project2).hideActiveLookup();
        }).append(() -> {
            if (project2 == null) {
                LightPlatformTestCase.b(34);
            }
            ((StartupManagerImpl)StartupManager.getInstance((Project)project2)).prepareForNextTest();
        }).append(() -> {
            if (ProjectManager.getInstance() == null) {
                throw new AssertionError((Object)"Application components damaged");
            }
        }).append(() -> {
            if (project2 == null) {
                LightPlatformTestCase.b(33);
            }
            WriteCommandAction.runWriteCommandAction((Project)project2, () -> {
                VirtualFile[] virtualFileArray;
                if (o != null) {
                    try {
                        virtualFileArray = o.getChildren();
                        int n2 = virtualFileArray.length;
                        for (int i2 = 0; i2 < n2; ++i2) {
                            VirtualFile virtualFile = virtualFileArray[i2];
                            virtualFile.delete(LightPlatformTestCase.class);
                        }
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
                if ((virtualFileArray = FileDocumentManager.getInstance()) instanceof FileDocumentManagerImpl) {
                    ((FileDocumentManagerImpl)virtualFileArray).dropAllUnsavedDocuments();
                }
            });
        }).append(() -> {
            if (project2 == null) {
                LightPlatformTestCase.b(32);
            }
            LightPlatformTestCase.assertFalse((boolean)PsiManager.getInstance((Project)project2).isDisposed());
        }).append(() -> {
            EncodingManager encodingManager = EncodingManager.getInstance();
            if (encodingManager instanceof EncodingManagerImpl) {
                ((EncodingManagerImpl)encodingManager).clearDocumentQueue();
            }
            if (!p && IdeaLogger.ourErrorsOccurred != null) {
                throw IdeaLogger.ourErrorsOccurred;
            }
        }).append(() -> {
            if (project2 == null) {
                LightPlatformTestCase.b(31);
            }
            LightPlatformTestCase.clearUncommittedDocuments(project2);
        }).append(() -> ((HintManagerImpl)HintManager.getInstance()).cleanup()).append(() -> ((UndoManagerImpl)UndoManager.getGlobalInstance()).dropHistoryInTests()).append(() -> {
            if (project2 == null) {
                LightPlatformTestCase.b(30);
            }
            ((UndoManagerImpl)UndoManager.getInstance((Project)project2)).dropHistoryInTests();
        }).append(() -> ((DocumentReferenceManagerImpl)DocumentReferenceManager.getInstance()).cleanupForNextTest()).append(() -> {
            if (project2 == null) {
                LightPlatformTestCase.b(29);
            }
            TemplateDataLanguageMappings.getInstance((Project)project2).cleanupForNextTest();
        }).append(() -> {
            if (project2 == null) {
                LightPlatformTestCase.b(28);
            }
            ((PsiManagerImpl)PsiManager.getInstance((Project)project2)).cleanupForNextTest();
        }).append(() -> {
            if (project2 == null) {
                LightPlatformTestCase.b(27);
            }
            ProjectManagerEx.getInstanceEx().closeTestProject(project2);
        }).append(() -> {
            if (ideaTestApplication == null) {
                LightPlatformTestCase.b(26);
            }
            ideaTestApplication.setDataProvider(null);
        }).append(() -> {
            v = null;
        }).append(() -> CompletionProgressIndicator.cleanupForNextTest()).append(() -> {
            if (k++ % 100 == 0) {
                GCUtil.clearBeanInfoCache();
            }
        }).run();
    }

    private static void C() throws Exception {
        Method method;
        Object object;
        Class<?> clazz = Class.forName("javax.swing.TimerQueue");
        DelayQueue delayQueue = (DelayQueue)ReflectionUtil.getField(clazz, (Object)(object = (method = ReflectionUtil.getMethod(clazz, (String)"sharedInstance", (Class[])new Class[0])).invoke(null, new Object[0])), DelayQueue.class, (String)"queue");
        Object object2 = delayQueue.peek();
        if (object2 != null) {
            long l2 = object2.getDelay(TimeUnit.MILLISECONDS);
            String string = "(delayed for " + l2 + "ms)";
            Method method2 = ReflectionUtil.getDeclaredMethod(object2.getClass(), (String)"getTimer", (Class[])new Class[0]);
            Timer timer = (Timer)method2.invoke(object2, new Object[0]);
            string = "Timer (listeners: " + Arrays.asList(timer.getActionListeners()) + ") " + string;
            throw new AssertionFailedError("Not disposed java.swing.Timer: " + string + "; queue:" + object);
        }
    }

    public static void clearUncommittedDocuments(@NotNull Project project2) {
        if (project2 == null) {
            LightPlatformTestCase.b(14);
        }
        PsiDocumentManagerImpl psiDocumentManagerImpl = (PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project2);
        psiDocumentManagerImpl.clearUncommittedDocuments();
        ProjectManagerImpl projectManagerImpl = (ProjectManagerImpl)ProjectManager.getInstance();
        if (projectManagerImpl.isDefaultProjectInitialized()) {
            Project project3 = projectManagerImpl.getDefaultProject();
            ((PsiDocumentManagerImpl)PsiDocumentManager.getInstance((Project)project3)).clearUncommittedDocuments();
        }
    }

    public static void checkEditorsReleased() {
        new RunAll(() -> UIUtil.dispatchAllInvocationEvents(), () -> {
            RunAll runAll = new RunAll(new ThrowableRunnable[0]);
            for (Editor editor : EditorFactory.getInstance().getAllEditors()) {
                runAll = runAll.append(() -> EditorFactoryImpl.throwNotReleasedError((Editor)editor)).append(() -> EditorFactory.getInstance().releaseEditor(editor));
            }
            runAll.run();
        }).run();
    }

    @Override
    public final void runBare() throws Throwable {
        this.runBareImpl(this::b);
    }

    protected void runBareImpl(ThrowableRunnable<?> throwableRunnable) throws Exception {
        if (!this.shouldRunTest()) {
            return;
        }
        TestRunnerUtil.replaceIdeEventQueueSafely();
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> {
            try {
                ourTestThread = Thread.currentThread();
                throwableRunnable.run();
            }
            finally {
                ourTestThread = null;
                try {
                    Application application = ApplicationManager.getApplication();
                    if (application instanceof ApplicationEx) {
                        PlatformTestCase.cleanupApplicationCaches(ourProject);
                    }
                    this.resetAllFields();
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            }
        }));
        SwingUtilities.invokeAndWait(EmptyRunnable.getInstance());
        if (IdeaLogger.ourErrorsOccurred != null) {
            throw IdeaLogger.ourErrorsOccurred;
        }
    }

    private void b() throws Throwable {
        this.setUp();
        try {
            p = true;
            this.runTest();
            p = false;
        }
        finally {
            this.tearDown();
        }
    }

    public Object getData(String string) {
        return ourProject == null || ourProject.isDisposed() ? null : new TestDataProvider(ourProject).getData(string);
    }

    protected Sdk getProjectJDK() {
        return null;
    }

    @NotNull
    protected ModuleType getModuleType() {
        EmptyModuleType emptyModuleType = EmptyModuleType.getInstance();
        if (emptyModuleType == null) {
            LightPlatformTestCase.b(15);
        }
        return emptyModuleType;
    }

    @NotNull
    protected static PsiFile createFile(@NonNls @NotNull String string, @NonNls @NotNull String string2) throws IncorrectOperationException {
        if (string == null) {
            LightPlatformTestCase.b(16);
        }
        if (string2 == null) {
            LightPlatformTestCase.b(17);
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(string);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)LightPlatformTestCase.getProject()).createFileFromText(string, fileType, (CharSequence)string2, LocalTimeCounter.currentTime(), true, false);
        if (psiFile == null) {
            LightPlatformTestCase.b(18);
        }
        return psiFile;
    }

    @NotNull
    protected static PsiFile createLightFile(@NonNls @NotNull String string, @NotNull String string2) throws IncorrectOperationException {
        if (string == null) {
            LightPlatformTestCase.b(19);
        }
        if (string2 == null) {
            LightPlatformTestCase.b(20);
        }
        FileType fileType = FileTypeManager.getInstance().getFileTypeByFileName(string);
        PsiFile psiFile = PsiFileFactory.getInstance((Project)LightPlatformTestCase.getProject()).createFileFromText(string, fileType, (CharSequence)string2, LocalTimeCounter.currentTime(), false, false);
        if (psiFile == null) {
            LightPlatformTestCase.b(21);
        }
        return psiFile;
    }

    @Override
    @NotNull
    protected String getTestName(boolean bl2) {
        String string = this.getName();
        LightPlatformTestCase.assertTrue((String)("Test name should start with 'test': " + string), (boolean)string.startsWith("test"));
        string = string.substring("test".length());
        if (!string.isEmpty() && bl2 && !PlatformTestUtil.isAllUppercaseName(string)) {
            string = Character.toLowerCase(string.charAt(0)) + string.substring(1);
        }
        String string2 = string;
        if (string2 == null) {
            LightPlatformTestCase.b(22);
        }
        return string2;
    }

    protected static void commitDocument(@NotNull Document document) {
        if (document == null) {
            LightPlatformTestCase.b(23);
        }
        PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).commitDocument(document);
    }

    protected static void commitAllDocuments() {
        PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).commitAllDocuments();
    }

    @Override
    @NotNull
    protected CodeStyleSettings getCurrentCodeStyleSettings() {
        CodeStyleSettings codeStyleSettings = CodeStyle.getSettings((Project)LightPlatformTestCase.getProject());
        if (codeStyleSettings == null) {
            LightPlatformTestCase.b(24);
        }
        return codeStyleSettings;
    }

    protected static Document getDocument(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            LightPlatformTestCase.b(25);
        }
        return PsiDocumentManager.getInstance((Project)LightPlatformTestCase.getProject()).getDocument(psiFile);
    }

    public static synchronized void closeAndDeleteProject() {
        File file;
        if (ourProject == null) {
            return;
        }
        if (ApplicationManager.getApplication().isWriteAccessAllowed()) {
            throw new IllegalStateException("Must not call closeAndDeleteProject from under write action");
        }
        if (!ourProject.isDisposed()) {
            LightPlatformTestCase.assertEquals((Object)ourProject, (Object)l.getProject());
            file = new File(ourProject.getProjectFilePath());
            if (file.exists()) {
                File file2 = file.getParentFile();
                if (file2.getName().startsWith("unitTest_")) {
                    FileUtil.delete((File)file2);
                } else {
                    FileUtil.delete((File)file);
                }
            }
        }
        LightPlatformTestCase.assertTrue((boolean)ProjectManagerEx.getInstanceEx().closeAndDispose(ourProject));
        LightPlatformTestCase.assertTrue((boolean)ourProject.isDisposed());
        if (ourPathToKeep != null && (file = new File(ourPathToKeep).getParentFile()).getName().startsWith("unitTest_")) {
            file.delete();
        }
        ourProject = null;
        LightPlatformTestCase.assertTrue((boolean)l.isDisposed());
        l = null;
        if (u != null) {
            LightPlatformTestCase.assertTrue((boolean)u.isDisposed());
            u = null;
        }
        ourPathToKeep = null;
    }

    static {
        PlatformTestUtil.registerProjectCleanup(LightPlatformTestCase::closeAndDeleteProject);
    }

    private static /* synthetic */ void b(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/LightPlatformTestCase";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localInspectionTools";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tools";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tool";
                break;
            }
            case 12: 
            case 14: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 13: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "application";
                break;
            }
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "initApplication";
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/LightPlatformTestCase";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getProjectDescriptor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "configureLocalInspectionTools";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModuleType";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createLightFile";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getTestName";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "getCurrentCodeStyleSettings";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "resetClassFields";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "initProject";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "doSetup";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "enableInspectionTools";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "enableInspectionTool";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doTearDown";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "clearUncommittedDocuments";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createLightFile";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "commitDocument";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "getDocument";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doTearDown$28";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doTearDown$27";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doTearDown$26";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doTearDown$25";
                break;
            }
            case 30: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doTearDown$23";
                break;
            }
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doTearDown$20";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doTearDown$18";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doTearDown$17";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doTearDown$14";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doTearDown$13";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doTearDown$12";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "lambda$doTearDown$11";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 23: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class SimpleLightProjectDescriptor
    extends LightProjectDescriptor {
        @NotNull
        private final ModuleType a;
        @Nullable
        private final Sdk b;

        SimpleLightProjectDescriptor(@NotNull ModuleType moduleType, @Nullable Sdk sdk) {
            if (moduleType == null) {
                SimpleLightProjectDescriptor.b(0);
            }
            this.a = moduleType;
            this.b = sdk;
        }

        @Override
        @NotNull
        public ModuleType getModuleType() {
            ModuleType moduleType = this.a;
            if (moduleType == null) {
                SimpleLightProjectDescriptor.b(1);
            }
            return moduleType;
        }

        @Override
        @Nullable
        public Sdk getSdk() {
            return this.b;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            SimpleLightProjectDescriptor simpleLightProjectDescriptor = (SimpleLightProjectDescriptor)object;
            if (!this.a.equals((Object)simpleLightProjectDescriptor.a)) {
                return false;
            }
            return this.a(simpleLightProjectDescriptor.getSdk());
        }

        public int hashCode() {
            return this.a.hashCode();
        }

        private boolean a(Sdk sdk) {
            if (this.b == null || sdk == null) {
                return this.b == sdk;
            }
            Object[] objectArray = this.b.getRootProvider().getUrls(OrderRootType.CLASSES);
            Object[] objectArray2 = sdk.getRootProvider().getUrls(OrderRootType.CLASSES);
            return ContainerUtil.newHashSet((Object[])objectArray).equals(ContainerUtil.newHashSet((Object[])objectArray2));
        }

        private static /* synthetic */ void b(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "moduleType";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/testFramework/LightPlatformTestCase$SimpleLightProjectDescriptor";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/testFramework/LightPlatformTestCase$SimpleLightProjectDescriptor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getModuleType";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

