/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.RunResult;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.ModifiableModuleModel;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.roots.AnnotationOrderRootType;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.JavaModuleExternalPaths;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.impl.ContentEntryImpl;
import com.intellij.openapi.roots.impl.libraries.ProjectLibraryTable;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryTable;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.DebugUtil;
import com.intellij.psi.stubs.StubTextInconsistencyException;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.testFramework.PlatformTestCase;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.util.Function;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.JpsElement;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.junit.Assert;

public class PsiTestUtil {
    public static VirtualFile createTestProjectStructure(Project project2, Module module2, String string, Collection<File> collection) throws Exception {
        return PsiTestUtil.createTestProjectStructure(project2, module2, string, collection, true);
    }

    public static VirtualFile createTestProjectStructure(Project project2, Module module2, Collection<File> collection) throws IOException {
        return PsiTestUtil.createTestProjectStructure(project2, module2, null, collection, true);
    }

    public static VirtualFile createTestProjectStructure(Project project2, Module module2, String string, Collection<File> collection, boolean bl2) throws IOException {
        VirtualFile virtualFile = PsiTestUtil.createTestProjectStructure(module2, string, collection, bl2);
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        return virtualFile;
    }

    public static VirtualFile createTestProjectStructure(Module module2, String string, Collection<File> collection, boolean bl2) throws IOException {
        return PsiTestUtil.createTestProjectStructure("unitTest", module2, string, collection, bl2);
    }

    public static VirtualFile createTestProjectStructure(String string, Module module2, String string2, Collection<File> collection, boolean bl2) throws IOException {
        File file = FileUtil.createTempDirectory((String)string, null, (boolean)false);
        collection.add(file);
        VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(file.getCanonicalPath().replace(File.separatorChar, '/'));
        assert (virtualFile != null && virtualFile.isDirectory()) : file;
        PlatformTestCase.synchronizeTempDirVfs(virtualFile);
        EdtTestUtil.runInEdtAndWait((ThrowableRunnable<Throwable>)((ThrowableRunnable)() -> WriteAction.run(() -> {
            if (string2 != null) {
                VirtualFile virtualFile2 = LocalFileSystem.getInstance().findFileByPath(string2.replace(File.separatorChar, '/'));
                if (virtualFile2 == null) {
                    throw new Exception(string2 + " not found");
                }
                VfsUtil.copyDirectory(null, (VirtualFile)virtualFile2, (VirtualFile)virtualFile, null);
            }
            if (bl2) {
                PsiTestUtil.addSourceContentToRoots(module2, virtualFile);
            }
        })));
        return virtualFile;
    }

    public static void removeAllRoots(@NotNull Module module2, Sdk sdk) {
        if (module2 == null) {
            PsiTestUtil.a(0);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, modifiableRootModel -> {
            modifiableRootModel.clear();
            modifiableRootModel.setSdk(sdk);
        });
    }

    public static void addSourceContentToRoots(Module module2, @NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            PsiTestUtil.a(1);
        }
        PsiTestUtil.addSourceContentToRoots(module2, virtualFile, false);
    }

    public static void addSourceContentToRoots(Module module2, @NotNull VirtualFile virtualFile, boolean bl2) {
        if (virtualFile == null) {
            PsiTestUtil.a(2);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, modifiableRootModel -> {
            if (virtualFile == null) {
                PsiTestUtil.a(24);
            }
            modifiableRootModel.addContentEntry(virtualFile).addSourceFolder(virtualFile, bl2);
        });
    }

    public static void addSourceRoot(Module module2, VirtualFile virtualFile) {
        PsiTestUtil.addSourceRoot(module2, virtualFile, false);
    }

    public static void addSourceRoot(Module module2, VirtualFile virtualFile, boolean bl2) {
        PsiTestUtil.addSourceRoot(module2, virtualFile, bl2 ? JavaSourceRootType.TEST_SOURCE : JavaSourceRootType.SOURCE);
    }

    public static <P extends JpsElement> void addSourceRoot(Module module2, VirtualFile virtualFile, @NotNull JpsModuleSourceRootType<P> jpsModuleSourceRootType) {
        if (jpsModuleSourceRootType == null) {
            PsiTestUtil.a(3);
        }
        PsiTestUtil.addSourceRoot(module2, virtualFile, jpsModuleSourceRootType, (JpsElement)jpsModuleSourceRootType.createDefaultProperties());
    }

    public static <P extends JpsElement> void addSourceRoot(Module module2, VirtualFile virtualFile, @NotNull JpsModuleSourceRootType<P> jpsModuleSourceRootType, P p2) {
        if (jpsModuleSourceRootType == null) {
            PsiTestUtil.a(4);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, modifiableRootModel -> {
            ContentEntry contentEntry;
            if (jpsModuleSourceRootType == null) {
                PsiTestUtil.a(23);
            }
            if ((contentEntry = PsiTestUtil.a((ModuleRootModel)modifiableRootModel, virtualFile)) == null) {
                contentEntry = modifiableRootModel.addContentEntry(virtualFile);
            }
            contentEntry.addSourceFolder(virtualFile, jpsModuleSourceRootType, p2);
        });
    }

    @Nullable
    private static ContentEntry a(ModuleRootModel moduleRootModel, VirtualFile virtualFile) {
        return (ContentEntry)ContainerUtil.find((Object[])moduleRootModel.getContentEntries(), contentEntry -> {
            VirtualFile virtualFile2 = contentEntry.getFile();
            return virtualFile2 != null && VfsUtilCore.isAncestor((VirtualFile)virtualFile2, (VirtualFile)virtualFile, (boolean)false);
        });
    }

    public static ContentEntry addContentRoot(Module module2, VirtualFile virtualFile) {
        ModuleRootModificationUtil.updateModel((Module)module2, modifiableRootModel -> modifiableRootModel.addContentEntry(virtualFile));
        for (ContentEntry contentEntry : ModuleRootManager.getInstance((Module)module2).getContentEntries()) {
            if (!Comparing.equal((Object)contentEntry.getFile(), (Object)virtualFile)) continue;
            Assert.assertFalse((boolean)((ContentEntryImpl)contentEntry).isDisposed());
            return contentEntry;
        }
        return null;
    }

    public static void addExcludedRoot(Module module2, VirtualFile virtualFile) {
        ModuleRootModificationUtil.updateModel((Module)module2, modifiableRootModel -> ApplicationManager.getApplication().runReadAction(() -> PsiTestUtil.a(modifiableRootModel, virtualFile).addExcludeFolder(virtualFile)));
    }

    @NotNull
    private static ContentEntry a(ModifiableRootModel modifiableRootModel, VirtualFile virtualFile) {
        ContentEntry contentEntry = PsiTestUtil.a((ModuleRootModel)modifiableRootModel, virtualFile);
        if (contentEntry == null) {
            throw new RuntimeException(virtualFile + " is not under content roots: " + Arrays.toString(modifiableRootModel.getContentRoots()));
        }
        ContentEntry contentEntry2 = contentEntry;
        if (contentEntry2 == null) {
            PsiTestUtil.a(5);
        }
        return contentEntry2;
    }

    public static void removeContentEntry(Module module2, VirtualFile virtualFile) {
        ModuleRootModificationUtil.updateModel((Module)module2, modifiableRootModel -> modifiableRootModel.removeContentEntry(PsiTestUtil.a(modifiableRootModel, virtualFile)));
    }

    public static void removeSourceRoot(@NotNull Module module2, @NotNull VirtualFile virtualFile) {
        if (module2 == null) {
            PsiTestUtil.a(6);
        }
        if (virtualFile == null) {
            PsiTestUtil.a(7);
        }
        ModuleRootModificationUtil.updateModel((Module)module2, modifiableRootModel -> {
            if (virtualFile == null) {
                PsiTestUtil.a(22);
            }
            ContentEntry contentEntry = PsiTestUtil.a(modifiableRootModel, virtualFile);
            for (SourceFolder sourceFolder : contentEntry.getSourceFolders()) {
                if (!virtualFile.equals(sourceFolder.getFile())) continue;
                contentEntry.removeSourceFolder(sourceFolder);
                break;
            }
        });
    }

    public static void removeExcludedRoot(Module module2, VirtualFile virtualFile) {
        ModuleRootModificationUtil.updateModel((Module)module2, modifiableRootModel -> {
            ContentEntry contentEntry = PsiTestUtil.a(modifiableRootModel, virtualFile);
            contentEntry.removeExcludeFolder(virtualFile.getUrl());
        });
    }

    public static void checkFileStructure(PsiFile psiFile2) {
        PsiTestUtil.a(psiFile2, (Function<PsiFile, String>)((Function)psiFile -> DebugUtil.psiTreeToString((PsiElement)psiFile, (boolean)false)));
    }

    private static void a(PsiFile psiFile, Function<PsiFile, String> function) {
        String string;
        PsiFile psiFile2 = PsiTestUtil.b(psiFile);
        String string2 = StringUtil.join((Collection)psiFile.getViewProvider().getAllFiles(), function, (String)"\n");
        if (!string2.equals(string = StringUtil.join((Collection)psiFile2.getViewProvider().getAllFiles(), function, (String)"\n"))) {
            Assert.assertEquals((Object)("Re-created from text:\n" + string), (Object)("PSI structure:\n" + string2));
        }
    }

    @NotNull
    private static PsiFile b(PsiFile psiFile) {
        LightVirtualFile lightVirtualFile = new LightVirtualFile(psiFile.getName(), (CharSequence)psiFile.getText());
        lightVirtualFile.setOriginalFile(psiFile.getViewProvider().getVirtualFile());
        PsiFile psiFile2 = Objects.requireNonNull(psiFile.getManager().findFile((VirtualFile)lightVirtualFile));
        if (psiFile2 == null) {
            PsiTestUtil.a(8);
        }
        return psiFile2;
    }

    public static void checkPsiMatchesTextIgnoringNonCode(PsiFile psiFile2) {
        PsiTestUtil.a(psiFile2, (Function<PsiFile, String>)((Function)psiFile -> DebugUtil.psiToStringIgnoringNonCode((PsiElement)psiFile)));
    }

    public static void addLibrary(Module module2, String string) {
        File file = new File(string);
        String string2 = file.getName();
        PsiTestUtil.addLibrary(module2, string2, file.getParent(), string2);
    }

    public static void addLibrary(Module module2, String string, String string2, String ... stringArray) {
        ModuleRootModificationUtil.updateModel((Module)module2, modifiableRootModel -> PsiTestUtil.addLibrary(module2, modifiableRootModel, string, string2, stringArray));
    }

    public static void addLibrary(@NotNull Disposable disposable, Module module2, String string, String string2, String ... stringArray) {
        if (disposable == null) {
            PsiTestUtil.a(9);
        }
        Ref ref = new Ref();
        ModuleRootModificationUtil.updateModel((Module)module2, modifiableRootModel -> ref.set((Object)PsiTestUtil.addLibrary(module2, modifiableRootModel, string, string2, stringArray)));
        Disposer.register((Disposable)disposable, () -> {
            Library library = (Library)ref.get();
            ModuleRootModificationUtil.updateModel((Module)module2, modifiableRootModel -> modifiableRootModel.removeOrderEntry((OrderEntry)modifiableRootModel.findLibraryOrderEntry(library)));
            WriteCommandAction.runWriteCommandAction(null, () -> {
                LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)module2.getProject());
                LibraryTable.ModifiableModel modifiableModel = libraryTable.getModifiableModel();
                modifiableModel.removeLibrary(library);
                modifiableModel.commit();
            });
        });
    }

    public static void addProjectLibrary(Module module2, String string, List<String> list2) {
        List<VirtualFile> list3 = PsiTestUtil.a(list2);
        PsiTestUtil.addProjectLibrary(module2, string, list3, Collections.emptyList());
    }

    @NotNull
    private static List<VirtualFile> a(List<String> list2) {
        List list3 = ContainerUtil.map(list2, string -> VirtualFileManager.getInstance().refreshAndFindFileByUrl(VfsUtil.getUrlForLibraryRoot((File)new File((String)string))));
        if (list3 == null) {
            PsiTestUtil.a(10);
        }
        return list3;
    }

    public static void addProjectLibrary(ModifiableRootModel modifiableRootModel, String string, List<String> list2) {
        List<VirtualFile> list3 = PsiTestUtil.a(list2);
        PsiTestUtil.a(modifiableRootModel, string, list3, Collections.emptyList());
    }

    public static void addProjectLibrary(Module module2, String string, VirtualFile ... virtualFileArray) {
        PsiTestUtil.addProjectLibrary(module2, string, Arrays.asList(virtualFileArray), Collections.emptyList());
    }

    public static Library addProjectLibrary(Module module2, String string, List<VirtualFile> list2, List<VirtualFile> list3) {
        Ref ref = Ref.create();
        ModuleRootModificationUtil.updateModel((Module)module2, modifiableRootModel -> ref.set((Object)PsiTestUtil.a(modifiableRootModel, string, list2, list3)));
        return (Library)ref.get();
    }

    @NotNull
    private static Library a(final ModifiableRootModel modifiableRootModel, final String string, final List<VirtualFile> list2, final List<VirtualFile> list3) {
        final LibraryTable libraryTable = ProjectLibraryTable.getInstance((Project)modifiableRootModel.getProject());
        RunResult runResult = new WriteAction<Library>(){

            protected void run(@NotNull Result<Library> result2) {
                VirtualFile virtualFile2;
                if (result2 == null) {
                    1.a(0);
                }
                Library library = libraryTable.createLibrary(string);
                Library.ModifiableModel modifiableModel = library.getModifiableModel();
                try {
                    for (VirtualFile virtualFile2 : list2) {
                        modifiableModel.addRoot(virtualFile2, OrderRootType.CLASSES);
                    }
                    for (VirtualFile virtualFile2 : list3) {
                        modifiableModel.addRoot(virtualFile2, OrderRootType.SOURCES);
                    }
                    modifiableModel.commit();
                }
                catch (Throwable throwable) {
                    modifiableModel.dispose();
                    throw throwable;
                }
                modifiableRootModel.addLibraryEntry(library);
                OrderEntry[] orderEntryArray = modifiableRootModel.getOrderEntries();
                virtualFile2 = orderEntryArray[orderEntryArray.length - 1];
                System.arraycopy(orderEntryArray, 0, orderEntryArray, 1, orderEntryArray.length - 1);
                orderEntryArray[0] = virtualFile2;
                modifiableRootModel.rearrangeOrderEntries(orderEntryArray);
                result2.setResult((Object)library);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PsiTestUtil$1", "run"));
            }
        }.execute();
        runResult.throwException();
        Library library = (Library)runResult.getResultObject();
        if (library == null) {
            PsiTestUtil.a(11);
        }
        return library;
    }

    @NotNull
    public static Library addLibrary(Module module2, ModifiableRootModel modifiableRootModel, String string, String string2, String ... stringArray) {
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (String string3 : stringArray) {
            String string4;
            if (!string2.endsWith("/") && !string3.startsWith("/")) {
                string3 = "/" + string3;
            }
            VirtualFile virtualFile = (string4 = string2 + string3).endsWith(".jar") ? JarFileSystem.getInstance().refreshAndFindFileByPath(string4 + "!/") : LocalFileSystem.getInstance().refreshAndFindFileByPath(string4);
            assert (virtualFile != null) : "Library root folder not found: " + string4 + "!/";
            arrayList.add(virtualFile);
        }
        Library library = PsiTestUtil.a(modifiableRootModel, string, arrayList, Collections.emptyList());
        if (library == null) {
            PsiTestUtil.a(12);
        }
        return library;
    }

    public static void addLibrary(Module module2, String string, String string2, String[] stringArray, String[] stringArray2) {
        String string3 = (stringArray.length > 0 ? stringArray[0] : stringArray2[0]).endsWith(".jar!/") ? "jar" : "file";
        String string4 = VirtualFileManager.constructUrl((String)string3, (String)string2);
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (String string5 : stringArray) {
            arrayList.add(string4 + string5);
        }
        for (String string5 : stringArray2) {
            arrayList2.add(string4 + string5);
        }
        ModuleRootModificationUtil.addModuleLibrary((Module)module2, (String)string, arrayList, arrayList2);
    }

    public static Module addModule(final Project project2, final ModuleType moduleType, final String string, final VirtualFile virtualFile) {
        return (Module)new WriteCommandAction<Module>(project2, new PsiFile[0]){

            protected void run(@NotNull Result<Module> result2) {
                String string2;
                if (result2 == null) {
                    2.a(0);
                }
                ModifiableModuleModel modifiableModuleModel = ModuleManager.getInstance((Project)project2).getModifiableModel();
                try {
                    string2 = modifiableModuleModel.newModule(virtualFile.getPath() + "/" + string + ".iml", moduleType.getId()).getName();
                    modifiableModuleModel.commit();
                }
                catch (Throwable throwable) {
                    modifiableModuleModel.dispose();
                    throw throwable;
                }
                Module module2 = ModuleManager.getInstance((Project)project2).findModuleByName(string2);
                assert (module2 != null) : string2;
                ModifiableRootModel modifiableRootModel = ModuleRootManager.getInstance((Module)module2).getModifiableModel();
                try {
                    modifiableRootModel.addContentEntry(virtualFile).addSourceFolder(virtualFile, false);
                    modifiableRootModel.commit();
                }
                catch (Throwable throwable) {
                    modifiableRootModel.dispose();
                    throw throwable;
                }
                result2.setResult((Object)module2);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/PsiTestUtil$2", "run"));
            }
        }.execute().getResultObject();
    }

    public static void setCompilerOutputPath(Module module2, String string, boolean bl2) {
        ModuleRootModificationUtil.updateModel((Module)module2, modifiableRootModel -> {
            CompilerModuleExtension compilerModuleExtension = (CompilerModuleExtension)modifiableRootModel.getModuleExtension(CompilerModuleExtension.class);
            compilerModuleExtension.inheritCompilerOutputPath(false);
            if (bl2) {
                compilerModuleExtension.setCompilerOutputPathForTests(string);
            } else {
                compilerModuleExtension.setCompilerOutputPath(string);
            }
        });
    }

    public static void setExcludeCompileOutput(Module module2, boolean bl2) {
        ModuleRootModificationUtil.updateModel((Module)module2, modifiableRootModel -> ((CompilerModuleExtension)modifiableRootModel.getModuleExtension(CompilerModuleExtension.class)).setExcludeOutput(bl2));
    }

    public static void setJavadocUrls(Module module2, String ... stringArray) {
        ModuleRootModificationUtil.updateModel((Module)module2, modifiableRootModel -> ((JavaModuleExternalPaths)modifiableRootModel.getModuleExtension(JavaModuleExternalPaths.class)).setJavadocUrls(stringArray));
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk addJdkAnnotations(@NotNull Sdk sdk) {
        if (sdk == null) {
            PsiTestUtil.a(13);
        }
        String string = FileUtil.toSystemIndependentName((String)PlatformTestUtil.getCommunityPath()) + "/java/jdkAnnotations";
        VirtualFile virtualFile = LocalFileSystem.getInstance().findFileByPath(string);
        Sdk sdk2 = PsiTestUtil.addRootsToJdk(sdk, AnnotationOrderRootType.getInstance(), virtualFile);
        if (sdk2 == null) {
            PsiTestUtil.a(14);
        }
        return sdk2;
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk addRootsToJdk(@NotNull Sdk sdk, @NotNull OrderRootType orderRootType, VirtualFile ... virtualFileArray) {
        Sdk sdk2;
        if (sdk == null) {
            PsiTestUtil.a(15);
        }
        if (orderRootType == null) {
            PsiTestUtil.a(16);
        }
        if (virtualFileArray == null) {
            PsiTestUtil.a(17);
        }
        try {
            sdk2 = (Sdk)sdk.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
        SdkModificator sdkModificator = sdk2.getSdkModificator();
        for (VirtualFile virtualFile : virtualFileArray) {
            sdkModificator.addRoot(virtualFile, orderRootType);
        }
        sdkModificator.commitChanges();
        Sdk sdk3 = sdk2;
        if (sdk3 == null) {
            PsiTestUtil.a(18);
        }
        return sdk3;
    }

    public static void checkStubsMatchText(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            PsiTestUtil.a(19);
        }
        try {
            StubTextInconsistencyException.checkStubTextConsistency((PsiFile)psiFile);
        }
        catch (StubTextInconsistencyException stubTextInconsistencyException) {
            PsiTestUtil.compareStubTexts(stubTextInconsistencyException);
        }
    }

    public static void compareStubTexts(@NotNull StubTextInconsistencyException stubTextInconsistencyException) {
        if (stubTextInconsistencyException == null) {
            PsiTestUtil.a(20);
        }
        Assert.assertEquals((Object)("Re-created from text:\n" + stubTextInconsistencyException.getStubsFromText()), (Object)("Stubs from PSI structure:\n" + stubTextInconsistencyException.getStubsFromPsi()));
        throw stubTextInconsistencyException;
    }

    public static void checkPsiStructureWithCommit(@NotNull PsiFile psiFile, Consumer<PsiFile> consumer) {
        if (psiFile == null) {
            PsiTestUtil.a(21);
        }
        consumer.accept(psiFile);
        Document document = psiFile.getViewProvider().getDocument();
        Project project2 = psiFile.getProject();
        if (document != null && PsiDocumentManager.getInstance((Project)project2).isUncommited(document)) {
            PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
            consumer.accept(psiFile);
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: 
            case 2: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vDir";
                break;
            }
            case 3: 
            case 4: 
            case 16: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootType";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/PsiTestUtil";
                break;
            }
            case 7: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "root";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sdk";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "roots";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/PsiTestUtil";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "findContentEntryWithAssertion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createDummyCopy";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryRoots";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "addProjectLibrary";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "addLibrary";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addJdkAnnotations";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "addRootsToJdk";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "removeAllRoots";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addSourceContentToRoots";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "addSourceRoot";
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeSourceRoot";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addLibrary";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addJdkAnnotations";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "addRootsToJdk";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "checkStubsMatchText";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "compareStubTexts";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "checkPsiStructureWithCommit";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "lambda$removeSourceRoot$10";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addSourceRoot$4";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "lambda$addSourceContentToRoots$3";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 14: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

