/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=2, d1={"\u0000\u0016\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a\u0010\u0010\u0000\u001a\u00020\u00012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u001a\u001a\u0010\u0004\u001a\u00020\u0005*\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u0003\u00a8\u0006\b"}, d2={"generateTemporaryPath", "Ljava/nio/file/Path;", "fileName", "", "writeChild", "Lcom/intellij/openapi/vfs/VirtualFile;", "relativePath", "data", "intellij.platform.testFramework"})
public final class TemporaryDirectoryKt {
    @NotNull
    public static final Path generateTemporaryPath(@Nullable String string) {
        Path path = Paths.get(FileUtilRt.getTempDirectory(), new String[0]);
        Path path2 = path.resolve(string);
        int n2 = 0;
        while (true) {
            Path path3 = path2;
            Intrinsics.checkExpressionValueIsNotNull((Object)path3, (String)"path");
            if (!PathKt.exists((Path)path3) || n2 >= 9) break;
            path2 = path.resolve("" + string + '_' + n2);
            ++n2;
        }
        if (PathKt.exists((Path)path2)) {
            throw (Throwable)new IOException("Cannot generate unique random path");
        }
        return path2;
    }

    @NotNull
    public static final VirtualFile writeChild(@NotNull VirtualFile virtualFile, @NotNull String string, @NotNull String string2) {
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"$receiver");
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"relativePath");
        Intrinsics.checkParameterIsNotNull((Object)string2, (String)"data");
        return VfsTestUtil.createFile(virtualFile, string, string2);
    }
}

