/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.LineTokenizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.testFramework.TestLogger;
import com.intellij.testFramework.UsefulTestCase;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Category;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.Priority;
import org.apache.log4j.WriterAppender;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.xml.DOMConfigurator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TestLoggerFactory
implements Logger.Factory {
    private static final String j = "$SYSTEM_DIR$";
    private static final String f = "$APPLICATION_DIR$";
    private static final String g = "$LOG_DIR$";
    private static final String c = "testlog";
    private static final long i = 0x6400000L;
    private static final long l = 102400L;
    private boolean a;
    private static final StringWriter e = new StringWriter();
    private static final StringBuffer d = e.getBuffer();
    static final char FAILED_TEST_DEBUG_OUTPUT_MARKER = '\u2003';
    private static final WriterAppender k = new WriterAppender((Layout)new PatternLayout("%d{HH:mm:ss,SSS} %p %.30c - %m%n"), (Writer)e);
    private static final int h = 10000000;
    private static final String b = Category.class.getName();

    private TestLoggerFactory() {
    }

    @NotNull
    public synchronized com.intellij.openapi.diagnostic.Logger getLoggerInstance(@NotNull String string) {
        if (string == null) {
            TestLoggerFactory.a(0);
        }
        if (!this.a) {
            this.a();
        }
        TestLogger testLogger = new TestLogger(Logger.getLogger((String)string));
        if (testLogger == null) {
            TestLoggerFactory.a(1);
        }
        return testLogger;
    }

    private void a() {
        if (!TestLoggerFactory.reconfigure()) {
            return;
        }
        this.a = true;
    }

    public static boolean reconfigure() {
        try {
            Object object;
            File file = new File(PathManager.getHomePath(), "test-log.xml");
            if (!file.exists()) {
                file = new File(PathManager.getBinPath(), "log.xml");
            }
            if (!file.exists()) {
                return false;
            }
            String string = TestLoggerFactory.getTestLogDir();
            String string2 = FileUtil.loadFile((File)file);
            string2 = StringUtil.replace((String)string2, (String)j, (String)StringUtil.replace((String)PathManager.getSystemPath(), (String)"\\", (String)"\\\\"));
            string2 = StringUtil.replace((String)string2, (String)f, (String)StringUtil.replace((String)PathManager.getHomePath(), (String)"\\", (String)"\\\\"));
            string2 = StringUtil.replace((String)string2, (String)g, (String)StringUtil.replace((String)string, (String)"\\", (String)"\\\\"));
            File file2 = new File(string);
            if (!file2.mkdirs() && !file2.exists()) {
                throw new IOException("Unable to create log dir: " + file2);
            }
            System.setProperty("log4j.defaultInitOverride", "true");
            try {
                object = new DOMConfigurator();
                object.doConfigure((Reader)new StringReader(string2), LogManager.getLoggerRepository());
            }
            catch (ClassCastException classCastException) {
                System.err.println("log.xml content:\n" + string2);
                throw classCastException;
            }
            object = new File(TestLoggerFactory.getTestLogDir(), "idea.log");
            if (((File)object).exists() && ((File)object).length() >= 0x6400000L) {
                FileUtil.writeToFile((File)object, (String)"");
            }
            return true;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return false;
        }
    }

    public static String getTestLogDir() {
        if (System.getProperty("idea.log.path") != null) {
            return System.getProperty("idea.log.path");
        }
        return PathManager.getSystemPath() + "/" + c;
    }

    public static void dumpLogToStdout(@NotNull String string) {
        File file;
        if (string == null) {
            TestLoggerFactory.a(2);
        }
        if ((file = new File(TestLoggerFactory.getTestLogDir(), "idea.log")).exists()) {
            try {
                String string2;
                Object object;
                long l2 = file.length();
                if (l2 > 102400L) {
                    object = new RandomAccessFile(file, "r");
                    String[] stringArray = null;
                    try {
                        ((RandomAccessFile)object).seek(l2 - 102400L);
                        byte[] byArray = new byte[102400];
                        int n2 = ((RandomAccessFile)object).read(byArray);
                        string2 = new String(byArray, 0, n2);
                    }
                    catch (Throwable object2) {
                        stringArray = object2;
                        throw object2;
                    }
                    finally {
                        if (object != null) {
                            if (stringArray != null) {
                                try {
                                    ((RandomAccessFile)object).close();
                                }
                                catch (Throwable throwable) {
                                    stringArray.addSuppressed(throwable);
                                }
                            } else {
                                ((RandomAccessFile)object).close();
                            }
                        }
                    }
                } else {
                    string2 = FileUtil.loadFile((File)file);
                }
                System.out.println("\n\nIdea Log:");
                object = Pattern.compile("[0-9\\-, :\\[\\]]+(DEBUG|INFO|ERROR) - ");
                for (String string3 : StringUtil.splitByLines((String)string2.substring(Math.max(0, string2.lastIndexOf(string))))) {
                    Matcher matcher = ((Pattern)object).matcher(string3);
                    int n3 = matcher.lookingAt() ? matcher.end() : 0;
                    System.out.println(string3.substring(n3));
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }
    }

    public static void enableDebugLogging(@NotNull Disposable disposable, String ... stringArray) {
        if (disposable == null) {
            TestLoggerFactory.a(3);
        }
        if (stringArray == null) {
            TestLoggerFactory.a(4);
        }
        for (String string : stringArray) {
            com.intellij.openapi.diagnostic.Logger logger = com.intellij.openapi.diagnostic.Logger.getInstance((String)string);
            logger.setLevel(Level.DEBUG);
            Disposer.register((Disposable)disposable, () -> logger.setLevel(Level.INFO));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void log(@NotNull Logger logger, @NotNull Level level, @Nullable String string, @Nullable Throwable throwable) {
        if (logger == null) {
            TestLoggerFactory.a(5);
        }
        if (level == null) {
            TestLoggerFactory.a(6);
        }
        if (!UsefulTestCase.IS_UNDER_TEAMCITY) {
            // empty if block
        }
        LoggingEvent loggingEvent = new LoggingEvent(b, (Category)logger, (Priority)level, (Object)string, throwable);
        k.doAppend(loggingEvent);
        if (d.length() > 10000000) {
            StringBuffer stringBuffer = d;
            synchronized (stringBuffer) {
                if (d.length() > 10000000) {
                    d.delete(0, d.length() - 10000000 + 2500000);
                }
            }
        }
    }

    public static void onTestFinished(boolean bl2) {
        if (!bl2 && d.length() != 0) {
            if (UsefulTestCase.IS_UNDER_TEAMCITY) {
                System.out.flush();
                System.out.println("##teamcity[blockOpened name='DEBUG log']\n");
                System.out.flush();
                System.out.println(d);
                System.out.flush();
                System.out.println("\n##teamcity[blockClosed name='DEBUG log']\n");
                System.out.flush();
            } else {
                String[] stringArray = LineTokenizer.tokenize((CharSequence)d, (boolean)false, (boolean)false);
                String string = StringUtil.join((String[])stringArray, (String)"\u2003\n");
                if (!string.startsWith("\n")) {
                    string = "\n" + string;
                }
                System.err.println(string);
            }
        }
        d.setLength(0);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/TestLoggerFactory";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "testStartMarker";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "categories";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logger";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "level";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/TestLoggerFactory";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoggerInstance";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getLoggerInstance";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "dumpLogToStdout";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "enableDebugLogging";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "log";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

