/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.codeInsight.editorActions.SelectWordHandler;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessor;
import com.intellij.codeInsight.editorActions.smartEnter.SmartEnterProcessors;
import com.intellij.codeInsight.generation.surroundWith.SurroundWithHandler;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.codeInsight.lookup.impl.LookupImpl;
import com.intellij.codeInsight.navigation.GotoImplementationHandler;
import com.intellij.codeInsight.navigation.GotoTargetHandler;
import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInsight.template.impl.TemplateManagerImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.codeInsight.template.impl.TemplateState;
import com.intellij.codeInsight.template.impl.actions.ListTemplatesAction;
import com.intellij.ide.DataManager;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenameHandler;
import com.intellij.testFramework.fixtures.CodeInsightTestFixture;
import com.intellij.ui.CollectionListModel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.ComponentPopupBuilderImpl;
import com.intellij.ui.speedSearch.NameFilteringListModel;
import com.intellij.util.Function;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

public class CodeInsightTestUtil {
    private CodeInsightTestUtil() {
    }

    @Nullable
    public static IntentionAction findIntentionByText(@NotNull List<IntentionAction> list2, @NonNls @NotNull String string) {
        if (list2 == null) {
            CodeInsightTestUtil.a(0);
        }
        if (string == null) {
            CodeInsightTestUtil.a(1);
        }
        for (IntentionAction intentionAction : list2) {
            String string2 = intentionAction.getText();
            if (!string2.equals(string)) continue;
            return intentionAction;
        }
        return null;
    }

    public static void doIntentionTest(CodeInsightTestFixture codeInsightTestFixture, @NonNls String string, @NonNls String string2) {
        String string3 = FileUtilRt.getExtension((String)string);
        string = FileUtil.getNameWithoutExtension((String)string);
        if (string3.isEmpty()) {
            string3 = "xml";
        }
        CodeInsightTestUtil.doIntentionTest(codeInsightTestFixture, string2, string + "." + string3, string + "_after." + string3);
    }

    public static void doIntentionTest(@NotNull CodeInsightTestFixture codeInsightTestFixture, @NonNls String string, @NotNull String string2, @NotNull String string3) {
        if (codeInsightTestFixture == null) {
            CodeInsightTestUtil.a(2);
        }
        if (string2 == null) {
            CodeInsightTestUtil.a(3);
        }
        if (string3 == null) {
            CodeInsightTestUtil.a(4);
        }
        codeInsightTestFixture.configureByFile(string2);
        List<IntentionAction> list2 = codeInsightTestFixture.getAvailableIntentions();
        IntentionAction intentionAction = CodeInsightTestUtil.findIntentionByText(list2, string);
        if (intentionAction == null) {
            Assert.fail((String)("Action not found: " + string + " in place: " + codeInsightTestFixture.getElementAtCaret() + " among " + list2));
        }
        codeInsightTestFixture.launchAction(intentionAction);
        codeInsightTestFixture.checkResultByFile(string3, false);
    }

    public static void doWordSelectionTest(@NotNull CodeInsightTestFixture codeInsightTestFixture, @NotNull String string, String ... stringArray) {
        if (codeInsightTestFixture == null) {
            CodeInsightTestUtil.a(5);
        }
        if (string == null) {
            CodeInsightTestUtil.a(6);
        }
        assert (stringArray != null && stringArray.length > 0);
        codeInsightTestFixture.configureByFile(string);
        SelectWordHandler selectWordHandler = new SelectWordHandler(null);
        DataContext dataContext = DataManager.getInstance().getDataContext((Component)codeInsightTestFixture.getEditor().getComponent());
        for (String string2 : stringArray) {
            selectWordHandler.execute(codeInsightTestFixture.getEditor(), dataContext);
            codeInsightTestFixture.checkResultByFile(string2, false);
        }
    }

    public static void doWordSelectionTestOnDirectory(@NotNull CodeInsightTestFixture codeInsightTestFixture, @NotNull String string, @NotNull String string2) {
        if (codeInsightTestFixture == null) {
            CodeInsightTestUtil.a(7);
        }
        if (string == null) {
            CodeInsightTestUtil.a(8);
        }
        if (string2 == null) {
            CodeInsightTestUtil.a(9);
        }
        SelectWordHandler selectWordHandler = new SelectWordHandler(null);
        codeInsightTestFixture.copyDirectoryToProject(string, string);
        codeInsightTestFixture.configureByFile(string + "/before." + string2);
        int n2 = 1;
        while (true) {
            String string3 = string + "/after" + n2 + "." + string2;
            if (!new File(codeInsightTestFixture.getTestDataPath() + "/" + string3).exists()) break;
            selectWordHandler.execute(codeInsightTestFixture.getEditor(), DataManager.getInstance().getDataContext((Component)codeInsightTestFixture.getEditor().getComponent()));
            codeInsightTestFixture.checkResultByFile(string3);
            ++n2;
        }
        junit.framework.Assert.assertTrue((String)"At least one 'after'-file required", (n2 > 1 ? 1 : 0) != 0);
    }

    public static void doSurroundWithTest(final @NotNull CodeInsightTestFixture codeInsightTestFixture, final @NotNull Surrounder surrounder, @NotNull String string, @NotNull String string2) {
        if (codeInsightTestFixture == null) {
            CodeInsightTestUtil.a(10);
        }
        if (surrounder == null) {
            CodeInsightTestUtil.a(11);
        }
        if (string == null) {
            CodeInsightTestUtil.a(12);
        }
        if (string2 == null) {
            CodeInsightTestUtil.a(13);
        }
        codeInsightTestFixture.configureByFile(string);
        new WriteCommandAction.Simple(codeInsightTestFixture.getProject(), new PsiFile[0]){

            protected void run() throws Throwable {
                SurroundWithHandler.invoke((Project)codeInsightTestFixture.getProject(), (Editor)codeInsightTestFixture.getEditor(), (PsiFile)codeInsightTestFixture.getFile(), (Surrounder)surrounder);
            }
        }.execute();
        codeInsightTestFixture.checkResultByFile(string2, false);
    }

    public static void doLiveTemplateTest(@NotNull CodeInsightTestFixture codeInsightTestFixture, @NotNull String string, @NotNull String string2) {
        if (codeInsightTestFixture == null) {
            CodeInsightTestUtil.a(14);
        }
        if (string == null) {
            CodeInsightTestUtil.a(15);
        }
        if (string2 == null) {
            CodeInsightTestUtil.a(16);
        }
        codeInsightTestFixture.configureByFile(string);
        new ListTemplatesAction().actionPerformedImpl(codeInsightTestFixture.getProject(), codeInsightTestFixture.getEditor());
        LookupImpl lookupImpl = (LookupImpl)LookupManager.getActiveLookup((Editor)codeInsightTestFixture.getEditor());
        assert (lookupImpl != null);
        lookupImpl.finishLookup('\n');
        codeInsightTestFixture.checkResultByFile(string2, false);
    }

    public static void doSmartEnterTest(final @NotNull CodeInsightTestFixture codeInsightTestFixture, @NotNull String string, @NotNull String string2) {
        if (codeInsightTestFixture == null) {
            CodeInsightTestUtil.a(17);
        }
        if (string == null) {
            CodeInsightTestUtil.a(18);
        }
        if (string2 == null) {
            CodeInsightTestUtil.a(19);
        }
        codeInsightTestFixture.configureByFile(string);
        final List list2 = SmartEnterProcessors.INSTANCE.allForLanguage(codeInsightTestFixture.getFile().getLanguage());
        new WriteCommandAction(codeInsightTestFixture.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    2.a(0);
                }
                Editor editor = codeInsightTestFixture.getEditor();
                for (SmartEnterProcessor smartEnterProcessor : list2) {
                    smartEnterProcessor.process(this.getProject(), editor, codeInsightTestFixture.getFile());
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/CodeInsightTestUtil$2", "run"));
            }
        }.execute();
        codeInsightTestFixture.checkResultByFile(string2, false);
    }

    public static void doFormattingTest(final @NotNull CodeInsightTestFixture codeInsightTestFixture, @NotNull String string, @NotNull String string2) {
        if (codeInsightTestFixture == null) {
            CodeInsightTestUtil.a(20);
        }
        if (string == null) {
            CodeInsightTestUtil.a(21);
        }
        if (string2 == null) {
            CodeInsightTestUtil.a(22);
        }
        codeInsightTestFixture.configureByFile(string);
        new WriteCommandAction(codeInsightTestFixture.getProject(), new PsiFile[0]){

            protected void run(@NotNull Result result2) throws Throwable {
                if (result2 == null) {
                    3.a(0);
                }
                CodeStyleManager.getInstance((Project)codeInsightTestFixture.getProject()).reformat((PsiElement)codeInsightTestFixture.getFile());
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/CodeInsightTestUtil$3", "run"));
            }
        }.execute();
        codeInsightTestFixture.checkResultByFile(string2, false);
    }

    public static void doInlineRename(VariableInplaceRenameHandler variableInplaceRenameHandler, String string, CodeInsightTestFixture codeInsightTestFixture) {
        CodeInsightTestUtil.doInlineRename(variableInplaceRenameHandler, string, codeInsightTestFixture.getEditor(), codeInsightTestFixture.getElementAtCaret());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doInlineRename(VariableInplaceRenameHandler variableInplaceRenameHandler, final String string, @NotNull Editor editor, PsiElement psiElement) {
        if (editor == null) {
            CodeInsightTestUtil.a(23);
        }
        Project project2 = editor.getProject();
        TemplateManagerImpl templateManagerImpl = (TemplateManagerImpl)TemplateManager.getInstance((Project)project2);
        try {
            templateManagerImpl.setTemplateTesting(true);
            variableInplaceRenameHandler.doRename(psiElement, editor, DataManager.getInstance().getDataContext((Component)editor.getComponent()));
            if (editor instanceof EditorWindow) {
                editor = ((EditorWindow)editor).getDelegate();
            }
            TemplateState templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
            assert (templateState != null);
            final TextRange textRange = templateState.getCurrentVariableRange();
            assert (textRange != null);
            final Editor editor2 = editor;
            new WriteCommandAction.Simple(project2, new PsiFile[0]){

                protected void run() throws Throwable {
                    editor2.getDocument().replaceString(textRange.getStartOffset(), textRange.getEndOffset(), (CharSequence)string);
                }
            }.execute().throwException();
            templateState = TemplateManagerImpl.getTemplateState((Editor)editor);
            assert (templateState != null);
            templateState.gotoEnd(false);
        }
        finally {
            templateManagerImpl.setTemplateTesting(false);
        }
    }

    public static void doInlineRenameTest(VariableInplaceRenameHandler variableInplaceRenameHandler, String string, String string2, String string3, CodeInsightTestFixture codeInsightTestFixture) {
        codeInsightTestFixture.configureByFile(string + "." + string2);
        CodeInsightTestUtil.doInlineRename(variableInplaceRenameHandler, string3, codeInsightTestFixture);
        codeInsightTestFixture.checkResultByFile(string + "_after." + string2);
    }

    public static void doActionTest(AnAction anAction, String string, CodeInsightTestFixture codeInsightTestFixture) {
        String string2 = FileUtilRt.getExtension((String)string);
        String string3 = FileUtil.getNameWithoutExtension((String)string);
        codeInsightTestFixture.configureByFile(string);
        codeInsightTestFixture.testAction(anAction);
        codeInsightTestFixture.checkResultByFile(string3 + "_after." + string2);
    }

    public static void addTemplate(final Template template, Disposable disposable) {
        final TemplateSettings templateSettings = TemplateSettings.getInstance();
        templateSettings.addTemplate(template);
        Disposer.register((Disposable)disposable, (Disposable)new Disposable(){

            public void dispose() {
                templateSettings.removeTemplate(template);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static GotoTargetHandler.GotoData gotoImplementation(Editor editor, PsiFile psiFile) {
        GotoTargetHandler.GotoData gotoData = new GotoImplementationHandler().getSourceAndTargetElements(editor, psiFile);
        if (gotoData.listUpdaterTask != null) {
            JBList jBList = new JBList();
            CollectionListModel collectionListModel = new CollectionListModel(new ArrayList());
            jBList.setModel((ListModel)collectionListModel);
            jBList.setModel((ListModel)new NameFilteringListModel((JList)jBList, Function.ID, Condition.FALSE, String::new));
            JBPopup jBPopup = new ComponentPopupBuilderImpl((JComponent)jBList, null).createPopup();
            gotoData.listUpdaterTask.init((AbstractPopup)jBPopup, (Object)jBList, new Ref());
            gotoData.listUpdaterTask.queue();
            try {
                while (!gotoData.listUpdaterTask.isFinished()) {
                    UIUtil.dispatchAllInvocationEvents();
                }
            }
            finally {
                Disposer.dispose((Disposable)jBPopup);
            }
        }
        GotoTargetHandler.GotoData gotoData2 = gotoData;
        if (gotoData2 == null) {
            CodeInsightTestUtil.a(24);
        }
        return gotoData2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 24: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 5: 
            case 7: 
            case 10: 
            case 14: 
            case 17: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fixture";
                break;
            }
            case 3: 
            case 6: 
            case 12: 
            case 15: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "before";
                break;
            }
            case 4: 
            case 13: 
            case 16: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "after";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directoryName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesExtension";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "surrounder";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/CodeInsightTestUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/CodeInsightTestUtil";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "gotoImplementation";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findIntentionByText";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doIntentionTest";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doWordSelectionTest";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "doWordSelectionTestOnDirectory";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "doSurroundWithTest";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "doLiveTemplateTest";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "doSmartEnterTest";
                break;
            }
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "doFormattingTest";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "doInlineRename";
                break;
            }
            case 24: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

