/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures;

import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.util.SystemInfo;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import org.junit.Assert;

public class EditorMouseFixture {
    private final EditorImpl f;
    private int b;
    private int e;
    private int c;
    private int g = 1;
    private int d;
    private Component a;

    public EditorMouseFixture(EditorImpl editorImpl) {
        this.f = editorImpl;
    }

    public EditorMouseFixture pressAtXY(int n2, int n3) {
        return this.a(1, new Point(n2, n3));
    }

    public EditorMouseFixture pressAt(int n2, int n3) {
        return this.a(1, this.a(n2, n3));
    }

    public EditorMouseFixture pressAtLineNumbers(int n2) {
        assert (this.f.getSettings().isLineNumbersShown());
        return this.a((Component)this.f.getGutterComponentEx(), 1, new Point(0, this.f.visibleLineToY(n2)));
    }

    private EditorMouseFixture a(int n2, Point point) {
        EditorComponentImpl editorComponentImpl = this.f.getContentComponent();
        return this.a((Component)editorComponentImpl, n2, point);
    }

    private EditorMouseFixture a(Component component, int n2, Point point) {
        this.a = component;
        this.d = 501;
        this.b = point.x;
        this.e = point.y;
        component.dispatchEvent(new MouseEvent(this.a, 501, System.currentTimeMillis(), this.a(), this.b, this.e, n2, false, this.g));
        return this;
    }

    public EditorMouseFixture release() {
        return this.a(1);
    }

    private EditorMouseFixture a(int n2) {
        int n3 = this.d;
        this.d = 502;
        this.a.dispatchEvent(new MouseEvent(this.a, 502, System.currentTimeMillis(), this.a(), this.b, this.e, n2, false, this.g));
        if (n3 == 501) {
            this.d = 500;
            this.a.dispatchEvent(new MouseEvent(this.a, 500, System.currentTimeMillis(), this.a(), this.b, this.e, n2, false, this.g));
        }
        this.a = null;
        return this;
    }

    public EditorMouseFixture clickAt(int n2, int n3) {
        return this.pressAt(n2, n3).release();
    }

    public EditorMouseFixture doubleClickAt(int n2, int n3) {
        return this.clickAt(n2, n3).a(2, this.a(n2, n3)).a(2);
    }

    public EditorMouseFixture tripleClickAt(int n2, int n3) {
        return this.doubleClickAt(n2, n3).a(3, this.a(n2, n3)).a(3);
    }

    public EditorMouseFixture dragTo(int n2, int n3) {
        Point point = this.a(n2, n3);
        return this.dragToXY(point.x, point.y);
    }

    public EditorMouseFixture dragToLineNumbers(int n2) {
        assert (this.f.getSettings().isLineNumbersShown());
        return this.a((JComponent)this.f.getGutterComponentEx(), 0, this.f.visibleLineToY(n2));
    }

    public EditorMouseFixture dragToXY(int n2, int n3) {
        Assert.assertFalse((String)"Cannot test mouse dragging: editor visible size is not set. Use EditorTestUtil.setEditorVisibleSize(width, height)", (boolean)this.f.getScrollingModel().getVisibleArea().isEmpty());
        EditorComponentImpl editorComponentImpl = this.f.getContentComponent();
        return this.a((JComponent)editorComponentImpl, n2, n3);
    }

    private EditorMouseFixture a(JComponent jComponent, int n2, int n3) {
        this.d = 506;
        this.b = n2;
        this.e = n3;
        jComponent.dispatchEvent(new MouseEvent(jComponent, 506, System.currentTimeMillis(), this.a(), this.b, this.e, 1, false, this.g));
        return this;
    }

    public EditorMouseFixture ctrl() {
        this.c |= SystemInfo.isMac ? 256 : 128;
        return this;
    }

    public EditorMouseFixture alt() {
        this.c |= 0x200;
        return this;
    }

    public EditorMouseFixture shift() {
        this.c |= 0x40;
        return this;
    }

    public EditorMouseFixture noModifiers() {
        this.c = 0;
        return this;
    }

    public EditorMouseFixture middle() {
        this.g = 2;
        return this;
    }

    public EditorMouseFixture right() {
        this.g = 3;
        return this;
    }

    private Point a(int n2, int n3) {
        return this.f.visualPositionToXY(new VisualPosition(n2, n3));
    }

    private int a() {
        if (this.g == 3) {
            return this.c | 4;
        }
        if (this.g == 2) {
            return this.c | 8;
        }
        return this.c;
    }
}

