/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.builders.ModuleFixtureBuilder;
import com.intellij.testFramework.fixtures.IdeaProjectTestFixture;
import com.intellij.testFramework.fixtures.ModuleFixture;
import com.intellij.testFramework.fixtures.TestFixtureBuilder;
import com.intellij.util.NotNullProducer;
import com.intellij.util.PathUtil;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public abstract class ModuleFixtureBuilderImpl<T extends ModuleFixture>
implements ModuleFixtureBuilder<T> {
    private static int b;
    private final NotNullProducer<? extends ModuleType> a;
    protected final List<String> myContentRoots;
    protected final List<String> mySourceRoots;
    protected final TestFixtureBuilder<? extends IdeaProjectTestFixture> myFixtureBuilder;
    private T c;
    protected String myOutputPath;
    protected String myTestOutputPath;

    public ModuleFixtureBuilderImpl(@NotNull ModuleType moduleType, TestFixtureBuilder<? extends IdeaProjectTestFixture> testFixtureBuilder) {
        if (moduleType == null) {
            ModuleFixtureBuilderImpl.a(0);
        }
        this.myContentRoots = new SmartList();
        this.mySourceRoots = new SmartList();
        this.a = () -> {
            if (moduleType == null) {
                ModuleFixtureBuilderImpl.a(2);
            }
            return moduleType;
        };
        this.myFixtureBuilder = testFixtureBuilder;
    }

    public ModuleFixtureBuilderImpl(@NotNull NotNullProducer<? extends ModuleType> notNullProducer, TestFixtureBuilder<? extends IdeaProjectTestFixture> testFixtureBuilder) {
        if (notNullProducer == null) {
            ModuleFixtureBuilderImpl.a(1);
        }
        this.myContentRoots = new SmartList();
        this.mySourceRoots = new SmartList();
        this.a = notNullProducer;
        this.myFixtureBuilder = testFixtureBuilder;
    }

    @Override
    public ModuleFixtureBuilder<T> addContentRoot(String string) {
        this.myContentRoots.add(string);
        return this;
    }

    @Override
    public ModuleFixtureBuilder<T> addSourceRoot(String string) {
        Assert.assertFalse((String)"content root should be added first", (boolean)this.myContentRoots.isEmpty());
        this.mySourceRoots.add(string);
        return this;
    }

    @Override
    public void setOutputPath(String string) {
        this.myOutputPath = string;
    }

    @Override
    public void setTestOutputPath(String string) {
        this.myTestOutputPath = string;
    }

    protected Module createModule() {
        Project project2 = this.myFixtureBuilder.getFixture().getProject();
        Assert.assertNotNull((Object)project2);
        String string = PathUtil.getParentPath((String)project2.getBasePath()) + "/" + ModuleFixtureBuilderImpl.b() + ".iml";
        return ModuleManager.getInstance((Project)project2).newModule(string, ((ModuleType)this.a.produce()).getId());
    }

    private static int b() {
        return b++;
    }

    @Override
    public synchronized T getFixture() {
        if (this.c == null) {
            this.c = this.instantiateFixture();
        }
        return this.c;
    }

    @Override
    public void addSourceContentRoot(String string) {
        this.addContentRoot(string);
        this.addSourceRoot(string);
    }

    protected abstract T instantiateFixture();

    Module buildModule() {
        return (Module)WriteAction.compute(() -> {
            Module module2 = this.createModule();
            this.initModule(module2);
            return module2;
        });
    }

    protected void initModule(Module module2) {
        ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module2);
        ModifiableRootModel modifiableRootModel = moduleRootManager.getModifiableModel();
        try {
            for (String string : this.myContentRoots) {
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(string);
                Assert.assertNotNull((String)("cannot find content root: " + string), (Object)virtualFile);
                ContentEntry contentEntry = modifiableRootModel.addContentEntry(virtualFile);
                for (String string2 : this.mySourceRoots) {
                    VirtualFile virtualFile2;
                    String string3 = string + "/" + string2;
                    VirtualFile virtualFile3 = LocalFileSystem.getInstance().refreshAndFindFileByPath(string3);
                    if (virtualFile3 == null && (virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(string2)) != null && VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)virtualFile2, (boolean)false)) {
                        virtualFile3 = virtualFile2;
                    }
                    if (virtualFile3 != null) {
                        contentEntry.addSourceFolder(virtualFile3, false);
                        continue;
                    }
                    contentEntry.addSourceFolder(VfsUtilCore.pathToUrl((String)string3), false);
                }
            }
            this.setupRootModel(modifiableRootModel);
        }
        catch (Throwable throwable) {
            modifiableRootModel.dispose();
            throw throwable;
        }
        modifiableRootModel.commit();
    }

    protected void setupRootModel(ModifiableRootModel modifiableRootModel) {
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleType";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleTypeProducer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/testFramework/fixtures/impl/ModuleFixtureBuilderImpl";
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$new$0";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

