/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.fixtures.impl;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileFilter;
import com.intellij.testFramework.fixtures.TempDirTestFixture;
import com.intellij.testFramework.fixtures.impl.BaseFixture;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;
import org.junit.Assert;

public class TempDirTestFixtureImpl
extends BaseFixture
implements TempDirTestFixture {
    private File d;

    @Override
    @NotNull
    public VirtualFile copyAll(@NotNull String string, @NotNull String string2) {
        if (string == null) {
            TempDirTestFixtureImpl.a(0);
        }
        if (string2 == null) {
            TempDirTestFixtureImpl.a(1);
        }
        VirtualFile virtualFile = this.copyAll(string, string2, VirtualFileFilter.ALL);
        if (virtualFile == null) {
            TempDirTestFixtureImpl.a(2);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile copyAll(final @NotNull String string, final @NotNull String string2, final @NotNull VirtualFileFilter virtualFileFilter) {
        if (string == null) {
            TempDirTestFixtureImpl.a(3);
        }
        if (string2 == null) {
            TempDirTestFixtureImpl.a(4);
        }
        if (virtualFileFilter == null) {
            TempDirTestFixtureImpl.a(5);
        }
        this.createTempDirectory();
        VirtualFile virtualFile = (VirtualFile)ApplicationManager.getApplication().runWriteAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                try {
                    VirtualFile virtualFile;
                    VirtualFile virtualFile2 = LocalFileSystem.getInstance().refreshAndFindFileByPath(TempDirTestFixtureImpl.this.d.getCanonicalPath().replace(File.separatorChar, '/'));
                    Assert.assertNotNull((Object)virtualFile2);
                    if (string2.length() > 0) {
                        Assert.assertFalse((String)"nested directories not implemented", (boolean)string2.contains("/"));
                        virtualFile = virtualFile2.findChild(string2);
                        if (virtualFile == null) {
                            virtualFile = virtualFile2.createChildDirectory((Object)this, string2);
                        }
                        virtualFile2 = virtualFile;
                    }
                    virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(string);
                    Assert.assertNotNull((String)(string + " not found"), (Object)virtualFile);
                    VfsUtil.copyDirectory(null, (VirtualFile)virtualFile, (VirtualFile)virtualFile2, (VirtualFileFilter)virtualFileFilter);
                    return virtualFile2;
                }
                catch (IOException iOException) {
                    throw new RuntimeException(iOException);
                }
            }
        });
        if (virtualFile == null) {
            TempDirTestFixtureImpl.a(6);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public String getTempDirPath() {
        String string = this.createTempDirectory().getAbsolutePath();
        if (string == null) {
            TempDirTestFixtureImpl.a(7);
        }
        return string;
    }

    public File createTempFile(String string) throws IOException {
        String string2 = StringUtil.getPackageName((String)string);
        if (string2.length() < 3) {
            string2 = string2 + "___";
        }
        String string3 = "." + StringUtil.getShortName((String)string);
        return FileUtil.createTempFile((File)new File(this.getTempDirPath()), (String)string2, (String)string3, (boolean)true);
    }

    @Override
    public VirtualFile getFile(final @NotNull String string) {
        if (string == null) {
            TempDirTestFixtureImpl.a(8);
        }
        return (VirtualFile)new WriteAction<VirtualFile>(){

            protected void run(@NotNull Result<VirtualFile> result2) throws IOException {
                if (result2 == null) {
                    2.a(0);
                }
                String string2 = TempDirTestFixtureImpl.this.d.getCanonicalPath() + '/' + string;
                VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByPath(string2);
                result2.setResult((Object)virtualFile);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl$2", "run"));
            }
        }.execute().getResultObject();
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String string) {
        if (string == null) {
            TempDirTestFixtureImpl.a(9);
        }
        File file = new File(this.createTempDirectory(), string);
        VirtualFile virtualFile = (VirtualFile)WriteAction.compute(() -> {
            FileUtil.createIfDoesntExist((File)file);
            return LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
        });
        if (virtualFile == null) {
            TempDirTestFixtureImpl.a(10);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile findOrCreateDir(@NotNull String string) throws IOException {
        if (string == null) {
            TempDirTestFixtureImpl.a(11);
        }
        VirtualFile virtualFile = VfsUtil.createDirectories((String)new File(this.createTempDirectory(), string).getPath());
        if (virtualFile == null) {
            TempDirTestFixtureImpl.a(12);
        }
        return virtualFile;
    }

    @Override
    @NotNull
    public VirtualFile createFile(@NotNull String string, final @NotNull String string2) throws IOException {
        if (string == null) {
            TempDirTestFixtureImpl.a(13);
        }
        if (string2 == null) {
            TempDirTestFixtureImpl.a(14);
        }
        final VirtualFile virtualFile = this.createFile(string);
        new WriteAction(){

            protected void run(@NotNull Result result2) throws IOException {
                if (result2 == null) {
                    3.a(0);
                }
                VfsUtil.saveText((VirtualFile)virtualFile, (String)string2);
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl$3", "run"));
            }
        }.execute();
        VirtualFile virtualFile2 = virtualFile;
        if (virtualFile2 == null) {
            TempDirTestFixtureImpl.a(15);
        }
        return virtualFile2;
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.createTempDirectory();
    }

    @Override
    public void tearDown() throws Exception {
        try {
            if (this.d != null) {
                new WriteAction(){

                    protected void run(@NotNull Result result2) throws IOException {
                        if (result2 == null) {
                            4.a(0);
                        }
                        TempDirTestFixtureImpl.this.findOrCreateDir("").delete((Object)this);
                    }

                    private static /* synthetic */ void a(int n2) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl$4", "run"));
                    }
                }.execute();
            }
        }
        finally {
            super.tearDown();
        }
    }

    protected File getTempHome() {
        return null;
    }

    @NotNull
    protected File createTempDirectory() {
        File file;
        try {
            if (this.d == null) {
                File file2 = this.getTempHome();
                this.d = file2 == null ? FileUtil.createTempDirectory((String)"unitTest", null, (boolean)false) : FileUtil.createTempDirectory((File)file2, (String)"unitTest", null, (boolean)false);
            }
            file = this.d;
        }
        catch (IOException iOException) {
            throw new RuntimeException("Cannot create temp dir", iOException);
        }
        if (file == null) {
            TempDirTestFixtureImpl.a(16);
        }
        return file;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 16: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataDir";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetDir";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 9: 
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/testFramework/fixtures/impl/TempDirTestFixtureImpl";
                break;
            }
            case 2: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyAll";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getTempDirPath";
                break;
            }
            case 10: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createFile";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "findOrCreateDir";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "createTempDirectory";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "copyAll";
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 16: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFile";
                break;
            }
            case 9: 
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createFile";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "findOrCreateDir";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 6: 
            case 7: 
            case 10: 
            case 12: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

