/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.CommonBundle;
import com.intellij.ide.actions.ShowFilePathAction;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.ApplicationInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.MemoryDumpHelper;
import com.intellij.util.SystemProperties;
import com.yourkit.api.Controller;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProfilingUtil {
    private static final Logger c = Logger.getInstance((String)"#com.intellij.util.ProfilingUtil");
    private static final NotificationGroup a = new NotificationGroup("Profiling", NotificationDisplayType.BALLOON, false);
    private static final boolean d;
    private static Controller b;
    private static boolean e;

    public static void reinitialize() {
        try {
            b = new Controller();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
    }

    public static boolean hasValidController() {
        return b != null;
    }

    public static void startCPUProfiling() {
        boolean bl2 = Boolean.getBoolean("profile.trace");
        ProfilingUtil.startCPUProfiling(bl2);
    }

    public static void startCPUProfiling(boolean bl2) {
        if (ProfilingUtil.hasValidController()) {
            try {
                if (bl2) {
                    b.startCPUTracing(null);
                } else {
                    b.startCPUSampling(null);
                }
                e = true;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        } else {
            c.warn("ProfilingUtil is disabled, add -agentlib:yjpagent to the command line");
        }
    }

    public static String captureCPUSnapshot() {
        if (ProfilingUtil.hasValidController()) {
            try {
                String string = b.captureSnapshot(0L);
                b.stopCPUProfiling();
                c.info("CPU snapshot is generated at " + string);
                e = false;
                return string;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    public static boolean canCaptureMemorySnapshot() {
        boolean bl2 = Boolean.getBoolean("profile.yourkit");
        return !bl2 && MemoryDumpHelper.memoryDumpAvailable() || ProfilingUtil.hasValidController();
    }

    public static String captureMemorySnapshot() {
        boolean bl2 = Boolean.getBoolean("profile.yourkit");
        if (!bl2 && MemoryDumpHelper.memoryDumpAvailable()) {
            try {
                File file = FileUtil.createTempFile((String)"heapDump.", (String)".hprof");
                FileUtil.delete((File)file);
                String string = file.getPath();
                MemoryDumpHelper.captureMemoryDump((String)string);
                return string;
            }
            catch (Exception exception) {
                if (!ProfilingUtil.hasValidController()) {
                    throw new RuntimeException(exception);
                }
                c.debug((Throwable)exception);
            }
        }
        if (ProfilingUtil.hasValidController()) {
            try {
                return b.captureMemorySnapshot();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        c.warn("ProfilingUtil is disabled, add -agentlib:yjpagent to the command line");
        return null;
    }

    public static boolean canCaptureAllocations() {
        return ProfilingUtil.hasValidController() && d;
    }

    public static void startRecordAllocations() {
        if (ProfilingUtil.canCaptureAllocations()) {
            try {
                b.startAllocationRecording("exactStacks,sizeLimit=4096,recordEach=1");
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static String stopRecordAllocations() {
        if (ProfilingUtil.canCaptureAllocations()) {
            try {
                String string = b.captureMemorySnapshot();
                b.stopAllocationRecording();
                return string;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
        return null;
    }

    public static void stopCPUProfiling() {
        if (ProfilingUtil.hasValidController()) {
            try {
                b.stopCPUProfiling();
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    @NotNull
    public static String formatSnapshotName() {
        String string = ApplicationInfo.getInstance().getBuild().asString();
        String string2 = SystemProperties.getUserName();
        String string3 = new SimpleDateFormat("dd.MM.yyyy_HH.mm.ss").format(new Date());
        String string4 = string + '_' + string2 + '_' + string3;
        if (string4 == null) {
            ProfilingUtil.a(0);
        }
        return string4;
    }

    /*
     * Exception decompiling
     */
    @Nullable
    public static File compressSnapshot(@NotNull String var0, @NotNull String var1_1) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void copySnapshotAndNotify(@Nullable String string, @Nullable Project project2) throws IOException {
        if (string == null) {
            return;
        }
        File file = ProfilingUtil.compressSnapshot(string, ProfilingUtil.formatSnapshotName());
        if (file == null) {
            return;
        }
        c.info("CPU snapshot is moved to " + file.getAbsolutePath());
        String string2 = "file://" + file.getAbsolutePath();
        String string3 = CommonBundle.message((String)"profiling.capture.snapshot.success", (Object[])new Object[]{file.getName(), string2, ShowFilePathAction.getFileManagerName()});
        a.createNotification("", string3, NotificationType.INFORMATION, ShowFilePathAction.FILE_SELECTING_LISTENER).notify(project2);
    }

    public static void notifyCapturingError(@NotNull Throwable throwable, @Nullable Project project2) {
        if (throwable == null) {
            ProfilingUtil.a(3);
        }
        c.warn(throwable);
        String string = CommonBundle.message((String)"profiling.capture.snapshot.error", (Object[])new Object[]{throwable.getMessage()});
        a.createNotification(string, NotificationType.ERROR).notify(project2);
    }

    public static boolean isCPUProfiling() {
        return e;
    }

    static {
        Controller controller = null;
        boolean bl2 = false;
        try {
            for (String string : ManagementFactory.getRuntimeMXBean().getInputArguments()) {
                if (!string.startsWith("-agentlib:yjpagent") && (!string.startsWith("-agentpath:") || !string.contains("yjpagent"))) continue;
                controller = new Controller();
                bl2 = string.contains("disablealloc") || string.contains("disableall");
                break;
            }
            if (controller == null) {
                c.warn("Profiling agent is not enabled. Add -agentlib:yjpagent to idea.vmoptions if necessary to profile IDEA.");
            }
        }
        catch (Throwable throwable) {
            c.warn("YourKit controller initialization failed : " + throwable.getMessage(), throwable.getCause());
        }
        b = controller;
        d = !bl2;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ProfilingUtil";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dumpFilePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "snapshotName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "formatSnapshotName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ProfilingUtil";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compressSnapshot";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "notifyCapturingError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

