/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.ide.structureView.StructureViewBuilder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.Stub;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.xml.XmlDoctype;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlProlog;
import com.intellij.util.Function;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.xml.DomAnchor;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomFileIndex;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.ModelMerger;
import com.intellij.util.xml.ModelMergerImpl;
import com.intellij.util.xml.NanoXmlUtil;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.impl.DomAnchorImpl;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.structure.DomStructureViewBuilder;
import com.intellij.util.xml.stubs.FileStub;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomServiceImpl
extends DomService {
    private static final Key<CachedValue<XmlFileHeader>> b = Key.create((String)"rootTag&ns");
    private static final UserDataCache<CachedValue<XmlFileHeader>, XmlFile, Object> a = new UserDataCache<CachedValue<XmlFileHeader>, XmlFile, Object>(){

        protected CachedValue<XmlFileHeader> compute(XmlFile xmlFile, Object object) {
            return CachedValuesManager.getManager((Project)xmlFile.getProject()).createCachedValue(() -> new CachedValueProvider.Result((Object)DomServiceImpl.a(xmlFile), new Object[]{xmlFile}), false);
        }
    };

    @NotNull
    private static XmlFileHeader a(XmlFile xmlFile) {
        Stub stub;
        ObjectStubTree objectStubTree;
        VirtualFile virtualFile;
        if (xmlFile instanceof PsiFileEx && ((PsiFileEx)xmlFile).isContentsLoaded() && xmlFile.getNode().isParsed()) {
            XmlFileHeader xmlFileHeader = DomServiceImpl.b(xmlFile);
            if (xmlFileHeader == null) {
                DomServiceImpl.a(0);
            }
            return xmlFileHeader;
        }
        if (!XmlUtil.isStubBuilding() && xmlFile.getFileType() == XmlFileType.INSTANCE && (virtualFile = xmlFile.getVirtualFile()) instanceof VirtualFileWithId && (objectStubTree = StubTreeLoader.getInstance().readFromVFile(xmlFile.getProject(), virtualFile)) != null && (stub = objectStubTree.getRoot()) instanceof FileStub) {
            XmlFileHeader xmlFileHeader = ((FileStub)stub).getHeader();
            if (xmlFileHeader == null) {
                DomServiceImpl.a(1);
            }
            return xmlFileHeader;
        }
        if (!xmlFile.isValid()) {
            XmlFileHeader xmlFileHeader = XmlFileHeader.EMPTY;
            if (xmlFileHeader == null) {
                DomServiceImpl.a(2);
            }
            return xmlFileHeader;
        }
        XmlFileHeader xmlFileHeader = NanoXmlUtil.parseHeader((PsiFile)xmlFile);
        if (xmlFileHeader == null) {
            DomServiceImpl.a(3);
        }
        return xmlFileHeader;
    }

    private static XmlFileHeader b(XmlFile xmlFile) {
        XmlDoctype xmlDoctype;
        XmlDocument xmlDocument = xmlFile.getDocument();
        if (xmlDocument == null) {
            return XmlFileHeader.EMPTY;
        }
        String string = null;
        String string2 = null;
        XmlProlog xmlProlog = xmlDocument.getProlog();
        if (xmlProlog != null && (xmlDoctype = xmlProlog.getDoctype()) != null) {
            string = xmlDoctype.getPublicId();
            string2 = xmlDoctype.getSystemId();
            if (string2 == null) {
                string2 = xmlDoctype.getDtdUri();
            }
        }
        if ((xmlDoctype = xmlDocument.getRootTag()) == null) {
            return XmlFileHeader.EMPTY;
        }
        String string3 = xmlDoctype.getLocalName();
        if (StringUtil.isNotEmpty((String)string3)) {
            if (xmlDoctype.getPrevSibling() instanceof PsiErrorElement) {
                return XmlFileHeader.EMPTY;
            }
            String string4 = xmlDoctype.getNamespace();
            return new XmlFileHeader(string3, string4 == "" || Comparing.equal((String)string4, (String)string2) ? null : string4, string, string2);
        }
        return XmlFileHeader.EMPTY;
    }

    public ModelMerger createModelMerger() {
        return new ModelMergerImpl();
    }

    public <T extends DomElement> DomAnchor<T> createAnchor(T t2) {
        return DomAnchorImpl.createAnchor(t2);
    }

    @NotNull
    public XmlFile getContainingFile(@NotNull DomElement domElement) {
        if (domElement == null) {
            DomServiceImpl.a(4);
        }
        if (domElement instanceof DomFileElement) {
            XmlFile xmlFile = ((DomFileElement)domElement).getFile();
            if (xmlFile == null) {
                DomServiceImpl.a(5);
            }
            return xmlFile;
        }
        XmlFile xmlFile = DomManagerImpl.getNotNullHandler(domElement).getFile();
        if (xmlFile == null) {
            DomServiceImpl.a(6);
        }
        return xmlFile;
    }

    @NotNull
    public EvaluatedXmlName getEvaluatedXmlName(@NotNull DomElement domElement) {
        if (domElement == null) {
            DomServiceImpl.a(7);
        }
        EvaluatedXmlName evaluatedXmlName = DomManagerImpl.getNotNullHandler(domElement).getXmlName();
        if (evaluatedXmlName == null) {
            DomServiceImpl.a(8);
        }
        return evaluatedXmlName;
    }

    @NotNull
    public XmlFileHeader getXmlFileHeader(XmlFile xmlFile) {
        XmlFileHeader xmlFileHeader = xmlFile.isValid() ? (XmlFileHeader)((CachedValue)a.get(b, (UserDataHolder)xmlFile, null)).getValue() : XmlFileHeader.EMPTY;
        if (xmlFileHeader == null) {
            DomServiceImpl.a(9);
        }
        return xmlFileHeader;
    }

    public Collection<VirtualFile> getDomFileCandidates(Class<? extends DomElement> clazz, Project project2, GlobalSearchScope globalSearchScope) {
        return FileBasedIndex.getInstance().getContainingFiles(DomFileIndex.NAME, (Object)clazz.getName(), globalSearchScope);
    }

    public <T extends DomElement> List<DomFileElement<T>> getFileElements(Class<T> clazz, Project project2, @Nullable GlobalSearchScope globalSearchScope) {
        Collection<VirtualFile> collection = this.getDomFileCandidates(clazz, project2, globalSearchScope != null ? globalSearchScope : GlobalSearchScope.allScope((Project)project2));
        ArrayList<DomFileElement<T>> arrayList = new ArrayList<DomFileElement<T>>(collection.size());
        for (VirtualFile virtualFile : collection) {
            DomFileElement domFileElement;
            PsiFile psiFile = PsiManager.getInstance((Project)project2).findFile(virtualFile);
            if (!(psiFile instanceof XmlFile) || (domFileElement = DomManager.getDomManager((Project)project2).getFileElement((XmlFile)psiFile, clazz)) == null) continue;
            arrayList.add(domFileElement);
        }
        return arrayList;
    }

    public StructureViewBuilder createSimpleStructureViewBuilder(XmlFile xmlFile, Function<DomElement, DomService.StructureViewMode> function) {
        return new DomStructureViewBuilder(xmlFile, function);
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 7: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 4: 
            case 7: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/xml/impl/DomServiceImpl";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domElement";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "calcXmlFileHeader";
                break;
            }
            case 4: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/xml/impl/DomServiceImpl";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getEvaluatedXmlName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getXmlFileHeader";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getEvaluatedXmlName";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 7: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

