/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.impl;

import com.intellij.ide.highlighter.DomSupportEnabled;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWithId;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.PsiFileEx;
import com.intellij.psi.stubs.ObjectStubTree;
import com.intellij.psi.stubs.StubTreeLoader;
import com.intellij.psi.xml.XmlFile;
import com.intellij.semantic.SemElement;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileDescription;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.EvaluatedXmlNameImpl;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.events.DomEvent;
import com.intellij.util.xml.impl.DomFileElementImpl;
import com.intellij.util.xml.impl.DomImplUtil;
import com.intellij.util.xml.impl.DomManagerImpl;
import com.intellij.util.xml.stubs.FileStub;
import com.intellij.xml.util.XmlUtil;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class FileDescriptionCachedValueProvider<T extends DomElement>
implements SemElement {
    private final XmlFile e;
    private volatile boolean a;
    private volatile DomFileElementImpl<T> f;
    private final MyCondition b = new MyCondition();
    private final DomManagerImpl c;
    private final DomService d;

    public FileDescriptionCachedValueProvider(DomManagerImpl domManagerImpl, XmlFile xmlFile) {
        this.c = domManagerImpl;
        this.e = xmlFile;
        this.d = DomService.getInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final DomFileElementImpl<T> getFileElement() {
        if (this.a) {
            return this.f;
        }
        DomFileElementImpl<T> domFileElementImpl = this.a(false, this.d.getXmlFileHeader(this.e), null);
        MyCondition myCondition = this.b;
        synchronized (myCondition) {
            if (this.a) {
                return this.f;
            }
            this.f = domFileElementImpl;
            WeakReference<DomFileElementImpl<DomFileElementImpl<DomFileElementImpl<DomFileElementImpl<T>>>>> weakReference = domFileElementImpl != null ? new WeakReference<DomFileElementImpl<DomFileElementImpl<DomFileElementImpl<DomFileElementImpl<T>>>>>(domFileElementImpl) : null;
            this.e.putUserData(DomManagerImpl.CACHED_FILE_ELEMENT, weakReference);
            this.a = true;
            return domFileElementImpl;
        }
    }

    @Nullable
    private DomFileElementImpl<T> a(boolean bl2, @NotNull XmlFileHeader xmlFileHeader, @Nullable StringBuilder stringBuilder) {
        ObjectStubTree objectStubTree;
        SmartList smartList;
        if (xmlFileHeader == null) {
            FileDescriptionCachedValueProvider.a(0);
        }
        if (stringBuilder != null) {
            stringBuilder.append(xmlFileHeader).append("\n");
        }
        if (!this.e.isValid()) {
            return null;
        }
        if (stringBuilder != null) {
            stringBuilder.append("File is valid\n");
        }
        if (!(this.e.getFileType() instanceof DomSupportEnabled)) {
            return null;
        }
        if (stringBuilder != null) {
            stringBuilder.append("File is of dom file type\n");
        }
        DomFileDescription<T> domFileDescription = this.a(xmlFileHeader, stringBuilder);
        DomFileElementImpl<T> domFileElementImpl = this.getLastValue();
        if (stringBuilder != null) {
            stringBuilder.append("last " + domFileElementImpl + "\n");
        }
        SmartList smartList2 = smartList = bl2 ? new SmartList() : Collections.emptyList();
        if (domFileElementImpl != null && bl2) {
            smartList.add(new DomEvent(domFileElementImpl, false));
        }
        if (domFileDescription == null) {
            return null;
        }
        Class clazz = domFileDescription.getRootElementClass();
        XmlName xmlName = DomImplUtil.createXmlName(domFileDescription.getRootTagName(), clazz, null);
        assert (xmlName != null);
        EvaluatedXmlNameImpl evaluatedXmlNameImpl = EvaluatedXmlNameImpl.createEvaluatedXmlName((XmlName)xmlName, (String)xmlName.getNamespaceKey(), (boolean)false);
        VirtualFile virtualFile = this.e.getVirtualFile();
        FileStub fileStub = null;
        if (domFileDescription.hasStubs() && virtualFile instanceof VirtualFileWithId && !this.a()) {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            if (!XmlUtil.isStubBuilding() && (objectStubTree = StubTreeLoader.getInstance().readOrBuild(this.e.getProject(), virtualFile, (PsiFile)this.e)) != null) {
                fileStub = (FileStub)objectStubTree.getRoot();
            }
        }
        objectStubTree = new DomFileElementImpl(this.e, clazz, evaluatedXmlNameImpl, this.c, domFileDescription, fileStub);
        if (stringBuilder != null) {
            stringBuilder.append("success " + objectStubTree + "\n");
        }
        if (bl2) {
            smartList.add(new DomEvent((DomElement)objectStubTree, true));
        }
        return objectStubTree;
    }

    private boolean a() {
        return this.e instanceof PsiFileEx && ((PsiFileEx)this.e).isContentsLoaded();
    }

    @Nullable
    private DomFileDescription<T> a(XmlFileHeader xmlFileHeader, @Nullable StringBuilder stringBuilder) {
        DomFileDescription domFileDescription;
        DomFileDescription domFileDescription2 = (DomFileDescription)this.e.getUserData(DomManagerImpl.MOCK_DESCRIPTION);
        if (domFileDescription2 != null) {
            return domFileDescription2;
        }
        if (stringBuilder != null) {
            stringBuilder.append("no mock\n");
        }
        XmlFile xmlFile = (XmlFile)this.e.getOriginalFile();
        if (stringBuilder != null) {
            stringBuilder.append("original: " + xmlFile + "\n");
        }
        if (!xmlFile.equals(this.e)) {
            FileDescriptionCachedValueProvider fileDescriptionCachedValueProvider = this.c.getOrCreateCachedValueProvider(xmlFile);
            DomFileElementImpl domFileElementImpl = fileDescriptionCachedValueProvider.getFileElement();
            if (stringBuilder != null) {
                stringBuilder.append("originalDom " + domFileElementImpl + "\n");
            }
            return domFileElementImpl == null ? null : domFileElementImpl.getFileDescription();
        }
        Set<DomFileDescription> set = this.c.getFileDescriptions(xmlFileHeader.getRootTagLocalName());
        if (stringBuilder != null) {
            stringBuilder.append("named " + new HashSet<DomFileDescription>(set) + "\n");
        }
        if ((domFileDescription = (DomFileDescription)ContainerUtil.find(set, (Condition)this.b)) == null) {
            Set<DomFileDescription> set2 = this.c.getAcceptingOtherRootTagNameDescriptions();
            domFileDescription = (DomFileDescription)ContainerUtil.find(set2, (Condition)this.b);
        }
        if (stringBuilder != null) {
            stringBuilder.append("found " + domFileDescription + "\n");
        }
        return domFileDescription;
    }

    @Nullable
    final DomFileElementImpl<T> getLastValue() {
        return this.f;
    }

    public String getFileElementWithLogging() {
        XmlFileHeader xmlFileHeader = this.d.getXmlFileHeader(this.e);
        StringBuilder stringBuilder = new StringBuilder();
        this.f = this.a(false, xmlFileHeader, stringBuilder);
        return stringBuilder.toString();
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rootTagName", "com/intellij/util/xml/impl/FileDescriptionCachedValueProvider", "_computeFileElement"));
    }

    private class MyCondition
    implements Condition<DomFileDescription> {
        public Module module;

        private MyCondition() {
        }

        public boolean value(DomFileDescription domFileDescription) {
            return domFileDescription.isMyFile(FileDescriptionCachedValueProvider.this.e, this.module);
        }
    }
}

