/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.formatter.comments;

import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.util.text.CharArrayUtil;
import com.intellij.webcore.formatter.comments.CommentLineData;
import com.intellij.webcore.formatter.comments.CommentLineDataBuilder;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DocCommentLineDataBuilder
extends CommentLineDataBuilder {
    private final boolean d;
    private final PsiElement c;
    private final CommonCodeStyleSettings.IndentOptions b;

    public DocCommentLineDataBuilder(@NotNull PsiElement psiElement, boolean bl2, @NotNull CommonCodeStyleSettings commonCodeStyleSettings) {
        if (psiElement == null) {
            DocCommentLineDataBuilder.a(0);
        }
        if (commonCodeStyleSettings == null) {
            DocCommentLineDataBuilder.a(1);
        }
        super(commonCodeStyleSettings.getRootSettings());
        this.c = psiElement;
        this.d = bl2;
        this.b = commonCodeStyleSettings.getIndentOptions() != null ? commonCodeStyleSettings.getIndentOptions() : new CommonCodeStyleSettings.IndentOptions();
    }

    @Override
    public List<CommentLineData> getLines() {
        CharSequence charSequence = this.c.getNode().getChars();
        ArrayList<CommentLineData> arrayList = new ArrayList<CommentLineData>();
        int n2 = 0;
        boolean bl2 = false;
        block3: for (int i2 = 0; i2 < charSequence.length(); ++i2) {
            char c2 = charSequence.charAt(i2);
            switch (c2) {
                case '\n': {
                    if (n2 < i2) {
                        CommentLineData commentLineData = this.a(charSequence, n2, i2, bl2);
                        bl2 = commentLineData.isTagLine();
                        arrayList.add(commentLineData);
                    }
                    n2 = i2 + 1;
                    continue block3;
                }
            }
        }
        if (n2 < charSequence.length()) {
            arrayList.add(this.a(charSequence, n2, charSequence.length(), bl2));
        }
        return arrayList;
    }

    private CommentLineData a(CharSequence charSequence, int n2, int n3, boolean bl2) {
        String string = new String(CharArrayUtil.fromSequence((CharSequence)charSequence, (int)n2, (int)n3));
        CommentLineData commentLineData = this.parseLine(string);
        commentLineData.setTagLine(bl2);
        return commentLineData;
    }

    @Override
    @NotNull
    public CommentLineData parseLine(@NotNull String string) {
        if (string == null) {
            DocCommentLineDataBuilder.a(2);
        }
        DocCommentLineData docCommentLineData = new DocCommentLineData(string);
        docCommentLineData.commentOffset = DocCommentLineDataBuilder.nextNonWhitespace(string, 0);
        if (docCommentLineData.commentOffset >= 0) {
            int n2;
            if (string.charAt(docCommentLineData.commentOffset) == '*') {
                ++docCommentLineData.commentOffset;
            }
            if ((n2 = DocCommentLineDataBuilder.nextNonWhitespace(string, docCommentLineData.commentOffset)) >= 0) {
                char c2 = string.charAt(n2);
                if (c2 == '@') {
                    docCommentLineData.tagStartOffset = n2;
                    int n3 = docCommentLineData.tagEndOffset = (n2 = DocCommentLineDataBuilder.nextWhitespace(string, n2 + 1)) >= 0 ? n2 : string.length();
                    if (docCommentLineData.tagEndOffset > docCommentLineData.tagStartOffset) {
                        docCommentLineData.tagName = string.substring(docCommentLineData.tagStartOffset, docCommentLineData.tagEndOffset);
                    }
                    if (n2 >= 0) {
                        if ("@param".equals(docCommentLineData.tagName)) {
                            if ((n2 = DocCommentLineDataBuilder.nextNonWhitespace(string, n2 + 1)) >= 0) {
                                boolean bl2 = string.charAt(n2) == '$';
                                n2 = DocCommentLineDataBuilder.nextWhitespace(string, n2);
                                if (!bl2 && n2 >= 0) {
                                    n2 = DocCommentLineDataBuilder.skipNextWord(string, n2);
                                }
                            }
                        } else if ("@return".equals(docCommentLineData.tagName) || "@throws".equals(docCommentLineData.tagName)) {
                            n2 = DocCommentLineDataBuilder.skipNextWord(string, n2);
                        }
                    }
                } else if (Character.isLetter(c2)) {
                    docCommentLineData.startsWithLetter = true;
                }
                if (n2 >= 0) {
                    docCommentLineData.textStartOffset = (n2 = DocCommentLineDataBuilder.nextNonWhitespace(string, n2)) >= 0 ? n2 : -1;
                    DocCommentLineDataBuilder.a(docCommentLineData, string);
                }
            }
        }
        DocCommentLineData docCommentLineData2 = docCommentLineData;
        if (docCommentLineData2 == null) {
            DocCommentLineDataBuilder.a(3);
        }
        return docCommentLineData2;
    }

    private static void a(@NotNull CommentLineData commentLineData, @NotNull String string) {
        if (commentLineData == null) {
            DocCommentLineDataBuilder.a(4);
        }
        if (string == null) {
            DocCommentLineDataBuilder.a(5);
        }
        if (commentLineData.textStartOffset < 0) {
            return;
        }
        int n2 = -1;
        block4: for (int i2 = commentLineData.textStartOffset; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            switch (c2) {
                case '{': {
                    int n3 = i2 + 1;
                    if (n3 >= string.length() || string.charAt(n3) != '@') continue block4;
                    n2 = i2;
                    continue block4;
                }
                case '}': {
                    if (n2 >= 0) {
                        TextRange textRange = new TextRange(n2, i2);
                        commentLineData.addUnbreakableRange(textRange);
                    }
                    n2 = -1;
                }
            }
        }
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 3: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "docComment";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lineData";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseLine";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseLine";
                break;
            }
            case 3: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectInlineTagsRanges";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class DocCommentLineData
    extends CommentLineData {
        int tagStartOffset;
        int tagEndOffset;
        String tagName;
        private boolean b;

        public DocCommentLineData(String string) {
            if (string == null) {
                DocCommentLineData.a(0);
            }
            super(string);
            this.tagStartOffset = -1;
            this.tagEndOffset = -1;
            this.tagName = "";
            this.b = false;
        }

        @Override
        public boolean isTagLine() {
            return this.tagStartOffset >= 0 || this.b;
        }

        @Override
        public void setTagLine(boolean bl2) {
            this.b = bl2;
        }

        @Override
        @NotNull
        public String getLinePrefix() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.commentOffset >= 0) {
                stringBuilder.append(this.line.substring(0, this.commentOffset));
                if (this.textStartOffset > this.commentOffset) {
                    if (DocCommentLineDataBuilder.this.d) {
                        StringUtil.repeatSymbol((Appendable)stringBuilder, (char)' ', (int)(this.textStartOffset - this.commentOffset - 1));
                    } else if (this.isTagLine()) {
                        StringUtil.repeatSymbol((Appendable)stringBuilder, (char)' ', (int)((DocCommentLineDataBuilder)DocCommentLineDataBuilder.this).b.CONTINUATION_INDENT_SIZE);
                    }
                }
            }
            String string = stringBuilder.toString();
            if (string == null) {
                DocCommentLineData.a(1);
            }
            return string;
        }

        @Override
        protected int getTabSize() {
            return ((DocCommentLineDataBuilder)DocCommentLineDataBuilder.this).b.TAB_SIZE;
        }

        private static /* synthetic */ void a(int n2) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n3;
            String string;
            switch (n2) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n2) {
                default: {
                    n3 = 3;
                    break;
                }
                case 1: {
                    n3 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n3];
            switch (n2) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "line";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder$DocCommentLineData";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/webcore/formatter/comments/DocCommentLineDataBuilder$DocCommentLineData";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLinePrefix";
                    break;
                }
            }
            switch (n2) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n2) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

