/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ui.Util;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBComboBoxLabel;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.editors.JBComboBoxTableCellEditorComponent;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SortedList;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.webcore.ScriptingFrameworkDescriptor;
import com.intellij.webcore.WebCoreBundle;
import com.intellij.webcore.libraries.LangScriptingContextProvider;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.AbstractListModel;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.ListModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EditLibraryDialog
extends DialogWrapper {
    private static final int e = 0;
    private static final int n = 1;
    private final String s;
    private final String k;
    private static final Comparator<VirtualFile> i = (virtualFile, virtualFile2) -> virtualFile.getName().compareToIgnoreCase(virtualFile2.getName());
    private JPanel v;
    private JTextField d;
    private final JBTable l;
    private final JBList j;
    private JComboBox b;
    private JTextField o;
    private JRadioButton u;
    private JRadioButton y;
    private JPanel r;
    private JPanel m;
    private final Project x;
    private final FileTableModel t;
    private final LangScriptingContextProvider w;
    private final MyDocUrlListModel f;
    private ScriptingFrameworkDescriptor h;
    private final Icon c;
    private final Icon g;
    private final AnActionButton a;
    private final AnActionButton q;
    private final FileChooserDescriptor p;

    public EditLibraryDialog(String string, LangScriptingContextProvider langScriptingContextProvider, Project project2) {
        super(true);
        this.c();
        this.p = new FileChooserDescriptor(true, true, false, true, false, true){
            {
                this.setTitle(WebCoreBundle.message((String)"edit.library.attach.files.dialog.title", (Object[])new Object[0]));
            }

            public boolean isFileSelectable(VirtualFile virtualFile) {
                if (!virtualFile.isDirectory() && !EditLibraryDialog.this.w.acceptsExtension(virtualFile.getExtension())) {
                    return false;
                }
                return super.isFileSelectable(virtualFile);
            }

            public boolean isFileVisible(VirtualFile virtualFile, boolean bl2) {
                if (!virtualFile.isDirectory() && !EditLibraryDialog.this.w.acceptsExtension(virtualFile.getExtension())) {
                    return false;
                }
                return super.isFileVisible(virtualFile, bl2);
            }
        };
        this.c = langScriptingContextProvider.getFileIcon();
        this.g = AllIcons.Nodes.Folder;
        this.w = langScriptingContextProvider;
        this.x = project2;
        this.l = new JBTable();
        this.l.setStriped(true);
        this.l.setUpdateSelectionOnSort(true);
        JPanel jPanel = ToolbarDecorator.createDecorator((JTable)this.l).disableUpAction().disableDownAction().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                List list2 = EditLibraryDialog.this.k();
                if (list2.isEmpty()) {
                    return;
                }
                DefaultActionGroup defaultActionGroup = new DefaultActionGroup(list2.toArray(AnAction.EMPTY_ARRAY));
                JBPopupFactory.getInstance().createActionGroupPopup(null, (ActionGroup)defaultActionGroup, DataManager.getInstance().getDataContext((Component)anActionButton.getContextComponent()), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, true).show(anActionButton.getPreferredPopupPoint());
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                EditLibraryDialog.this.m();
            }
        }).createPanel();
        this.r.add((Component)jPanel, "Center");
        this.setTitle(string);
        this.s = langScriptingContextProvider.getLibraryTypeName(OrderRootType.SOURCES);
        this.k = langScriptingContextProvider.getLibraryTypeName(OrderRootType.CLASSES);
        this.t = new FileTableModel();
        this.l.setRowHeight(this.l.getRowHeight() + 5);
        this.l.setModel((TableModel)this.t);
        new TableSpeedSearch((JTable)this.l);
        this.f = new MyDocUrlListModel();
        this.j = new JBList((ListModel)this.f);
        this.f.addListDataListener(new ListDataListener(){

            @Override
            public void intervalAdded(ListDataEvent listDataEvent) {
                EditLibraryDialog.this.b();
            }

            @Override
            public void intervalRemoved(ListDataEvent listDataEvent) {
                Object object = listDataEvent.getSource();
                if (object instanceof MyDocUrlListModel && ((MyDocUrlListModel)object).getDocUrls().length == 0) {
                    EditLibraryDialog.this.b();
                }
            }

            @Override
            public void contentsChanged(ListDataEvent listDataEvent) {
            }
        });
        this.j.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                EditLibraryDialog.this.q.setEnabled(EditLibraryDialog.this.j.getSelectedIndex() >= 0);
            }
        });
        this.a = new AnActionButton("Download", AllIcons.Actions.Download){

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    5.a(0);
                }
                EditLibraryDialog.this.a();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$5", "actionPerformed"));
            }
        };
        this.q = new AnActionButton("Edit", AllIcons.ToolbarDecorator.Edit){

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    6.a(0);
                }
                EditLibraryDialog.this.g();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$6", "actionPerformed"));
            }
        };
        this.m.add((Component)ToolbarDecorator.createDecorator((JList)this.j).disableUpDownActions().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                EditLibraryDialog.this.l();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                EditLibraryDialog.this.e();
            }
        }).addExtraAction(this.q).addExtraAction(this.a).createPanel(), "Center");
        this.a.setEnabled(false);
        this.q.setEnabled(false);
        this.n();
        this.o.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                EditLibraryDialog.this.i();
            }
        });
        this.init();
        TableColumn tableColumn = this.l.getColumnModel().getColumn(1);
        tableColumn.setMaxWidth(80);
        tableColumn.setCellEditor((TableCellEditor)((Object)new TypeCellEditor()));
        tableColumn.setCellRenderer(new DefaultTableCellRenderer(){
            private final JBComboBoxLabel a = new JBComboBoxLabel();

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
                VirtualFile virtualFile = EditLibraryDialog.this.t.getFileAt(n2);
                if (virtualFile == null || virtualFile.isDirectory()) {
                    this.a.setText("");
                    this.a.setIcon(null);
                } else {
                    this.a.setText(String.valueOf(object));
                    if (bl2) {
                        this.a.setSelectionIcon();
                    } else {
                        this.a.setRegularIcon();
                    }
                }
                this.a.setBackground(bl2 ? jTable.getSelectionBackground() : jTable.getBackground());
                this.a.setForeground(bl2 ? jTable.getSelectionForeground() : jTable.getForeground());
                return this.a;
            }
        });
        TableColumn tableColumn2 = this.l.getColumnModel().getColumn(0);
        tableColumn2.setCellRenderer(new FileNameTableCellRenderer());
    }

    @NotNull
    private List<AnAction> k() {
        ArrayList arrayList = ContainerUtil.newArrayList((Object[])new AnAction[]{new AnAction(WebCoreBundle.message((String)"edit.library.attach.files.popup.title", (Object[])new Object[0]), null, this.c){

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    11.a(0);
                }
                EditLibraryDialog.this.h();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$11", "actionPerformed"));
            }
        }, new AnAction(WebCoreBundle.message((String)"edit.library.attach.directories.popup.title", (Object[])new Object[0]), null, this.g){

            public void actionPerformed(@NotNull AnActionEvent anActionEvent) {
                if (anActionEvent == null) {
                    12.a(0);
                }
                EditLibraryDialog.this.f();
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/webcore/libraries/ui/EditLibraryDialog$12", "actionPerformed"));
            }
        }});
        if (arrayList == null) {
            EditLibraryDialog.a(0);
        }
        return arrayList;
    }

    public EditLibraryDialog(String string, LangScriptingContextProvider langScriptingContextProvider, Project project2, ScriptingLibraryModel scriptingLibraryModel) {
        this(string, langScriptingContextProvider, project2);
        this.d.setText(scriptingLibraryModel.getName());
        this.t.setFiles(scriptingLibraryModel.getSourceFiles(), scriptingLibraryModel.getCompactFiles());
        Set set = scriptingLibraryModel.getDocUrls();
        this.f.setDocUrls(set);
        if (scriptingLibraryModel.getFrameworkDescriptor() != null) {
            this.a(scriptingLibraryModel.getFrameworkDescriptor());
        }
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.u);
        buttonGroup.add(this.y);
        if (scriptingLibraryModel.getLibraryLevel() == ScriptingLibraryModel.LibraryLevel.GLOBAL) {
            this.y.setSelected(true);
        } else {
            this.u.setSelected(true);
        }
        this.b();
    }

    private void a(ScriptingFrameworkDescriptor scriptingFrameworkDescriptor) {
        this.h = scriptingFrameworkDescriptor;
        this.o.setText(scriptingFrameworkDescriptor.getFrameworkVersion());
        for (int i2 = 0; i2 < this.b.getItemCount(); ++i2) {
            Object e2 = this.b.getItemAt(i2);
            if (!(e2 instanceof ScriptingFrameworkDescriptor) || !scriptingFrameworkDescriptor.getFrameworkName().equals(((ScriptingFrameworkDescriptor)e2).getFrameworkName())) continue;
            this.b.setSelectedItem(e2);
        }
    }

    private void b() {
        for (String string : this.getDocUrls()) {
            if (this.w.getOfflineDocUrl(string) == null) continue;
            this.a.setEnabled(true);
            return;
        }
        this.a.setEnabled(false);
    }

    private void n() {
        ArrayList<String> arrayList = new ArrayList<String>();
        ScriptingFrameworkDescriptor[] scriptingFrameworkDescriptorArray = this.w.getSupportedFrameworks(this.x);
        arrayList.add(new String("<Custom>"));
        if (scriptingFrameworkDescriptorArray != null) {
            arrayList.addAll(Arrays.asList(scriptingFrameworkDescriptorArray));
        }
        DefaultComboBoxModel<Object> defaultComboBoxModel = new DefaultComboBoxModel<Object>(ArrayUtil.toObjectArray(arrayList));
        this.b.setModel(defaultComboBoxModel);
        this.b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Object object = EditLibraryDialog.this.b.getSelectedItem();
                if (object instanceof ScriptingFrameworkDescriptor) {
                    String string = ((ScriptingFrameworkDescriptor)object).getFrameworkName();
                    if (EditLibraryDialog.this.h == null || !string.equals(EditLibraryDialog.this.h.getFrameworkName())) {
                        EditLibraryDialog.this.h = new ScriptingFrameworkDescriptor(((ScriptingFrameworkDescriptor)object).getFrameworkName(), null);
                        EditLibraryDialog.this.o.setText("");
                    }
                } else {
                    EditLibraryDialog.this.h = null;
                    EditLibraryDialog.this.o.setText("");
                }
            }
        });
    }

    private void a() {
        LinkedHashSet linkedHashSet = ContainerUtil.newLinkedHashSet();
        for (String string : this.getDocUrls()) {
            String string2 = this.w.getOfflineDocUrl(string);
            if (string2 == null) continue;
            linkedHashSet.add(string2);
        }
        this.a(ContainerUtil.newLinkedList((Iterable)linkedHashSet), this.getRootPane());
    }

    private void a(@NotNull Queue<String> queue, @Nullable Component component) {
        if (queue == null) {
            EditLibraryDialog.a(1);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        String string = queue.poll();
        if (string != null) {
            this.w.downloadOfflineDoc(this.x, string, component, (Consumer<File>)((Consumer)file -> {
                if (queue == null) {
                    EditLibraryDialog.a(4);
                }
                AtomicBoolean atomicBoolean = new AtomicBoolean(true);
                if (file != null) {
                    WriteAction.run(() -> {
                        VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
                        if (virtualFile != null) {
                            atomicBoolean.set(false);
                            this.f.addUrl(virtualFile.getUrl());
                        }
                    });
                }
                if (atomicBoolean.get()) {
                    this.a(queue, component);
                }
            }));
        }
    }

    protected JComponent createCenterPanel() {
        return this.v;
    }

    public String getLibName() {
        return this.d.getText();
    }

    private void h() {
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)this.p, (Project)this.x, null);
        if (virtualFileArray.length == 0) {
            return;
        }
        VfsUtilCore.DistinctVFilesRootsCollection distinctVFilesRootsCollection = new VfsUtilCore.DistinctVFilesRootsCollection(virtualFileArray);
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : distinctVFilesRootsCollection) {
            if (!virtualFile.isValid()) continue;
            if (virtualFile.isDirectory()) {
                this.a(virtualFile, arrayList);
                continue;
            }
            arrayList.add(virtualFile);
        }
        this.a(arrayList);
    }

    private void f() {
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createMultipleFoldersDescriptor();
        fileChooserDescriptor.setTitle(WebCoreBundle.message((String)"edit.library.dialog.attach.directories.dialog.title", (Object[])new Object[0]));
        VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Project)this.x, null);
        if (virtualFileArray.length == 0) {
            return;
        }
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (VirtualFile virtualFile : virtualFileArray) {
            if (!virtualFile.isValid()) continue;
            arrayList.add(virtualFile);
        }
        this.a(arrayList);
    }

    private void a(@NotNull List<VirtualFile> list2) {
        if (list2 == null) {
            EditLibraryDialog.a(2);
        }
        Collections.sort(list2, i);
        int n2 = 0;
        for (VirtualFile virtualFile : list2) {
            this.a(virtualFile, n2++ == list2.size() - 1);
        }
        this.j();
        if (this.d.getText().isEmpty() && !list2.isEmpty()) {
            this.d.setText(list2.get(0).getName());
        }
    }

    private void a(VirtualFile virtualFile, final Collection<VirtualFile> collection) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)virtualFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile virtualFile) {
                if (virtualFile == null) {
                    14.a(0);
                }
                if (virtualFile.isValid() && !virtualFile.isDirectory() && EditLibraryDialog.this.w.acceptsExtension(virtualFile.getExtension())) {
                    collection.add(virtualFile);
                }
                return true;
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/webcore/libraries/ui/EditLibraryDialog$14", "visitFile"));
            }
        });
    }

    private void a(VirtualFile virtualFile, boolean bl2) {
        int n2 = this.t.addFile(virtualFile);
        this.l.setRowSelectionInterval(n2, n2);
        if (bl2) {
            TableUtil.scrollSelectionToVisible((JTable)this.l);
        }
    }

    private void m() {
        int[] nArray = this.l.getSelectedRows();
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        for (int n2 : nArray) {
            arrayList.add(this.t.getFileAt(n2));
        }
        this.t.removeFiles(arrayList);
    }

    public VirtualFile[] getSourceFiles() {
        return this.t.a();
    }

    public VirtualFile[] getCompactFiles() {
        return this.t.getCompactFiles();
    }

    public String[] getDocUrls() {
        return this.f.getDocUrls();
    }

    protected void doOKAction() {
        if (!EditLibraryDialog.a(this.d.getText())) {
            Messages.showErrorDialog((Project)this.x, (String)IdeBundle.message((String)"scripting.lib.invalid.name", (Object[])new Object[0]), (String)"Error");
            return;
        }
        super.doOKAction();
    }

    private static boolean a(String string) {
        return string != null && string.matches("\\w[\\w\\d\\._\\-\\d ]*");
    }

    private void g() {
        String string = (String)this.j.getSelectedValue();
        int n2 = this.j.getSelectedIndex();
        VirtualFile virtualFile = Util.showSpecifyJavadocUrlDialog((JComponent)this.v, (String)string);
        if (virtualFile != null && virtualFile.isValid()) {
            String string2 = virtualFile.getUrl();
            this.f.replaceUrl(string, string2);
            this.j.ensureIndexIsVisible(n2);
            this.j.setSelectedIndex(n2);
            this.b();
        }
    }

    private void l() {
        VirtualFile virtualFile;
        String string = null;
        if (this.h == null) {
            this.j();
        }
        if (this.h != null) {
            string = this.d();
        }
        if ((virtualFile = Util.showSpecifyJavadocUrlDialog((JComponent)this.v, (String)(string != null ? string : ""))) != null && virtualFile.isValid()) {
            String string2 = virtualFile.getUrl();
            int n2 = this.f.addUrl(string2);
            this.j.ensureIndexIsVisible(n2);
            this.j.setSelectedIndex(n2);
            this.b();
        }
    }

    public JComponent getPreferredFocusedComponent() {
        return this.d;
    }

    @Nullable
    private String d() {
        String string = this.w.getDefaultDocUrl(this.h);
        if (string != null && !this.f.contains(string)) {
            return string;
        }
        return null;
    }

    private void e() {
        this.f.remove((String)this.j.getSelectedValue());
    }

    @Nullable
    public ScriptingFrameworkDescriptor getSelectedFramework() {
        return this.h;
    }

    private void j() {
        ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
        arrayList.addAll(Arrays.asList(this.t.getCompactFiles()));
        arrayList.addAll(Arrays.asList(this.t.a()));
        for (VirtualFile virtualFile : arrayList) {
            ScriptingFrameworkDescriptor scriptingFrameworkDescriptor = this.w.detectFramework(virtualFile);
            if (scriptingFrameworkDescriptor == null) continue;
            this.o.setText(scriptingFrameworkDescriptor.getFrameworkVersion());
            this.a(scriptingFrameworkDescriptor);
            if (this.d.getText().isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(scriptingFrameworkDescriptor.getFrameworkName());
                if (scriptingFrameworkDescriptor.getFrameworkVersion() != null) {
                    stringBuilder.append(' ').append(scriptingFrameworkDescriptor.getFrameworkVersion());
                }
                this.d.setText(stringBuilder.toString());
            }
            return;
        }
    }

    private void i() {
        if (this.h != null) {
            this.h.setFrameworkVersion(this.o.getText());
        }
    }

    @NotNull
    public ScriptingLibraryModel.LibraryLevel getLibraryLevel() {
        ScriptingLibraryModel.LibraryLevel libraryLevel = this.y.isSelected() ? ScriptingLibraryModel.LibraryLevel.GLOBAL : ScriptingLibraryModel.LibraryLevel.PROJECT;
        if (libraryLevel == null) {
            EditLibraryDialog.a(3);
        }
        return libraryLevel;
    }

    static /* synthetic */ Comparator access$2400() {
        return i;
    }

    private static /* synthetic */ void a(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                n3 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/webcore/libraries/ui/EditLibraryDialog";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urls";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filesToAdd";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getAddFilesActions";
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/webcore/libraries/ui/EditLibraryDialog";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLibraryLevel";
                break;
            }
        }
        switch (n2) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "processUrlQueue";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addVirtualFiles";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processUrlQueue$2";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private /* synthetic */ void c() {
        JPanel jPanel;
        JPanel jPanel2;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        JTextField jTextField;
        JComboBox jComboBox;
        JTextField jTextField2;
        JPanel jPanel3;
        this.v = jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 5, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 0, null, null, null));
        this.d = jTextField2 = new JTextField();
        jPanel4.add((Component)jTextField2, new GridConstraints(0, 1, 1, 4, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel = new JLabel();
        this.a(jLabel, ResourceBundle.getBundle("messages/IdeBundle").getString("scripting.lib.name"));
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Framework type:");
        jLabel2.setDisplayedMnemonic('F');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.b = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Version:");
        jLabel3.setDisplayedMnemonic('V');
        jLabel3.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel3, new GridConstraints(1, 2, 1, 1, 8, 0, 0, 0, null, null, null));
        this.o = jTextField = new JTextField();
        jPanel4.add((Component)jTextField, new GridConstraints(1, 3, 1, 1, 8, 1, 6, 0, null, new Dimension(55, -1), new Dimension(55, -1)));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Visibility:");
        jPanel4.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(1, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel4.add((Component)jPanel5, new GridConstraints(2, 1, 1, 4, 0, 3, 3, 3, null, null, null));
        this.u = jRadioButton2 = new JRadioButton();
        jRadioButton2.setSelected(true);
        jRadioButton2.setText("Project");
        jRadioButton2.setMnemonic('P');
        jRadioButton2.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jRadioButton2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.y = jRadioButton = new JRadioButton();
        jRadioButton.setText("Global");
        jRadioButton.setMnemonic('G');
        jRadioButton.setDisplayedMnemonicIndex(0);
        jPanel5.add((Component)jRadioButton, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel5.add((Component)spacer, new GridConstraints(0, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel4.add((Component)spacer2, new GridConstraints(1, 4, 1, 1, 0, 1, 6, 1, null, null, null));
        this.r = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel2.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 2, 7, null, null, null));
        JPanel jPanel6 = new JPanel();
        jPanel6.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel6.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithoutIndent");
        jPanel3.add((Component)jPanel6, new GridConstraints(2, 0, 1, 1, 0, 3, 3, 2, null, null, null));
        jPanel6.setBorder(IdeBorderFactory.PlainSmallWithoutIndent.createTitledBorder(null, (String)ResourceBundle.getBundle("messages/IdeBundle").getString("scripting.lib.docUrl.title"), (int)0, (int)0, null, null));
        this.m = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jPanel6.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 7, 3, null, null, null));
        jLabel.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jComboBox);
        jLabel3.setLabelFor(jTextField);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.v;
    }

    private /* synthetic */ void a(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl2 = false;
        char c2 = '\u0000';
        int n2 = -1;
        for (int i2 = 0; i2 < string.length(); ++i2) {
            if (string.charAt(i2) == '&') {
                if (++i2 == string.length()) break;
                if (!bl2 && string.charAt(i2) != '&') {
                    bl2 = true;
                    c2 = string.charAt(i2);
                    n2 = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i2));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl2) {
            jLabel.setDisplayedMnemonic(c2);
            jLabel.setDisplayedMnemonicIndex(n2);
        }
    }

    private static class MyDocUrlListModel
    extends AbstractListModel {
        private final ArrayList<String> a = new ArrayList();

        private MyDocUrlListModel() {
        }

        public void setDocUrls(Set<String> set) {
            if (set != null && set.size() > 0) {
                this.a.addAll(set);
            }
        }

        @Override
        public int getSize() {
            return this.a.size();
        }

        @Override
        public Object getElementAt(int n2) {
            return this.a.get(n2);
        }

        public int addUrl(String string) {
            if (!this.a.contains(string)) {
                this.a.add(string);
                int n2 = this.a.indexOf(string);
                this.fireIntervalAdded(this, n2, n2);
                return n2;
            }
            return this.a.indexOf(string);
        }

        public void replaceUrl(String string, String string2) {
            if (string == null || !this.a.contains(string)) {
                return;
            }
            int n2 = this.a.indexOf(string);
            this.a.remove(string);
            this.a.add(n2, string2);
        }

        public int indexOf(String string) {
            return this.a.indexOf(string);
        }

        public void remove(String string) {
            if (string == null || !this.a.contains(string)) {
                return;
            }
            int n2 = this.a.indexOf(string);
            this.a.remove(string);
            this.fireIntervalRemoved(this, n2, n2);
        }

        public boolean contains(String string) {
            return this.a.contains(string);
        }

        public String[] getDocUrls() {
            return ArrayUtil.toStringArray(this.a);
        }
    }

    private class FileTableModel
    extends AbstractTableModel {
        private final SortedList<VirtualFile> b = new SortedList(EditLibraryDialog.access$2400());
        private final HashSet<VirtualFile> a = new HashSet();

        private FileTableModel() {
        }

        @Override
        public String getColumnName(int n2) {
            switch (n2) {
                case 0: {
                    return IdeBundle.message((String)"scripting.lib.file.name", (Object[])new Object[0]);
                }
                case 1: {
                    return IdeBundle.message((String)"scripting.lib.file.type", (Object[])new Object[0]);
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            VirtualFile virtualFile;
            return n3 == 1 && (virtualFile = this.getFileAt(n2)) != null && !virtualFile.isDirectory();
        }

        @Override
        public void setValueAt(Object object, int n2, int n3) {
            VirtualFile virtualFile;
            if (n3 == 1 && (virtualFile = EditLibraryDialog.this.t.getFileAt(n2)) != null) {
                this.a(virtualFile, EditLibraryDialog.this.k.equals(object));
            }
        }

        public int addFile(VirtualFile virtualFile) {
            this.b.add((Object)virtualFile);
            if (!virtualFile.isDirectory() && EditLibraryDialog.this.w.isCompact(virtualFile)) {
                this.a.add(virtualFile);
            }
            this.fireTableDataChanged();
            return this.b.indexOf((Object)virtualFile);
        }

        public void setFiles(Set<VirtualFile> set, Set<VirtualFile> set2) {
            this.b.clear();
            this.b.addAll(set);
            this.b.addAll(set2);
            for (VirtualFile virtualFile : set) {
                this.a(virtualFile, false, false);
            }
            for (VirtualFile virtualFile : set2) {
                this.a(virtualFile, true, false);
            }
        }

        private void a(VirtualFile virtualFile, boolean bl2) {
            this.a(virtualFile, bl2, true);
        }

        private void a(VirtualFile virtualFile, boolean bl2, boolean bl3) {
            boolean bl4 = false;
            if (bl2 && !virtualFile.isDirectory()) {
                if (!this.a.contains(virtualFile)) {
                    this.a.add(virtualFile);
                    bl4 = true;
                }
            } else if (this.a.contains(virtualFile)) {
                this.a.remove(virtualFile);
                bl4 = true;
            }
            if (bl4 && bl3) {
                this.fireTableDataChanged();
            }
        }

        @Override
        public int getRowCount() {
            return this.b.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            VirtualFile virtualFile = (VirtualFile)this.b.get(n2);
            switch (n3) {
                case 0: {
                    return virtualFile.getPresentableName();
                }
                case 1: {
                    return this.a.contains(virtualFile) ? EditLibraryDialog.this.k : EditLibraryDialog.this.s;
                }
            }
            return "";
        }

        @Nullable
        public VirtualFile getFileAt(int n2) {
            if (n2 < 0 || n2 >= this.b.size()) {
                return null;
            }
            return (VirtualFile)this.b.get(n2);
        }

        public void removeFile(VirtualFile virtualFile) {
            if (this.b.remove((Object)virtualFile)) {
                this.fireTableDataChanged();
            }
        }

        public void removeFiles(List<VirtualFile> list2) {
            if (this.b.removeAll(list2)) {
                this.fireTableDataChanged();
            }
        }

        private VirtualFile[] a(boolean bl2) {
            ArrayList<VirtualFile> arrayList = new ArrayList<VirtualFile>();
            for (VirtualFile virtualFile : this.b) {
                if (this.a.contains(virtualFile) != bl2) continue;
                arrayList.add(virtualFile);
            }
            return arrayList.toArray(VirtualFile.EMPTY_ARRAY);
        }

        public VirtualFile[] getCompactFiles() {
            return this.a(true);
        }

        private VirtualFile[] a() {
            return this.a(false);
        }
    }

    private class TypeCellEditor
    extends AbstractTableCellEditor {
        private final JBComboBoxTableCellEditorComponent a = new JBComboBoxTableCellEditorComponent();

        public TypeCellEditor() {
            this.a.setOptions(new Object[]{EditLibraryDialog.this.s, EditLibraryDialog.this.k});
            this.a.setToString(object -> (String)object);
        }

        public Object getCellEditorValue() {
            return this.a.getEditorValue();
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl2, int n2, int n3) {
            VirtualFile virtualFile = EditLibraryDialog.this.t.getFileAt(n2);
            this.a.setCell(jTable, n2, n3);
            if (virtualFile != null) {
                Object object2 = EditLibraryDialog.this.t.getValueAt(n2, 1);
                this.a.setDefaultValue(object2);
            }
            return this.a;
        }
    }

    private class FileNameTableCellRenderer
    extends DefaultTableCellRenderer {
        private FileNameTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl2, boolean bl3, int n2, int n3) {
            Component component = super.getTableCellRendererComponent(jTable, object, bl2, bl3, n2, n3);
            if (component instanceof JLabel) {
                JLabel jLabel = (JLabel)component;
                VirtualFile virtualFile = EditLibraryDialog.this.t.getFileAt(n2);
                if (virtualFile != null) {
                    jLabel.setToolTipText(virtualFile.getPresentableUrl());
                    jLabel.setIcon(virtualFile.isDirectory() ? EditLibraryDialog.this.g : EditLibraryDialog.this.c);
                }
                jLabel.setBorder(null);
            }
            return component;
        }
    }
}

