/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.libraries.ui;

import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.webcore.libraries.ScriptingLibraryManager;
import com.intellij.webcore.libraries.ScriptingLibraryMappings;
import com.intellij.webcore.libraries.ScriptingLibraryModel;
import com.intellij.webcore.libraries.ScriptingLibraryTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.table.AbstractTableModel;
import org.jetbrains.annotations.Nullable;

public class ScriptingLibraryTableModel
extends AbstractTableModel {
    public static final int LIB_ENABLED_COL = 0;
    public static final int LIB_NAME_COL = 1;
    public static final int LIB_TYPE_COL = 2;
    private final ScriptingLibraryManager a;
    private LibraryScope[] d;
    private final ScriptingLibraryMappings b;
    private boolean c;

    public ScriptingLibraryTableModel(ScriptingLibraryManager scriptingLibraryManager, ScriptingLibraryMappings scriptingLibraryMappings) {
        this.a = scriptingLibraryManager;
        this.b = scriptingLibraryMappings;
        this.c = false;
        this.d = this.getLibrariesScopes();
    }

    public void resetTable() {
        this.b.reset();
        this.d = this.getLibrariesScopes();
        this.c = false;
        this.fireTableDataChanged();
    }

    @Override
    public int getRowCount() {
        return this.d.length;
    }

    @Override
    public int getColumnCount() {
        return 3;
    }

    @Override
    public boolean isCellEditable(int n2, int n3) {
        return n3 == 0;
    }

    @Override
    public Object getValueAt(int n2, int n3) {
        LibraryScope libraryScope = this.d[n2];
        assert (libraryScope != null);
        switch (n3) {
            case 0: {
                return libraryScope.myState;
            }
            case 1: {
                return libraryScope.myLibrary.getName();
            }
            case 2: {
                switch (libraryScope.myLibrary.getLibraryLevel()) {
                    case PREDEFINED: {
                        return "Predefined";
                    }
                    case GLOBAL: {
                        return "Global";
                    }
                    case PROJECT: {
                        return "Project";
                    }
                }
            }
        }
        return "?";
    }

    @Override
    public void setValueAt(Object object, int n2, int n3) {
        this.c = true;
        switch (n3) {
            case 0: {
                if (!(object instanceof Boolean)) break;
                LibraryScope libraryScope = this.d[n2];
                libraryScope.myState = Boolean.TRUE.equals(object) ? EnabledState.ON : EnabledState.OFF;
            }
        }
        this.fireTableCellUpdated(n2, n3);
    }

    @Override
    public String getColumnName(int n2) {
        switch (n2) {
            case 0: {
                return "Enabled";
            }
            case 1: {
                return "Name";
            }
            case 2: {
                return "Type";
            }
        }
        return "?";
    }

    public void applyChanges() {
        Set set = this.b.getMappings().keySet();
        for (LibraryScope libraryScope : this.d) {
            String string = libraryScope.myLibrary.getName();
            if (libraryScope.myState == EnabledState.ON && !this.b.isAssociatedWithProject(string)) {
                this.b.associate(null, string, libraryScope.myLibrary.isPredefined());
                continue;
            }
            if (libraryScope.myState != EnabledState.OFF) continue;
            this.b.disassociate(null, string);
            for (VirtualFile virtualFile : set) {
                if (!this.b.isAssociatedWith(virtualFile, string)) continue;
                this.b.disassociate(virtualFile, string);
            }
        }
    }

    public void applyMappings() {
        Map map = this.b.getMappings();
        for (Map.Entry entry : map.entrySet()) {
            if (!(entry.getValue() instanceof ScriptingLibraryMappings.CompoundLibrary)) continue;
            ScriptingLibraryMappings.CompoundLibrary compoundLibrary = (ScriptingLibraryMappings.CompoundLibrary)entry.getValue();
            List list2 = ContainerUtil.map((Collection)compoundLibrary.getLibraries(), scriptingLibraryModel -> scriptingLibraryModel.getName());
            for (LibraryScope libraryScope : this.d) {
                if (libraryScope.myState == EnabledState.OFF && list2.contains(libraryScope.myLibrary.getName())) {
                    compoundLibrary.toggleLibrary(libraryScope.myLibrary);
                    continue;
                }
                if (libraryScope.myState != EnabledState.ON || entry.getKey() != null || list2.contains(libraryScope.myLibrary.getName())) continue;
                compoundLibrary.toggleLibrary(libraryScope.myLibrary);
            }
        }
    }

    public ScriptingLibraryModel createLibrary(String string, VirtualFile[] virtualFileArray, VirtualFile[] virtualFileArray2, String[] stringArray, ScriptingLibraryModel.LibraryLevel libraryLevel, boolean bl2) {
        return (ScriptingLibraryModel)WriteAction.compute(() -> {
            ScriptingLibraryModel scriptingLibraryModel = this.a.createLibrary(string, virtualFileArray, virtualFileArray2, stringArray, libraryLevel, bl2);
            this.fireLibTableChanged(true);
            for (int i2 = 0; i2 < this.d.length; ++i2) {
                LibraryScope libraryScope = this.d[i2];
                if (libraryScope.myLibrary != scriptingLibraryModel) continue;
                this.setValueAt(Boolean.TRUE, i2, 0);
                break;
            }
            return scriptingLibraryModel;
        });
    }

    @Nullable
    public ScriptingLibraryModel getLibrary(String string) {
        ScriptingLibraryTable scriptingLibraryTable = this.a.getScriptingLibraryTable();
        return scriptingLibraryTable.getLibraryByName(string);
    }

    public int getLibraryIndex(String string) {
        int n2 = 0;
        for (LibraryScope libraryScope : this.d) {
            if (libraryScope.myLibrary.getName().equals(string)) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    public void removeLibrary(String string) {
        ScriptingLibraryModel scriptingLibraryModel = this.getLibrary(string);
        if (scriptingLibraryModel != null) {
            this.a.removeLibrary(scriptingLibraryModel);
            this.fireLibTableChanged(true);
        }
    }

    @Nullable
    public ScriptingLibraryModel updateLibrary(String string, String string2, VirtualFile[] virtualFileArray, VirtualFile[] virtualFileArray2, String[] stringArray) {
        return (ScriptingLibraryModel)WriteAction.compute(() -> {
            ScriptingLibraryModel scriptingLibraryModel = this.a.updateLibrary(string, string2, virtualFileArray, virtualFileArray2, stringArray);
            this.c = true;
            this.fireTableDataChanged();
            return scriptingLibraryModel;
        });
    }

    public void fireLibTableChanged(boolean bl2) {
        this.c = true;
        LibraryScope[] libraryScopeArray = this.getLibrariesScopes();
        if (bl2) {
            for (LibraryScope libraryScope : libraryScopeArray) {
                for (LibraryScope libraryScope2 : this.d) {
                    if (!libraryScope2.myLibrary.getName().equals(libraryScope.myLibrary.getName())) continue;
                    libraryScope.myState = libraryScope2.myState;
                }
            }
        }
        this.d = libraryScopeArray;
        this.fireTableDataChanged();
    }

    @Nullable
    public String getLibNameAt(int n2) {
        ScriptingLibraryModel scriptingLibraryModel = this.d[n2].myLibrary;
        return scriptingLibraryModel != null ? scriptingLibraryModel.getName() : null;
    }

    @Nullable
    public ScriptingLibraryModel getLibraryAt(int n2) {
        return this.d[n2].myLibrary;
    }

    public boolean isChanged() {
        return this.c;
    }

    private static ScriptingLibraryModel[] a(ScriptingLibraryTable scriptingLibraryTable) {
        ArrayList<ScriptingLibraryModel> arrayList = new ArrayList<ScriptingLibraryModel>();
        for (ScriptingLibraryModel scriptingLibraryModel3 : scriptingLibraryTable.getAllLibraries()) {
            if (scriptingLibraryModel3 == null) continue;
            arrayList.add(scriptingLibraryModel3);
        }
        Collections.sort(arrayList, (scriptingLibraryModel, scriptingLibraryModel2) -> {
            if (scriptingLibraryModel.isPredefined() != scriptingLibraryModel2.isPredefined()) {
                return (scriptingLibraryModel.isPredefined() ? 1 : 0) - (scriptingLibraryModel2.isPredefined() ? 1 : 0);
            }
            return scriptingLibraryModel.getName().compareToIgnoreCase(scriptingLibraryModel2.getName());
        });
        return arrayList.toArray(new ScriptingLibraryModel[0]);
    }

    public LibraryScope[] getLibrariesScopes() {
        Object object;
        Object object2;
        Map map = this.b.getMappings();
        HashMap<String, HashSet<VirtualFile>> hashMap = new HashMap<String, HashSet<VirtualFile>>();
        for (Map.Entry libraryScopeArray2 : map.entrySet()) {
            VirtualFile i2 = (VirtualFile)libraryScopeArray2.getKey();
            object2 = (ScriptingLibraryModel)libraryScopeArray2.getValue();
            if (!(object2 instanceof ScriptingLibraryMappings.CompoundLibrary)) continue;
            object = (ScriptingLibraryMappings.CompoundLibrary)object2;
            Collection collection = object.getLibraries();
            VirtualFile virtualFile = collection.iterator();
            while (virtualFile.hasNext()) {
                ScriptingLibraryModel scriptingLibraryModel = (ScriptingLibraryModel)virtualFile.next();
                HashSet<VirtualFile> hashSet = (HashSet<VirtualFile>)hashMap.get(scriptingLibraryModel.getName());
                if (hashSet == null) {
                    hashSet = new HashSet<VirtualFile>();
                    hashMap.put(scriptingLibraryModel.getName(), hashSet);
                }
                hashSet.add(i2);
            }
        }
        ScriptingLibraryModel[] scriptingLibraryModelArray = ScriptingLibraryTableModel.a(this.a.getScriptingLibraryTable());
        LibraryScope[] libraryScopeArray = new LibraryScope[scriptingLibraryModelArray.length];
        for (int i2 = 0; i2 < scriptingLibraryModelArray.length; ++i2) {
            object2 = EnabledState.OFF;
            object = scriptingLibraryModelArray[i2].getName();
            if (hashMap.containsKey(object)) {
                if (this.b.isAssociatedWithProject((String)object)) {
                    object2 = EnabledState.ON;
                } else {
                    for (VirtualFile virtualFile : (Set)hashMap.get(object)) {
                        if (virtualFile == null) continue;
                        object2 = EnabledState.PARTLY;
                        break;
                    }
                }
            }
            libraryScopeArray[i2] = new LibraryScope(scriptingLibraryModelArray[i2], (EnabledState)((Object)object2));
        }
        return libraryScopeArray;
    }

    private static class LibraryScope {
        public ScriptingLibraryModel myLibrary;
        public EnabledState myState;

        private LibraryScope(ScriptingLibraryModel scriptingLibraryModel, EnabledState enabledState) {
            this.myLibrary = scriptingLibraryModel;
            this.myState = enabledState;
        }
    }

    public static enum EnabledState {
        ON,
        PARTLY,
        OFF;

    }
}

