/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.webcore.resourceRoots;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.MultiMap;
import com.intellij.webcore.resourceRoots.WebResourcesPathsConfiguration;
import java.util.Collection;

public class MarkResourceRootActionBase
extends AnAction {
    private static final Logger b = Logger.getInstance(MarkResourceRootActionBase.class);
    private final boolean a;

    public MarkResourceRootActionBase(boolean bl2, String string) {
        super(string);
        this.a = bl2;
    }

    public void update(AnActionEvent anActionEvent) {
        boolean bl2 = this.a(anActionEvent);
        anActionEvent.getPresentation().setVisible(bl2);
        anActionEvent.getPresentation().setEnabled(bl2);
    }

    public void actionPerformed(AnActionEvent anActionEvent) {
        Project project2 = (Project)anActionEvent.getData(CommonDataKeys.PROJECT);
        VirtualFile[] virtualFileArray = (VirtualFile[])anActionEvent.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (project2 == null) {
            b.warn("Can not resolve a project (null)");
            return;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        WebResourcesPathsConfiguration webResourcesPathsConfiguration = WebResourcesPathsConfiguration.getInstance(project2);
        MultiMap<String, String> multiMap = webResourcesPathsConfiguration.getResourceRoots();
        assert (virtualFileArray != null);
        for (VirtualFile virtualFile : virtualFileArray) {
            String string = projectFileIndex.getContentRootForFile(virtualFile).getUrl();
            if (this.a) {
                multiMap.putValue((Object)string, (Object)virtualFile.getUrl());
                continue;
            }
            multiMap.remove((Object)string, (Object)virtualFile.getUrl());
        }
        webResourcesPathsConfiguration.setResourceRoots(multiMap);
    }

    private boolean a(AnActionEvent anActionEvent) {
        Module module2 = (Module)anActionEvent.getData(LangDataKeys.MODULE);
        VirtualFile[] virtualFileArray = (VirtualFile[])anActionEvent.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (module2 == null || virtualFileArray == null) {
            return false;
        }
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)module2.getProject()).getFileIndex();
        for (VirtualFile virtualFile : virtualFileArray) {
            if (!virtualFile.isDirectory()) {
                return false;
            }
            if (!projectFileIndex.isInContent(virtualFile)) {
                return false;
            }
            WebResourcesPathsConfiguration webResourcesPathsConfiguration = WebResourcesPathsConfiguration.getInstance(module2.getProject());
            if (webResourcesPathsConfiguration != null) {
                MultiMap<String, String> multiMap = webResourcesPathsConfiguration.getResourceRoots();
                Collection collection = multiMap.get((Object)projectFileIndex.getContentRootForFile(virtualFile).getUrl());
                if (this.a != collection.contains(virtualFile.getUrl())) continue;
                return false;
            }
            b.warn("Can not get configuration for " + module2.getProject());
            return false;
        }
        return true;
    }
}

