/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.rpp.addproperty;

import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.JBColor;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.util.IncorrectOperationException;
import com.sixrr.rpp.RefactorJConfig;
import com.sixrr.rpp.utils.StringUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

class AddPropertyDialog
extends RefactoringDialog {
    private JCheckBox e;
    private JCheckBox g;
    private JCheckBox a;
    private JCheckBox f;
    private JTextField h;
    private JTextField c;
    private JTextField d;
    private final PsiClass b;

    AddPropertyDialog(PsiClass psiClass) {
        super(psiClass.getProject(), true);
        this.setModal(true);
        this.b = psiClass;
        this.setTitle(RefactorJBundle.message((String)"add.property", (Object[])new Object[0]));
        this.init();
        RefactorJConfig refactorJConfig = RefactorJConfig.getInstance();
        this.e.setSelected(refactorJConfig.ADD_PROPERTY_ADD_SETTER);
        this.g.setSelected(refactorJConfig.ADD_PROPERTY_ADD_GETTER);
        this.f.setSelected(refactorJConfig.ADD_PROPERTY_ADD_TO_CONSTRUCTOR);
        this.a.setSelected(false);
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AddPropertyDialog.this.validateButtons();
            }
        });
        DocumentAdapter documentAdapter = new DocumentAdapter(){

            protected void textChanged(DocumentEvent documentEvent) {
                AddPropertyDialog.this.validateButtons();
            }
        };
        this.h.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.c.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.d.getDocument().addDocumentListener((DocumentListener)documentAdapter);
        this.validateButtons();
    }

    protected String getDimensionServiceKey() {
        return "RefactorJ.AddProperty";
    }

    protected JComponent createCenterPanel() {
        JPanel jPanel = new JPanel();
        String string = RefactorJBundle.message((String)"add.property.dialog.title", (Object[])new Object[]{this.b.getName()});
        IdeaTitledBorder ideaTitledBorder = IdeBorderFactory.createTitledBorder((String)string, (boolean)true);
        jPanel.setBorder((Border)ideaTitledBorder);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)new JLabel(RefactorJBundle.message((String)"property.name.field.label", (Object[])new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.h = new JTextField(30);
        jPanel.add((Component)this.h, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)new JLabel(RefactorJBundle.message((String)"property.type.field.label", (Object[])new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.c = new JTextField(30);
        jPanel.add((Component)this.c, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        this.g = new JCheckBox(RefactorJBundle.message((String)"create.property.getter.checkbox", (Object[])new Object[0]));
        jPanel.add((Component)this.g, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        this.e = new JCheckBox(RefactorJBundle.message((String)"create.property.setter.checkbox", (Object[])new Object[0]));
        jPanel.add((Component)this.e, gridBagConstraints);
        gridBagConstraints.gridy = 4;
        this.f = new JCheckBox(RefactorJBundle.message((String)"add.property.to.constructors.checkbox", (Object[])new Object[0]));
        jPanel.add((Component)this.f, gridBagConstraints);
        gridBagConstraints.gridy = 5;
        this.a = new JCheckBox(RefactorJBundle.message((String)"make.property.final.checkbox", (Object[])new Object[0]));
        jPanel.add((Component)this.a, gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridy = 6;
        jPanel.add((Component)new JLabel(RefactorJBundle.message((String)"initialization.expression.checkbox", (Object[])new Object[0])), gridBagConstraints);
        gridBagConstraints.gridx = 1;
        this.d = new JTextField(30);
        jPanel.add((Component)this.d, gridBagConstraints);
        return jPanel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.h;
    }

    protected void doHelpAction() {
        HelpManager helpManager = HelpManager.getInstance();
        helpManager.invokeHelp("refactorj.addProperty");
    }

    protected void doAction() {
    }

    protected boolean areButtonsValid() {
        return this.b() && this.c() && this.a();
    }

    private boolean b() {
        String string = this.getInitializationExpression();
        if (string.length() == 0) {
            return true;
        }
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)this.b.getManager().getProject()).getElementFactory();
        try {
            psiElementFactory.createExpressionFromText(string, (PsiElement)this.b);
            return true;
        }
        catch (IncorrectOperationException incorrectOperationException) {
            return false;
        }
    }

    private boolean a() {
        String string = this.getFieldType();
        if (string.length() == 0) {
            return false;
        }
        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)this.b.getManager().getProject()).getElementFactory();
        try {
            psiElementFactory.createTypeFromText(string, (PsiElement)this.b);
            return true;
        }
        catch (IncorrectOperationException incorrectOperationException) {
            return false;
        }
    }

    private boolean c() {
        String string = this.getFieldName();
        if (string.length() == 0) {
            return false;
        }
        if (StringUtils.isKeyword(string)) {
            return false;
        }
        return string.matches("[a-zA-Z0-9_]*");
    }

    protected void validateButtons() {
        if (this.b()) {
            this.d.setForeground(JBColor.foreground());
        } else {
            this.d.setForeground((Color)JBColor.RED);
        }
        if (this.c()) {
            this.h.setForeground(JBColor.foreground());
        } else {
            this.h.setForeground((Color)JBColor.RED);
        }
        if (this.a()) {
            this.c.setForeground(JBColor.foreground());
        } else {
            this.c.setForeground((Color)JBColor.RED);
        }
        this.a.setEnabled(!this.e.isSelected());
        super.validateButtons();
    }

    public boolean getAddSetter() {
        return this.e.isSelected();
    }

    public boolean getAddGetter() {
        return this.g.isSelected();
    }

    public String getInitializationExpression() {
        return this.d.getText();
    }

    public String getFieldName() {
        return this.h.getText().trim();
    }

    public String getFieldType() {
        return this.c.getText().trim();
    }

    public boolean getAddToConstructor() {
        return this.f.isSelected();
    }

    public boolean getMakeFinal() {
        return this.a.isSelected() && !this.e.isSelected();
    }
}

