/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.rpp.pushannotationdown;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.psi.MethodInheritanceUtils;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.sixrr.rpp.RefactorJConfig;
import com.sixrr.rpp.pushannotationdown.PushAnnotationDownDialog;
import org.jetbrains.annotations.NotNull;

class PushAnnotationDownHandler
implements RefactoringActionHandler {
    PushAnnotationDownHandler() {
    }

    protected String getRefactoringName() {
        return RefactorJBundle.message((String)"push.annotation.down", (Object[])new Object[0]);
    }

    protected String getHelpID() {
        return "refactorj.pushAnnotationDown";
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile psiFile, DataContext dataContext) {
        PsiParameter psiParameter;
        if (project2 == null) {
            PushAnnotationDownHandler.a(0);
        }
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        CaretModel caretModel = editor.getCaretModel();
        int n2 = caretModel.getOffset();
        PsiElement psiElement = psiFile.findElementAt(n2);
        PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiAnnotation.class, (boolean)false);
        if (psiAnnotation == null) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)RefactorJBundle.message((String)"0.the.caret.should.be.positioned.at.an.annotation.to.be.refactored.to.be.refactored", (Object[])new Object[]{RefactorJBundle.message((String)"cannot.perform.the.refactoring", (Object[])new Object[0])}), null, (String)this.getHelpID());
            return;
        }
        PsiElement psiElement2 = psiAnnotation.getParent().getParent();
        if (!(psiElement2 instanceof PsiClass || psiElement2 instanceof PsiMethod || psiElement2 instanceof PsiParameter)) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)(RefactorJBundle.message((String)"cannot.perform.the.refactoring", (Object[])new Object[0]) + RefactorJBundle.message((String)"can.only.push.annotations.down.on.methods.parameters.and.classes", (Object[])new Object[0])), null, (String)this.getHelpID());
            return;
        }
        if (psiElement2 instanceof PsiClass && ((PsiClass[])(psiParameter = MethodInheritanceUtils.getNonLibrarySubClasses((PsiClass)((PsiClass)psiElement2)))).length == 0) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)(RefactorJBundle.message((String)"cannot.perform.the.refactoring", (Object[])new Object[0]) + RefactorJBundle.message((String)"can.not.find.any.available.subclasses.for.the.selected.class", (Object[])new Object[0])), null, (String)this.getHelpID());
            return;
        }
        if (psiElement2 instanceof PsiMethod && ((PsiClass[])(psiParameter = MethodInheritanceUtils.findAvailableSubClassesForMethod((PsiMethod)((PsiMethod)psiElement2)))).length == 0) {
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)(RefactorJBundle.message((String)"cannot.perform.the.refactoring", (Object[])new Object[0]) + RefactorJBundle.message((String)"can.not.find.any.available.overriding.methods.for.the.selected.method", (Object[])new Object[0])), null, (String)this.getHelpID());
            return;
        }
        if (psiElement2 instanceof PsiParameter) {
            psiParameter = (PsiParameter)psiElement2;
            PsiElement psiElement3 = psiParameter.getDeclarationScope();
            if (!(psiElement3 instanceof PsiMethod)) {
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)(RefactorJBundle.message((String)"cannot.perform.the.refactoring", (Object[])new Object[0]) + RefactorJBundle.message((String)"can.only.push.annotations.down.on.methods.parameters.and.classes", (Object[])new Object[0])), null, (String)this.getHelpID());
                return;
            }
            PsiClass[] psiClassArray = MethodInheritanceUtils.findAvailableSubClassesForMethod((PsiMethod)((PsiMethod)psiElement3));
            if (psiClassArray.length == 0) {
                CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)(RefactorJBundle.message((String)"cannot.perform.the.refactoring", (Object[])new Object[0]) + RefactorJBundle.message((String)"can.not.find.any.available.overriding.methods.for.the.selected.method", (Object[])new Object[0])), null, (String)this.getHelpID());
                return;
            }
        }
        this.a(psiAnnotation, project2);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] psiElementArray, DataContext dataContext) {
        if (project2 == null) {
            PushAnnotationDownHandler.a(1);
        }
        if (psiElementArray == null) {
            PushAnnotationDownHandler.a(2);
        }
        if (psiElementArray.length != 1) {
            return;
        }
        PsiAnnotation psiAnnotation = (PsiAnnotation)PsiTreeUtil.getParentOfType((PsiElement)psiElementArray[0], PsiAnnotation.class, (boolean)false);
        if (psiAnnotation == null) {
            return;
        }
        this.a(psiAnnotation, project2);
    }

    private void a(PsiAnnotation psiAnnotation, Project project2) {
        PushAnnotationDownDialog pushAnnotationDownDialog = new PushAnnotationDownDialog(psiAnnotation);
        if (!pushAnnotationDownDialog.showAndGet()) {
            return;
        }
        boolean bl2 = pushAnnotationDownDialog.isPreviewUsages();
        boolean bl3 = pushAnnotationDownDialog.getReplaceExistingAnnotation();
        boolean bl4 = pushAnnotationDownDialog.getDeleteSelectedAnnotation();
        RefactorJConfig refactorJConfig = RefactorJConfig.getInstance();
        refactorJConfig.PUSH_ANNOTATION_DOWN_REPLACE_EXISTING_ANNOTATION = bl3;
        refactorJConfig.PUSH_ANNOTATION_DOWN_REMOVE_ANNOTATION = bl4;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/sixrr/rpp/pushannotationdown/PushAnnotationDownHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

