/*
 * Decompiled with CFR 0.152.
 */
package com.sixrr.rpp.pushjavadocdown;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactorJBundle;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.psi.SearchUtils;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.sixrr.rpp.RefactorJConfig;
import com.sixrr.rpp.pushjavadocdown.PushJavadocDownDialog;
import com.sixrr.rpp.utils.JavadocUtils;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class PushJavadocDownHandler
implements RefactoringActionHandler {
    PushJavadocDownHandler() {
    }

    protected String getRefactoringName() {
        return RefactorJBundle.message((String)"push.javadoc.down", (Object[])new Object[0]);
    }

    protected String getHelpID() {
        return "refactorj.pushJavadocDown";
    }

    public void invoke(@NotNull Project project2, Editor editor, PsiFile psiFile, DataContext dataContext) {
        if (project2 == null) {
            PushJavadocDownHandler.a(0);
        }
        ScrollingModel scrollingModel = editor.getScrollingModel();
        scrollingModel.scrollToCaret(ScrollType.MAKE_VISIBLE);
        CaretModel caretModel = editor.getCaretModel();
        int n2 = caretModel.getOffset();
        PsiElement psiElement = psiFile.findElementAt(n2);
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class, (boolean)false);
        if (psiClass == null) {
            String string = RefactorJBundle.message((String)"cannot.perform.the.refactoring", (Object[])new Object[0]) + RefactorJBundle.message((String)"the.caret.should.be.positioned.within.a.class.to.be.refactored", (Object[])new Object[0]);
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)string, null, (String)this.getHelpID());
            return;
        }
        if (psiClass.isEnum()) {
            String string = RefactorJBundle.message((String)"cannot.perform.the.refactoring", (Object[])new Object[0]) + RefactorJBundle.message((String)"the.selected.class.is.an.enumeration", (Object[])new Object[0]);
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)string, null, (String)this.getHelpID());
            return;
        }
        if (!PushJavadocDownHandler.a(psiClass)) {
            String string = RefactorJBundle.message((String)"cannot.perform.the.refactoring", (Object[])new Object[0]) + RefactorJBundle.message((String)"the.selected.class.has.no.overridden.methods.with.javadoc", (Object[])new Object[0]);
            CommonRefactoringUtil.showErrorHint((Project)project2, (Editor)editor, (String)string, null, (String)this.getHelpID());
            return;
        }
        this.a(psiClass, psiMethod, project2);
    }

    public void invoke(@NotNull Project project2, @NotNull PsiElement[] psiElementArray, DataContext dataContext) {
        if (project2 == null) {
            PushJavadocDownHandler.a(1);
        }
        if (psiElementArray == null) {
            PushJavadocDownHandler.a(2);
        }
        if (psiElementArray.length != 1) {
            return;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiElementArray[0], PsiClass.class, (boolean)false);
        PsiMethod psiMethod = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElementArray[0], PsiMethod.class, (boolean)false);
        if (psiClass == null) {
            return;
        }
        if (!PushJavadocDownHandler.a(psiClass)) {
            return;
        }
        this.a(psiClass, psiMethod, project2);
    }

    private void a(PsiClass psiClass, PsiMethod psiMethod, Project project2) {
        PushJavadocDownDialog pushJavadocDownDialog = new PushJavadocDownDialog(psiClass, psiMethod);
        if (!pushJavadocDownDialog.showAndGet()) {
            return;
        }
        boolean bl2 = pushJavadocDownDialog.isPreviewUsages();
        List<PsiMethod> list2 = pushJavadocDownDialog.getMethodsToPushDown();
        boolean bl3 = pushJavadocDownDialog.getReplaceExistingComments();
        boolean bl4 = pushJavadocDownDialog.getCreateInheritDoc();
        RefactorJConfig refactorJConfig = RefactorJConfig.getInstance();
        refactorJConfig.PUSH_JAVADOC_DOWN_ADD_INHERITDOC = bl4;
        refactorJConfig.PUSH_JAVADOC_DOWN_REPLACE_EXISTING_JAVADOC = bl3;
    }

    private static boolean a(PsiClass psiClass) {
        PsiMethod[] psiMethodArray;
        for (PsiMethod psiMethod : psiMethodArray = psiClass.getMethods()) {
            Iterable iterable;
            if (psiMethod.isConstructor() || !JavadocUtils.hasJavadoc(psiMethod) || !(iterable = SearchUtils.findOverridingMethods((PsiMethod)psiMethod)).iterator().hasNext()) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void a(int n2) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "elements";
                break;
            }
        }
        objectArray[1] = "com/sixrr/rpp/pushjavadocdown/PushJavadocDownHandler";
        objectArray[2] = "invoke";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

