/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.freemarker.psi.FtlArgumentList;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.FtlExpression;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.freemarker.psi.FtlNameValuePair;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.freemarker.psi.files.FtlFile;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlMethodType;
import com.intellij.freemarker.psi.variables.FtlParameter;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.lang.ASTNode;
import com.intellij.lang.parameterInfo.CreateParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoContext;
import com.intellij.lang.parameterInfo.ParameterInfoHandler;
import com.intellij.lang.parameterInfo.ParameterInfoUIContext;
import com.intellij.lang.parameterInfo.UpdateParameterInfoContext;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import gnu.trove.THashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlParameterInfoHandler
implements ParameterInfoHandler<FtlArgumentList, FtlCallableType>,
DumbAware {
    public boolean couldShowInLookup() {
        return true;
    }

    public Object[] getParametersForLookup(LookupElement item, ParameterInfoContext context) {
        return null;
    }

    public Object[] getParametersForDocumentation(FtlCallableType p, ParameterInfoContext context) {
        return new Object[]{p};
    }

    public FtlArgumentList findElementForParameterInfo(@NotNull CreateParameterInfoContext context) {
        if (context == null) {
            FtlParameterInfoHandler.$$$reportNull$$$0(0);
        }
        return FtlParameterInfoHandler.findArgumentList((ParameterInfoContext)context);
    }

    @Nullable
    private static FtlArgumentList findArgumentList(ParameterInfoContext context) {
        FtlArgumentList list;
        int offset = context.getOffset();
        PsiFile file = context.getFile();
        if (!(file instanceof FtlFile)) {
            return null;
        }
        PsiDocumentManager.getInstance((Project)file.getProject()).commitDocument(context.getEditor().getDocument());
        FtlMacro macro = (FtlMacro)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, FtlMacro.class, (boolean)false);
        if (macro != null) {
            PsiElement element = file.findElementAt(offset);
            if (element == null) {
                return null;
            }
            FtlArgumentList argumentList = macro.getArgumentList();
            if (PsiTreeUtil.isAncestor((PsiElement)argumentList, (PsiElement)element, (boolean)false)) {
                return argumentList;
            }
            if (element instanceof PsiWhiteSpace && element.getNextSibling() == argumentList) {
                return argumentList;
            }
            PsiElement prevSibling = element.getPrevSibling();
            if (prevSibling == argumentList) {
                return argumentList;
            }
            if (prevSibling instanceof PsiWhiteSpace && prevSibling.getPrevSibling() == argumentList && offset == element.getTextRange().getStartOffset()) {
                return argumentList;
            }
        }
        if ((list = (FtlArgumentList)PsiTreeUtil.findElementOfClassAtOffset((PsiFile)file, (int)offset, FtlArgumentList.class, (boolean)false)) != null && offset == list.getTextRange().getStartOffset()) {
            return null;
        }
        return list;
    }

    public void showParameterInfo(@NotNull FtlArgumentList element, @NotNull CreateParameterInfoContext context) {
        FtlMacro macro;
        FtlCallableType type;
        PsiElement parent;
        if (element == null) {
            FtlParameterInfoHandler.$$$reportNull$$$0(1);
        }
        if (context == null) {
            FtlParameterInfoHandler.$$$reportNull$$$0(2);
        }
        if ((parent = element.getParent()) instanceof FtlMethodCallExpression) {
            Object[] candidates = ((FtlMethodCallExpression)parent).getCallableCandidates();
            if (candidates.length == 0) {
                return;
            }
            context.setItemsToShow(candidates);
            context.showHint((PsiElement)element, element.getTextRange().getStartOffset(), (ParameterInfoHandler)this);
        }
        if (parent instanceof FtlMacro && (type = (macro = (FtlMacro)parent).getMacroType()) != null) {
            context.setItemsToShow(new Object[]{type});
            context.showHint((PsiElement)element, macro.getStartTagNameElement().getTextRange().getEndOffset(), (ParameterInfoHandler)this);
        }
    }

    public FtlArgumentList findElementForUpdatingParameterInfo(@NotNull UpdateParameterInfoContext context) {
        if (context == null) {
            FtlParameterInfoHandler.$$$reportNull$$$0(3);
        }
        return FtlParameterInfoHandler.findArgumentList((ParameterInfoContext)context);
    }

    public void updateParameterInfo(@NotNull FtlArgumentList argumentList, @NotNull UpdateParameterInfoContext context) {
        if (argumentList == null) {
            FtlParameterInfoHandler.$$$reportNull$$$0(4);
        }
        if (context == null) {
            FtlParameterInfoHandler.$$$reportNull$$$0(5);
        }
        if (context.getParameterOwner() != argumentList) {
            context.removeHint();
            return;
        }
        assert (argumentList.isValid());
        context.setParameterOwner((PsiElement)argumentList);
        int offset = context.getEditor().getCaretModel().getOffset() - argumentList.getTextRange().getStartOffset();
        int index = 0;
        boolean inExpression = true;
        THashSet usedNames = new THashSet();
        for (ASTNode child : argumentList.getNode().getChildren(null)) {
            boolean expr;
            PsiElement psiChild = child.getPsi();
            boolean bl = expr = psiChild instanceof FtlExpression || psiChild instanceof FtlNameValuePair;
            if (child.getElementType() == FtlElementTypes.COMMA) {
                ++index;
                inExpression = true;
            } else if (expr) {
                if (!inExpression) {
                    ++index;
                }
                inExpression = true;
            }
            if ((offset -= child.getTextLength()) <= 0) {
                if (!argumentList.isPositional()) break;
                context.setCurrentParameter(index);
                return;
            }
            if (expr) {
                inExpression = false;
            }
            if (!(psiChild instanceof FtlNameValuePair)) continue;
            usedNames.add(((FtlNameValuePair)psiChild).getName());
        }
        if (!argumentList.isPositional()) {
            Object[] view = context.getObjectsToView();
            if (view.length == 1) {
                FtlParameter[] parameters = ((FtlCallableType)view[0]).getParameters();
                for (int i = 0; i < parameters.length; ++i) {
                    if (usedNames.contains(parameters[i].getName())) continue;
                    context.setCurrentParameter(i);
                    return;
                }
            }
        } else {
            context.setCurrentParameter(index);
        }
    }

    public String getParameterCloseChars() {
        return ", )";
    }

    public void updateUI(FtlCallableType p, @NotNull ParameterInfoUIContext context) {
        PsiElement list;
        if (context == null) {
            FtlParameterInfoHandler.$$$reportNull$$$0(6);
        }
        if (!(list = context.getParameterOwner()).isValid()) {
            return;
        }
        int index = context.getCurrentParameterIndex();
        boolean applicable = FtlParameterInfoHandler.isApplicable(p, list, index);
        int highlightStart = -1;
        int highlightEnd = -1;
        StringBuilder sb = new StringBuilder();
        FtlParameter[] variables = p.getParameters();
        for (int i = 0; i < variables.length; ++i) {
            FtlParameter variable;
            if (i != 0) {
                sb.append(", ");
            }
            if (i == index) {
                highlightStart = sb.length();
            }
            if (!(variable = variables[i]).isValid()) {
                return;
            }
            FtlType type = variable.getType();
            if (type != null) {
                sb.append(type.getPresentableText()).append(" ");
            }
            sb.append(variable.getName());
            if (i != index) continue;
            highlightEnd = sb.length();
        }
        if (variables.length == 0) {
            sb.append(CodeInsightBundle.message((String)"parameter.info.no.parameters", (Object[])new Object[0]));
        }
        boolean deprecated = p instanceof FtlMethodType && ((FtlMethodType)p).getMethod().isDeprecated();
        context.setupUIComponentPresentation(sb.toString(), highlightStart, highlightEnd, !applicable, deprecated, false, context.getDefaultParameterColor());
    }

    private static boolean isApplicable(FtlCallableType p, PsiElement list, int index) {
        boolean applicable;
        boolean bl = applicable = p.getParameters().length > index || index == 0 && p.getParameters().length == 0;
        if (applicable && list.getParent() instanceof FtlMethodCallExpression) {
            PsiType[] psiTypes = ((FtlMethodCallExpression)list.getParent()).getArgumentTypes();
            for (int i = 0; i < index; ++i) {
                FtlType type = p.getParameters()[i].getType();
                PsiType psiType = psiTypes[i];
                if (type instanceof FtlPsiType && (psiType == null || ((FtlPsiType)type).getPsiType().isAssignableFrom(psiType))) continue;
                return false;
            }
        }
        return applicable;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "argumentList";
                break;
            }
        }
        objectArray2[1] = "com/intellij/freemarker/FtlParameterInfoHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForParameterInfo";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "showParameterInfo";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findElementForUpdatingParameterInfo";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "updateParameterInfo";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "updateUI";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

