/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi;

import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.freemarker.inspections.FtlReferencesInspection;
import com.intellij.freemarker.psi.FtlArgumentList;
import com.intellij.freemarker.psi.FtlAssignmentResolver;
import com.intellij.freemarker.psi.FtlInterpolation;
import com.intellij.freemarker.psi.FtlMethodCallExpression;
import com.intellij.freemarker.psi.FtlPsiUtil;
import com.intellij.freemarker.psi.FtlQualifiedReference;
import com.intellij.freemarker.psi.FtlResolveResult;
import com.intellij.freemarker.psi.FtlType;
import com.intellij.freemarker.psi.directives.FtlAssignmentDeclaration;
import com.intellij.freemarker.psi.directives.FtlAssignmentType;
import com.intellij.freemarker.psi.directives.FtlIfDirective;
import com.intellij.freemarker.psi.directives.FtlImportDirective;
import com.intellij.freemarker.psi.directives.FtlLoopVariable;
import com.intellij.freemarker.psi.directives.FtlMacro;
import com.intellij.freemarker.psi.directives.FtlParameterDeclaration;
import com.intellij.freemarker.psi.directives.FtlSignatureDirective;
import com.intellij.freemarker.psi.variables.FtlCallableType;
import com.intellij.freemarker.psi.variables.FtlCallableVariable;
import com.intellij.freemarker.psi.variables.FtlImplicitVariable;
import com.intellij.freemarker.psi.variables.FtlMacroLoopVariable;
import com.intellij.freemarker.psi.variables.FtlNamespaceType;
import com.intellij.freemarker.psi.variables.FtlParameter;
import com.intellij.freemarker.psi.variables.FtlPsiType;
import com.intellij.freemarker.psi.variables.FtlVariable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.beanProperties.BeanPropertyElement;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.resolve.JavaMethodCandidateInfo;
import com.intellij.psi.resolve.JavaMethodResolveHelper;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FtlVariantsProcessor<T>
implements PsiScopeProcessor {
    @NonNls
    private static final THashSet<String> INSECURE_OBJECT_METHODS = new THashSet(Arrays.asList("wait", "notify", "notifyAll"));
    private final Set<T> myResult;
    private final Set<String> myMacroNames;
    private final Set<String> myUsedNames;
    private final boolean myForCompletion;
    private final PsiElement myParent;
    @Nullable
    private final String myReferenceName;
    private final boolean myMethodCall;
    private final JavaMethodResolveHelper myPropertyMethods;
    private final JavaMethodResolveHelper myMethods;
    private final FtlAssignmentResolver myAssignments;
    private final FtlAssignmentResolver myImplicits;
    private final FtlQualifiedReference myReference;
    private final PsiType[] myArgTypes;

    protected FtlVariantsProcessor(@NotNull FtlQualifiedReference reference, @Nullable String referenceName) {
        if (reference == null) {
            FtlVariantsProcessor.$$$reportNull$$$0(0);
        }
        this.myResult = new LinkedHashSet<T>();
        this.myMacroNames = new THashSet();
        this.myUsedNames = new THashSet();
        this.myAssignments = new FtlAssignmentResolver();
        this.myImplicits = new FtlAssignmentResolver();
        this.myReference = reference;
        this.myForCompletion = referenceName == null;
        this.myParent = reference.getExpressionParent();
        this.myReferenceName = referenceName;
        this.myMethodCall = this.myParent instanceof FtlMethodCallExpression;
        this.myArgTypes = this.myMethodCall && !this.myForCompletion ? ((FtlMethodCallExpression)this.myParent).getArgumentTypes() : null;
        this.myPropertyMethods = new FtlJavaMethodResolveHelper(this.myArgTypes);
        this.myMethods = new FtlJavaMethodResolveHelper(this.myArgTypes);
    }

    public boolean execute(@NotNull PsiElement element, @NotNull ResolveState state) {
        boolean staticError;
        if (element == null) {
            FtlVariantsProcessor.$$$reportNull$$$0(1);
        }
        if (state == null) {
            FtlVariantsProcessor.$$$reportNull$$$0(2);
        }
        if (!(element instanceof PsiNamedElement)) {
            return true;
        }
        if (element instanceof PsiClass) {
            return true;
        }
        PsiNamedElement namedElement = (PsiNamedElement)element;
        if (StringUtil.isEmpty((String)namedElement.getName())) {
            return true;
        }
        boolean bl = staticError = state.get(FtlPsiType.STATIC_ERROR) == Boolean.TRUE;
        if (element instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)element;
            if (method.isConstructor()) {
                return true;
            }
            PsiClass containingClass = method.getContainingClass();
            if (containingClass != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && INSECURE_OBJECT_METHODS.contains((Object)method.getName())) {
                return true;
            }
            if (!this.myMethodCall && (this.myReferenceName == null || this.myReferenceName.equals(PropertyUtilBase.getPropertyName((PsiMethod)method))) && PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method)) {
                if (!method.hasModifierProperty("public")) {
                    return true;
                }
                this.myPropertyMethods.addMethod(method, (PsiSubstitutor)state.get(PsiSubstitutor.KEY), staticError);
            }
        }
        if (this.myReferenceName != null && !this.myReferenceName.equals(namedElement.getName())) {
            return true;
        }
        if (namedElement instanceof PsiModifierListOwner && !((PsiModifierListOwner)namedElement).hasModifierProperty("public")) {
            return true;
        }
        if (element instanceof PsiField) {
            if (!this.shouldExposeFields() && !(element instanceof PsiEnumConstant)) {
                return true;
            }
            PsiField field = (PsiField)element;
            String getterName = PropertyUtilBase.suggestGetterName((PsiField)field);
            for (PsiMethod method : Objects.requireNonNull(field.getContainingClass()).findMethodsByName(getterName, true)) {
                if (!PropertyUtilBase.isSimplePropertyGetter((PsiMethod)method)) continue;
                return true;
            }
        }
        boolean isMacroDirective = FtlVariantsProcessor.isMacroDirective(element);
        if (!this.myForCompletion) {
            boolean isCallTarget;
            boolean bl2 = FtlVariantsProcessor.isCallableVariable(element) ? !isMacroDirective : (isCallTarget = element instanceof PsiMethod);
            if (isCallTarget != this.myMethodCall) {
                return true;
            }
        } else {
            if (this.myParent instanceof FtlInterpolation && isMacroDirective) {
                return true;
            }
            if (this.myParent instanceof FtlMacro && !isMacroDirective && !FtlVariantsProcessor.isNamespace(element)) {
                return true;
            }
        }
        if (!(this.myParent instanceof FtlMacro) && PsiTreeUtil.getParentOfType((PsiElement)this.myParent, FtlArgumentList.class, (boolean)false) == null && isMacroDirective && !this.myForCompletion) {
            return true;
        }
        if (this.myReference.isMacroParameter(false) && !(element instanceof FtlParameter)) {
            return true;
        }
        if (this.myForCompletion && !FtlVariantsProcessor.canBeOverloaded(element) && !this.myUsedNames.add(namedElement.getName())) {
            return true;
        }
        if (element instanceof PsiMethod) {
            this.myMethods.addMethod((PsiMethod)element, (PsiSubstitutor)state.get(PsiSubstitutor.KEY), staticError);
        } else if (element instanceof FtlAssignmentDeclaration) {
            this.myAssignments.addAssignment((FtlVariable)element, state.get(FtlIfDirective.MAYBE_UNDEFINED) == Boolean.TRUE, ((FtlAssignmentDeclaration)element).getDirective().getType());
        } else if (element instanceof FtlLoopVariable || element instanceof FtlMacroLoopVariable || element instanceof FtlParameterDeclaration) {
            this.myAssignments.addAssignment((FtlVariable)element, false, FtlAssignmentType.LOCAL);
        } else if (element instanceof FtlImplicitVariable) {
            FtlImplicitVariable variable = (FtlImplicitVariable)element;
            FtlAssignmentType assignmentType = element.getContainingFile() == this.myParent.getContainingFile() || !variable.isGlobal() ? FtlAssignmentType.ASSIGN : FtlAssignmentType.GLOBAL;
            this.myImplicits.addAssignment(variable, false, assignmentType);
        } else {
            if (element instanceof FtlSignatureDirective && !this.myMacroNames.add(((FtlSignatureDirective)element).getName())) {
                return true;
            }
            ContainerUtil.addIfNotNull(this.myResult, this.execute(namedElement, staticError ? JavaMethodResolveHelper.ErrorType.STATIC : JavaMethodResolveHelper.ErrorType.NONE, (PsiSubstitutor)state.get(PsiSubstitutor.KEY)));
        }
        return true;
    }

    private static boolean canBeOverloaded(@NotNull PsiElement element) {
        if (element == null) {
            FtlVariantsProcessor.$$$reportNull$$$0(3);
        }
        return element instanceof PsiMethod || FtlVariantsProcessor.isCallableVariable(element);
    }

    @Nullable
    private static FtlCallableType getCallableType(PsiElement element) {
        if (element instanceof FtlCallableVariable || element instanceof FtlImplicitVariable) {
            FtlType ftlType = ((FtlVariable)element).getType();
            return FtlPsiUtil.asInstanceOf(ftlType, FtlCallableType.class);
        }
        return null;
    }

    private static boolean isCallableVariable(PsiElement element) {
        return FtlVariantsProcessor.getCallableType(element) != null;
    }

    private static boolean isMacroDirective(@Nullable PsiElement element) {
        FtlCallableType callableType = FtlVariantsProcessor.getCallableType(element);
        return callableType != null && callableType.isMacro();
    }

    private boolean shouldExposeFields() {
        PsiFile file = this.myReference.getElement().getContainingFile();
        InspectionProfileImpl profile = InspectionProjectProfileManager.getInstance((Project)file.getProject()).getCurrentProfile();
        InspectionToolWrapper wrapper = profile.getInspectionTool("FtlReferencesInspection", (PsiElement)file);
        if (wrapper == null) {
            return false;
        }
        return ((FtlReferencesInspection)wrapper.getTool()).fieldsExposed;
    }

    private static boolean isNamespace(PsiElement element) {
        return element instanceof FtlImportDirective || element instanceof FtlVariable && FtlPsiUtil.asInstanceOf(((FtlVariable)element).getType(), FtlNamespaceType.class) != null;
    }

    public void handleEvent(@NotNull PsiScopeProcessor.Event event, Object associated) {
        if (event == null) {
            FtlVariantsProcessor.$$$reportNull$$$0(4);
        }
        this.myMethods.handleEvent(event, associated);
        this.myPropertyMethods.handleEvent(event, associated);
        if (event == JavaScopeProcessorEvent.CHANGE_LEVEL) {
            this.myAssignments.handleLevelChange();
        }
    }

    @Nullable
    protected abstract T execute(PsiNamedElement var1, JavaMethodResolveHelper.ErrorType var2, PsiSubstitutor var3);

    @NotNull
    public T[] toArray(@NotNull T[] array) {
        PsiMethod method;
        PsiNamedElement element;
        if (array == null) {
            FtlVariantsProcessor.$$$reportNull$$$0(5);
        }
        LinkedHashSet<T> result = new LinkedHashSet<T>(this.myResult);
        HashSet<String> parameterNames = new HashSet<String>();
        for (FtlResolveResult declaration : this.myAssignments.getResults()) {
            element = (PsiNamedElement)declaration.getElement();
            T variant = this.execute(element, declaration.getResolveError(), PsiSubstitutor.EMPTY);
            if (variant == null) continue;
            if (element instanceof FtlParameterDeclaration) {
                parameterNames.add(element.getName());
            }
            result.add(variant);
        }
        for (JavaMethodCandidateInfo ci : this.myPropertyMethods.getMethods()) {
            method = ci.getMethod();
            String propertyName = PropertyUtilBase.getPropertyName((PsiMethod)method);
            assert (propertyName != null) : method;
            if (parameterNames.contains(propertyName)) continue;
            BeanPropertyElement element2 = new BeanPropertyElement(method, propertyName);
            ContainerUtil.addIfNotNull(result, this.execute((PsiNamedElement)element2, this.myPropertyMethods.getResolveError(), ci.getSubstitutor()));
        }
        for (JavaMethodCandidateInfo ci : this.myMethods.getMethods()) {
            method = ci.getMethod();
            if (parameterNames.contains(method.getName())) continue;
            ContainerUtil.addIfNotNull(result, this.execute((PsiNamedElement)method, this.myMethods.getResolveError(), ci.getSubstitutor()));
        }
        for (FtlResolveResult declaration : this.myImplicits.getResults()) {
            element = (PsiNamedElement)declaration.getElement();
            if (parameterNames.contains(element.getName())) continue;
            ContainerUtil.addIfNotNull(result, this.execute(element, declaration.getResolveError(), PsiSubstitutor.EMPTY));
        }
        T[] TArray = result.toArray(array);
        if (TArray == null) {
            FtlVariantsProcessor.$$$reportNull$$$0(6);
        }
        return TArray;
    }

    @Nullable
    public String getReferenceName() {
        return this.myReferenceName;
    }

    public boolean isMethodCall() {
        return this.myMethodCall;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "array";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/freemarker/psi/FtlVariantsProcessor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/freemarker/psi/FtlVariantsProcessor";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "toArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "canBeOverloaded";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "handleEvent";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "toArray";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MethodCandidateInfoWithConversion
    extends MethodCandidateInfo {
        public MethodCandidateInfoWithConversion(@NotNull PsiMethod method, PsiSubstitutor substitutor, boolean accessProblem, boolean staticProblem, PsiElement argumentList, PsiElement currentFileContext, PsiType[] newArgTypes, @NotNull LanguageLevel languageLevel) {
            if (method == null) {
                MethodCandidateInfoWithConversion.$$$reportNull$$$0(0);
            }
            if (languageLevel == null) {
                MethodCandidateInfoWithConversion.$$$reportNull$$$0(1);
            }
            super((PsiElement)method, substitutor, accessProblem, staticProblem, argumentList, currentFileContext, newArgTypes, PsiType.EMPTY_ARRAY, languageLevel);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "method";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "languageLevel";
                    break;
                }
            }
            objectArray[1] = "com/intellij/freemarker/psi/FtlVariantsProcessor$MethodCandidateInfoWithConversion";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class FtlJavaMethodResolveHelper
    extends JavaMethodResolveHelper {
        public FtlJavaMethodResolveHelper(PsiType[] args) {
            super(FtlVariantsProcessor.this.myParent, FtlVariantsProcessor.this.myParent.getContainingFile(), args);
        }

        protected List<CandidateInfo> getCandidates() {
            List candidates = super.getCandidates();
            ArrayList normal = ContainerUtil.newArrayList();
            ArrayList converted = ContainerUtil.newArrayList();
            for (CandidateInfo candidate : candidates) {
                (candidate instanceof MethodCandidateInfoWithConversion ? converted : normal).add(candidate);
            }
            return normal.isEmpty() ? converted : normal;
        }

        protected MethodCandidateInfo createCandidateInfo(@NotNull PsiMethod method, PsiSubstitutor substitutor, boolean staticProblem, PsiElement currentFileContext, boolean accessProblem, PsiElement argumentList, PsiType[] argumentTypes, @NotNull LanguageLevel languageLevel, final boolean vararg) {
            PsiType[] newArgTypes;
            if (method == null) {
                FtlJavaMethodResolveHelper.$$$reportNull$$$0(0);
            }
            if (languageLevel == null) {
                FtlJavaMethodResolveHelper.$$$reportNull$$$0(1);
            }
            PsiParameterList list = method.getParameterList();
            if (FtlVariantsProcessor.this.myArgTypes != null && list.getParametersCount() == FtlVariantsProcessor.this.myArgTypes.length && (newArgTypes = this.replaceStringWithChar(list)) != null) {
                return new MethodCandidateInfoWithConversion(method, substitutor, accessProblem, staticProblem, argumentList, currentFileContext, newArgTypes, languageLevel){

                    public boolean isVarargs() {
                        return vararg;
                    }
                };
            }
            return super.createCandidateInfo(method, substitutor, staticProblem, currentFileContext, accessProblem, argumentList, argumentTypes, languageLevel, vararg);
        }

        private PsiType[] replaceStringWithChar(PsiParameterList list) {
            PsiType[] newArgTypes = null;
            PsiParameter[] parameters = list.getParameters();
            for (int i = 0; i < parameters.length; ++i) {
                if (!PsiType.CHAR.equals((Object)parameters[i].getType()) || FtlVariantsProcessor.this.myArgTypes[i] == null || !FtlVariantsProcessor.this.myArgTypes[i].equalsToText("java.lang.String")) continue;
                if (newArgTypes == null) {
                    newArgTypes = (PsiType[])FtlVariantsProcessor.this.myArgTypes.clone();
                }
                newArgTypes[i] = PsiType.CHAR;
            }
            return newArgTypes;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "method";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "languageLevel";
                    break;
                }
            }
            objectArray[1] = "com/intellij/freemarker/psi/FtlVariantsProcessor$FtlJavaMethodResolveHelper";
            objectArray[2] = "createCandidateInfo";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

