/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.freemarker.psi.directives;

import com.intellij.freemarker.psi.FtlCompositeElementType;
import com.intellij.freemarker.psi.FtlElementTypes;
import com.intellij.freemarker.psi.directives.FtlDirective;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.tree.IElementType;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FtlDirectiveType
extends FtlCompositeElementType {
    public static final FtlDirectiveType COMMENT_DIRECTIVE = new FtlDirectiveType("comment", true){

        @Override
        public FtlDirective createPsiElement(ASTNode node) {
            return new FtlDirective(node){

                @Override
                public boolean isClosed() {
                    return this.findChildByType((IElementType)FtlElementTypes.COMMENT_END) != null;
                }
            };
        }
    };
    public static final FtlDirectiveType UNKNOWN_DIRECTIVE = new FtlDirectiveType("unknown", false);
    private final String myDirectiveName;
    private final boolean myExpectsClosing;

    public FtlDirectiveType(@NotNull @NonNls String directiveName, boolean expectsClosing) {
        if (directiveName == null) {
            FtlDirectiveType.$$$reportNull$$$0(0);
        }
        super(directiveName.toUpperCase() + "_DIRECTIVE");
        this.myDirectiveName = directiveName;
        this.myExpectsClosing = expectsClosing;
    }

    public String getDirectiveName() {
        return this.myDirectiveName;
    }

    public static boolean isDirective(@Nullable PsiElement element, String ... directiveNames) {
        return element instanceof FtlDirective && Arrays.asList(directiveNames).contains(((FtlDirective)element).getDirectiveName());
    }

    public FtlDirective createPsiElement(ASTNode node) {
        return new FtlDirective(node);
    }

    public boolean expectsClosing() {
        return this.myExpectsClosing;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "directiveName", "com/intellij/freemarker/psi/directives/FtlDirectiveType", "<init>"));
    }
}

