/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl;

import com.intellij.codeInsight.daemon.DaemonBundle;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoComposite;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInsight.daemon.impl.TrafficTooltipRendererImpl;
import com.intellij.codeInsight.daemon.impl.actions.ShowErrorDescriptionAction;
import com.intellij.codeInsight.hint.LineTooltipRenderer;
import com.intellij.codeInsight.hint.TooltipLinkHandlerEP;
import com.intellij.codeInsight.hint.TooltipRenderer;
import com.intellij.codeInspection.ui.InspectionNodeInfo;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.ErrorStripTooltipRendererProvider;
import com.intellij.openapi.editor.impl.TrafficTooltipRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.Html;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import gnu.trove.THashSet;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DaemonTooltipRendererProvider
implements ErrorStripTooltipRendererProvider {
    @NonNls
    private static final String END_MARKER = "<!-- end marker -->";
    private final Project myProject;

    DaemonTooltipRendererProvider(Project project) {
        this.myProject = project;
    }

    @Override
    public TooltipRenderer calcTooltipRenderer(@NotNull Collection<RangeHighlighter> highlighters) {
        if (highlighters == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(0);
        }
        LineTooltipRenderer bigRenderer = null;
        SmartList infos = new SmartList();
        THashSet tooltips = new THashSet();
        for (RangeHighlighter marker : highlighters) {
            Object tooltipObject = marker.getErrorStripeTooltip();
            if (tooltipObject == null) continue;
            if (tooltipObject instanceof HighlightInfo) {
                HighlightInfo info = (HighlightInfo)tooltipObject;
                if (info.getToolTip() == null || !tooltips.add(info.getToolTip())) continue;
                infos.add(info);
                continue;
            }
            String text = tooltipObject.toString();
            if (!tooltips.add(text)) continue;
            if (bigRenderer == null) {
                bigRenderer = new MyRenderer(text, new Object[]{highlighters});
                continue;
            }
            bigRenderer.addBelow(text);
        }
        if (!infos.isEmpty()) {
            ContainerUtil.quickSort((List)infos, (o1, o2) -> {
                int i = SeverityRegistrar.getSeverityRegistrar(this.myProject).compare(o2.getSeverity(), o1.getSeverity());
                if (i != 0) {
                    return i;
                }
                return o1.getToolTip().compareTo(o2.getToolTip());
            });
            HighlightInfoComposite composite = new HighlightInfoComposite((List<HighlightInfo>)infos);
            String toolTip = composite.getToolTip();
            MyRenderer myRenderer = new MyRenderer(toolTip == null ? null : UIUtil.convertSpace2Nbsp((String)toolTip), new Object[]{highlighters});
            if (bigRenderer != null) {
                myRenderer.addBelow(bigRenderer.getText());
            }
            bigRenderer = myRenderer;
        }
        return bigRenderer;
    }

    @Override
    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text) {
        if (text == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(1);
        }
        MyRenderer myRenderer = new MyRenderer(text, new Object[]{text});
        if (myRenderer == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(2);
        }
        return myRenderer;
    }

    @Override
    @NotNull
    public TooltipRenderer calcTooltipRenderer(@NotNull String text, int width) {
        if (text == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(3);
        }
        MyRenderer myRenderer = new MyRenderer(text, width, new Object[]{text});
        if (myRenderer == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(4);
        }
        return myRenderer;
    }

    @Override
    @NotNull
    public TrafficTooltipRenderer createTrafficTooltipRenderer(@NotNull Runnable onHide, @NotNull Editor editor) {
        if (onHide == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(5);
        }
        if (editor == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(6);
        }
        TrafficTooltipRendererImpl trafficTooltipRendererImpl = new TrafficTooltipRendererImpl(onHide, editor);
        if (trafficTooltipRendererImpl == null) {
            DaemonTooltipRendererProvider.$$$reportNull$$$0(7);
        }
        return trafficTooltipRendererImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighters";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "onHide";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider";
                break;
            }
            case 2: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "calcTooltipRenderer";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "createTrafficTooltipRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "calcTooltipRenderer";
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createTrafficTooltipRenderer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyRenderer
    extends LineTooltipRenderer {
        public MyRenderer(String text, Object[] comparable) {
            super(text, comparable);
        }

        public MyRenderer(String text, int width, Object[] comparable) {
            super(text, width, comparable);
        }

        @Override
        protected void onHide(JComponent contentComponent) {
            ShowErrorDescriptionAction.rememberCurrentWidth(contentComponent.getWidth());
        }

        @Override
        protected boolean dressDescription(@NotNull Editor editor) {
            if (editor == null) {
                MyRenderer.$$$reportNull$$$0(0);
            }
            List problems = StringUtil.split((String)UIUtil.getHtmlBody((Html)new Html(this.myText).setKeepFont(true)), (String)"<hr size=1 noshade>");
            String text = "";
            for (String problem : problems) {
                String ref = MyRenderer.getLinkRef(problem);
                if (ref != null) {
                    String description = TooltipLinkHandlerEP.getDescription(ref, editor);
                    if (description == null) continue;
                    description = InspectionNodeInfo.stripUIRefsFromInspectionDescription(UIUtil.getHtmlBody((Html)new Html(description).setKeepFont(true)));
                    text = text + UIUtil.getHtmlBody((Html)new Html(problem).setKeepFont(true)).replace(DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0]), DaemonBundle.message((String)"inspection.collapse.description", (Object[])new Object[0])) + DaemonTooltipRendererProvider.END_MARKER + "<p>" + description + "<hr size=1 noshade>";
                    continue;
                }
                text = text + UIUtil.getHtmlBody((Html)new Html(problem).setKeepFont(true)) + "<hr size=1 noshade>";
            }
            if (!text.isEmpty()) {
                this.myText = XmlStringUtil.wrapInHtml((CharSequence)StringUtil.trimEnd((String)text, (String)"<hr size=1 noshade>"));
                return true;
            }
            return false;
        }

        @Nullable
        private static String getLinkRef(@NonNls String text) {
            String ref;
            int quoteIdx;
            String linkWithRef = "<a href=\"";
            int linkStartIdx = text.indexOf("<a href=\"");
            if (linkStartIdx >= 0 && (quoteIdx = (ref = text.substring(linkStartIdx + "<a href=\"".length())).indexOf(34)) > 0) {
                return ref.substring(0, quoteIdx);
            }
            return null;
        }

        @Override
        protected void stripDescription() {
            List problems = StringUtil.split((String)UIUtil.getHtmlBody((Html)new Html(this.myText).setKeepFont(true)), (String)"<hr size=1 noshade>");
            this.myText = "";
            for (String problem1 : problems) {
                String problem = (String)StringUtil.split((String)problem1, (String)DaemonTooltipRendererProvider.END_MARKER).get(0);
                this.myText = this.myText + UIUtil.getHtmlBody((Html)new Html(problem).setKeepFont(true)).replace(DaemonBundle.message((String)"inspection.collapse.description", (Object[])new Object[0]), DaemonBundle.message((String)"inspection.extended.description", (Object[])new Object[0])) + "<hr size=1 noshade>";
            }
            this.myText = XmlStringUtil.wrapInHtml((CharSequence)StringUtil.trimEnd((String)this.myText, (String)"<hr size=1 noshade>"));
        }

        @Override
        protected LineTooltipRenderer createRenderer(String text, int width) {
            return new MyRenderer(text, width, this.getEqualityObjects());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/daemon/impl/DaemonTooltipRendererProvider$MyRenderer", "dressDescription"));
        }
    }
}

