/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.daemon.impl.analysis.encoding;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.util.IncorrectOperationException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EncodingReference
implements PsiReference,
EmptyResolveMessageProvider {
    private final PsiElement myElement;
    private final String myCharsetName;
    private final TextRange myRangeInElement;

    public EncodingReference(PsiElement element, String charsetName, TextRange rangeInElement) {
        this.myElement = element;
        this.myCharsetName = charsetName;
        this.myRangeInElement = rangeInElement;
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        return this.myRangeInElement;
    }

    @Nullable
    public PsiElement resolve() {
        return CharsetToolkit.forName((String)this.myCharsetName) == null ? null : this.myElement;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.myCharsetName;
        if (string == null) {
            EncodingReference.$$$reportNull$$$0(0);
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return null;
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            EncodingReference.$$$reportNull$$$0(1);
        }
        return null;
    }

    public boolean isReferenceTo(PsiElement element) {
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        Charset[] charsets = CharsetToolkit.getAvailableCharsets();
        ArrayList<LookupElementBuilder> suggestions = new ArrayList<LookupElementBuilder>(charsets.length);
        for (Charset charset : charsets) {
            suggestions.add(LookupElementBuilder.create((String)charset.name()).withCaseSensitivity(false));
        }
        Object[] objectArray = suggestions.toArray(LookupElement.EMPTY_ARRAY);
        if (objectArray == null) {
            EncodingReference.$$$reportNull$$$0(2);
        }
        return objectArray;
    }

    public boolean isSoft() {
        return false;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = CodeInsightBundle.message((String)"unknown.encoding.0", (Object[])new Object[0]);
        if (string == null) {
            EncodingReference.$$$reportNull$$$0(3);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/daemon/impl/analysis/encoding/EncodingReference";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCanonicalText";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/daemon/impl/analysis/encoding/EncodingReference";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

