/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation;

import com.intellij.application.options.CodeStyle;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.CommentUtil;
import com.intellij.codeInsight.actions.MultiCaretCodeInsightActionHandler;
import com.intellij.codeInsight.generation.CommenterDataHolder;
import com.intellij.codeInsight.generation.CommenterWithLineSuffix;
import com.intellij.codeInsight.generation.EscapingCommenter;
import com.intellij.codeInsight.generation.IndentedCommenter;
import com.intellij.codeInsight.generation.SelfManagingCommenter;
import com.intellij.codeInsight.hint.HintManagerImpl;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.highlighter.custom.CustomFileTypeLexer;
import com.intellij.lang.CodeDocumentationAwareCommenter;
import com.intellij.lang.Commenter;
import com.intellij.lang.CustomUncommenter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.impl.AbstractFileType;
import com.intellij.openapi.fileTypes.impl.CustomSyntaxTableFileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.CustomHighlighterTokenType;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.Indent;
import com.intellij.psi.templateLanguages.MultipleLangCommentProvider;
import com.intellij.psi.templateLanguages.OuterLanguageElement;
import com.intellij.psi.templateLanguages.TemplateLanguageFileViewProvider;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.ui.LightweightHint;
import com.intellij.util.containers.IntArrayList;
import com.intellij.util.text.CharArrayUtil;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CommentByBlockCommentHandler
extends MultiCaretCodeInsightActionHandler {
    private Project myProject;
    private Editor myEditor;
    private Caret myCaret;
    @NotNull
    private PsiFile myFile;
    private Document myDocument;
    private Commenter myCommenter;
    private CommenterDataHolder mySelfManagedCommenterData;
    private String myWarning;
    private RangeMarker myWarningLocation;

    @Override
    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull Caret caret, @NotNull PsiFile file2) {
        String suffix;
        String prefix;
        if (project == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(1);
        }
        if (caret == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(2);
        }
        if (file2 == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(3);
        }
        this.myProject = project;
        this.myEditor = editor;
        this.myCaret = caret;
        this.myFile = file2;
        this.myWarning = null;
        this.myWarningLocation = null;
        this.myDocument = editor.getDocument();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.comment.block");
        Commenter commenter = CommentByBlockCommentHandler.findCommenter(this.myFile, this.myEditor, caret);
        if (commenter == null) {
            return;
        }
        this.myCommenter = commenter;
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            this.mySelfManagedCommenterData = selfManagingCommenter.createBlockCommentingState(caret.getSelectionStart(), caret.getSelectionEnd(), this.myDocument, this.myFile);
            if (this.mySelfManagedCommenterData == null) {
                this.mySelfManagedCommenterData = SelfManagingCommenter.EMPTY_STATE;
            }
            prefix = selfManagingCommenter.getBlockCommentPrefix(caret.getSelectionStart(), this.myDocument, this.mySelfManagedCommenterData);
            suffix = selfManagingCommenter.getBlockCommentSuffix(caret.getSelectionEnd(), this.myDocument, this.mySelfManagedCommenterData);
        } else {
            prefix = commenter.getBlockCommentPrefix();
            suffix = commenter.getBlockCommentSuffix();
        }
        if (prefix == null || suffix == null) {
            return;
        }
        TextRange commentedRange = this.findCommentedRange(commenter);
        if (commentedRange != null) {
            int commentStart = commentedRange.getStartOffset();
            int commentEnd = commentedRange.getEndOffset();
            int selectionStart = commentStart;
            int selectionEnd = commentEnd;
            if (this.myCaret.hasSelection()) {
                selectionStart = this.myCaret.getSelectionStart();
                selectionEnd = this.myCaret.getSelectionEnd();
            }
            if (!(commentStart >= selectionStart && commentStart < selectionEnd || commentEnd > selectionStart && commentEnd <= selectionEnd)) {
                this.commentRange(selectionStart, selectionEnd, prefix, suffix, commenter);
            } else {
                this.uncommentRange(commentedRange, CommentByBlockCommentHandler.trim(prefix), CommentByBlockCommentHandler.trim(suffix), commenter);
            }
        } else if (this.myCaret.hasSelection()) {
            Boolean value;
            int selectionStart = this.myCaret.getSelectionStart();
            int selectionEnd = this.myCaret.getSelectionEnd();
            if (commenter instanceof IndentedCommenter && (value = ((IndentedCommenter)commenter).forceIndentedLineComment()) != null && value == Boolean.TRUE) {
                selectionStart = this.myDocument.getLineStartOffset(this.myDocument.getLineNumber(selectionStart));
                selectionEnd = this.myDocument.getLineEndOffset(this.myDocument.getLineNumber(selectionEnd));
            }
            this.commentRange(selectionStart, selectionEnd, prefix, suffix, commenter);
        } else {
            Boolean value;
            EditorUtil.fillVirtualSpaceUntilCaret(editor);
            int caretOffset = this.myCaret.getOffset();
            if (commenter instanceof IndentedCommenter && (value = ((IndentedCommenter)commenter).forceIndentedLineComment()) != null && value == Boolean.TRUE) {
                int lineNumber = this.myDocument.getLineNumber(caretOffset);
                int start = this.myDocument.getLineStartOffset(lineNumber);
                int end = this.myDocument.getLineEndOffset(lineNumber);
                this.commentRange(start, end, prefix, suffix, commenter);
                return;
            }
            this.myDocument.insertString(caretOffset, (CharSequence)(prefix + suffix));
            this.myCaret.moveToOffset(caretOffset + prefix.length());
        }
        this.showMessageIfNeeded();
    }

    private void showMessageIfNeeded() {
        if (this.myWarning != null) {
            this.myEditor.getScrollingModel().disableAnimation();
            this.myEditor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            this.myEditor.getScrollingModel().enableAnimation();
            LogicalPosition hintPosition = this.myCaret.getLogicalPosition();
            if (this.myWarningLocation != null) {
                LogicalPosition targetPosition = this.myEditor.offsetToLogicalPosition(this.myWarningLocation.getStartOffset());
                Point targetPoint = this.myEditor.logicalPositionToXY(targetPosition);
                if (this.myEditor.getScrollingModel().getVisibleArea().contains(targetPoint)) {
                    hintPosition = targetPosition;
                }
            }
            LightweightHint hint = new LightweightHint(HintUtil.createInformationLabel(this.myWarning));
            Point p = HintManagerImpl.getHintPosition(hint, this.myEditor, hintPosition, (short)1);
            HintManagerImpl.getInstanceImpl().showEditorHint(hint, this.myEditor, p, 0, 0, false);
        }
    }

    @Nullable
    private static String trim(String s) {
        return s == null ? null : s.trim();
    }

    private boolean testSelectionForNonComments() {
        if (!this.myCaret.hasSelection()) {
            return true;
        }
        TextRange range2 = new TextRange(this.myCaret.getSelectionStart(), this.myCaret.getSelectionEnd() - 1);
        for (PsiElement element = this.myFile.findElementAt(range2.getStartOffset()); element != null && range2.intersects(element.getTextRange()); element = element.getNextSibling()) {
            if (!(element instanceof OuterLanguageElement ? !this.isInjectedWhiteSpace(range2, (OuterLanguageElement)element) : !this.isWhiteSpaceOrComment(element, range2))) continue;
            return false;
        }
        return true;
    }

    private boolean isInjectedWhiteSpace(@NotNull TextRange range2, @NotNull OuterLanguageElement element) {
        PsiFile psi;
        if (range2 == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(4);
        }
        if (element == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(5);
        }
        if ((psi = element.getContainingFile().getViewProvider().getPsi(element.getLanguage())) == null) {
            return false;
        }
        List injectedElements = PsiTreeUtil.getInjectedElements((OuterLanguageElement)element);
        for (PsiElement el : injectedElements) {
            if (this.isWhiteSpaceOrComment(el, range2)) continue;
            return false;
        }
        return true;
    }

    private boolean isWhiteSpaceOrComment(@NotNull PsiElement element, @NotNull TextRange range2) {
        TextRange textRange;
        TextRange intersection;
        if (element == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(6);
        }
        if (range2 == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(7);
        }
        if ((intersection = range2.intersection(textRange = element.getTextRange())) == null) {
            return false;
        }
        intersection = TextRange.create((int)Math.max(intersection.getStartOffset() - textRange.getStartOffset(), 0), (int)Math.min(intersection.getEndOffset() - textRange.getStartOffset(), textRange.getLength()));
        return CommentByBlockCommentHandler.isWhiteSpaceOrComment(element) || intersection.substring(element.getText()).trim().length() == 0;
    }

    private static boolean isWhiteSpaceOrComment(PsiElement element) {
        return element instanceof PsiWhiteSpace || PsiTreeUtil.getParentOfType((PsiElement)element, PsiComment.class, (boolean)false) != null;
    }

    @Nullable
    private TextRange findCommentedRange(Commenter commenter) {
        String commentText;
        PsiElement comment;
        TextRange commentedRange;
        String suffix;
        String prefix;
        CharSequence text = this.myDocument.getCharsSequence();
        FileType fileType = this.myFile.getFileType();
        if (fileType instanceof CustomSyntaxTableFileType) {
            CustomFileTypeLexer lexer = new CustomFileTypeLexer(((CustomSyntaxTableFileType)fileType).getSyntaxTable());
            int caretOffset = this.myCaret.getOffset();
            int commentStart = CharArrayUtil.lastIndexOf((CharSequence)text, (String)commenter.getBlockCommentPrefix(), (int)caretOffset);
            if (commentStart == -1) {
                return null;
            }
            lexer.start(text, commentStart, text.length());
            if (lexer.getTokenType() == CustomHighlighterTokenType.MULTI_LINE_COMMENT && lexer.getTokenEnd() >= caretOffset) {
                return new TextRange(commentStart, lexer.getTokenEnd());
            }
            return null;
        }
        String selectedText = this.myCaret.getSelectedText();
        if (commenter instanceof CustomUncommenter && selectedText != null) {
            TextRange commentedRange2 = ((CustomUncommenter)commenter).findMaximumCommentedRange((CharSequence)selectedText);
            if (commentedRange2 == null) {
                return null;
            }
            return commentedRange2.shiftRight(this.myCaret.getSelectionStart());
        }
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            prefix = selfManagingCommenter.getBlockCommentPrefix(this.myCaret.getSelectionStart(), this.myDocument, this.mySelfManagedCommenterData);
            suffix = selfManagingCommenter.getBlockCommentSuffix(this.myCaret.getSelectionEnd(), this.myDocument, this.mySelfManagedCommenterData);
        } else {
            prefix = CommentByBlockCommentHandler.trim(commenter.getBlockCommentPrefix());
            suffix = CommentByBlockCommentHandler.trim(commenter.getBlockCommentSuffix());
        }
        if (prefix == null || suffix == null) {
            return null;
        }
        if (commenter instanceof SelfManagingCommenter) {
            commentedRange = ((SelfManagingCommenter)commenter).getBlockCommentRange(this.myCaret.getSelectionStart(), this.myCaret.getSelectionEnd(), this.myDocument, this.mySelfManagedCommenterData);
        } else {
            if (!this.testSelectionForNonComments()) {
                return null;
            }
            commentedRange = this.getSelectedComments(text, prefix, suffix);
        }
        if (commentedRange == null && (comment = this.findCommentAtCaret()) != null && (commentText = comment.getText()).startsWith(prefix) && commentText.endsWith(suffix)) {
            commentedRange = comment.getTextRange();
        }
        return commentedRange;
    }

    @Nullable
    private TextRange getSelectedComments(CharSequence text, String prefix, String suffix) {
        TextRange commentedRange = null;
        if (this.myCaret.hasSelection()) {
            int selectionStart = this.myCaret.getSelectionStart();
            selectionStart = CharArrayUtil.shiftForward((CharSequence)text, (int)selectionStart, (String)" \t\n");
            int selectionEnd = this.myCaret.getSelectionEnd() - 1;
            if ((selectionEnd = CharArrayUtil.shiftBackward((CharSequence)text, (int)selectionEnd, (String)" \t\n") + 1) - selectionStart >= prefix.length() + suffix.length() && CharArrayUtil.regionMatches((CharSequence)text, (int)selectionStart, (CharSequence)prefix) && CharArrayUtil.regionMatches((CharSequence)text, (int)(selectionEnd - suffix.length()), (CharSequence)suffix)) {
                commentedRange = new TextRange(selectionStart, selectionEnd);
            }
        }
        return commentedRange;
    }

    @Nullable
    private static Commenter findCommenter(PsiFile file2, Editor editor, Caret caret) {
        FileType fileType = file2.getFileType();
        if (fileType instanceof AbstractFileType) {
            return ((AbstractFileType)fileType).getCommenter();
        }
        Language lang = PsiUtilBase.getLanguageInEditor((Caret)caret, (Project)file2.getProject());
        return CommentByBlockCommentHandler.getCommenter(file2, editor, lang, lang);
    }

    @Nullable
    public static Commenter getCommenter(PsiFile file2, Editor editor, Language lineStartLanguage, Language lineEndLanguage) {
        Language lang;
        FileViewProvider viewProvider = file2.getViewProvider();
        for (MultipleLangCommentProvider provider : (MultipleLangCommentProvider[])MultipleLangCommentProvider.EP_NAME.getExtensions()) {
            if (!provider.canProcess(file2, viewProvider)) continue;
            return provider.getLineCommenter(file2, editor, lineStartLanguage, lineEndLanguage);
        }
        Language fileLanguage = file2.getLanguage();
        Language language = lang = lineStartLanguage == null || LanguageCommenters.INSTANCE.forLanguage(lineStartLanguage) == null || fileLanguage.getBaseLanguage() == lineStartLanguage ? fileLanguage : lineStartLanguage;
        if (viewProvider instanceof TemplateLanguageFileViewProvider && lang == ((TemplateLanguageFileViewProvider)viewProvider).getTemplateDataLanguage()) {
            lang = viewProvider.getBaseLanguage();
        }
        return (Commenter)LanguageCommenters.INSTANCE.forLanguage(lang);
    }

    @Nullable
    private PsiElement findCommentAtCaret() {
        PsiComment comment;
        TextRange range2;
        int offset = this.myCaret.getOffset();
        if (offset == (range2 = new TextRange(this.myCaret.getSelectionStart(), this.myCaret.getSelectionEnd())).getEndOffset()) {
            --offset;
        }
        if (offset <= range2.getStartOffset()) {
            ++offset;
        }
        if ((comment = this.getCommentAtOffset(offset)) == null || this.myCaret.hasSelection() && !range2.contains(comment.getTextRange())) {
            return null;
        }
        return comment;
    }

    @Nullable
    private PsiComment getCommentAtOffset(int offset) {
        PsiElement elt = this.myFile.getViewProvider().findElementAt(offset);
        if (elt == null) {
            return null;
        }
        return (PsiComment)PsiTreeUtil.getParentOfType((PsiElement)elt, PsiComment.class, (boolean)false);
    }

    public void commentRange(int startOffset, int endOffset, String commentPrefix, String commentSuffix, Commenter commenter) {
        if (this.breaksExistingComment(startOffset, true) || this.breaksExistingComment(endOffset, false)) {
            this.myWarning = CodeInsightBundle.message((String)"block.comment.intersects.existing.comment", (Object[])new Object[0]);
            return;
        }
        CharSequence chars = this.myDocument.getCharsSequence();
        LogicalPosition caretPosition = this.myCaret.getLogicalPosition();
        if ((startOffset == 0 || chars.charAt(startOffset - 1) == '\n') && (endOffset == this.myDocument.getTextLength() || endOffset > 0 && chars.charAt(endOffset - 1) == '\n')) {
            String space;
            CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)this.myProject);
            CommonCodeStyleSettings settings = CodeStyle.getLanguageSettings((PsiFile)this.myFile);
            if (!settings.BLOCK_COMMENT_AT_FIRST_COLUMN) {
                int line1 = this.myEditor.offsetToLogicalPosition((int)startOffset).line;
                int line2 = this.myEditor.offsetToLogicalPosition((int)(endOffset - 1)).line;
                FileType fileType = this.myFile.getFileType();
                Indent minIndent = CommentUtil.getMinLineIndent(this.myProject, this.myDocument, line1, line2, fileType);
                if (minIndent == null) {
                    minIndent = codeStyleManager.zeroIndent();
                }
                space = codeStyleManager.fillIndent(minIndent, fileType);
            } else {
                space = "";
            }
            StringBuilder nestingPrefix = new StringBuilder(space).append(commentPrefix);
            if (!commentPrefix.endsWith("\n")) {
                nestingPrefix.append("\n");
            }
            StringBuilder nestingSuffix = new StringBuilder(space);
            nestingSuffix.append(commentSuffix.startsWith("\n") ? commentSuffix.substring(1) : commentSuffix);
            nestingSuffix.append("\n");
            TextRange range2 = this.insertNestedComments(startOffset, endOffset, nestingPrefix.toString(), nestingSuffix.toString(), commenter);
            if (range2 != null) {
                this.myCaret.setSelection(range2.getStartOffset(), range2.getEndOffset());
                LogicalPosition pos = new LogicalPosition(caretPosition.line + 1, caretPosition.column);
                this.myCaret.moveToLogicalPosition(pos);
            }
            return;
        }
        TextRange range3 = this.insertNestedComments(startOffset, endOffset, commentPrefix, commentSuffix, commenter);
        if (range3 != null) {
            this.myCaret.setSelection(range3.getStartOffset(), range3.getEndOffset());
            LogicalPosition pos = new LogicalPosition(caretPosition.line, caretPosition.column + commentPrefix.length());
            this.myCaret.moveToLogicalPosition(pos);
        }
    }

    private boolean breaksExistingComment(int offset, boolean includingAfterLineComment) {
        if (!(this.myCommenter instanceof CodeDocumentationAwareCommenter) || !(this.myEditor instanceof EditorEx) || offset == 0) {
            return false;
        }
        CodeDocumentationAwareCommenter commenter = (CodeDocumentationAwareCommenter)this.myCommenter;
        HighlighterIterator it = ((EditorEx)this.myEditor).getHighlighter().createIterator(offset - 1);
        IElementType tokenType = it.getTokenType();
        return tokenType != null && (it.getEnd() > offset && (tokenType == commenter.getLineCommentTokenType() || tokenType == commenter.getBlockCommentTokenType() || tokenType == commenter.getDocumentationCommentTokenType()) || includingAfterLineComment && it.getEnd() == offset && tokenType == commenter.getLineCommentTokenType() && !(commenter instanceof CommenterWithLineSuffix));
    }

    private boolean canDetectBlockComments() {
        return this.myEditor instanceof EditorEx && this.myCommenter instanceof CodeDocumentationAwareCommenter && ((CodeDocumentationAwareCommenter)this.myCommenter).getBlockCommentTokenType() != null;
    }

    private TextRange getBlockCommentAt(int offset) {
        PsiComment comment;
        CodeDocumentationAwareCommenter commenter = (CodeDocumentationAwareCommenter)this.myCommenter;
        HighlighterIterator it = ((EditorEx)this.myEditor).getHighlighter().createIterator(offset);
        if (it.getTokenType() == commenter.getBlockCommentTokenType()) {
            return new TextRange(it.getStart(), it.getEnd());
        }
        if (CommentByBlockCommentHandler.docCommentIsBlockComment(commenter) && (comment = this.getCommentAtOffset(offset)) != null && commenter.isDocumentationComment(comment)) {
            return comment.getTextRange();
        }
        return null;
    }

    private static boolean docCommentIsBlockComment(CodeDocumentationAwareCommenter commenter) {
        return commenter.getBlockCommentPrefix() != null && commenter.getDocumentationCommentPrefix() != null && commenter.getDocumentationCommentPrefix().startsWith(commenter.getBlockCommentPrefix()) && commenter.getBlockCommentSuffix() != null && commenter.getDocumentationCommentSuffix() != null && commenter.getDocumentationCommentSuffix().endsWith(commenter.getBlockCommentSuffix());
    }

    private int doBoundCommentingAndGetShift(int offset, String commented, int skipLength, String toInsert, boolean skipBrace, TextRange selection) {
        if (commented == null && (offset == selection.getStartOffset() || offset + (skipBrace ? skipLength : 0) == selection.getEndOffset())) {
            return 0;
        }
        if (commented == null) {
            this.myDocument.insertString(offset + (skipBrace ? skipLength : 0), (CharSequence)toInsert);
            return toInsert.length();
        }
        this.myDocument.replaceString(offset, offset + skipLength, (CharSequence)commented);
        return commented.length() - skipLength;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TextRange insertNestedComments(int startOffset, int endOffset, String commentPrefix, String commentSuffix, Commenter commenter) {
        int prefixIndex;
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            return selfManagingCommenter.insertBlockComment(startOffset, endOffset, this.myDocument, this.mySelfManagedCommenterData);
        }
        String normalizedPrefix = commentPrefix.trim();
        String normalizedSuffix = commentSuffix.trim();
        IntArrayList nestedCommentPrefixes = new IntArrayList();
        IntArrayList nestedCommentSuffixes = new IntArrayList();
        String commentedPrefix = commenter.getCommentedBlockCommentPrefix();
        String commentedSuffix = commenter.getCommentedBlockCommentSuffix();
        CharSequence chars = this.myDocument.getCharsSequence();
        boolean canDetectBlockComments = this.canDetectBlockComments();
        boolean warnAboutNestedComments = false;
        for (int i = startOffset; i < endOffset; ++i) {
            TextRange commentRange;
            if (CharArrayUtil.regionMatches((CharSequence)chars, (int)i, (CharSequence)normalizedPrefix)) {
                if (commentedPrefix == null && canDetectBlockComments) {
                    commentRange = this.getBlockCommentAt(i);
                    if (commentRange == null || commentRange.getStartOffset() != i) continue;
                    warnAboutNestedComments = true;
                }
                nestedCommentPrefixes.add(i);
                continue;
            }
            if (!CharArrayUtil.regionMatches((CharSequence)chars, (int)i, (CharSequence)normalizedSuffix)) continue;
            if (commentedSuffix == null && canDetectBlockComments && (commentRange = this.getBlockCommentAt(i)) == null) {
                this.myWarning = CodeInsightBundle.message((String)"block.comment.wrapping.suffix", (Object[])new Object[0]);
                this.myWarningLocation = this.myDocument.createRangeMarker(i, i);
                return null;
            }
            nestedCommentSuffixes.add(i);
        }
        if (warnAboutNestedComments) {
            this.myWarning = CodeInsightBundle.message((String)"block.comment.nested.comment", (Object[])new Object[]{nestedCommentPrefixes.size()});
            this.myWarningLocation = this.myDocument.createRangeMarker(nestedCommentPrefixes.get(0), nestedCommentPrefixes.get(0) + normalizedPrefix.length());
        }
        int shift = 0;
        if (commentedSuffix != null || nestedCommentSuffixes.isEmpty() || nestedCommentSuffixes.get(nestedCommentSuffixes.size() - 1) + commentSuffix.length() != endOffset) {
            this.myDocument.insertString(endOffset, (CharSequence)commentSuffix);
            shift += commentSuffix.length();
        }
        int i = nestedCommentPrefixes.size() - 1;
        int j = nestedCommentSuffixes.size() - 1;
        TextRange selection = new TextRange(startOffset, endOffset);
        while (i >= 0 && j >= 0) {
            int suffixIndex;
            prefixIndex = nestedCommentPrefixes.get(i);
            if (prefixIndex > (suffixIndex = nestedCommentSuffixes.get(j))) {
                shift += this.doBoundCommentingAndGetShift(prefixIndex, commentedPrefix, normalizedPrefix.length(), commentSuffix, false, selection);
                --i;
                continue;
            }
            shift += this.doBoundCommentingAndGetShift(suffixIndex, commentedSuffix, normalizedSuffix.length(), commentPrefix, true, selection);
            --j;
        }
        while (i >= 0) {
            prefixIndex = nestedCommentPrefixes.get(i);
            shift += this.doBoundCommentingAndGetShift(prefixIndex, commentedPrefix, normalizedPrefix.length(), commentSuffix, false, selection);
            --i;
        }
        while (j >= 0) {
            int suffixIndex = nestedCommentSuffixes.get(j);
            shift += this.doBoundCommentingAndGetShift(suffixIndex, commentedSuffix, normalizedSuffix.length(), commentPrefix, true, selection);
            --j;
        }
        if (commentedPrefix != null || nestedCommentPrefixes.isEmpty() || nestedCommentPrefixes.get(0) != startOffset) {
            this.myDocument.insertString(startOffset, (CharSequence)commentPrefix);
            shift += commentPrefix.length();
        }
        RangeMarker marker = this.myDocument.createRangeMarker(startOffset, endOffset + shift);
        try {
            TextRange textRange = CommentByBlockCommentHandler.processDocument(this.myDocument, marker, commenter, true);
            return textRange;
        }
        finally {
            marker.dispose();
        }
    }

    static TextRange processDocument(Document document, RangeMarker marker, Commenter commenter, boolean escape) {
        if (commenter instanceof EscapingCommenter) {
            if (escape) {
                ((EscapingCommenter)commenter).escape(document, marker);
            } else {
                ((EscapingCommenter)commenter).unescape(document, marker);
            }
        }
        return TextRange.create((int)marker.getStartOffset(), (int)marker.getEndOffset());
    }

    private static int getNearest(String text, String pattern, int position) {
        int result2 = text.indexOf(pattern, position);
        return result2 == -1 ? text.length() : result2;
    }

    static void commentNestedComments(@NotNull Document document, TextRange range2, Commenter commenter) {
        if (document == null) {
            CommentByBlockCommentHandler.$$$reportNull$$$0(8);
        }
        int offset = range2.getStartOffset();
        IntArrayList toReplaceWithComments = new IntArrayList();
        IntArrayList prefixes = new IntArrayList();
        String text = document.getCharsSequence().subSequence(range2.getStartOffset(), range2.getEndOffset()).toString();
        String commentedPrefix = commenter.getCommentedBlockCommentPrefix();
        String commentedSuffix = commenter.getCommentedBlockCommentSuffix();
        String commentPrefix = commenter.getBlockCommentPrefix();
        String commentSuffix = commenter.getBlockCommentSuffix();
        int nearestSuffix = CommentByBlockCommentHandler.getNearest(text, commentedSuffix, 0);
        int nearestPrefix = CommentByBlockCommentHandler.getNearest(text, commentedPrefix, 0);
        int level = 0;
        int lastSuffix = -1;
        int i = Math.min(nearestPrefix, nearestSuffix);
        while (i < text.length()) {
            if (i > nearestPrefix) {
                nearestPrefix = CommentByBlockCommentHandler.getNearest(text, commentedPrefix, i);
            } else if (i > nearestSuffix) {
                nearestSuffix = CommentByBlockCommentHandler.getNearest(text, commentedSuffix, i);
            } else if (i == nearestPrefix) {
                if (level <= 0) {
                    if (lastSuffix != -1) {
                        toReplaceWithComments.add(lastSuffix);
                    }
                    level = 1;
                    lastSuffix = -1;
                    toReplaceWithComments.add(i);
                    prefixes.add(i);
                } else {
                    ++level;
                }
                nearestPrefix = CommentByBlockCommentHandler.getNearest(text, commentedPrefix, nearestPrefix + 1);
            } else {
                lastSuffix = i;
                --level;
                nearestSuffix = CommentByBlockCommentHandler.getNearest(text, commentedSuffix, nearestSuffix + 1);
            }
            i = Math.min(nearestPrefix, nearestSuffix);
        }
        if (lastSuffix != -1) {
            toReplaceWithComments.add(lastSuffix);
        }
        int prefixIndex = prefixes.size() - 1;
        for (int i2 = toReplaceWithComments.size() - 1; i2 >= 0; --i2) {
            int position = toReplaceWithComments.get(i2);
            if (prefixIndex >= 0 && position == prefixes.get(prefixIndex)) {
                --prefixIndex;
                document.replaceString(offset + position, offset + position + commentedPrefix.length(), (CharSequence)commentPrefix);
                continue;
            }
            document.replaceString(offset + position, offset + position + commentedSuffix.length(), (CharSequence)commentSuffix);
        }
    }

    private TextRange expandRange(int delOffset1, int delOffset2) {
        int offset2;
        CharSequence chars = this.myDocument.getCharsSequence();
        int offset1 = CharArrayUtil.shiftBackward((CharSequence)chars, (int)(delOffset1 - 1), (String)" \t");
        if (!(offset1 >= 0 && chars.charAt(offset1) != '\n' && chars.charAt(offset1) != '\r' || (offset2 = CharArrayUtil.shiftForward((CharSequence)chars, (int)delOffset2, (String)" \t")) != this.myDocument.getTextLength() && chars.charAt(offset2) != '\r' && chars.charAt(offset2) != '\n')) {
            delOffset1 = offset1 + 1;
            if (offset2 < this.myDocument.getTextLength()) {
                delOffset2 = offset2 + 1;
                if (chars.charAt(offset2) == '\r' && offset2 + 1 < this.myDocument.getTextLength() && chars.charAt(offset2 + 1) == '\n') {
                    ++delOffset2;
                }
            }
        }
        return new TextRange(delOffset1, delOffset2);
    }

    private Couple<TextRange> findCommentBlock(TextRange range2, String commentPrefix, String commentSuffix) {
        CharSequence chars = this.myDocument.getCharsSequence();
        int startOffset = range2.getStartOffset();
        boolean endsProperly = CharArrayUtil.regionMatches((CharSequence)chars, (int)(range2.getEndOffset() - commentSuffix.length()), (CharSequence)commentSuffix);
        TextRange start = this.expandRange(startOffset, startOffset + commentPrefix.length());
        TextRange end = endsProperly ? this.expandRange(range2.getEndOffset() - commentSuffix.length(), range2.getEndOffset()) : new TextRange(range2.getEndOffset(), range2.getEndOffset());
        return Couple.of((Object)start, (Object)end);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void uncommentRange(TextRange range2, String commentPrefix, String commentSuffix, Commenter commenter) {
        if (commenter instanceof SelfManagingCommenter) {
            SelfManagingCommenter selfManagingCommenter = (SelfManagingCommenter)commenter;
            selfManagingCommenter.uncommentBlockComment(range2.getStartOffset(), range2.getEndOffset(), this.myDocument, this.mySelfManagedCommenterData);
            return;
        }
        String text = this.myDocument.getCharsSequence().subSequence(range2.getStartOffset(), range2.getEndOffset()).toString();
        int startOffset = range2.getStartOffset();
        ArrayList<Object> ranges = new ArrayList<Object>();
        if (commenter instanceof CustomUncommenter) {
            CustomUncommenter customUncommenter = (CustomUncommenter)commenter;
            for (Couple coupleFromCommenter : customUncommenter.getCommentRangesToDelete((CharSequence)text)) {
                TextRange openComment = ((TextRange)coupleFromCommenter.first).shiftRight(startOffset);
                TextRange closeComment = ((TextRange)coupleFromCommenter.second).shiftRight(startOffset);
                ranges.add(Couple.of((Object)openComment, (Object)closeComment));
            }
        } else {
            int start;
            int position = 0;
            while ((start = CommentByBlockCommentHandler.getNearest(text, commentPrefix, position)) != text.length()) {
                int end;
                position = start;
                position = end = CommentByBlockCommentHandler.getNearest(text, commentSuffix, position + commentPrefix.length()) + commentSuffix.length();
                Couple<TextRange> pair = this.findCommentBlock(new TextRange(start + startOffset, end + startOffset), commentPrefix, commentSuffix);
                ranges.add(pair);
            }
        }
        RangeMarker marker = this.myDocument.createRangeMarker(range2);
        try {
            for (int i = ranges.size() - 1; i >= 0; --i) {
                Couple toDelete = (Couple)ranges.get(i);
                this.myDocument.deleteString(((TextRange)toDelete.first).getStartOffset(), ((TextRange)toDelete.first).getEndOffset());
                int shift = ((TextRange)toDelete.first).getEndOffset() - ((TextRange)toDelete.first).getStartOffset();
                this.myDocument.deleteString(((TextRange)toDelete.second).getStartOffset() - shift, ((TextRange)toDelete.second).getEndOffset() - shift);
                if (commenter.getCommentedBlockCommentPrefix() == null) continue;
                CommentByBlockCommentHandler.commentNestedComments(this.myDocument, new TextRange(((TextRange)toDelete.first).getEndOffset() - shift, ((TextRange)toDelete.second).getStartOffset() - shift), commenter);
            }
            CommentByBlockCommentHandler.processDocument(this.myDocument, marker, commenter, false);
        }
        finally {
            marker.dispose();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "caret";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
        }
        objectArray2[1] = "com/intellij/codeInsight/generation/CommentByBlockCommentHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "invoke";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "isInjectedWhiteSpace";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "isWhiteSpaceOrComment";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "commentNestedComments";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

