/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.CodeInsightActionHandler;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.codeInsight.unwrap.LanguageUnwrappers;
import com.intellij.codeInsight.unwrap.ScopeHighlighter;
import com.intellij.codeInsight.unwrap.UnwrapDescriptor;
import com.intellij.codeInsight.unwrap.Unwrapper;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupAdapter;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.JBPopupListener;
import com.intellij.openapi.ui.popup.LightweightWindowEvent;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.tree.RecursiveTreeElementWalkingVisitor;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.ui.components.JBList;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.NotNullList;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.NotNull;

public class UnwrapHandler
implements CodeInsightActionHandler {
    public static final int HIGHLIGHTER_LEVEL = 6001;

    public boolean startInWriteAction() {
        return false;
    }

    public void invoke(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            UnwrapHandler.$$$reportNull$$$0(0);
        }
        if (editor == null) {
            UnwrapHandler.$$$reportNull$$$0(1);
        }
        if (file2 == null) {
            UnwrapHandler.$$$reportNull$$$0(2);
        }
        if (!EditorModificationUtil.checkModificationAllowed((Editor)editor)) {
            return;
        }
        List<AnAction> options = UnwrapHandler.collectOptions(project, editor, file2);
        this.selectOption(options, editor, file2);
    }

    @NotNull
    private static List<AnAction> collectOptions(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        if (project == null) {
            UnwrapHandler.$$$reportNull$$$0(3);
        }
        if (editor == null) {
            UnwrapHandler.$$$reportNull$$$0(4);
        }
        if (file2 == null) {
            UnwrapHandler.$$$reportNull$$$0(5);
        }
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        UnwrapDescriptor descriptor = UnwrapHandler.getUnwrapDescription(file2);
        for (Pair<PsiElement, Unwrapper> desc : descriptor.collectUnwrappers(project, editor, file2)) {
            PsiElement element = (PsiElement)desc.getFirst();
            Unwrapper unwrapper = (Unwrapper)desc.getSecond();
            if (element == null || unwrapper == null) {
                throw new IllegalStateException(descriptor + " returned " + desc);
            }
            result2.add(UnwrapHandler.createUnwrapAction(unwrapper, element, editor, project));
        }
        ArrayList<AnAction> arrayList = result2;
        if (arrayList == null) {
            UnwrapHandler.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    private static UnwrapDescriptor getUnwrapDescription(@NotNull PsiFile file2) {
        if (file2 == null) {
            UnwrapHandler.$$$reportNull$$$0(7);
        }
        return (UnwrapDescriptor)LanguageUnwrappers.INSTANCE.forLanguage(file2.getLanguage());
    }

    private static AnAction createUnwrapAction(@NotNull Unwrapper u, @NotNull PsiElement el, @NotNull Editor ed, @NotNull Project p) {
        if (u == null) {
            UnwrapHandler.$$$reportNull$$$0(8);
        }
        if (el == null) {
            UnwrapHandler.$$$reportNull$$$0(9);
        }
        if (ed == null) {
            UnwrapHandler.$$$reportNull$$$0(10);
        }
        if (p == null) {
            UnwrapHandler.$$$reportNull$$$0(11);
        }
        return new MyUnwrapAction(p, ed, u, el);
    }

    protected void selectOption(List<AnAction> options, Editor editor, PsiFile file2) {
        if (options.isEmpty()) {
            return;
        }
        if (!UnwrapHandler.getUnwrapDescription(file2).showOptionsDialog() || ApplicationManager.getApplication().isUnitTestMode()) {
            options.get(0).actionPerformed(null);
            return;
        }
        UnwrapHandler.showPopup(options, editor);
    }

    private static void showPopup(List<AnAction> options, Editor editor) {
        final ScopeHighlighter highlighter = new ScopeHighlighter(editor);
        DefaultListModel<String> m = new DefaultListModel<String>();
        for (AnAction a : options) {
            m.addElement(((MyUnwrapAction)a).getName());
        }
        JBList list2 = new JBList(m);
        list2.setSelectionMode(0);
        list2.setVisibleRowCount(options.size());
        list2.addListSelectionListener(new ListSelectionListener((JList)list2, options, highlighter){
            final /* synthetic */ JList val$list;
            final /* synthetic */ List val$options;
            final /* synthetic */ ScopeHighlighter val$highlighter;
            {
                this.val$list = jList;
                this.val$options = list2;
                this.val$highlighter = scopeHighlighter;
            }

            @Override
            public void valueChanged(ListSelectionEvent e) {
                int index = this.val$list.getSelectedIndex();
                if (index < 0) {
                    return;
                }
                MyUnwrapAction a = (MyUnwrapAction)((Object)this.val$options.get(index));
                NotNullList toExtract = new NotNullList();
                PsiElement wholeRange = a.collectAffectedElements((List<PsiElement>)toExtract);
                this.val$highlighter.highlight(wholeRange, (List<PsiElement>)toExtract);
            }
        });
        PopupChooserBuilder builder = JBPopupFactory.getInstance().createListPopupBuilder((JList)list2);
        builder.setTitle(CodeInsightBundle.message((String)"unwrap.popup.title", (Object[])new Object[0])).setMovable(false).setResizable(false).setRequestFocus(true).setItemChoosenCallback(() -> UnwrapHandler.lambda$showPopup$0(options, (JList)list2)).addListener((JBPopupListener)new JBPopupAdapter(){

            public void onClosed(LightweightWindowEvent event) {
                highlighter.dropHighlight();
            }
        });
        JBPopup popup2 = builder.createPopup();
        popup2.showInBestPositionFor(editor);
    }

    public static TextAttributes getTestAttributesForExtract() {
        EditorColorsManager manager = EditorColorsManager.getInstance();
        return manager.getGlobalScheme().getAttributes(EditorColors.SEARCH_RESULT_ATTRIBUTES);
    }

    private static /* synthetic */ void lambda$showPopup$0(List options, JList list2) {
        MyUnwrapAction a = (MyUnwrapAction)((Object)options.get(list2.getSelectedIndex()));
        a.actionPerformed(null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInsight/unwrap/UnwrapHandler";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "u";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ed";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInsight/unwrap/UnwrapHandler";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "collectOptions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "collectOptions";
                break;
            }
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getUnwrapDescription";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createUnwrapAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyUnwrapAction
    extends AnAction {
        private static final Key<Integer> CARET_POS_KEY = new Key("UNWRAP_HANDLER_CARET_POSITION");
        private final Project myProject;
        private final Editor myEditor;
        private final Unwrapper myUnwrapper;
        @NotNull
        private final PsiElement myElement;

        MyUnwrapAction(@NotNull Project project, @NotNull Editor editor, @NotNull Unwrapper unwrapper, @NotNull PsiElement element) {
            if (project == null) {
                MyUnwrapAction.$$$reportNull$$$0(0);
            }
            if (editor == null) {
                MyUnwrapAction.$$$reportNull$$$0(1);
            }
            if (unwrapper == null) {
                MyUnwrapAction.$$$reportNull$$$0(2);
            }
            if (element == null) {
                MyUnwrapAction.$$$reportNull$$$0(3);
            }
            super(unwrapper.getDescription(element));
            this.myProject = project;
            this.myEditor = editor;
            this.myUnwrapper = unwrapper;
            this.myElement = element;
        }

        public void actionPerformed(AnActionEvent e) {
            PsiFile file2 = this.myElement.getContainingFile();
            if (!FileModificationService.getInstance().prepareFileForWrite(file2)) {
                return;
            }
            CommandProcessor.getInstance().executeCommand(this.myProject, () -> ApplicationManager.getApplication().runWriteAction(() -> {
                try {
                    UnwrapDescriptor d = UnwrapHandler.getUnwrapDescription(file2);
                    if (d.shouldTryToRestoreCaretPosition()) {
                        this.saveCaretPosition(file2);
                    }
                    int scrollOffset = this.myEditor.getScrollingModel().getVerticalScrollOffset();
                    List<PsiElement> extractedElements = this.myUnwrapper.unwrap(this.myEditor, this.myElement);
                    if (d.shouldTryToRestoreCaretPosition()) {
                        this.restoreCaretPosition(file2);
                    }
                    this.myEditor.getScrollingModel().scrollVertically(scrollOffset);
                    this.highlightExtractedElements(extractedElements);
                }
                catch (IncorrectOperationException ex) {
                    throw new RuntimeException(ex);
                }
            }), null, (Object)this.myEditor.getDocument());
        }

        private void saveCaretPosition(PsiFile file2) {
            int offset = this.myEditor.getCaretModel().getOffset();
            PsiElement el = file2.findElementAt(offset);
            if (el == null) {
                return;
            }
            int innerOffset = offset - el.getTextOffset();
            el.putCopyableUserData(CARET_POS_KEY, (Object)innerOffset);
        }

        private void restoreCaretPosition(PsiFile file2) {
            ((TreeElement)file2.getNode()).acceptTree(new RecursiveTreeElementWalkingVisitor(){

                @Override
                protected void visitNode(TreeElement element) {
                    PsiElement el = element.getPsi();
                    Integer offset = (Integer)el.getCopyableUserData(CARET_POS_KEY);
                    if (offset != null) {
                        myEditor.getCaretModel().moveToOffset(el.getTextOffset() + offset);
                        el.putCopyableUserData(CARET_POS_KEY, null);
                        return;
                    }
                    super.visitNode(element);
                }
            });
        }

        private void highlightExtractedElements(List<PsiElement> extractedElements) {
            for (PsiElement each : extractedElements) {
                TextRange textRange = each.getTextRange();
                HighlightManager.getInstance((Project)this.myProject).addRangeHighlight(this.myEditor, textRange.getStartOffset(), textRange.getEndOffset(), UnwrapHandler.getTestAttributesForExtract(), false, true, null);
            }
        }

        public String getName() {
            return this.myUnwrapper.getDescription(this.myElement);
        }

        PsiElement collectAffectedElements(@NotNull List<PsiElement> toExtract) {
            if (toExtract == null) {
                MyUnwrapAction.$$$reportNull$$$0(4);
            }
            return this.myUnwrapper.collectAffectedElements(this.myElement, toExtract);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "editor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unwrapper";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toExtract";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/codeInsight/unwrap/UnwrapHandler$MyUnwrapAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "collectAffectedElements";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

