/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.ActionClassHolder;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalQuickFixWrapper;
import com.intellij.codeInspection.ex.QuickFixAction;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefDirectory;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.ui.InspectionModuleNode;
import com.intellij.codeInspection.ui.InspectionNode;
import com.intellij.codeInspection.ui.InspectionPackageNode;
import com.intellij.codeInspection.ui.InspectionResultsViewComparator;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTree;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.codeInspection.ui.ProblemDescriptionNode;
import com.intellij.codeInspection.ui.RefElementNode;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import com.intellij.util.ui.tree.TreeUtil;
import gnu.trove.THashMap;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class InspectionRVContentProvider {
    private static final Logger LOG = Logger.getInstance(InspectionRVContentProvider.class);
    private final Project myProject;

    public InspectionRVContentProvider(@NotNull Project project) {
        if (project == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(0);
        }
        this.myProject = project;
    }

    public abstract boolean checkReportedProblems(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionToolWrapper var2);

    public Iterable<? extends ScopeToolState> getTools(Tools tools) {
        return tools.getTools();
    }

    public boolean hasQuickFixes(InspectionTree tree) {
        TreePath[] treePaths = tree.getSelectionPaths();
        if (treePaths == null) {
            return false;
        }
        for (TreePath selectionPath : treePaths) {
            if (TreeUtil.treeNodeTraverser((TreeNode)((TreeNode)selectionPath.getLastPathComponent())).traverse(TreeTraversal.PRE_ORDER_DFS).processEach(node -> {
                ProblemDescriptionNode problemDescriptionNode;
                if (!((InspectionTreeNode)node).isValid()) {
                    return true;
                }
                if (node instanceof ProblemDescriptionNode && !(problemDescriptionNode = (ProblemDescriptionNode)node).isQuickFixAppliedFromView()) {
                    CommonProblemDescriptor descriptor = problemDescriptionNode.getDescriptor();
                    QuickFix[] fixes = descriptor != null ? descriptor.getFixes() : null;
                    return fixes == null || fixes.length == 0;
                }
                return true;
            })) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public abstract QuickFixAction[] getCommonQuickFixes(@NotNull InspectionToolWrapper var1, @NotNull InspectionTree var2);

    @NotNull
    public QuickFixAction[] getPartialQuickFixes(@NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionTree tree) {
        if (toolWrapper == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(1);
        }
        if (tree == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(2);
        }
        GlobalInspectionContextImpl context = tree.getContext();
        InspectionToolPresentation presentation = context.getPresentation(toolWrapper);
        CommonProblemDescriptor[] descriptors = tree.getSelectedDescriptors();
        THashMap result2 = new THashMap();
        for (CommonProblemDescriptor d : descriptors) {
            QuickFix[] fixes = d.getFixes();
            if (fixes == null || fixes.length == 0) continue;
            for (QuickFix fix : fixes) {
                String familyName = fix.getFamilyName();
                FixAndOccurrences fixAndOccurrences = (FixAndOccurrences)result2.get(familyName);
                if (fixAndOccurrences == null) {
                    LocalQuickFixWrapper localQuickFixWrapper = new LocalQuickFixWrapper(fix, presentation.getToolWrapper());
                    try {
                        localQuickFixWrapper.setText(StringUtil.escapeMnemonics((String)fix.getFamilyName()));
                    }
                    catch (AbstractMethodError e) {
                        localQuickFixWrapper.setText("Name is not available");
                    }
                    fixAndOccurrences = new FixAndOccurrences(localQuickFixWrapper);
                    result2.put(familyName, fixAndOccurrences);
                } else {
                    LocalQuickFixWrapper quickFixAction = fixAndOccurrences.fix;
                    InspectionRVContentProvider.checkFixClass(presentation, fix, quickFixAction);
                }
                ++fixAndOccurrences.occurrences;
            }
        }
        QuickFixAction[] quickFixActionArray = (QuickFixAction[])result2.values().stream().filter(fixAndOccurrence -> fixAndOccurrence.occurrences != descriptors.length).sorted(Comparator.comparingInt(fixAndOccurrence -> fixAndOccurrence.occurrences).reversed()).map(fixAndOccurrence -> {
            LocalQuickFixWrapper fix = fixAndOccurrence.fix;
            int occurrences = fixAndOccurrence.occurrences;
            fix.setText(fix.getText() + " (" + occurrences + " problem" + (occurrences == 1 ? "" : "s") + ")");
            return fix;
        }).toArray(QuickFixAction[]::new);
        if (quickFixActionArray == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(3);
        }
        return quickFixActionArray;
    }

    protected static void checkFixClass(InspectionToolPresentation presentation, QuickFix fix, LocalQuickFixWrapper quickFixAction) {
        Class class2;
        Class class1 = InspectionRVContentProvider.getFixClass(fix);
        if (!class1.equals(class2 = InspectionRVContentProvider.getFixClass(quickFixAction.getFix()))) {
            String message = MessageFormat.format("QuickFix-es with the same family name ({0}) should be the same class instances but actually are {1} and {2} instances. Please assign reported exception for the inspection \"{3}\" (\"{4}\") developer.", fix.getFamilyName(), class1.getName(), class2.getName(), presentation.getToolWrapper().getTool().getClass(), presentation.getToolWrapper().getShortName());
            AssertionError error = new AssertionError((Object)message);
            StreamEx.of(presentation.getProblemDescriptors()).select(ProblemDescriptorBase.class).map(ProblemDescriptorBase::getCreationTrace).nonNull().map(InspectionRVContentProvider::extractStackTrace).findFirst().ifPresent(arg_0 -> error.setStackTrace(arg_0));
            LOG.error(message, (Throwable)((Object)error));
        }
    }

    private static StackTraceElement[] extractStackTrace(Throwable throwable) {
        Set classes = StreamEx.of((Object[])new Class[]{ProblemDescriptorBase.class, InspectionManagerBase.class, ProblemsHolder.class}).map(Class::getName).toSet();
        return (StackTraceElement[])((StreamEx)StreamEx.of((Object[])throwable.getStackTrace()).dropWhile(ste -> classes.contains(ste.getClassName()))).toArray(StackTraceElement.class);
    }

    public InspectionNode appendToolNodeContent(@NotNull GlobalInspectionContextImpl context, @NotNull InspectionNode toolNode, @NotNull InspectionTreeNode parentNode, boolean showStructure, boolean groupBySeverity) {
        if (context == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(4);
        }
        if (toolNode == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(5);
        }
        if (parentNode == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(6);
        }
        InspectionToolWrapper wrapper = toolNode.getToolWrapper();
        InspectionToolPresentation presentation = context.getPresentation(wrapper);
        Map<String, Set<RefEntity>> content = presentation.getContent();
        return this.appendToolNodeContent(context, toolNode, parentNode, showStructure, groupBySeverity, content, entity -> {
            if (context == null) {
                InspectionRVContentProvider.$$$reportNull$$$0(19);
            }
            if (context.getUIOptions().FILTER_RESOLVED_ITEMS) {
                return presentation.isExcluded((RefEntity)entity) ? null : presentation.getProblemElements().get((RefEntity)entity);
            }
            CommonProblemDescriptor[] problems = (CommonProblemDescriptor[])ObjectUtils.notNull((Object)presentation.getProblemElements().get((RefEntity)entity), (Object)CommonProblemDescriptor.EMPTY_ARRAY);
            CommonProblemDescriptor[] suppressedProblems = presentation.getSuppressedProblems((RefEntity)entity);
            CommonProblemDescriptor[] resolvedProblems = presentation.getResolvedProblems((RefEntity)entity);
            CommonProblemDescriptor[] result2 = new CommonProblemDescriptor[problems.length + suppressedProblems.length + resolvedProblems.length];
            System.arraycopy(problems, 0, result2, 0, problems.length);
            System.arraycopy(suppressedProblems, 0, result2, problems.length, suppressedProblems.length);
            System.arraycopy(resolvedProblems, 0, result2, problems.length + suppressedProblems.length, resolvedProblems.length);
            return result2;
        });
    }

    public abstract InspectionNode appendToolNodeContent(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionNode var2, @NotNull InspectionTreeNode var3, boolean var4, boolean var5, @NotNull Map<String, Set<RefEntity>> var6, @NotNull Function<RefEntity, CommonProblemDescriptor[]> var7);

    protected abstract void appendDescriptor(@NotNull GlobalInspectionContextImpl var1, @NotNull InspectionToolWrapper var2, @NotNull RefEntityContainer var3, @NotNull InspectionTreeNode var4, boolean var5);

    public boolean isContentLoaded() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    protected <T> void buildTree(@NotNull GlobalInspectionContextImpl context, @NotNull Map<String, Set<T>> packageContents, boolean canPackageRepeat, @NotNull InspectionToolWrapper toolWrapper, @NotNull Function<T, RefEntityContainer<?>> computeContainer, boolean showStructure, UnaryOperator<InspectionTreeNode> createdNodesConsumer) {
        Iterator<String> iterator;
        MultiMap packageDescriptors;
        block32: {
            Iterator iterator2;
            HashMap<String, InspectionModuleNode> moduleNodes;
            if (context == null) {
                InspectionRVContentProvider.$$$reportNull$$$0(7);
            }
            if (packageContents == null) {
                InspectionRVContentProvider.$$$reportNull$$$0(8);
            }
            if (toolWrapper == null) {
                InspectionRVContentProvider.$$$reportNull$$$0(9);
            }
            if (computeContainer == null) {
                InspectionRVContentProvider.$$$reportNull$$$0(10);
            }
            HashMap module2PackageMap = new HashMap();
            boolean supportStructure = showStructure;
            packageDescriptors = new MultiMap();
            iterator = packageContents.keySet().iterator();
            block0: while (true) {
                if (!iterator.hasNext()) {
                    if (supportStructure) {
                        moduleNodes = new HashMap<String, InspectionModuleNode>();
                        iterator2 = module2PackageMap.keySet().iterator();
                        break;
                    }
                    iterator = module2PackageMap.values().iterator();
                    break block32;
                }
                String string = iterator.next();
                Set<T> elements = packageContents.get(string);
                Iterator<T> iterator3 = elements.iterator();
                while (true) {
                    InspectionPackageNode pNode;
                    if (!iterator3.hasNext()) continue block0;
                    T userObject = iterator3.next();
                    RefEntityContainer container = computeContainer.apply(userObject);
                    supportStructure &= container.supportStructure();
                    String moduleName = showStructure ? container.getModule() : null;
                    HashMap packageNodes = (HashMap)module2PackageMap.get(moduleName);
                    if (packageNodes == null) {
                        packageNodes = new HashMap();
                        module2PackageMap.put(moduleName, packageNodes);
                    }
                    if ((pNode = (InspectionPackageNode)packageNodes.get(string)) == null) {
                        pNode = new InspectionPackageNode(string);
                        packageNodes.put(string, pNode);
                    }
                    packageDescriptors.putValue((Object)pNode, (Object)container);
                }
                break;
            }
            while (iterator2.hasNext()) {
                InspectionPackageNode packageNode;
                Object module;
                InspectionModuleNode moduleNode;
                block37: {
                    block36: {
                        Map packageNodes;
                        block35: {
                            block33: {
                                block34: {
                                    String moduleName = (String)iterator2.next();
                                    packageNodes = (Map)module2PackageMap.get(moduleName);
                                    moduleNode = (InspectionModuleNode)moduleNodes.get(moduleName);
                                    if (moduleNode != null) break block33;
                                    if (moduleName == null) break block34;
                                    module = (Module)ReadAction.compute(() -> ModuleManager.getInstance((Project)this.myProject).findModuleByName(moduleName));
                                    if (module == null) continue;
                                    moduleNode = new InspectionModuleNode((Module)module);
                                    moduleNodes.put(moduleName, moduleNode);
                                    moduleNode = (InspectionModuleNode)createdNodesConsumer.apply(moduleNode);
                                    break block35;
                                }
                                module = packageNodes.values().iterator();
                                break block36;
                            }
                            moduleNode = (InspectionModuleNode)createdNodesConsumer.apply(moduleNode);
                        }
                        module = packageNodes.values().iterator();
                        break block37;
                    }
                    while (module.hasNext()) {
                        packageNode = (InspectionPackageNode)module.next();
                        for (Object container : packageDescriptors.get((Object)packageNode)) {
                            this.appendDescriptor(context, toolWrapper, (RefEntityContainer)container, packageNode, canPackageRepeat);
                        }
                        createdNodesConsumer.apply(packageNode);
                    }
                    continue;
                }
                while (module.hasNext()) {
                    packageNode = (InspectionPackageNode)module.next();
                    if (packageNode.getPackageName() != null) {
                        Object container;
                        Collection objectContainers = packageDescriptors.get((Object)packageNode);
                        packageNode = (InspectionPackageNode)InspectionRVContentProvider.merge(packageNode, moduleNode, true);
                        container = objectContainers.iterator();
                        while (container.hasNext()) {
                            RefEntityContainer container2 = (RefEntityContainer)container.next();
                            this.appendDescriptor(context, toolWrapper, container2, packageNode, canPackageRepeat);
                        }
                        continue;
                    }
                    for (Object container : packageDescriptors.get((Object)packageNode)) {
                        this.appendDescriptor(context, toolWrapper, (RefEntityContainer)container, moduleNode, canPackageRepeat);
                    }
                }
            }
            return;
        }
        while (iterator.hasNext()) {
            Map map = (Map)((Object)iterator.next());
            block9: for (InspectionPackageNode pNode : map.values()) {
                for (RefEntityContainer container : packageDescriptors.get((Object)pNode)) {
                    this.appendDescriptor(context, toolWrapper, container, pNode, canPackageRepeat);
                }
                int count = pNode.getChildCount();
                ArrayList<TreeNode> childNodes = new ArrayList<TreeNode>(count);
                for (int i = 0; i < count; ++i) {
                    childNodes.add(pNode.getChildAt(i));
                }
                for (TreeNode childNode : childNodes) {
                    if (childNode instanceof ProblemDescriptionNode) {
                        createdNodesConsumer.apply(pNode);
                        continue block9;
                    }
                    LOG.assertTrue(childNode instanceof RefElementNode, (Object)childNode.getClass().getName());
                    RefElementNode elementNode = (RefElementNode)childNode;
                    LinkedHashSet<RefElementNode> parentNodes = new LinkedHashSet<RefElementNode>();
                    if (pNode.getPackageName() != null) {
                        parentNodes.add(elementNode);
                    } else {
                        boolean hasElementNodeUnder = true;
                        for (int e = 0; e < elementNode.getChildCount(); ++e) {
                            TreeNode grandChildNode = elementNode.getChildAt(e);
                            if (grandChildNode instanceof ProblemDescriptionNode) {
                                hasElementNodeUnder = false;
                                break;
                            }
                            LOG.assertTrue(grandChildNode instanceof RefElementNode);
                            parentNodes.add((RefElementNode)grandChildNode);
                        }
                        if (!hasElementNodeUnder) {
                            createdNodesConsumer.apply(elementNode);
                            continue;
                        }
                    }
                    if (!"unused".equals(toolWrapper.getShortName())) {
                        for (RefElementNode parentNode : parentNodes) {
                            ArrayList nodes = new ArrayList();
                            TreeUtil.traverse((TreeNode)parentNode, node -> {
                                if (node instanceof ProblemDescriptionNode) {
                                    nodes.add((ProblemDescriptionNode)node);
                                }
                                return true;
                            });
                            if (nodes.isEmpty()) continue;
                            parentNode.removeAllChildren();
                            for (ProblemDescriptionNode node2 : nodes) {
                                parentNode.insertByOrder(node2, false);
                            }
                        }
                    }
                    for (RefElementNode node3 : parentNodes) {
                        createdNodesConsumer.apply(node3);
                    }
                }
            }
        }
    }

    @NotNull
    protected static RefElementNode addNodeToParent(@NotNull RefEntityContainer container, @NotNull InspectionToolPresentation presentation, InspectionTreeNode parentNode) {
        if (container == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(11);
        }
        if (presentation == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(12);
        }
        RefElementNode nodeToBeAdded = container.createNode(presentation);
        Ref firstLevel = new Ref((Object)true);
        RefElementNode prevNode = null;
        Ref result2 = new Ref();
        while (true) {
            RefEntityContainer owner;
            RefElementNode currentNode = (Boolean)firstLevel.get() != false ? nodeToBeAdded : container.createNode(presentation);
            RefEntityContainer finalContainer = container;
            RefElementNode finalPrevNode = prevNode;
            TreeUtil.treeNodeTraverser((TreeNode)parentNode).traverse(TreeTraversal.PRE_ORDER_DFS).processEach(node -> {
                if (node instanceof RefElementNode) {
                    RefElementNode refElementNode = (RefElementNode)node;
                    RefEntity userObject = finalContainer.getRefEntity();
                    RefEntity object = refElementNode.getElement();
                    if (userObject != null && object != null && userObject.getClass().equals(object.getClass()) && finalContainer.areEqual(object, userObject)) {
                        if (((Boolean)firstLevel.get()).booleanValue()) {
                            result2.set((Object)refElementNode);
                        } else {
                            refElementNode.insertByOrder(finalPrevNode, false);
                            result2.set((Object)nodeToBeAdded);
                        }
                        return false;
                    }
                }
                return true;
            });
            if (!result2.isNull()) {
                RefElementNode refElementNode = (RefElementNode)result2.get();
                if (refElementNode == null) {
                    InspectionRVContentProvider.$$$reportNull$$$0(13);
                }
                return refElementNode;
            }
            if (!((Boolean)firstLevel.get()).booleanValue()) {
                currentNode.insertByOrder(prevNode, false);
            }
            if ((owner = container.getOwner()) == null) {
                parentNode.insertByOrder(currentNode, false);
                RefElementNode refElementNode = nodeToBeAdded;
                if (refElementNode == null) {
                    InspectionRVContentProvider.$$$reportNull$$$0(14);
                }
                return refElementNode;
            }
            container = owner;
            prevNode = currentNode;
            firstLevel.set((Object)false);
        }
    }

    public static InspectionTreeNode merge(InspectionTreeNode child, InspectionTreeNode parent, boolean merge) {
        return (InspectionTreeNode)ReadAction.compute(() -> {
            if (merge) {
                for (int i = 0; i < parent.getChildCount(); ++i) {
                    InspectionTreeNode current = (InspectionTreeNode)parent.getChildAt(i);
                    if (child.getClass() != current.getClass()) continue;
                    if (current instanceof InspectionPackageNode) {
                        if (((InspectionPackageNode)current).getPackageName().compareTo(((InspectionPackageNode)child).getPackageName()) != 0) continue;
                        InspectionRVContentProvider.processDepth(child, current);
                        return current;
                    }
                    if (current instanceof RefElementNode) {
                        if (InspectionResultsViewComparator.getInstance().compare(current, child) != 0) continue;
                        InspectionRVContentProvider.processDepth(child, current);
                        return current;
                    }
                    if (current instanceof InspectionNode) {
                        if (((InspectionNode)current).getToolWrapper().getShortName().compareTo(((InspectionNode)child).getToolWrapper().getShortName()) != 0) continue;
                        InspectionRVContentProvider.processDepth(child, current);
                        return current;
                    }
                    if (!(current instanceof InspectionModuleNode) || ((InspectionModuleNode)current).getName().compareTo(((InspectionModuleNode)child).getName()) != 0) continue;
                    InspectionRVContentProvider.processDepth(child, current);
                    return current;
                }
            }
            return parent.insertByOrder(child, false);
        });
    }

    private static void processDepth(InspectionTreeNode child, InspectionTreeNode current) {
        InspectionTreeNode[] children2 = new InspectionTreeNode[child.getChildCount()];
        for (int i = 0; i < children2.length; ++i) {
            children2[i] = (InspectionTreeNode)child.getChildAt(i);
        }
        for (InspectionTreeNode node : children2) {
            InspectionRVContentProvider.merge(node, current, true);
        }
    }

    @NotNull
    protected static QuickFixAction[] getCommonFixes(@NotNull InspectionToolPresentation presentation, @NotNull CommonProblemDescriptor[] descriptors) {
        if (presentation == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(15);
        }
        if (descriptors == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(16);
        }
        HashMap<String, LocalQuickFixWrapper> result2 = null;
        for (CommonProblemDescriptor d : descriptors) {
            QuickFix[] fixes = d.getFixes();
            if (fixes == null || fixes.length == 0) continue;
            if (result2 == null) {
                result2 = new HashMap<String, LocalQuickFixWrapper>();
                for (QuickFix fix : fixes) {
                    if (fix == null) continue;
                    result2.put(fix.getFamilyName(), new LocalQuickFixWrapper(fix, presentation.getToolWrapper()));
                }
                continue;
            }
            for (String familyName : new ArrayList(result2.keySet())) {
                boolean isFound = false;
                for (QuickFix fix : fixes) {
                    if (fix == null || !familyName.equals(fix.getFamilyName())) continue;
                    isFound = true;
                    LocalQuickFixWrapper quickFixAction = (LocalQuickFixWrapper)((Object)result2.get(fix.getFamilyName()));
                    InspectionRVContentProvider.checkFixClass(presentation, fix, quickFixAction);
                    try {
                        quickFixAction.setText(StringUtil.escapeMnemonics((String)fix.getFamilyName()));
                    }
                    catch (AbstractMethodError e) {
                        quickFixAction.setText("Name is not available");
                    }
                    break;
                }
                if (isFound) continue;
                result2.remove(familyName);
                if (!result2.isEmpty()) continue;
                if (QuickFixAction.EMPTY == null) {
                    InspectionRVContentProvider.$$$reportNull$$$0(17);
                }
                return QuickFixAction.EMPTY;
            }
        }
        QuickFixAction[] quickFixActionArray = result2 == null || result2.isEmpty() ? QuickFixAction.EMPTY : result2.values().toArray(QuickFixAction.EMPTY);
        if (quickFixActionArray == null) {
            InspectionRVContentProvider.$$$reportNull$$$0(18);
        }
        return quickFixActionArray;
    }

    private static Class getFixClass(QuickFix fix) {
        return fix instanceof ActionClassHolder ? ((ActionClassHolder)fix).getActionClass() : fix.getClass();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWrapper";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/codeInspection/ex/InspectionRVContentProvider";
                break;
            }
            case 4: 
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolNode";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "packageContents";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computeContainer";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 12: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/codeInspection/ex/InspectionRVContentProvider";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPartialQuickFixes";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "addNodeToParent";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommonFixes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getPartialQuickFixes";
                break;
            }
            case 3: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "appendToolNodeContent";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "buildTree";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "addNodeToParent";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCommonFixes";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "lambda$appendToolNodeContent$6";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 13: 
            case 14: 
            case 17: 
            case 18: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class FixAndOccurrences {
        final LocalQuickFixWrapper fix;
        int occurrences;

        FixAndOccurrences(LocalQuickFixWrapper fix) {
            this.fix = fix;
        }
    }

    protected static class RefEntityContainer<Descriptor> {
        private final Descriptor[] myDescriptors;
        @Nullable
        private final RefEntity myEntity;

        public RefEntityContainer(@Nullable RefEntity entity, Descriptor[] descriptors) {
            this.myEntity = entity;
            this.myDescriptors = descriptors;
        }

        @Nullable
        public RefEntityContainer<Descriptor> getOwner() {
            if (this.myEntity == null) {
                return null;
            }
            RefEntity entity = this.myEntity.getOwner();
            return entity instanceof RefElement && !(entity instanceof RefDirectory) ? new RefEntityContainer<Descriptor>(entity, this.myDescriptors) : null;
        }

        @NotNull
        public RefElementNode createNode(@NotNull InspectionToolPresentation presentation) {
            if (presentation == null) {
                RefEntityContainer.$$$reportNull$$$0(0);
            }
            RefElementNode refElementNode = (RefElementNode)ReadAction.compute(() -> {
                if (presentation == null) {
                    RefEntityContainer.$$$reportNull$$$0(4);
                }
                return presentation.createRefNode(this.myEntity);
            });
            if (refElementNode == null) {
                RefEntityContainer.$$$reportNull$$$0(1);
            }
            return refElementNode;
        }

        @Nullable
        public RefEntity getRefEntity() {
            return this.myEntity;
        }

        @Nullable
        public String getModule() {
            RefModule refModule = this.myEntity instanceof RefElement ? ((RefElement)this.myEntity).getModule() : (this.myEntity instanceof RefModule ? (RefModule)this.myEntity : null);
            return refModule != null ? refModule.getName() : null;
        }

        boolean areEqual(@NotNull RefEntity o1, @NotNull RefEntity o2) {
            if (o1 == null) {
                RefEntityContainer.$$$reportNull$$$0(2);
            }
            if (o2 == null) {
                RefEntityContainer.$$$reportNull$$$0(3);
            }
            return Comparing.equal((Object)o1, (Object)o2);
        }

        boolean supportStructure() {
            return this.myEntity == null || this.myEntity instanceof RefElement && !(this.myEntity instanceof RefDirectory);
        }

        public Descriptor[] getDescriptors() {
            return this.myDescriptors;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/codeInspection/ex/InspectionRVContentProvider$RefEntityContainer";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o2";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/codeInspection/ex/InspectionRVContentProvider$RefEntityContainer";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createNode";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "createNode";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "areEqual";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "lambda$createNode$0";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

