/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.windows.WindowsCryptUtils;
import com.intellij.util.EncryptionSupport;
import java.security.Key;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0016J\u0018\u0010\b\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/intellij/credentialStore/WindowsEncryptionSupport;", "Lcom/intellij/util/EncryptionSupport;", "key", "Ljava/security/Key;", "(Ljava/security/Key;)V", "decrypt", "", "data", "encrypt", "size", "", "intellij.platform.credentialStore"})
public final class WindowsEncryptionSupport
extends EncryptionSupport {
    @NotNull
    public byte[] encrypt(@NotNull byte[] data, int size) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        return WindowsCryptUtils.protect(super.encrypt(data, size));
    }

    @NotNull
    public byte[] decrypt(@NotNull byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        byte[] byArray = WindowsCryptUtils.unprotect(data);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"WindowsCryptUtils.unprotect(data)");
        return super.decrypt(byArray);
    }

    public WindowsEncryptionSupport(@NotNull Key key) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        super(key);
    }
}

